/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import groovy.transform.CompilationUnitAware;
import groovy.transform.MapConstructor;
import groovy.transform.options.PropertyHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.VisibilityUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class MapConstructorASTTransformation
extends AbstractASTTransformation
implements CompilationUnitAware {
    private CompilationUnit compilationUnit;
    static final Class MY_CLASS = MapConstructor.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode MAP_TYPE = ClassHelper.makeWithoutCaching(Map.class, false);
    private static final ClassNode LHMAP_TYPE = ClassHelper.makeWithoutCaching(LinkedHashMap.class, false);

    @Override
    public String getAnnotationName() {
        return MY_TYPE_NAME;
    }

    @Override
    public void visit(ASTNode[] nodes2, SourceUnit source) {
        this.init(nodes2, source);
        AnnotatedNode parent = (AnnotatedNode)nodes2[1];
        AnnotationNode anno = (AnnotationNode)nodes2[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            boolean includeFields = this.memberHasValue(anno, "includeFields", true);
            boolean includeProperties = !this.memberHasValue(anno, "includeProperties", false);
            boolean includeSuperProperties = this.memberHasValue(anno, "includeSuperProperties", true);
            boolean includeSuperFields = this.memberHasValue(anno, "includeSuperFields", true);
            boolean includeStatic = this.memberHasValue(anno, "includeStatic", true);
            boolean allProperties = this.memberHasValue(anno, "allProperties", true);
            boolean noArg = this.memberHasValue(anno, "noArg", true);
            boolean specialNamedArgHandling = !this.memberHasValue(anno, "specialNamedArgHandling", false);
            List<String> excludes = MapConstructorASTTransformation.getMemberStringList(anno, "excludes");
            List<String> includes2 = MapConstructorASTTransformation.getMemberStringList(anno, "includes");
            boolean allNames = this.memberHasValue(anno, "allNames", true);
            if (!this.checkIncludeExcludeUndefinedAware(anno, excludes, includes2, MY_TYPE_NAME)) {
                return;
            }
            if (!this.checkPropertyList(cNode, includes2, "includes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, allProperties)) {
                return;
            }
            if (!this.checkPropertyList(cNode, excludes, "excludes", anno, MY_TYPE_NAME, includeFields, includeSuperProperties, allProperties)) {
                return;
            }
            GroovyClassLoader classLoader = this.compilationUnit != null ? this.compilationUnit.getTransformLoader() : source.getClassLoader();
            PropertyHandler handler = PropertyHandler.createPropertyHandler(this, classLoader, cNode);
            if (handler == null) {
                return;
            }
            if (!handler.validateAttributes(this, anno)) {
                return;
            }
            Expression pre = anno.getMember("pre");
            if (pre != null && !(pre instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'pre'. Found " + pre, cNode);
                return;
            }
            Expression post2 = anno.getMember("post");
            if (post2 != null && !(post2 instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'post'. Found " + post2, cNode);
                return;
            }
            MapConstructorASTTransformation.createConstructors(this, anno, handler, cNode, includeFields, includeProperties, includeSuperProperties, includeSuperFields, noArg, allNames, allProperties, specialNamedArgHandling, includeStatic, excludes, includes2, (ClosureExpression)pre, (ClosureExpression)post2, source);
            if (pre != null) {
                anno.setMember("pre", new ClosureExpression(Parameter.EMPTY_ARRAY, EmptyStatement.INSTANCE));
            }
            if (post2 != null) {
                anno.setMember("post", new ClosureExpression(Parameter.EMPTY_ARRAY, EmptyStatement.INSTANCE));
            }
        }
    }

    private static void createConstructors(AbstractASTTransformation xform, AnnotationNode anno, PropertyHandler handler, ClassNode cNode, boolean includeFields, boolean includeProperties, boolean includeSuperProperties, boolean includeSuperFields, boolean noArg, boolean allNames, boolean allProperties, boolean specialNamedArgHandling, boolean includeStatic, List<String> excludes, List<String> includes2, ClosureExpression pre, ClosureExpression post2, SourceUnit source) {
        Iterator<ConstructorNode> iterator2 = cNode.getDeclaredConstructors().iterator();
        while (iterator2.hasNext()) {
            ConstructorNode next2 = iterator2.next();
            if (next2.getFirstStatement() != null) continue;
            iterator2.remove();
        }
        HashSet<String> names = new HashSet<String>();
        List<Object> superList = includeSuperProperties || includeSuperFields ? GeneralUtils.getAllProperties(names, cNode, cNode.getSuperClass(), includeSuperProperties, includeSuperFields, false, allProperties, true, false, false, allNames, includeStatic) : new ArrayList();
        List<PropertyNode> list2 = GeneralUtils.getAllProperties(names, cNode, cNode, includeProperties, includeFields, false, allProperties, false, false, false, allNames, includeStatic);
        Parameter map2 = GeneralUtils.param(MAP_TYPE, "args");
        BlockStatement body2 = new BlockStatement();
        ClassCodeExpressionTransformer transformer = MapConstructorASTTransformation.makeMapTypedArgsTransformer();
        if (pre != null) {
            ClosureExpression transformed = (ClosureExpression)transformer.transform(pre);
            GeneralUtils.copyStatementsWithSuperAdjustment(transformed, body2);
        }
        BlockStatement inner2 = new BlockStatement();
        superList.addAll(list2);
        if (!handler.validateProperties(xform, body2, cNode, superList)) {
            return;
        }
        boolean specialNamedArgCase = specialNamedArgHandling && ImmutableASTTransformation.isSpecialNamedArgCase(superList, true);
        MapConstructorASTTransformation.processProps(xform, anno, cNode, handler, allNames, excludes, includes2, superList, map2, inner2);
        body2.addStatement(inner2);
        Parameter[] params2 = GeneralUtils.params(specialNamedArgCase ? new Parameter(LHMAP_TYPE, "args") : map2);
        if (post2 != null) {
            ClosureExpression transformed = (ClosureExpression)transformer.transform(post2);
            body2.addStatement(transformed.getCode());
        }
        int modifiers = VisibilityUtils.getVisibility(anno, cNode, ConstructorNode.class, 1);
        MapConstructorASTTransformation.doAddConstructor(cNode, new ConstructorNode(modifiers, params2, ClassNode.EMPTY_ARRAY, body2));
        if (noArg && !superList.isEmpty() && !ClassNodeUtils.hasNoArgConstructor(cNode)) {
            MapConstructorASTTransformation.createNoArgConstructor(cNode, modifiers);
        }
    }

    private static void doAddConstructor(final ClassNode cNode, ConstructorNode constructorNode) {
        AnnotatedNodeUtils.markAsGenerated(cNode, constructorNode);
        cNode.addConstructor(constructorNode);
        Parameter argsParam = null;
        for (Parameter p : constructorNode.getParameters()) {
            if (!"args".equals(p.getName())) continue;
            argsParam = p;
            break;
        }
        if (argsParam != null) {
            final Parameter arg = argsParam;
            ClassCodeVisitorSupport variableExpressionFix = new ClassCodeVisitorSupport(){

                @Override
                protected SourceUnit getSourceUnit() {
                    return cNode.getModule().getContext();
                }

                @Override
                public void visitVariableExpression(VariableExpression expression2) {
                    super.visitVariableExpression(expression2);
                    if ("args".equals(expression2.getName())) {
                        expression2.setAccessedVariable(arg);
                    }
                }
            };
            variableExpressionFix.visitConstructor(constructorNode);
        }
    }

    private static void processProps(AbstractASTTransformation xform, AnnotationNode anno, ClassNode cNode, PropertyHandler handler, boolean allNames, List<String> excludes, List<String> includes2, List<PropertyNode> superList, Parameter map2, BlockStatement inner2) {
        for (PropertyNode pNode : superList) {
            Statement propInit;
            String name2 = pNode.getName();
            if (MapConstructorASTTransformation.shouldSkipUndefinedAware(name2, excludes, includes2, allNames) || (propInit = handler.createPropInit(xform, anno, cNode, pNode, map2)) == null) continue;
            inner2.addStatement(propInit);
        }
    }

    private static void createNoArgConstructor(ClassNode cNode, int modifiers) {
        Statement body2 = GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.THIS, GeneralUtils.args(new MapExpression())));
        ConstructorNode consNode = new ConstructorNode(modifiers, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, body2);
        AnnotatedNodeUtils.markAsGenerated(cNode, consNode);
        cNode.addConstructor(consNode);
    }

    private static ClassCodeExpressionTransformer makeMapTypedArgsTransformer() {
        return new ClassCodeExpressionTransformer(){

            @Override
            public Expression transform(Expression exp) {
                VariableExpression ve;
                if (exp instanceof ClosureExpression) {
                    ClosureExpression ce = (ClosureExpression)exp;
                    ce.getCode().visit(this);
                } else if (exp instanceof VariableExpression && "args".equals((ve = (VariableExpression)exp).getName()) && ve.getAccessedVariable() instanceof DynamicVariable) {
                    VariableExpression newVe = GeneralUtils.varX(GeneralUtils.param(MAP_TYPE, "args"));
                    newVe.setSourcePosition(ve);
                    return newVe;
                }
                return exp.transformExpression(this);
            }

            @Override
            protected SourceUnit getSourceUnit() {
                return null;
            }
        };
    }

    @Override
    public void setCompilationUnit(CompilationUnit unit) {
        this.compilationUnit = unit;
    }
}

