/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.Reference;
import groovyjarjarasm.asm.Opcodes;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class CategoryASTTransformation
implements ASTTransformation,
Opcodes {
    private final VariableExpression thisExpression = CategoryASTTransformation.createThisExpression();

    private static VariableExpression createThisExpression() {
        VariableExpression expr2 = new VariableExpression("$this");
        expr2.setClosureSharedVariable(true);
        return expr2;
    }

    @Override
    public void visit(ASTNode[] nodes2, final SourceUnit source) {
        if (nodes2.length != 2 || !(nodes2[0] instanceof AnnotationNode) || !(nodes2[1] instanceof ClassNode)) {
            source.getErrorCollector().addError(new SyntaxErrorMessage(new SyntaxException("@Category can only be added to a ClassNode but got: " + (nodes2.length == 2 ? nodes2[1] : "nothing"), nodes2[0].getLineNumber(), nodes2[0].getColumnNumber()), source));
        }
        AnnotationNode annotation = (AnnotationNode)nodes2[0];
        ClassNode parent = (ClassNode)nodes2[1];
        ClassNode targetClass = CategoryASTTransformation.getTargetClass(source, annotation);
        this.thisExpression.setType(targetClass);
        final LinkedList varStack = new LinkedList();
        if (!CategoryASTTransformation.ensureNoInstanceFieldOrProperty(source, parent)) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (FieldNode fieldNode : parent.getFields()) {
            names.add(fieldNode.getName());
        }
        for (PropertyNode propertyNode : parent.getProperties()) {
            names.add(propertyNode.getName());
        }
        varStack.add(names);
        final Reference<Parameter> parameter = new Reference<Parameter>();
        ClassCodeExpressionTransformer classCodeExpressionTransformer = new ClassCodeExpressionTransformer(){

            @Override
            protected SourceUnit getSourceUnit() {
                return source;
            }

            private void addVariablesToStack(Parameter[] params2) {
                HashSet<String> names = new HashSet<String>((Collection)varStack.getLast());
                for (Parameter param2 : params2) {
                    names.add(param2.getName());
                }
                varStack.add(names);
            }

            @Override
            public void visitCatchStatement(CatchStatement statement2) {
                ((Set)varStack.getLast()).add(statement2.getVariable().getName());
                super.visitCatchStatement(statement2);
                ((Set)varStack.getLast()).remove(statement2.getVariable().getName());
            }

            @Override
            public void visitMethod(MethodNode node) {
                this.addVariablesToStack(node.getParameters());
                super.visitMethod(node);
                varStack.removeLast();
            }

            @Override
            public void visitBlockStatement(BlockStatement block) {
                HashSet names = new HashSet((Collection)varStack.getLast());
                varStack.add(names);
                super.visitBlockStatement(block);
                varStack.remove(names);
            }

            @Override
            public void visitClosureExpression(ClosureExpression ce) {
                this.addVariablesToStack(ClosureUtils.getParametersSafe(ce));
                super.visitClosureExpression(ce);
                varStack.removeLast();
            }

            @Override
            public void visitDeclarationExpression(DeclarationExpression expression2) {
                if (expression2.isMultipleAssignmentDeclaration()) {
                    TupleExpression te = expression2.getTupleExpression();
                    List<Expression> list2 = te.getExpressions();
                    for (Expression arg : list2) {
                        VariableExpression ve = (VariableExpression)arg;
                        ((Set)varStack.getLast()).add(ve.getName());
                    }
                } else {
                    VariableExpression ve = expression2.getVariableExpression();
                    ((Set)varStack.getLast()).add(ve.getName());
                }
                super.visitDeclarationExpression(expression2);
            }

            @Override
            public void visitForLoop(ForStatement forLoop) {
                Expression exp = forLoop.getCollectionExpression();
                exp.visit(this);
                Parameter loopParam = forLoop.getVariable();
                if (loopParam != null) {
                    ((Set)varStack.getLast()).add(loopParam.getName());
                }
                super.visitForLoop(forLoop);
            }

            @Override
            public void visitExpressionStatement(ExpressionStatement es) {
                Expression exp = es.getExpression();
                if (exp instanceof DeclarationExpression) {
                    exp.visit(this);
                }
                super.visitExpressionStatement(es);
            }

            @Override
            public Expression transform(Expression exp) {
                if (exp instanceof VariableExpression) {
                    VariableExpression ve = (VariableExpression)exp;
                    if (ve.getName().equals("this")) {
                        return CategoryASTTransformation.this.thisExpression;
                    }
                    if (!((Set)varStack.getLast()).contains(ve.getName())) {
                        return new PropertyExpression((Expression)CategoryASTTransformation.this.thisExpression, ve.getName());
                    }
                } else if (exp instanceof PropertyExpression) {
                    VariableExpression vex;
                    PropertyExpression pe = (PropertyExpression)exp;
                    if (pe.getObjectExpression() instanceof VariableExpression && (vex = (VariableExpression)pe.getObjectExpression()).isThisExpression()) {
                        pe.setObjectExpression(CategoryASTTransformation.this.thisExpression);
                        return pe;
                    }
                } else if (exp instanceof ClosureExpression) {
                    ClosureExpression ce = (ClosureExpression)exp;
                    ce.getVariableScope().putReferencedLocalVariable((Parameter)parameter.get());
                    this.addVariablesToStack(ClosureUtils.hasImplicitParameter(ce) ? GeneralUtils.params(GeneralUtils.param(ClassHelper.OBJECT_TYPE, "it")) : ClosureUtils.getParametersSafe(ce));
                    ce.getCode().visit(this);
                    varStack.removeLast();
                }
                return super.transform(exp);
            }
        };
        for (MethodNode method : parent.getMethods()) {
            if (method.isStatic()) continue;
            method.setModifiers(method.getModifiers() | 8);
            Parameter[] origParams = method.getParameters();
            Parameter[] newParams = new Parameter[origParams.length + 1];
            Parameter p = new Parameter(targetClass, "$this");
            p.setClosureSharedVariable(true);
            newParams[0] = p;
            parameter.set(p);
            System.arraycopy(origParams, 0, newParams, 1, origParams.length);
            method.setParameters(newParams);
            classCodeExpressionTransformer.visitMethod(method);
        }
        new VariableScopeVisitor(source, true).visitClass(parent);
    }

    private static boolean ensureNoInstanceFieldOrProperty(SourceUnit source, ClassNode parent) {
        boolean valid = true;
        for (FieldNode fieldNode : parent.getFields()) {
            if (fieldNode.isStatic() || fieldNode.getLineNumber() <= 0) continue;
            CategoryASTTransformation.addUnsupportedError(fieldNode, source);
            valid = false;
        }
        for (PropertyNode propertyNode : parent.getProperties()) {
            if (propertyNode.isStatic() || propertyNode.getLineNumber() <= 0) continue;
            CategoryASTTransformation.addUnsupportedError(propertyNode, source);
            valid = false;
        }
        return valid;
    }

    private static void addUnsupportedError(ASTNode node, SourceUnit unit) {
        unit.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("The @Category transformation does not support instance " + (node instanceof FieldNode ? "fields" : "properties") + " but found [" + CategoryASTTransformation.getName(node) + "]", node.getLineNumber(), node.getColumnNumber()), unit));
    }

    private static String getName(ASTNode node) {
        if (node instanceof FieldNode) {
            return ((FieldNode)node).getName();
        }
        if (node instanceof PropertyNode) {
            return ((PropertyNode)node).getName();
        }
        return node.getText();
    }

    private static ClassNode getTargetClass(SourceUnit source, AnnotationNode annotation) {
        Expression value2 = annotation.getMember("value");
        if (!(value2 instanceof ClassExpression)) {
            source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException("@groovy.lang.Category must define 'value' which is the class to apply this category to", annotation.getLineNumber(), annotation.getColumnNumber(), annotation.getLastLineNumber(), annotation.getLastColumnNumber()), source));
            return null;
        }
        ClassExpression ce = (ClassExpression)value2;
        return ce.getType();
    }
}

