/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AutoImplement;
import groovy.transform.Undefined;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.antlr.AntlrParserPlugin;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.ast.tools.ParameterUtils;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class AutoImplementASTTransformation
extends AbstractASTTransformation {
    static final Class MY_CLASS = AutoImplement.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    @Override
    public void visit(ASTNode[] nodes2, SourceUnit source) {
        this.init(nodes2, source);
        AnnotatedNode parent = (AnnotatedNode)nodes2[1];
        AnnotationNode anno = (AnnotationNode)nodes2[0];
        if (!MY_TYPE.equals(anno.getClassNode())) {
            return;
        }
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            if (!this.checkNotInterface(cNode, MY_TYPE_NAME)) {
                return;
            }
            ClassNode exception = this.getMemberClassValue(anno, "exception");
            if (exception != null && Undefined.isUndefinedException(exception)) {
                exception = null;
            }
            String message = AutoImplementASTTransformation.getMemberStringValue(anno, "message");
            Expression code = anno.getMember("code");
            if (code != null && !(code instanceof ClosureExpression)) {
                this.addError("Expected closure value for annotation parameter 'code'. Found " + code, cNode);
                return;
            }
            this.createMethods(cNode, exception, message, (ClosureExpression)code);
            if (code != null) {
                anno.setMember("code", new ClosureExpression(Parameter.EMPTY_ARRAY, EmptyStatement.INSTANCE));
            }
        }
    }

    private void createMethods(ClassNode cNode, ClassNode exception, String message, ClosureExpression code) {
        for (MethodNode candidate : AutoImplementASTTransformation.getAllCorrectedMethodsMap(cNode).values()) {
            if (!candidate.isAbstract()) continue;
            ClassNodeUtils.addGeneratedMethod(cNode, candidate.getName(), 1, candidate.getReturnType(), candidate.getParameters(), candidate.getExceptions(), this.methodBody(exception, message, code, candidate.getReturnType()));
        }
    }

    private static Map<String, MethodNode> getAllCorrectedMethodsMap(ClassNode cNode) {
        HashMap<String, MethodNode> result2 = new HashMap<String, MethodNode>();
        for (MethodNode mn : cNode.getMethods()) {
            result2.put(MethodNodeUtils.methodDescriptorWithoutReturnType(mn), mn);
        }
        ClassNode next2 = cNode;
        while (true) {
            Map<String, ClassNode> genericsSpec = GenericsUtils.createGenericsSpec(next2);
            for (MethodNode mn : next2.getMethods()) {
                String td;
                ClassNode correctedClass;
                MethodNode found;
                MethodNode correctedMethod = GenericsUtils.correctToGenericsSpec(genericsSpec, mn);
                if (next2 == cNode || (found = AutoImplementASTTransformation.getDeclaredMethodCorrected(genericsSpec, correctedMethod, correctedClass = GenericsUtils.correctToGenericsSpecRecurse(genericsSpec, next2))) == null || result2.containsKey(td = MethodNodeUtils.methodDescriptorWithoutReturnType(found)) && !((MethodNode)result2.get(td)).isAbstract()) continue;
                result2.put(td, found);
            }
            ArrayList<ClassNode> interfaces2 = new ArrayList<ClassNode>(Arrays.asList(next2.getInterfaces()));
            Map<String, ClassNode> updatedGenericsSpec = new HashMap<String, ClassNode>(genericsSpec);
            while (!interfaces2.isEmpty()) {
                ClassNode origInterface = (ClassNode)interfaces2.remove(0);
                if (origInterface.equals(ClassHelper.OBJECT_TYPE)) continue;
                updatedGenericsSpec = GenericsUtils.createGenericsSpec(origInterface, updatedGenericsSpec);
                ClassNode correctedInterface = GenericsUtils.correctToGenericsSpecRecurse(updatedGenericsSpec, origInterface);
                for (MethodNode nextMethod : correctedInterface.getMethods()) {
                    String td;
                    MethodNode correctedMethod = GenericsUtils.correctToGenericsSpec(genericsSpec, nextMethod);
                    MethodNode found = AutoImplementASTTransformation.getDeclaredMethodCorrected(updatedGenericsSpec, correctedMethod, correctedInterface);
                    if (found == null || result2.containsKey(td = MethodNodeUtils.methodDescriptorWithoutReturnType(found)) && !((MethodNode)result2.get(td)).isAbstract()) continue;
                    result2.put(td, found);
                }
                interfaces2.addAll(Arrays.asList(correctedInterface.getInterfaces()));
            }
            ClassNode superClass = next2.getUnresolvedSuperClass();
            if (superClass == null) break;
            next2 = GenericsUtils.correctToGenericsSpecRecurse(updatedGenericsSpec, superClass);
        }
        return result2;
    }

    private static MethodNode getDeclaredMethodCorrected(Map<String, ClassNode> genericsSpec, MethodNode origMethod, ClassNode correctedClass) {
        for (MethodNode nameMatch : correctedClass.getDeclaredMethods(origMethod.getName())) {
            MethodNode correctedMethod = GenericsUtils.correctToGenericsSpec(genericsSpec, nameMatch);
            if (!ParameterUtils.parametersEqual(correctedMethod.getParameters(), origMethod.getParameters())) continue;
            return correctedMethod;
        }
        return null;
    }

    private BlockStatement methodBody(ClassNode exception, String message, ClosureExpression code, ClassNode returnType) {
        BlockStatement body2 = new BlockStatement();
        if (code != null) {
            body2.addStatement(code.getCode());
        } else if (exception != null) {
            body2.addStatement(GeneralUtils.throwS(GeneralUtils.ctorX(exception, message == null ? ArgumentListExpression.EMPTY_ARGUMENTS : GeneralUtils.constX(message))));
        } else {
            Expression result2 = AntlrParserPlugin.getDefaultValueForPrimitive(returnType);
            if (result2 != null) {
                body2.addStatement(GeneralUtils.returnS(result2));
            }
        }
        return body2;
    }
}

