/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AnnotationCollector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.trait.TraitComposer;

public class AnnotationCollectorTransform {
    private static List<AnnotationNode> getMeta(ClassNode cn) {
        List<AnnotationNode> meta = (List<AnnotationNode>)cn.getNodeMetaData(AnnotationCollector.class);
        if (meta == null) {
            meta = cn.isPrimaryClassNode() ? AnnotationCollectorTransform.getTargetListFromAnnotations(cn) : AnnotationCollectorTransform.getTargetListFromClass(cn);
            cn.setNodeMetaData(AnnotationCollector.class, meta);
        }
        return meta;
    }

    protected void addError(String message, ASTNode node, SourceUnit source) {
        source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(message, node.getLineNumber(), node.getColumnNumber(), node.getLastLineNumber(), node.getLastColumnNumber()), source));
    }

    private List<AnnotationNode> getTargetListFromValue(AnnotationNode collector, AnnotationNode aliasAnnotationUsage, SourceUnit source) {
        Expression memberValue = collector.getMember("value");
        if (memberValue == null) {
            return Collections.emptyList();
        }
        if (!(memberValue instanceof ListExpression)) {
            this.addError("Annotation collector expected a list of classes, but got a " + memberValue.getClass(), collector, source);
            return Collections.emptyList();
        }
        ListExpression memberListExp = (ListExpression)memberValue;
        List<Expression> memberList = memberListExp.getExpressions();
        if (memberList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationNode> ret = new ArrayList<AnnotationNode>();
        for (Expression e : memberList) {
            AnnotationNode toAdd = new AnnotationNode(e.getType());
            toAdd.setSourcePosition(aliasAnnotationUsage);
            ret.add(toAdd);
        }
        return ret;
    }

    private static List<AnnotationNode> getStoredTargetList(AnnotationNode aliasAnnotationUsage, SourceUnit source) {
        ClassNode alias = aliasAnnotationUsage.getClassNode().redirect();
        List<AnnotationNode> ret = AnnotationCollectorTransform.getMeta(alias);
        return AnnotationCollectorTransform.copy(ret, aliasAnnotationUsage);
    }

    private static List<AnnotationNode> copy(List<AnnotationNode> orig, AnnotationNode aliasAnnotationUsage) {
        if (orig.isEmpty()) {
            return orig;
        }
        ArrayList<AnnotationNode> ret = new ArrayList<AnnotationNode>(orig.size());
        for (AnnotationNode an : orig) {
            AnnotationNode newAn = new AnnotationNode(an.getClassNode());
            AnnotationCollectorTransform.copyMembers(an, newAn);
            newAn.setSourcePosition(aliasAnnotationUsage);
            ret.add(newAn);
        }
        return ret;
    }

    private static List<AnnotationNode> getTargetListFromAnnotations(ClassNode alias) {
        List<AnnotationNode> annotations2 = alias.getAnnotations();
        if (annotations2.size() < 2) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationNode> ret = new ArrayList<AnnotationNode>(annotations2.size());
        for (AnnotationNode an : annotations2) {
            ClassNode type = an.getClassNode();
            if (type.getName().equals(AnnotationCollector.class.getName()) || "java.lang.annotation".equals(type.getPackageName())) continue;
            AnnotationNode toAdd = new AnnotationNode(type);
            AnnotationCollectorTransform.copyMembers(an, toAdd);
            ret.add(toAdd);
        }
        return ret;
    }

    private static void copyMembers(AnnotationNode from2, AnnotationNode to2) {
        Map<String, Expression> members2 = from2.getMembers();
        AnnotationCollectorTransform.copyMembers(members2, to2);
    }

    private static void copyMembers(Map<String, Expression> members2, AnnotationNode to2) {
        for (Map.Entry<String, Expression> entry2 : members2.entrySet()) {
            to2.addMember(entry2.getKey(), entry2.getValue());
        }
    }

    private static List<AnnotationNode> getTargetListFromClass(ClassNode alias) {
        Object[][] data2;
        alias = AnnotationCollectorTransform.getSerializeClass(alias);
        Class c = alias.getTypeClass();
        try {
            Method m = c.getMethod("value", new Class[0]);
            data2 = (Object[][])m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new GroovyBugError(e);
        }
        return AnnotationCollectorTransform.makeListOfAnnotations(data2);
    }

    private static ClassNode getSerializeClass(ClassNode alias) {
        ClassExpression ce;
        AnnotationNode annotationNode;
        Expression member2;
        List<AnnotationNode> annotations2 = alias.getAnnotations(ClassHelper.make(AnnotationCollector.class));
        if (!annotations2.isEmpty() && (member2 = (annotationNode = annotations2.get(0)).getMember("serializeClass")) instanceof ClassExpression && !(ce = (ClassExpression)member2).getType().getName().equals(AnnotationCollector.class.getName())) {
            alias = ce.getType();
        }
        return alias;
    }

    private static List<AnnotationNode> makeListOfAnnotations(Object[][] data2) {
        if (data2.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationNode> ret = new ArrayList<AnnotationNode>(data2.length);
        for (Object[] inner2 : data2) {
            Class anno = (Class)inner2[0];
            AnnotationNode toAdd = new AnnotationNode(ClassHelper.make(anno));
            ret.add(toAdd);
            Map member2 = (Map)inner2[1];
            if (member2.isEmpty()) continue;
            HashMap<String, Expression> generated = new HashMap<String, Expression>(member2.size());
            for (Map.Entry entry2 : member2.entrySet()) {
                generated.put((String)entry2.getKey(), AnnotationCollectorTransform.makeExpression(entry2.getValue()));
            }
            AnnotationCollectorTransform.copyMembers(generated, toAdd);
        }
        return ret;
    }

    private static Expression makeExpression(Object o) {
        if (o instanceof Class) {
            return new ClassExpression(ClassHelper.make((Class)o));
        }
        if (o instanceof Object[][]) {
            List<AnnotationNode> annotations2 = AnnotationCollectorTransform.makeListOfAnnotations((Object[][])o);
            ListExpression le = new ListExpression();
            for (AnnotationNode an : annotations2) {
                le.addExpression(new AnnotationConstantExpression(an));
            }
            return le;
        }
        if (o instanceof Object[]) {
            Object[] values2;
            ListExpression le = new ListExpression();
            for (Object val : values2 = (Object[])o) {
                le.addExpression(AnnotationCollectorTransform.makeExpression(val));
            }
            return le;
        }
        return new ConstantExpression(o, true);
    }

    protected List<AnnotationNode> getTargetAnnotationList(AnnotationNode collector, AnnotationNode aliasAnnotationUsage, SourceUnit source) {
        List<AnnotationNode> stored = AnnotationCollectorTransform.getStoredTargetList(aliasAnnotationUsage, source);
        List<AnnotationNode> targetList = this.getTargetListFromValue(collector, aliasAnnotationUsage, source);
        int size2 = targetList.size() + stored.size();
        if (size2 == 0) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationNode> ret = new ArrayList<AnnotationNode>(size2);
        ret.addAll(stored);
        ret.addAll(targetList);
        return ret;
    }

    public List<AnnotationNode> visit(AnnotationNode collector, AnnotationNode aliasAnnotationUsage, AnnotatedNode aliasAnnotated, SourceUnit source) {
        List<AnnotationNode> ret = this.getTargetAnnotationList(collector, aliasAnnotationUsage, source);
        HashSet<String> unusedNames = new HashSet<String>(aliasAnnotationUsage.getMembers().keySet());
        for (AnnotationNode an : ret) {
            for (String name2 : aliasAnnotationUsage.getMembers().keySet()) {
                if (!an.getClassNode().hasMethod(name2, Parameter.EMPTY_ARRAY)) continue;
                unusedNames.remove(name2);
                an.setMember(name2, aliasAnnotationUsage.getMember(name2));
            }
        }
        if (!unusedNames.isEmpty()) {
            String message = "Annotation collector got unmapped names " + ((Object)unusedNames).toString() + ".";
            this.addError(message, aliasAnnotationUsage, source);
        }
        return ret;
    }

    public static class ClassChanger {
        public void transformClass(ClassNode cn) {
            AnnotationNode collector = null;
            ListIterator<AnnotationNode> it = cn.getAnnotations().listIterator();
            while (it.hasNext()) {
                AnnotationNode an = it.next();
                if (!an.getClassNode().getName().equals(AnnotationCollector.class.getName())) continue;
                collector = an;
                break;
            }
            if (collector == null) {
                return;
            }
            boolean legacySerialization = false;
            Expression member2 = collector.getMember("serializeClass");
            if (member2 instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)member2;
                legacySerialization = ce.getType().getName().equals(cn.getName());
            }
            ClassNode helper = cn;
            if (legacySerialization) {
                helper.setModifiers(16 + helper.getModifiers() & 0xFFFF99FF);
                helper.setSuperClass(ClassHelper.OBJECT_TYPE);
                helper.setInterfaces(ClassNode.EMPTY_ARRAY);
            } else {
                helper = new InnerClassNode(cn.getPlainNodeReference(), cn.getName() + "$CollectorHelper", 25, ClassHelper.OBJECT_TYPE.getPlainNodeReference());
                cn.getModule().addClass(helper);
                helper.addAnnotation(new AnnotationNode(TraitComposer.COMPILESTATIC_CLASSNODE));
                MethodNode serializeClass = collector.getClassNode().getMethod("serializeClass", Parameter.EMPTY_ARRAY);
                collector.setMember("serializeClass", new ClassExpression(helper.getPlainNodeReference()));
            }
            List meta = AnnotationCollectorTransform.getMeta(cn);
            ArrayList<Expression> outer = new ArrayList<Expression>(meta.size());
            for (AnnotationNode an : meta) {
                Expression serialized = this.serialize(an);
                outer.add(serialized);
            }
            ArrayExpression ae = new ArrayExpression(ClassHelper.OBJECT_TYPE.makeArray(), outer);
            ReturnStatement code = new ReturnStatement(ae);
            helper.addMethod("value", 9, ClassHelper.OBJECT_TYPE.makeArray().makeArray(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, code);
            ListIterator<AnnotationNode> it2 = cn.getAnnotations().listIterator();
            while (it2.hasNext()) {
                AnnotationNode an = it2.next();
                if (an == collector || "java.lang.annotation".equals(an.getClassNode().getPackageName())) continue;
                it2.remove();
            }
        }

        private Expression serialize(Expression e) {
            if (e instanceof AnnotationConstantExpression) {
                AnnotationConstantExpression ace = (AnnotationConstantExpression)e;
                return this.serialize((AnnotationNode)ace.getValue());
            }
            if (e instanceof ListExpression) {
                boolean annotationConstant = false;
                ListExpression le = (ListExpression)e;
                List<Expression> list2 = le.getExpressions();
                ArrayList<Expression> newList = new ArrayList<Expression>(list2.size());
                for (Expression exp : list2) {
                    annotationConstant = annotationConstant || exp instanceof AnnotationConstantExpression;
                    newList.add(this.serialize(exp));
                }
                ClassNode type = ClassHelper.OBJECT_TYPE;
                if (annotationConstant) {
                    type = type.makeArray();
                }
                return new ArrayExpression(type, newList);
            }
            return e;
        }

        private Expression serialize(AnnotationNode an) {
            MapExpression map2 = new MapExpression();
            for (String key : an.getMembers().keySet()) {
                map2.addMapEntryExpression(new ConstantExpression(key), this.serialize(an.getMember(key)));
            }
            ArrayList<Expression> l = new ArrayList<Expression>(2);
            l.add(new ClassExpression(an.getClassNode()));
            l.add(map2);
            return new ArrayExpression(ClassHelper.OBJECT_TYPE, l);
        }
    }
}

