/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.Undefined;
import groovyjarjarasm.asm.Opcodes;
import java.lang.annotation.Retention;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.AnnotatedNodeUtils;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.BeanUtils;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.ErrorCollecting;

public abstract class AbstractASTTransformation
implements Opcodes,
ASTTransformation,
ErrorCollecting {
    public static final ClassNode RETENTION_CLASSNODE = ClassHelper.makeWithoutCaching(Retention.class);
    protected SourceUnit sourceUnit;

    protected List<AnnotationNode> copyAnnotatedNodeAnnotations(AnnotatedNode annotatedNode, String myTypeName) {
        ArrayList<AnnotationNode> copiedAnnotations = new ArrayList<AnnotationNode>();
        ArrayList<AnnotationNode> notCopied = new ArrayList<AnnotationNode>();
        GeneralUtils.copyAnnotatedNodeAnnotations(annotatedNode, copiedAnnotations, notCopied);
        for (AnnotationNode annotation : notCopied) {
            this.addError(myTypeName + " does not support keeping Closure annotation members.", annotation);
        }
        return copiedAnnotations;
    }

    public String getAnnotationName() {
        return null;
    }

    protected void init(ASTNode[] nodes2, SourceUnit sourceUnit) {
        if (nodes2 == null || nodes2.length != 2 || !(nodes2[0] instanceof AnnotationNode) || !(nodes2[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + (nodes2 == null ? null : Arrays.asList(nodes2)));
        }
        this.sourceUnit = sourceUnit;
    }

    public boolean memberHasValue(AnnotationNode node, String name2, Object value2) {
        Expression member2 = node.getMember(name2);
        return member2 instanceof ConstantExpression && ((ConstantExpression)member2).getValue().equals(value2);
    }

    public Object getMemberValue(AnnotationNode node, String name2) {
        Expression member2 = node.getMember(name2);
        if (member2 instanceof ConstantExpression) {
            return ((ConstantExpression)member2).getValue();
        }
        return null;
    }

    public static String getMemberStringValue(AnnotationNode node, String name2, String defaultValue2) {
        Expression member2 = node.getMember(name2);
        if (member2 instanceof ConstantExpression) {
            Object result2 = ((ConstantExpression)member2).getValue();
            if (result2 instanceof String && Undefined.isUndefined((String)result2)) {
                result2 = null;
            }
            if (result2 != null) {
                return result2.toString();
            }
        }
        return defaultValue2;
    }

    public static String getMemberStringValue(AnnotationNode node, String name2) {
        return AbstractASTTransformation.getMemberStringValue(node, name2, null);
    }

    public int getMemberIntValue(AnnotationNode node, String name2) {
        Object value2 = this.getMemberValue(node, name2);
        if (value2 instanceof Integer) {
            return (Integer)value2;
        }
        return 0;
    }

    public ClassNode getMemberClassValue(AnnotationNode node, String name2) {
        return this.getMemberClassValue(node, name2, null);
    }

    public ClassNode getMemberClassValue(AnnotationNode node, String name2, ClassNode defaultValue2) {
        Expression member2 = node.getMember(name2);
        if (member2 != null) {
            if (member2 instanceof ClassExpression) {
                if (!Undefined.isUndefined(member2.getType())) {
                    return member2.getType();
                }
            } else {
                if (member2 instanceof VariableExpression) {
                    this.addError("Error expecting to find class value for '" + name2 + "' but found variable: " + member2.getText() + ". Missing import?", node);
                    return null;
                }
                if (member2 instanceof ConstantExpression) {
                    this.addError("Error expecting to find class value for '" + name2 + "' but found constant: " + member2.getText() + "!", node);
                    return null;
                }
            }
        }
        return defaultValue2;
    }

    public static List<String> getMemberStringList(AnnotationNode anno, String name2) {
        Expression expr2 = anno.getMember(name2);
        if (expr2 == null) {
            return null;
        }
        if (expr2 instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)expr2;
            if (AbstractASTTransformation.isUndefinedMarkerList(listExpression)) {
                return null;
            }
            return AbstractASTTransformation.getValueStringList(listExpression);
        }
        return AbstractASTTransformation.tokenize(AbstractASTTransformation.getMemberStringValue(anno, name2));
    }

    private static boolean isUndefinedMarkerList(ListExpression listExpression) {
        Object value2;
        if (listExpression.getExpressions().size() != 1) {
            return false;
        }
        Expression itemExpr = listExpression.getExpression(0);
        if (itemExpr == null) {
            return false;
        }
        return itemExpr instanceof ConstantExpression ? (value2 = ((ConstantExpression)itemExpr).getValue()) instanceof String && Undefined.isUndefined((String)value2) : itemExpr instanceof ClassExpression && Undefined.isUndefined(itemExpr.getType());
    }

    @Deprecated
    public static List<String> getMemberList(AnnotationNode anno, String name2) {
        List<String> list2;
        Expression expr2 = anno.getMember(name2);
        if (expr2 instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)expr2;
            list2 = AbstractASTTransformation.getValueStringList(listExpression);
        } else {
            list2 = AbstractASTTransformation.tokenize(AbstractASTTransformation.getMemberStringValue(anno, name2));
        }
        return list2;
    }

    private static List<String> getValueStringList(ListExpression listExpression) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (Expression itemExpr : listExpression.getExpressions()) {
            Object value2;
            if (!(itemExpr instanceof ConstantExpression) || (value2 = ((ConstantExpression)itemExpr).getValue()) == null) continue;
            list2.add(value2.toString());
        }
        return list2;
    }

    @Deprecated
    public List<ClassNode> getClassList(AnnotationNode anno, String name2) {
        ClassNode cn;
        List<ClassNode> list2 = new ArrayList<ClassNode>();
        Expression expr2 = anno.getMember(name2);
        if (expr2 instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)expr2;
            list2 = AbstractASTTransformation.getTypeList(listExpression);
        } else if (expr2 instanceof ClassExpression && (cn = expr2.getType()) != null) {
            list2.add(cn);
        }
        return list2;
    }

    public List<ClassNode> getMemberClassList(AnnotationNode anno, String name2) {
        List<ClassNode> list2 = new ArrayList<ClassNode>();
        Expression expr2 = anno.getMember(name2);
        if (expr2 == null) {
            return null;
        }
        if (expr2 instanceof ListExpression) {
            ListExpression listExpression = (ListExpression)expr2;
            if (AbstractASTTransformation.isUndefinedMarkerList(listExpression)) {
                return null;
            }
            list2 = AbstractASTTransformation.getTypeList(listExpression);
        } else if (expr2 instanceof ClassExpression) {
            ClassNode cn = expr2.getType();
            if (Undefined.isUndefined(cn)) {
                return null;
            }
            if (cn != null) {
                list2.add(cn);
            }
        }
        return list2;
    }

    private static List<ClassNode> getTypeList(ListExpression listExpression) {
        ArrayList<ClassNode> list2 = new ArrayList<ClassNode>();
        for (Expression itemExpr : listExpression.getExpressions()) {
            ClassNode cn;
            if (!(itemExpr instanceof ClassExpression) || (cn = itemExpr.getType()) == null) continue;
            list2.add(cn);
        }
        return list2;
    }

    @Override
    public void addError(String msg, ASTNode expr2) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr2.getLineNumber(), expr2.getColumnNumber(), expr2.getLastLineNumber(), expr2.getLastColumnNumber()), this.sourceUnit));
    }

    protected boolean checkNotInterface(ClassNode cNode, String annotationName) {
        if (cNode.isInterface()) {
            this.addError("Error processing interface '" + cNode.getName() + "'. " + annotationName + " not allowed for interfaces.", cNode);
            return false;
        }
        return true;
    }

    public boolean hasAnnotation(ClassNode node, ClassNode annotation) {
        return AnnotatedNodeUtils.hasAnnotation(node, annotation);
    }

    public static List<String> tokenize(String rawExcludes) {
        return rawExcludes == null ? new ArrayList() : StringGroovyMethods.tokenize(rawExcludes, ", ");
    }

    public static boolean deemedInternalName(String name2) {
        return name2.contains("$");
    }

    public static boolean shouldSkipUndefinedAware(String name2, List<String> excludes, List<String> includes2) {
        return AbstractASTTransformation.shouldSkipUndefinedAware(name2, excludes, includes2, false);
    }

    public static boolean shouldSkipUndefinedAware(String name2, List<String> excludes, List<String> includes2, boolean allNames) {
        return excludes != null && excludes.contains(name2) || !allNames && AbstractASTTransformation.deemedInternalName(name2) || includes2 != null && !includes2.contains(name2);
    }

    public static boolean shouldSkip(String name2, List<String> excludes, List<String> includes2) {
        return AbstractASTTransformation.shouldSkip(name2, excludes, includes2, false);
    }

    public static boolean shouldSkip(String name2, List<String> excludes, List<String> includes2, boolean allNames) {
        return excludes != null && excludes.contains(name2) || !allNames && AbstractASTTransformation.deemedInternalName(name2) || includes2 != null && !includes2.isEmpty() && !includes2.contains(name2);
    }

    @Deprecated
    public static boolean shouldSkipOnDescriptor(boolean checkReturn, Map genericsSpec, MethodNode mNode, List<ClassNode> excludeTypes, List<ClassNode> includeTypes) {
        String md;
        MethodNode correctedMethodNode;
        ClassNode next2;
        Map<String, ClassNode> updatedGenericsSpec;
        LinkedList<ClassNode> remaining;
        String descriptor = mNode.getTypeDescriptor();
        String descriptorNoReturn = MethodNodeUtils.methodDescriptorWithoutReturnType(mNode);
        for (ClassNode cn : excludeTypes) {
            remaining = new LinkedList<ClassNode>();
            remaining.add(cn);
            updatedGenericsSpec = new HashMap<String, ClassNode>(genericsSpec);
            while (!remaining.isEmpty()) {
                next2 = (ClassNode)remaining.remove(0);
                if (next2.equals(ClassHelper.OBJECT_TYPE)) continue;
                updatedGenericsSpec = GenericsUtils.createGenericsSpec(next2, updatedGenericsSpec);
                for (MethodNode mn : next2.getMethods()) {
                    correctedMethodNode = GenericsUtils.correctToGenericsSpec(updatedGenericsSpec, mn);
                    if (!(checkReturn ? (md = correctedMethodNode.getTypeDescriptor()).equals(descriptor) : (md = MethodNodeUtils.methodDescriptorWithoutReturnType(correctedMethodNode)).equals(descriptorNoReturn))) continue;
                    return true;
                }
                remaining.addAll(Arrays.asList(next2.getInterfaces()));
            }
        }
        if (includeTypes.isEmpty()) {
            return false;
        }
        for (ClassNode cn : includeTypes) {
            remaining = new LinkedList();
            remaining.add(cn);
            updatedGenericsSpec = new HashMap(genericsSpec);
            while (!remaining.isEmpty()) {
                next2 = (ClassNode)remaining.remove(0);
                if (next2.equals(ClassHelper.OBJECT_TYPE)) continue;
                updatedGenericsSpec = GenericsUtils.createGenericsSpec(next2, updatedGenericsSpec);
                for (MethodNode mn : next2.getMethods()) {
                    correctedMethodNode = GenericsUtils.correctToGenericsSpec(updatedGenericsSpec, mn);
                    if (!(checkReturn ? (md = correctedMethodNode.getTypeDescriptor()).equals(descriptor) : (md = MethodNodeUtils.methodDescriptorWithoutReturnType(correctedMethodNode)).equals(descriptorNoReturn))) continue;
                    return false;
                }
                remaining.addAll(Arrays.asList(next2.getInterfaces()));
            }
        }
        return true;
    }

    public static boolean shouldSkipOnDescriptorUndefinedAware(boolean checkReturn, Map genericsSpec, MethodNode mNode, List<ClassNode> excludeTypes, List<ClassNode> includeTypes) {
        String md;
        MethodNode correctedMethodNode;
        ClassNode next2;
        Map<String, ClassNode> updatedGenericsSpec;
        LinkedList<ClassNode> remaining;
        String descriptor = mNode.getTypeDescriptor();
        String descriptorNoReturn = MethodNodeUtils.methodDescriptorWithoutReturnType(mNode);
        if (excludeTypes != null) {
            for (ClassNode cn : excludeTypes) {
                remaining = new LinkedList<ClassNode>();
                remaining.add(cn);
                updatedGenericsSpec = new HashMap<String, ClassNode>(genericsSpec);
                while (!remaining.isEmpty()) {
                    next2 = (ClassNode)remaining.remove(0);
                    if (next2.equals(ClassHelper.OBJECT_TYPE)) continue;
                    updatedGenericsSpec = GenericsUtils.createGenericsSpec(next2, updatedGenericsSpec);
                    for (MethodNode mn : next2.getMethods()) {
                        correctedMethodNode = GenericsUtils.correctToGenericsSpec(updatedGenericsSpec, mn);
                        if (!(checkReturn ? (md = correctedMethodNode.getTypeDescriptor()).equals(descriptor) : (md = MethodNodeUtils.methodDescriptorWithoutReturnType(correctedMethodNode)).equals(descriptorNoReturn))) continue;
                        return true;
                    }
                    remaining.addAll(Arrays.asList(next2.getInterfaces()));
                }
            }
        }
        if (includeTypes == null) {
            return false;
        }
        for (ClassNode cn : includeTypes) {
            remaining = new LinkedList();
            remaining.add(cn);
            updatedGenericsSpec = new HashMap(genericsSpec);
            while (!remaining.isEmpty()) {
                next2 = (ClassNode)remaining.remove(0);
                if (next2.equals(ClassHelper.OBJECT_TYPE)) continue;
                updatedGenericsSpec = GenericsUtils.createGenericsSpec(next2, updatedGenericsSpec);
                for (MethodNode mn : next2.getMethods()) {
                    correctedMethodNode = GenericsUtils.correctToGenericsSpec(updatedGenericsSpec, mn);
                    if (!(checkReturn ? (md = correctedMethodNode.getTypeDescriptor()).equals(descriptor) : (md = MethodNodeUtils.methodDescriptorWithoutReturnType(correctedMethodNode)).equals(descriptorNoReturn))) continue;
                    return false;
                }
                remaining.addAll(Arrays.asList(next2.getInterfaces()));
            }
        }
        return true;
    }

    @Deprecated
    protected boolean checkIncludeExclude(AnnotationNode node, List<String> excludes, List<String> includes2, String typeName) {
        if (includes2 != null && !includes2.isEmpty() && excludes != null && !excludes.isEmpty()) {
            this.addError("Error during " + typeName + " processing: Only one of 'includes' and 'excludes' should be supplied not both.", node);
            return false;
        }
        return true;
    }

    protected boolean checkIncludeExcludeUndefinedAware(AnnotationNode node, List<String> excludes, List<String> includes2, String typeName) {
        if (includes2 != null && excludes != null && !excludes.isEmpty()) {
            this.addError("Error during " + typeName + " processing: Only one of 'includes' and 'excludes' should be supplied not both.", node);
            return false;
        }
        return true;
    }

    @Deprecated
    protected void checkIncludeExclude(AnnotationNode node, List<String> excludes, List<String> includes2, List<ClassNode> excludeTypes, List<ClassNode> includeTypes, String typeName) {
        int found = 0;
        if (includes2 != null && !includes2.isEmpty()) {
            ++found;
        }
        if (excludes != null && !excludes.isEmpty()) {
            ++found;
        }
        if (includeTypes != null && !includeTypes.isEmpty()) {
            ++found;
        }
        if (excludeTypes != null && !excludeTypes.isEmpty()) {
            ++found;
        }
        if (found > 1) {
            this.addError("Error during " + typeName + " processing: Only one of 'includes', 'excludes', 'includeTypes' and 'excludeTypes' should be supplied.", node);
        }
    }

    protected void checkIncludeExcludeUndefinedAware(AnnotationNode node, List<String> excludes, List<String> includes2, List<ClassNode> excludeTypes, List<ClassNode> includeTypes, String typeName) {
        int found = 0;
        if (includes2 != null) {
            ++found;
        }
        if (excludes != null && !excludes.isEmpty()) {
            ++found;
        }
        if (includeTypes != null) {
            ++found;
        }
        if (excludeTypes != null && !excludeTypes.isEmpty()) {
            ++found;
        }
        if (found > 1) {
            this.addError("Error during " + typeName + " processing: Only one of 'includes', 'excludes', 'includeTypes' and 'excludeTypes' should be supplied.", node);
        }
    }

    public boolean checkPropertyList(ClassNode cNode, List<String> propertyNameList, String listName, AnnotationNode anno, String typeName, boolean includeFields) {
        return this.checkPropertyList(cNode, propertyNameList, listName, anno, typeName, includeFields, false, false);
    }

    public boolean checkPropertyList(ClassNode cNode, List<String> propertyNameList, String listName, AnnotationNode anno, String typeName, boolean includeFields, boolean includeSuperProperties, boolean allProperties) {
        return this.checkPropertyList(cNode, propertyNameList, listName, anno, typeName, includeFields, includeSuperProperties, allProperties, false, false);
    }

    public boolean checkPropertyList(ClassNode cNode, List<String> propertyNameList, String listName, AnnotationNode anno, String typeName, boolean includeFields, boolean includeSuperProperties, boolean allProperties, boolean includeSuperFields, boolean includeStatic) {
        if (propertyNameList == null || propertyNameList.isEmpty()) {
            return true;
        }
        ArrayList<String> pNames = new ArrayList<String>();
        for (PropertyNode pNode : BeanUtils.getAllProperties(cNode, includeSuperProperties, includeStatic, allProperties)) {
            pNames.add(pNode.getField().getName());
        }
        boolean result2 = true;
        if (includeFields || includeSuperFields) {
            ArrayList<String> fNames = new ArrayList<String>();
            if (includeFields) {
                fNames.addAll(GeneralUtils.getInstanceNonPropertyFieldNames(cNode));
            }
            if (includeSuperFields) {
                List<FieldNode> superNonPropertyFields = GeneralUtils.getSuperNonPropertyFields(cNode.getSuperClass());
                Iterator iterator2 = superNonPropertyFields.iterator();
                while (iterator2.hasNext()) {
                    FieldNode fn2 = (FieldNode)iterator2.next();
                    fNames.add(fn2.getName());
                }
            }
            for (String pName : propertyNameList) {
                if (pNames.contains(pName) || fNames.contains(pName)) continue;
                this.addError("Error during " + typeName + " processing: '" + listName + "' property or field '" + pName + "' does not exist.", anno);
                result2 = false;
            }
        } else {
            for (String pName : propertyNameList) {
                if (pNames.contains(pName)) continue;
                this.addError("Error during " + typeName + " processing: '" + listName + "' property '" + pName + "' does not exist.", anno);
                result2 = false;
            }
        }
        return result2;
    }

    @Deprecated
    public static ClassNode nonGeneric(ClassNode type) {
        return GenericsUtils.nonGeneric(type);
    }
}

