/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.GroovyClassLoader;
import groovy.transform.CompilationUnitAware;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.ASTTransformationsContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.ASTTransformationCollectorCodeVisitor;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.util.URLStreams;

public final class ASTTransformationVisitor
extends ClassCodeVisitorSupport {
    private final ASTTransformationsContext context;
    private final CompilePhase phase;
    private SourceUnit source;
    private List<ASTNode[]> targetNodes;
    private Map<ASTNode, List<ASTTransformation>> transforms;

    private ASTTransformationVisitor(CompilePhase phase, ASTTransformationsContext context) {
        this.phase = phase;
        this.context = context;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode classNode) {
        Map<Class<? extends ASTTransformation>, Set<ASTNode>> baseTransforms = classNode.getTransforms(this.phase);
        if (!baseTransforms.isEmpty()) {
            HashMap<Class<? extends ASTTransformation>, ASTTransformation> transformInstances = new HashMap<Class<? extends ASTTransformation>, ASTTransformation>();
            for (Class<? extends ASTTransformation> clazz2 : baseTransforms.keySet()) {
                try {
                    transformInstances.put(clazz2, clazz2.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.source.getErrorCollector().addError(new SimpleMessage("Could not instantiate Transformation Processor " + clazz2, this.source));
                }
            }
            this.transforms = new HashMap<ASTNode, List<ASTTransformation>>();
            for (Map.Entry entry2 : baseTransforms.entrySet()) {
                for (ASTNode node : (Set)entry2.getValue()) {
                    List<ASTTransformation> list2 = this.transforms.get(node);
                    if (list2 == null) {
                        list2 = new ArrayList<ASTTransformation>();
                        this.transforms.put(node, list2);
                    }
                    list2.add((ASTTransformation)transformInstances.get(entry2.getKey()));
                }
            }
            this.targetNodes = new LinkedList<ASTNode[]>();
            super.visitClass(classNode);
            for (ASTNode[] aSTNodeArray : this.targetNodes) {
                for (ASTTransformation snt : this.transforms.get(aSTNodeArray[0])) {
                    if (snt instanceof CompilationUnitAware) {
                        ((CompilationUnitAware)((Object)snt)).setCompilationUnit(this.context.getCompilationUnit());
                    }
                    snt.visit(aSTNodeArray, this.source);
                }
            }
        }
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        super.visitAnnotations(node);
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!this.transforms.containsKey(annotation)) continue;
            this.targetNodes.add(new ASTNode[]{annotation, node});
        }
    }

    public static void addPhaseOperations(final CompilationUnit compilationUnit2) {
        ASTTransformationsContext context = compilationUnit2.getASTTransformationsContext();
        ASTTransformationVisitor.addGlobalTransforms(context);
        compilationUnit2.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

            @Override
            public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                ASTTransformationCollectorCodeVisitor collector = new ASTTransformationCollectorCodeVisitor(source, compilationUnit2.getTransformLoader());
                collector.visitClass(classNode);
            }
        }, 4);
        block3: for (CompilePhase phase : CompilePhase.values()) {
            ASTTransformationVisitor visitor = new ASTTransformationVisitor(phase, context);
            switch (phase) {
                case INITIALIZATION: 
                case PARSING: 
                case CONVERSION: {
                    continue block3;
                }
                default: {
                    compilationUnit2.addPhaseOperation(new CompilationUnit.PrimaryClassNodeOperation(){

                        @Override
                        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                            ASTTransformationVisitor.this.source = source;
                            ASTTransformationVisitor.this.visitClass(classNode);
                        }
                    }, phase.getPhaseNumber());
                }
            }
        }
    }

    public static void addGlobalTransformsAfterGrab(ASTTransformationsContext context) {
        ASTTransformationVisitor.doAddGlobalTransforms(context, false);
    }

    public static void addGlobalTransforms(ASTTransformationsContext context) {
        ASTTransformationVisitor.doAddGlobalTransforms(context, true);
    }

    private static void doAddGlobalTransforms(ASTTransformationsContext context, boolean isFirstScan) {
        CompilationUnit compilationUnit2 = context.getCompilationUnit();
        GroovyClassLoader transformLoader = compilationUnit2.getTransformLoader();
        LinkedHashMap<String, URL> transformNames = new LinkedHashMap<String, URL>();
        try {
            Enumeration<URL> globalServices = transformLoader.getResources("META-INF/services/org.codehaus.groovy.transform.ASTTransformation");
            while (globalServices.hasMoreElements()) {
                String className2;
                URL service = globalServices.nextElement();
                BufferedReader svcIn = new BufferedReader(new InputStreamReader(URLStreams.openUncachedStream(service), "UTF-8"));
                try {
                    className2 = svcIn.readLine();
                }
                catch (IOException ioe) {
                    compilationUnit2.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                    svcIn.close();
                    continue;
                }
                try {
                    Set<String> disabledGlobalTransforms = compilationUnit2.getConfiguration().getDisabledGlobalASTTransformations();
                    if (disabledGlobalTransforms == null) {
                        disabledGlobalTransforms = Collections.emptySet();
                    }
                    while (className2 != null) {
                        if (!className2.startsWith("#") && className2.length() > 0 && !disabledGlobalTransforms.contains(className2)) {
                            if (transformNames.containsKey(className2)) {
                                try {
                                    if (!service.toURI().equals(((URL)transformNames.get(className2)).toURI())) {
                                        compilationUnit2.getErrorCollector().addWarning(2, "The global transform for class " + className2 + " is defined in both " + ((URL)transformNames.get(className2)).toExternalForm() + " and " + service.toExternalForm() + " - the former definition will be used and the latter ignored.", null, null);
                                    }
                                }
                                catch (URISyntaxException e) {
                                    compilationUnit2.getErrorCollector().addWarning(2, "Failed to parse URL as URI because of exception " + e.toString(), null, null);
                                }
                            } else {
                                transformNames.put(className2, service);
                            }
                        }
                        try {
                            className2 = svcIn.readLine();
                        }
                        catch (IOException ioe) {
                            compilationUnit2.getErrorCollector().addError(new SimpleMessage("IOException reading the service definition at " + service.toExternalForm() + " because of exception " + ioe.toString(), null));
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    svcIn.close();
                }
            }
        }
        catch (IOException e) {
            compilationUnit2.getErrorCollector().addError(new SimpleMessage("IO Exception attempting to load global transforms:" + e.getMessage(), null));
        }
        if (isFirstScan) {
            for (Map.Entry entry2 : transformNames.entrySet()) {
                context.getGlobalTransformNames().add((String)entry2.getKey());
            }
            ASTTransformationVisitor.addPhaseOperationsForGlobalTransforms(context.getCompilationUnit(), transformNames, isFirstScan);
        } else {
            Iterator it = transformNames.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry2;
                entry2 = it.next();
                if (context.getGlobalTransformNames().add((String)entry2.getKey())) continue;
                it.remove();
            }
            ASTTransformationVisitor.addPhaseOperationsForGlobalTransforms(context.getCompilationUnit(), transformNames, isFirstScan);
        }
    }

    private static void addPhaseOperationsForGlobalTransforms(CompilationUnit compilationUnit2, Map<String, URL> transformNames, boolean isFirstScan) {
        GroovyClassLoader transformLoader = compilationUnit2.getTransformLoader();
        for (Map.Entry<String, URL> entry2 : transformNames.entrySet()) {
            try {
                Class gTransClass = transformLoader.loadClass(entry2.getKey(), false, true, false);
                GroovyASTTransformation transformAnnotation = gTransClass.getAnnotation(GroovyASTTransformation.class);
                if (transformAnnotation == null) {
                    compilationUnit2.getErrorCollector().addWarning(new WarningMessage(2, "Transform Class " + entry2.getKey() + " is specified as a global transform in " + entry2.getValue().toExternalForm() + " but it is not annotated by " + GroovyASTTransformation.class.getName() + " the global transform associated with it may fail and cause the compilation to fail.", null, null));
                    continue;
                }
                if (ASTTransformation.class.isAssignableFrom(gTransClass)) {
                    final ASTTransformation instance = (ASTTransformation)gTransClass.newInstance();
                    if (instance instanceof CompilationUnitAware) {
                        ((CompilationUnitAware)((Object)instance)).setCompilationUnit(compilationUnit2);
                    }
                    CompilationUnit.SourceUnitOperation suOp = new CompilationUnit.SourceUnitOperation(){

                        @Override
                        public void call(SourceUnit source) throws CompilationFailedException {
                            instance.visit(new ASTNode[]{source.getAST()}, source);
                        }
                    };
                    if (isFirstScan) {
                        compilationUnit2.addPhaseOperation(suOp, transformAnnotation.phase().getPhaseNumber());
                        continue;
                    }
                    compilationUnit2.addNewPhaseOperation(suOp, transformAnnotation.phase().getPhaseNumber());
                    continue;
                }
                compilationUnit2.getErrorCollector().addError(new SimpleMessage("Transform Class " + entry2.getKey() + " specified at " + entry2.getValue().toExternalForm() + " is not an ASTTransformation.", null));
            }
            catch (Exception e) {
                compilationUnit2.getErrorCollector().addError(new SimpleMessage("Could not instantiate global transform class " + entry2.getKey() + " specified at " + entry2.getValue().toExternalForm() + "  because of exception " + e.toString(), null));
            }
        }
    }
}

