/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.shell.util;

import groovy.lang.GroovyObjectSupport;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageSource
extends GroovyObjectSupport {
    private final String[] bundleNames;
    private ResourceBundle[] cachedBundles;

    public MessageSource(String[] names) {
        assert (names != null);
        assert (names.length != 0);
        this.bundleNames = names;
    }

    public MessageSource(String name2) {
        this(new String[]{name2});
    }

    private static String[] classNames(Class[] types2) {
        assert (types2 != null);
        assert (types2.length != 0);
        String[] names = new String[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            assert (types2[i] != null);
            names[i] = types2[i].getName();
        }
        return names;
    }

    public MessageSource(Class[] types2) {
        this(MessageSource.classNames(types2));
    }

    public MessageSource(Class type) {
        this(new String[]{type.getName()});
    }

    private ResourceBundle[] createBundles() {
        ResourceBundle[] bundles = new ResourceBundle[this.bundleNames.length];
        for (int i = 0; i < this.bundleNames.length; ++i) {
            assert (this.bundleNames[i] != null);
            bundles[i] = ResourceBundle.getBundle(this.bundleNames[i]);
        }
        return bundles;
    }

    private ResourceBundle[] getBundles() {
        if (this.cachedBundles == null) {
            this.cachedBundles = this.createBundles();
        }
        return this.cachedBundles;
    }

    public String getMessage(String code) {
        assert (code != null);
        MissingResourceException error2 = null;
        ResourceBundle[] bundles = this.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            try {
                return bundles[i].getString(code);
            }
            catch (MissingResourceException e) {
                if (error2 == null) continue;
                error2 = e;
                continue;
            }
        }
        assert (error2 != null);
        throw error2;
    }

    public String format(String code, Object[] args2) {
        assert (args2 != null);
        String pattern = this.getMessage(code);
        return MessageFormat.format(pattern, args2);
    }

    @Override
    public Object getProperty(String name2) {
        return this.getMessage(name2);
    }
}

