/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.control.SourceUnit;

public class ASTHelper {
    private SourceUnit controller;
    private ClassLoader classLoader;
    protected ModuleNode output;
    private String packageName;
    protected static Map resolutions = new HashMap();

    public ASTHelper(SourceUnit controller, ClassLoader classLoader) {
        this();
        this.controller = controller;
        this.classLoader = classLoader;
    }

    public ASTHelper() {
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.setPackage(packageName, new ArrayList<AnnotationNode>());
    }

    public PackageNode setPackage(String packageName, List<AnnotationNode> annotations2) {
        this.packageName = packageName;
        if (packageName != null && packageName.length() > 0) {
            packageName = packageName + '.';
        }
        PackageNode packageNode = new PackageNode(packageName);
        packageNode.addAnnotations(annotations2);
        this.output.setPackage(packageNode);
        return packageNode;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public SourceUnit getController() {
        return this.controller;
    }

    public void setController(SourceUnit controller) {
        this.controller = controller;
    }

    public static String dot(String base, String name2) {
        if (base != null && base.length() > 0) {
            return base + "." + name2;
        }
        return name2;
    }

    protected void makeModule() {
        this.output = new ModuleNode(this.controller);
        resolutions.clear();
    }

    protected String dot(String base) {
        return ASTHelper.dot(base, "");
    }

    protected void addImport(ClassNode type, String name2, String aliasName) {
        this.addImport(type, name2, aliasName, new ArrayList<AnnotationNode>());
    }

    protected void addImport(ClassNode type, String name2, String aliasName, List<AnnotationNode> annotations2) {
        if (aliasName == null) {
            aliasName = name2;
        }
        this.output.addImport(aliasName, type, annotations2);
    }

    protected void addStaticImport(ClassNode type, String name2, String alias) {
        this.addStaticImport(type, name2, alias, new ArrayList<AnnotationNode>());
    }

    protected void addStaticImport(ClassNode type, String name2, String alias, List<AnnotationNode> annotations2) {
        if (alias == null) {
            alias = name2;
        }
        this.output.addStaticImport(type, name2, alias, annotations2);
    }

    protected void addStaticStarImport(ClassNode type, String importClass) {
        this.addStaticStarImport(type, importClass, new ArrayList<AnnotationNode>());
    }

    protected void addStaticStarImport(ClassNode type, String importClass, List<AnnotationNode> annotations2) {
        this.output.addStaticStarImport(importClass, type, annotations2);
    }

    protected void addStarImport(String importPackage) {
        this.addStarImport(importPackage, new ArrayList<AnnotationNode>());
    }

    protected void addStarImport(String importPackage, List<AnnotationNode> annotations2) {
        this.output.addStarImport(this.dot(importPackage), annotations2);
    }
}

