/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.Reflector;

public class ReflectorLoader
extends ClassLoader {
    private boolean inDefine = false;
    private final Map loadedClasses = new HashMap();
    private final ClassLoader delegatationLoader = this.getClass().getClassLoader();
    private static final String REFLECTOR = Reflector.class.getName();

    protected Class findClass(String name2) throws ClassNotFoundException {
        if (this.delegatationLoader == null) {
            return super.findClass(name2);
        }
        return this.delegatationLoader.loadClass(name2);
    }

    protected synchronized Class loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        if (this.inDefine && name2.equals(REFLECTOR)) {
            return Reflector.class;
        }
        return super.loadClass(name2, resolve2);
    }

    public synchronized Class defineClass(String name2, byte[] bytecode, ProtectionDomain domain) {
        this.inDefine = true;
        Class<?> c = this.defineClass(name2, bytecode, 0, bytecode.length, domain);
        this.loadedClasses.put(name2, c);
        this.resolveClass(c);
        this.inDefine = false;
        return c;
    }

    public ReflectorLoader(ClassLoader parent) {
        super(parent);
    }

    public synchronized Class getLoadedClass(String name2) {
        return (Class)this.loadedClasses.get(name2);
    }

    static String getReflectorName(Class theClass) {
        String className2 = theClass.getName();
        if (className2.startsWith("java.")) {
            String packagePrefix = "gjdk.";
            String name2 = packagePrefix + className2 + "_GroovyReflector";
            if (theClass.isArray()) {
                Class<?> clazz2 = theClass;
                name2 = packagePrefix;
                int level = 0;
                while (clazz2.isArray()) {
                    clazz2 = clazz2.getComponentType();
                    ++level;
                }
                String componentName = clazz2.getName();
                name2 = packagePrefix + componentName + "_GroovyReflectorArray";
                if (level > 1) {
                    name2 = name2 + level;
                }
            }
            return name2;
        }
        String name3 = className2.replace('$', '_') + "_GroovyReflector";
        if (theClass.isArray()) {
            Class<?> clazz3 = theClass;
            int level = 0;
            while (clazz3.isArray()) {
                clazz3 = clazz3.getComponentType();
                ++level;
            }
            String componentName = clazz3.getName();
            name3 = componentName.replace('$', '_') + "_GroovyReflectorArray";
            if (level > 1) {
                name3 = name3 + level;
            }
        }
        return name3;
    }
}

