/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentReaderHashMap
extends AbstractMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3225682440765612861L;
    protected final BarrierLock barrierLock = new BarrierLock();
    protected transient Object lastWrite;
    public static final int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected transient int count;
    protected int threshold;
    protected float loadFactor;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recordModification(Object x) {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            this.lastWrite = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Entry[] getTableForReading() {
        BarrierLock barrierLock = this.barrierLock;
        synchronized (barrierLock) {
            return this.table;
        }
    }

    private static int p2capacity(int initialCapacity) {
        int result2;
        int cap = initialCapacity;
        if (cap > 0x40000000 || cap < 0) {
            result2 = 0x40000000;
        } else {
            for (result2 = 4; result2 < cap; result2 <<= 1) {
            }
        }
        return result2;
    }

    private static int hash(Object x) {
        int h = x.hashCode();
        return (h << 7) - h + (h >>> 9) + (h >>> 17);
    }

    protected boolean eq(Object x, Object y) {
        return x == y || x.equals(y);
    }

    public ConcurrentReaderHashMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int cap = ConcurrentReaderHashMap.p2capacity(initialCapacity);
        this.table = new Entry[cap];
        this.threshold = (int)((float)cap * loadFactor);
    }

    public ConcurrentReaderHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ConcurrentReaderHashMap() {
        this(32, 0.75f);
    }

    public ConcurrentReaderHashMap(Map t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(t);
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Entry first;
        int hash2 = ConcurrentReaderHashMap.hash(key);
        Entry[] tab = this.table;
        int index2 = hash2 & tab.length - 1;
        Entry e = first = tab[index2];
        while (true) {
            if (e == null) {
                Entry[] reread = this.getTableForReading();
                if (tab == reread && first == tab[index2]) {
                    return null;
                }
                tab = reread;
                index2 = hash2 & tab.length - 1;
                e = first = tab[index2];
                continue;
            }
            if (e.hash == hash2 && this.eq(key, e.key)) {
                Object value2 = e.value;
                if (value2 != null) {
                    return value2;
                }
                ConcurrentReaderHashMap concurrentReaderHashMap = this;
                synchronized (concurrentReaderHashMap) {
                    tab = this.table;
                }
                index2 = hash2 & tab.length - 1;
                e = first = tab[index2];
                continue;
            }
            e = e.next;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value2) {
        Entry first;
        if (value2 == null) {
            throw new NullPointerException();
        }
        int hash2 = ConcurrentReaderHashMap.hash(key);
        Entry[] tab = this.table;
        int index2 = hash2 & tab.length - 1;
        Entry e = first = tab[index2];
        while (!(e == null || e.hash == hash2 && this.eq(key, e.key))) {
            e = e.next;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this;
        synchronized (concurrentReaderHashMap) {
            if (tab == this.table) {
                if (e == null) {
                    if (first == tab[index2]) {
                        Entry newEntry;
                        tab[index2] = newEntry = new Entry(hash2, key, value2, first);
                        if (++this.count >= this.threshold) {
                            this.rehash();
                        } else {
                            this.recordModification(newEntry);
                        }
                        return null;
                    }
                } else {
                    Object oldValue = e.value;
                    if (first == tab[index2] && oldValue != null) {
                        e.value = value2;
                        return oldValue;
                    }
                }
            }
            return this.sput(key, value2, hash2);
        }
    }

    protected Object sput(Object key, Object value2, int hash2) {
        Entry first;
        Entry[] tab = this.table;
        int index2 = hash2 & tab.length - 1;
        Entry e = first = tab[index2];
        while (true) {
            if (e == null) {
                Entry newEntry;
                tab[index2] = newEntry = new Entry(hash2, key, value2, first);
                if (++this.count >= this.threshold) {
                    this.rehash();
                } else {
                    this.recordModification(newEntry);
                }
                return null;
            }
            if (e.hash == hash2 && this.eq(key, e.key)) {
                Object oldValue = e.value;
                e.value = value2;
                return oldValue;
            }
            e = e.next;
        }
    }

    protected void rehash() {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int newCapacity = oldCapacity << 1;
        int mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        Entry[] newTable = new Entry[newCapacity];
        for (int i = 0; i < oldCapacity; ++i) {
            int k;
            Entry e = oldTable[i];
            if (e == null) continue;
            int idx = e.hash & mask;
            Entry next2 = e.next;
            if (next2 == null) {
                newTable[idx] = e;
                continue;
            }
            Entry lastRun = e;
            int lastIdx = idx;
            Entry last2 = next2;
            while (last2 != null) {
                k = last2.hash & mask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last2;
                }
                last2 = last2.next;
            }
            newTable[lastIdx] = lastRun;
            Entry p = e;
            while (p != lastRun) {
                k = p.hash & mask;
                newTable[k] = new Entry(p.hash, p.key, p.value, newTable[k]);
                p = p.next;
            }
        }
        this.table = newTable;
        this.recordModification(newTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key) {
        Entry first;
        int hash2 = ConcurrentReaderHashMap.hash(key);
        Entry[] tab = this.table;
        int index2 = hash2 & tab.length - 1;
        Entry e = first = tab[index2];
        e = first;
        while (!(e == null || e.hash == hash2 && this.eq(key, e.key))) {
            e = e.next;
        }
        ConcurrentReaderHashMap concurrentReaderHashMap = this;
        synchronized (concurrentReaderHashMap) {
            if (tab == this.table) {
                if (e == null) {
                    if (first == tab[index2]) {
                        return null;
                    }
                } else {
                    Object oldValue = e.value;
                    if (first == tab[index2] && oldValue != null) {
                        e.value = null;
                        --this.count;
                        Entry head2 = e.next;
                        Entry p = first;
                        while (p != e) {
                            head2 = new Entry(p.hash, p.key, p.value, head2);
                            p = p.next;
                        }
                        tab[index2] = head2;
                        this.recordModification(head2);
                        return oldValue;
                    }
                }
            }
            return this.sremove(key, hash2);
        }
    }

    protected Object sremove(Object key, int hash2) {
        Entry first;
        Entry[] tab = this.table;
        int index2 = hash2 & tab.length - 1;
        Entry e = first = tab[index2];
        while (e != null) {
            if (e.hash == hash2 && this.eq(key, e.key)) {
                Object oldValue = e.value;
                e.value = null;
                --this.count;
                Entry head2 = e.next;
                Entry p = first;
                while (p != e) {
                    head2 = new Entry(p.hash, p.key, p.value, head2);
                    p = p.next;
                }
                tab[index2] = head2;
                this.recordModification(head2);
                return oldValue;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.getTableForReading();
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value2.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean contains(Object value2) {
        return this.containsValue(value2);
    }

    @Override
    public synchronized void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        while (n >= this.threshold) {
            this.rehash();
        }
        for (Map.Entry entry2 : t.entrySet()) {
            Object key = entry2.getKey();
            Object value2 = entry2.getValue();
            this.put(key, value2);
        }
    }

    @Override
    public synchronized void clear() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                e.value = null;
                e = e.next;
            }
            tab[i] = null;
        }
        this.count = 0;
        this.recordModification(tab);
    }

    @Override
    public synchronized Object clone() {
        try {
            ConcurrentReaderHashMap t = (ConcurrentReaderHashMap)super.clone();
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            Entry[] tab = this.table;
            Entry[] ttab = t.table = new Entry[tab.length];
            for (int i = 0; i < tab.length; ++i) {
                Entry first = null;
                Entry e = tab[i];
                while (e != null) {
                    first = new Entry(e.hash, e.key, e.value, first);
                    e = e.next;
                }
                ttab[i] = first;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    protected synchronized boolean findAndRemoveEntry(Map.Entry entry2) {
        Object key = entry2.getKey();
        Object v = this.get(key);
        if (v != null && v.equals(entry2.getValue())) {
            this.remove(key);
            return true;
        }
        return false;
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    private synchronized void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.table.length);
        s2.writeInt(this.count);
        for (int index2 = this.table.length - 1; index2 >= 0; --index2) {
            Entry entry2 = this.table[index2];
            while (entry2 != null) {
                s2.writeObject(entry2.key);
                s2.writeObject(entry2.value);
                entry2 = entry2.next;
            }
        }
    }

    private synchronized void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int numBuckets = s2.readInt();
        this.table = new Entry[numBuckets];
        int size2 = s2.readInt();
        for (int i = 0; i < size2; ++i) {
            Object key = s2.readObject();
            Object value2 = s2.readObject();
            this.put(key, value2);
        }
    }

    public synchronized int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        @Override
        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        @Override
        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        protected HashIterator() {
            this.tab = ConcurrentReaderHashMap.this.getTableForReading();
            this.index = this.tab.length - 1;
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        @Override
        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object v = this.entry.value;
                    if (v != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = v;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result2 = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return result2;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentReaderHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final int hash;
        protected final Object key;
        protected final Entry next;
        protected volatile Object value;

        Entry(int hash2, Object key, Object value2, Entry next2) {
            this.hash = hash2;
            this.key = key;
            this.next = next2;
            this.value = value2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value2) {
            if (value2 == null) {
                throw new NullPointerException();
            }
            Object oldValue = this.value;
            this.value = value2;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key.equals(e.getKey()) && this.value.equals(e.getValue());
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new HashIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry2 = (Map.Entry)o;
            Object v = ConcurrentReaderHashMap.this.get(entry2.getKey());
            return v != null && v.equals(entry2.getValue());
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            return ConcurrentReaderHashMap.this.findAndRemoveEntry((Map.Entry)o);
        }

        @Override
        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentReaderHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ConcurrentReaderHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return ConcurrentReaderHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ConcurrentReaderHashMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            ConcurrentReaderHashMap.this.clear();
        }

        @Override
        public Object[] toArray() {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    protected static class BarrierLock
    implements Serializable {
        private static final long serialVersionUID = -2159505361622844863L;

        protected BarrierLock() {
        }
    }
}

