/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.memoize;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.groovy.util.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;

@ThreadSafe
public final class LRUCache<K, V>
implements MemoizeCache<K, V> {
    private final ConcurrentMap<K, V> map;

    public LRUCache(int maxCacheSize) {
        this.map = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(maxCacheSize).build();
    }

    @Override
    public V put(K key, V value2) {
        return this.map.put(key, value2);
    }

    @Override
    public V get(K key) {
        return this.map.get(key);
    }

    @Override
    public V getAndPut(K key, MemoizeCache.ValueProvider<? super K, ? extends V> valueProvider) {
        V value2 = this.get(key);
        if (null == value2) {
            value2 = valueProvider.provide(key);
            this.put(key, value2);
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanUpNullReferences() {
        ConcurrentMap<K, V> concurrentMap = this.map;
        synchronized (concurrentMap) {
            Iterator iterator2 = this.map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry2 = iterator2.next();
                Object value2 = entry2.getValue();
                if (!(value2 instanceof SoftReference) || ((SoftReference)value2).get() != null) continue;
                iterator2.remove();
            }
        }
    }
}

