/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.EmptyRange;
import groovy.lang.GString;
import groovy.lang.IntRange;
import groovy.lang.Range;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FromString;
import groovy.transform.stc.PickFirstResolver;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.groovy.io.StringBuilderWriter;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.RangeInfo;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.util.CharSequenceReader;

public class StringGroovyMethods
extends DefaultGroovyMethodsSupport {
    static String lineSeparator = null;

    public static boolean asBoolean(CharSequence string2) {
        if (null == string2) {
            return false;
        }
        return string2.length() > 0;
    }

    public static boolean asBoolean(Matcher matcher2) {
        if (null == matcher2) {
            return false;
        }
        RegexSupport.setLastMatcher(matcher2);
        return matcher2.find();
    }

    public static <T> T asType(CharSequence self, Class<T> c) {
        return StringGroovyMethods.asType(self.toString(), c);
    }

    public static <T> T asType(GString self, Class<T> c) {
        if (c == File.class) {
            return (T)new File(self.toString());
        }
        if (Number.class.isAssignableFrom(c) || c.isPrimitive()) {
            return StringGroovyMethods.asType(self.toString(), c);
        }
        return DefaultGroovyMethods.asType((Object)self, c);
    }

    public static <T> T asType(String self, Class<T> c) {
        if (c == List.class) {
            return (T)StringGroovyMethods.toList((CharSequence)self);
        }
        if (c == BigDecimal.class) {
            return (T)StringGroovyMethods.toBigDecimal((CharSequence)self);
        }
        if (c == BigInteger.class) {
            return (T)StringGroovyMethods.toBigInteger((CharSequence)self);
        }
        if (c == Long.class || c == Long.TYPE) {
            return (T)StringGroovyMethods.toLong((CharSequence)self);
        }
        if (c == Integer.class || c == Integer.TYPE) {
            return (T)StringGroovyMethods.toInteger((CharSequence)self);
        }
        if (c == Short.class || c == Short.TYPE) {
            return (T)StringGroovyMethods.toShort((CharSequence)self);
        }
        if (c == Byte.class || c == Byte.TYPE) {
            return (T)Byte.valueOf(self.trim());
        }
        if (c == Character.class || c == Character.TYPE) {
            return (T)StringGroovyMethods.toCharacter(self);
        }
        if (c == Double.class || c == Double.TYPE) {
            return (T)StringGroovyMethods.toDouble((CharSequence)self);
        }
        if (c == Float.class || c == Float.TYPE) {
            return (T)StringGroovyMethods.toFloat((CharSequence)self);
        }
        if (c == File.class) {
            return (T)new File(self);
        }
        if (c.isEnum()) {
            return (T)InvokerHelper.invokeMethod(c, "valueOf", new Object[]{self});
        }
        return DefaultGroovyMethods.asType((Object)self, c);
    }

    public static Pattern bitwiseNegate(CharSequence self) {
        return Pattern.compile(self.toString());
    }

    @Deprecated
    public static Pattern bitwiseNegate(String self) {
        return StringGroovyMethods.bitwiseNegate((CharSequence)self);
    }

    public static String uncapitalize(CharSequence self) {
        if (self.length() == 0) {
            return "";
        }
        return "" + Character.toLowerCase(self.charAt(0)) + self.subSequence(1, self.length());
    }

    public static String capitalize(CharSequence self) {
        if (self.length() == 0) {
            return "";
        }
        return "" + Character.toUpperCase(self.charAt(0)) + self.subSequence(1, self.length());
    }

    @Deprecated
    public static String capitalize(String self) {
        return StringGroovyMethods.capitalize((CharSequence)self);
    }

    public static String center(CharSequence self, Number numberOfChars) {
        return StringGroovyMethods.center(self, numberOfChars, (CharSequence)" ");
    }

    public static String center(CharSequence self, Number numberOfChars, CharSequence padding2) {
        String semiPad;
        int numChars = numberOfChars.intValue();
        if (numChars <= self.length()) {
            return self.toString();
        }
        int charsToAdd = numChars - self.length();
        String string2 = semiPad = charsToAdd % 2 == 1 ? StringGroovyMethods.getPadding(padding2, charsToAdd / 2 + 1) : StringGroovyMethods.getPadding(padding2, charsToAdd / 2);
        if (charsToAdd % 2 == 0) {
            return semiPad + self + semiPad;
        }
        return semiPad.substring(0, charsToAdd / 2) + self + semiPad;
    }

    @Deprecated
    public static String center(String self, Number numberOfChars) {
        return StringGroovyMethods.center((CharSequence)self, numberOfChars);
    }

    @Deprecated
    public static String center(String self, Number numberOfChars, String padding2) {
        return StringGroovyMethods.center((CharSequence)self, numberOfChars, (CharSequence)padding2);
    }

    public static boolean contains(CharSequence self, CharSequence text2) {
        int idx = self.toString().indexOf(text2.toString());
        return idx >= 0;
    }

    @Deprecated
    public static boolean contains(String self, String text2) {
        return StringGroovyMethods.contains((CharSequence)self, (CharSequence)text2);
    }

    public static int count(CharSequence self, CharSequence text2) {
        int answer = 0;
        int idx = 0;
        while ((idx = self.toString().indexOf(text2.toString(), idx)) >= answer) {
            ++answer;
            ++idx;
        }
        return answer;
    }

    @Deprecated
    public static int count(String self, String text2) {
        return StringGroovyMethods.count((CharSequence)self, (CharSequence)text2);
    }

    public static String denormalize(CharSequence self) {
        CharSequence cs;
        int len;
        if (lineSeparator == null) {
            StringBuilderWriter sw = new StringBuilderWriter(2);
            try {
                BufferedWriter bw = new BufferedWriter(sw);
                bw.newLine();
                bw.flush();
                lineSeparator = ((Object)sw).toString();
            }
            catch (IOException ioe) {
                lineSeparator = "\n";
            }
        }
        if ((len = self.length()) < 1) {
            return self.toString();
        }
        StringBuilder sb = new StringBuilder(110 * len / 100);
        int i = 0;
        CharSequence charSequence = cs = self instanceof GString ? self.toString() : self;
        block6: while (i < len) {
            char ch = cs.charAt(i++);
            switch (ch) {
                case '\r': {
                    sb.append(lineSeparator);
                    if (i >= len || cs.charAt(i) != '\n') continue block6;
                    ++i;
                    continue block6;
                }
                case '\n': {
                    sb.append(lineSeparator);
                    continue block6;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Deprecated
    public static String denormalize(String self) {
        return StringGroovyMethods.denormalize((CharSequence)self);
    }

    public static CharSequence drop(CharSequence self, int num) {
        if (num <= 0) {
            return self;
        }
        if (self.length() <= num) {
            return self.subSequence(0, 0);
        }
        return self.subSequence(num, self.length());
    }

    public static String drop(GString self, int num) {
        return StringGroovyMethods.drop(self.toString(), num);
    }

    public static String drop(String self, int num) {
        return (String)StringGroovyMethods.drop((CharSequence)self, num);
    }

    public static String dropWhile(CharSequence self, @ClosureParams(value=FromString.class, conflictResolutionStrategy=PickFirstResolver.class, options={"String", "Character"}) Closure condition) {
        Iterator<Character> selfIter = ClosureUtils.hasSingleCharacterArg(condition) ? new CharacterIterator(self) : new StringIterator(self);
        return DefaultGroovyMethods.join(DefaultGroovyMethods.dropWhile(selfIter, condition), "");
    }

    @Deprecated
    public static /* bridge */ /* synthetic */ CharSequence dropWhile(CharSequence self, @ClosureParams(value=FromString.class, conflictResolutionStrategy=PickFirstResolver.class, options={"String", "Character"}) Closure condition) {
        return StringGroovyMethods.dropWhile(self, condition);
    }

    public static String dropWhile(GString self, @ClosureParams(value=FromString.class, conflictResolutionStrategy=PickFirstResolver.class, options={"String", "Character"}) Closure condition) {
        return StringGroovyMethods.dropWhile(self.toString(), condition);
    }

    public static <T> T eachLine(CharSequence self, @ClosureParams(value=FromString.class, options={"String", "String,Integer"}) Closure<T> closure) throws IOException {
        return StringGroovyMethods.eachLine((CharSequence)self.toString(), 0, closure);
    }

    public static <T> T eachLine(CharSequence self, int firstLine, @ClosureParams(value=FromString.class, options={"String", "String,Integer"}) Closure<T> closure) throws IOException {
        int count2 = firstLine;
        T result2 = null;
        for (String line : new LineIterable(self)) {
            result2 = DefaultGroovyMethods.callClosureForLine(closure, line, count2);
            ++count2;
        }
        return result2;
    }

    @Deprecated
    public static <T> T eachLine(String self, @ClosureParams(value=FromString.class, options={"String", "String,Integer"}) Closure<T> closure) throws IOException {
        return StringGroovyMethods.eachLine((CharSequence)self, closure);
    }

    @Deprecated
    public static <T> T eachLine(String self, int firstLine, @ClosureParams(value=FromString.class, options={"String", "String,Integer"}) Closure<T> closure) throws IOException {
        return StringGroovyMethods.eachLine((CharSequence)self, firstLine, closure);
    }

    public static String collectReplacements(String orig, @ClosureParams(value=FromString.class, conflictResolutionStrategy=PickFirstResolver.class, options={"String", "Character"}) Closure<String> transform2) {
        if (orig == null) {
            return orig;
        }
        StringBuilder sb = null;
        int len = orig.length();
        for (int i = 0; i < len; ++i) {
            char ch = orig.charAt(i);
            String replacement = transform2.call(ClosureUtils.hasSingleCharacterArg(transform2) ? Character.valueOf(ch) : Character.toString(ch));
            if (replacement != null) {
                if (sb == null) {
                    sb = new StringBuilder((int)(1.1 * (double)len));
                    sb.append(orig, 0, i);
                }
                sb.append(replacement);
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? orig : sb.toString();
    }

    public static <T extends CharSequence> T eachMatch(T self, CharSequence regex, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        StringGroovyMethods.eachMatch(self.toString(), regex.toString(), closure);
        return self;
    }

    public static <T extends CharSequence> T eachMatch(T self, Pattern pattern, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        StringGroovyMethods.eachMatch(self.toString(), pattern, closure);
        return self;
    }

    public static String eachMatch(String self, Pattern pattern, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        Matcher m = pattern.matcher(self);
        DefaultGroovyMethods.each(m, closure);
        return self;
    }

    public static String eachMatch(String self, String regex, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        return StringGroovyMethods.eachMatch(self, Pattern.compile(regex), closure);
    }

    public static String expand(CharSequence self) {
        return StringGroovyMethods.expand(self, 8);
    }

    public static String expand(CharSequence self, int tabStop) {
        if (self.length() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String line : new LineIterable(self)) {
            builder.append(StringGroovyMethods.expandLine((CharSequence)line, tabStop));
            builder.append("\n");
        }
        if (self.charAt(self.length() - 1) != '\n') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Deprecated
    public static String expand(String self) {
        return StringGroovyMethods.expand((CharSequence)self);
    }

    @Deprecated
    public static String expand(String self, int tabStop) {
        return StringGroovyMethods.expand((CharSequence)self, tabStop);
    }

    public static String expandLine(CharSequence self, int tabStop) {
        int index2;
        String s2 = self.toString();
        while ((index2 = s2.indexOf(9)) != -1) {
            StringBuilder builder = new StringBuilder(s2);
            int count2 = tabStop - index2 % tabStop;
            builder.deleteCharAt(index2);
            for (int i = 0; i < count2; ++i) {
                builder.insert(index2, " ");
            }
            s2 = builder.toString();
        }
        return s2;
    }

    @Deprecated
    public static String expandLine(String self, int tabStop) {
        return StringGroovyMethods.expandLine((CharSequence)self, tabStop);
    }

    public static String find(CharSequence self, CharSequence regex) {
        return StringGroovyMethods.find(self, Pattern.compile(regex.toString()));
    }

    public static String find(CharSequence self, CharSequence regex, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure closure) {
        return StringGroovyMethods.find(self, Pattern.compile(regex.toString()), closure);
    }

    public static String find(CharSequence self, Pattern pattern) {
        Matcher matcher2 = pattern.matcher(self.toString());
        if (matcher2.find()) {
            return matcher2.group(0);
        }
        return null;
    }

    public static String find(CharSequence self, Pattern pattern, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure closure) {
        Matcher matcher2 = pattern.matcher(self.toString());
        if (matcher2.find()) {
            if (StringGroovyMethods.hasGroup(matcher2)) {
                int count2 = matcher2.groupCount();
                ArrayList<String> groups = new ArrayList<String>(count2);
                for (int i = 0; i <= count2; ++i) {
                    groups.add(matcher2.group(i));
                }
                return InvokerHelper.toString(closure.call((Object)groups));
            }
            return InvokerHelper.toString(closure.call((Object)matcher2.group(0)));
        }
        return null;
    }

    @Deprecated
    public static String find(String self, Pattern pattern) {
        return StringGroovyMethods.find((CharSequence)self, pattern);
    }

    @Deprecated
    public static String find(String self, Pattern pattern, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure closure) {
        return StringGroovyMethods.find((CharSequence)self, pattern, closure);
    }

    @Deprecated
    public static String find(String self, String regex) {
        return StringGroovyMethods.find((CharSequence)self, (CharSequence)regex);
    }

    @Deprecated
    public static String find(String self, String regex, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure closure) {
        return StringGroovyMethods.find((CharSequence)self, (CharSequence)regex, closure);
    }

    public static List<String> findAll(CharSequence self, CharSequence regex) {
        return StringGroovyMethods.findAll(self, Pattern.compile(regex.toString()));
    }

    public static <T> List<T> findAll(CharSequence self, CharSequence regex, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure<T> closure) {
        return StringGroovyMethods.findAll(self, Pattern.compile(regex.toString()), closure);
    }

    public static List<String> findAll(CharSequence self, Pattern pattern) {
        Matcher matcher2 = pattern.matcher(self.toString());
        boolean hasGroup = StringGroovyMethods.hasGroup(matcher2);
        ArrayList<String> list2 = new ArrayList<String>();
        Iterator iter2 = StringGroovyMethods.iterator(matcher2);
        while (iter2.hasNext()) {
            if (hasGroup) {
                list2.add((String)((List)iter2.next()).get(0));
                continue;
            }
            list2.add((String)iter2.next());
        }
        return new ArrayList<String>(list2);
    }

    public static <T> List<T> findAll(CharSequence self, Pattern pattern, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure<T> closure) {
        Matcher matcher2 = pattern.matcher(self.toString());
        return DefaultGroovyMethods.collect(matcher2, closure);
    }

    @Deprecated
    public static List<String> findAll(String self, Pattern pattern) {
        return StringGroovyMethods.findAll((CharSequence)self, pattern);
    }

    @Deprecated
    public static <T> List<T> findAll(String self, Pattern pattern, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure<T> closure) {
        return StringGroovyMethods.findAll((CharSequence)self, pattern, closure);
    }

    @Deprecated
    public static List<String> findAll(String self, String regex) {
        return StringGroovyMethods.findAll((CharSequence)self, (CharSequence)regex);
    }

    @Deprecated
    public static <T> List<T> findAll(String self, String regex, @ClosureParams(value=FromString.class, options={"java.util.List<java.lang.String>", "java.lang.String[]"}) Closure<T> closure) {
        return StringGroovyMethods.findAll((CharSequence)self, (CharSequence)regex, closure);
    }

    private static int findMinimumLeadingSpaces(String line, int count2) {
        int index2;
        int length = line.length();
        for (index2 = 0; index2 < length && index2 < count2 && Character.isWhitespace(line.charAt(index2)); ++index2) {
        }
        return index2;
    }

    public static String getAt(CharSequence self, Collection indices) {
        StringBuilder answer = new StringBuilder();
        for (Object value2 : indices) {
            if (value2 instanceof Range) {
                answer.append(StringGroovyMethods.getAt(self, (Range)value2));
                continue;
            }
            if (value2 instanceof Collection) {
                answer.append(StringGroovyMethods.getAt(self, (Collection)value2));
                continue;
            }
            int idx = DefaultTypeTransformation.intUnbox(value2);
            answer.append(StringGroovyMethods.getAt(self, idx));
        }
        return answer.toString();
    }

    public static String getAt(CharSequence text2, EmptyRange range2) {
        return "";
    }

    public static CharSequence getAt(CharSequence text2, int index2) {
        index2 = StringGroovyMethods.normaliseIndex(index2, text2.length());
        return text2.subSequence(index2, index2 + 1);
    }

    public static String getAt(GString text2, int index2) {
        return StringGroovyMethods.getAt(text2.toString(), index2);
    }

    public static CharSequence getAt(CharSequence text2, IntRange range2) {
        return StringGroovyMethods.getAt(text2, (Range)range2);
    }

    public static String getAt(GString text2, IntRange range2) {
        return StringGroovyMethods.getAt(text2, (Range)range2);
    }

    public static CharSequence getAt(CharSequence text2, Range range2) {
        RangeInfo info2 = StringGroovyMethods.subListBorders(text2.length(), range2);
        CharSequence sequence2 = text2.subSequence(info2.from, info2.to);
        return info2.reverse ? StringGroovyMethods.reverse(sequence2) : sequence2;
    }

    public static String getAt(GString text2, Range range2) {
        return StringGroovyMethods.getAt(text2.toString(), range2);
    }

    public static List getAt(Matcher self, Collection indices) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        if (indices instanceof IntRange) {
            int size2 = (int)StringGroovyMethods.size(self);
            RangeInfo info2 = StringGroovyMethods.subListBorders(size2, (Range)indices);
            indices = new IntRange(((IntRange)indices).getInclusive(), info2.from, info2.to - 1);
        }
        for (Object value2 : indices) {
            if (value2 instanceof Range) {
                result2.addAll(StringGroovyMethods.getAt(self, (Collection)((Range)value2)));
                continue;
            }
            int idx = DefaultTypeTransformation.intUnbox(value2);
            result2.add(StringGroovyMethods.getAt(self, idx));
        }
        return result2;
    }

    public static Object getAt(Matcher matcher2, int idx) {
        try {
            int count2 = StringGroovyMethods.getCount(matcher2);
            if (idx < -count2 || idx >= count2) {
                throw new IndexOutOfBoundsException("index is out of range " + -count2 + ".." + (count2 - 1) + " (index = " + idx + ")");
            }
            idx = StringGroovyMethods.normaliseIndex(idx, count2);
            Iterator iter2 = StringGroovyMethods.iterator(matcher2);
            Object result2 = null;
            for (int i = 0; i <= idx; ++i) {
                result2 = iter2.next();
            }
            return result2;
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }

    public static boolean matchesPartially(Matcher matcher2) {
        return matcher2.matches() || matcher2.hitEnd();
    }

    @Deprecated
    public static String getAt(String self, Collection indices) {
        return StringGroovyMethods.getAt((CharSequence)self, indices);
    }

    @Deprecated
    public static String getAt(String text2, EmptyRange range2) {
        return StringGroovyMethods.getAt((CharSequence)text2, range2);
    }

    public static String getAt(String text2, int index2) {
        index2 = StringGroovyMethods.normaliseIndex(index2, text2.length());
        return text2.substring(index2, index2 + 1);
    }

    public static String getAt(String text2, IntRange range2) {
        return StringGroovyMethods.getAt(text2, (Range)range2);
    }

    public static String getAt(String text2, Range range2) {
        RangeInfo info2 = StringGroovyMethods.subListBorders(text2.length(), range2);
        String answer = text2.substring(info2.from, info2.to);
        if (info2.reverse) {
            answer = StringGroovyMethods.reverse((CharSequence)answer);
        }
        return answer;
    }

    public static char[] getChars(CharSequence self) {
        return self.toString().toCharArray();
    }

    @Deprecated
    public static char[] getChars(String self) {
        return StringGroovyMethods.getChars((CharSequence)self);
    }

    public static int getCount(Matcher matcher2) {
        int counter = 0;
        matcher2.reset();
        while (matcher2.find()) {
            ++counter;
        }
        return counter;
    }

    private static String getPadding(CharSequence padding2, int length) {
        if (padding2.length() < length) {
            return StringGroovyMethods.multiply(padding2, (Number)(length / padding2.length() + 1)).substring(0, length);
        }
        return "" + padding2.subSequence(0, length);
    }

    private static String getReplacement(Matcher matcher2, Closure closure) {
        if (!StringGroovyMethods.hasGroup(matcher2)) {
            return InvokerHelper.toString(closure.call((Object)matcher2.group()));
        }
        int count2 = matcher2.groupCount();
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i <= count2; ++i) {
            groups.add(matcher2.group(i));
        }
        if (closure.getParameterTypes().length == 1 && closure.getParameterTypes()[0] == Object[].class) {
            return InvokerHelper.toString(closure.call(groups.toArray()));
        }
        return InvokerHelper.toString(closure.call((Object)groups));
    }

    public static boolean hasGroup(Matcher matcher2) {
        return matcher2.groupCount() > 0;
    }

    public static boolean isAllWhitespace(CharSequence self) {
        for (int i = 0; i < self.length(); ++i) {
            if (Character.isWhitespace(self.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isAllWhitespace(String self) {
        return StringGroovyMethods.isAllWhitespace((CharSequence)self);
    }

    public static boolean isBigDecimal(CharSequence self) {
        try {
            new BigDecimal(self.toString().trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Deprecated
    public static boolean isBigDecimal(String self) {
        return StringGroovyMethods.isBigDecimal((CharSequence)self);
    }

    public static boolean isBigInteger(CharSequence self) {
        try {
            new BigInteger(self.toString().trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Deprecated
    public static boolean isBigInteger(String self) {
        return StringGroovyMethods.isBigInteger((CharSequence)self);
    }

    public static boolean isCase(CharSequence caseValue, Object switchValue) {
        if (switchValue == null) {
            return caseValue == null;
        }
        return caseValue.toString().equals(switchValue.toString());
    }

    @Deprecated
    public static boolean isCase(GString caseValue, Object switchValue) {
        return StringGroovyMethods.isCase((CharSequence)caseValue, switchValue);
    }

    public static boolean isCase(Pattern caseValue, Object switchValue) {
        if (switchValue == null) {
            return caseValue == null;
        }
        Matcher matcher2 = caseValue.matcher(switchValue.toString());
        if (matcher2.matches()) {
            RegexSupport.setLastMatcher(matcher2);
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isCase(String caseValue, Object switchValue) {
        return StringGroovyMethods.isCase((CharSequence)caseValue, switchValue);
    }

    public static boolean isDouble(CharSequence self) {
        try {
            Double.valueOf(self.toString().trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Deprecated
    public static boolean isDouble(String self) {
        return StringGroovyMethods.isDouble((CharSequence)self);
    }

    public static boolean isFloat(CharSequence self) {
        try {
            Float.valueOf(self.toString().trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Deprecated
    public static boolean isFloat(String self) {
        return StringGroovyMethods.isFloat((CharSequence)self);
    }

    public static boolean isInteger(CharSequence self) {
        try {
            Integer.valueOf(self.toString().trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Deprecated
    public static boolean isInteger(String self) {
        return StringGroovyMethods.isInteger((CharSequence)self);
    }

    public static boolean isLong(CharSequence self) {
        try {
            Long.valueOf(self.toString().trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Deprecated
    public static boolean isLong(String self) {
        return StringGroovyMethods.isLong((CharSequence)self);
    }

    public static boolean isNumber(CharSequence self) {
        return StringGroovyMethods.isBigDecimal(self);
    }

    @Deprecated
    public static boolean isNumber(String self) {
        return StringGroovyMethods.isNumber((CharSequence)self);
    }

    public static Iterator iterator(final Matcher matcher2) {
        matcher2.reset();
        return new Iterator(){
            private boolean found;
            private boolean done;

            @Override
            public boolean hasNext() {
                if (this.done) {
                    return false;
                }
                if (!this.found) {
                    this.found = matcher2.find();
                    if (!this.found) {
                        this.done = true;
                    }
                }
                return this.found;
            }

            public Object next() {
                if (!this.found && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.found = false;
                if (StringGroovyMethods.hasGroup(matcher2)) {
                    ArrayList<String> list2 = new ArrayList<String>(matcher2.groupCount());
                    for (int i = 0; i <= matcher2.groupCount(); ++i) {
                        list2.add(matcher2.group(i));
                    }
                    return list2;
                }
                return matcher2.group();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static StringBuilder leftShift(CharSequence self, Object value2) {
        return new StringBuilder(self).append(value2);
    }

    public static StringBuffer leftShift(String self, Object value2) {
        return new StringBuffer(self).append(value2);
    }

    public static StringBuffer leftShift(StringBuffer self, Object value2) {
        self.append(value2);
        return self;
    }

    public static StringBuilder leftShift(StringBuilder self, Object value2) {
        self.append(value2);
        return self;
    }

    public static boolean matches(CharSequence self, Pattern pattern) {
        return pattern.matcher(self).matches();
    }

    @Deprecated
    public static boolean matches(String self, Pattern pattern) {
        return StringGroovyMethods.matches((CharSequence)self, pattern);
    }

    public static String minus(CharSequence self, Object target) {
        String text2;
        String s2 = self.toString();
        int index2 = s2.indexOf(text2 = DefaultGroovyMethods.toString(target));
        if (index2 == -1) {
            return s2;
        }
        int end = index2 + text2.length();
        if (s2.length() > end) {
            return s2.substring(0, index2) + s2.substring(end);
        }
        return s2.substring(0, index2);
    }

    public static String minus(CharSequence self, Pattern pattern) {
        return pattern.matcher(self).replaceFirst("");
    }

    @Deprecated
    public static String minus(String self, Pattern pattern) {
        return StringGroovyMethods.minus((CharSequence)self, pattern);
    }

    @Deprecated
    public static String minus(String self, Object target) {
        return StringGroovyMethods.minus((CharSequence)self, target);
    }

    public static String multiply(CharSequence self, Number factor) {
        int size2 = factor.intValue();
        if (size2 == 0) {
            return "";
        }
        if (size2 < 0) {
            throw new IllegalArgumentException("multiply() should be called with a number of 0 or greater not: " + size2);
        }
        StringBuilder answer = new StringBuilder(self);
        for (int i = 1; i < size2; ++i) {
            answer.append(self);
        }
        return answer.toString();
    }

    @Deprecated
    public static String multiply(String self, Number factor) {
        return StringGroovyMethods.multiply((CharSequence)self, factor);
    }

    public static String next(CharSequence self) {
        StringBuilder buffer = new StringBuilder(self);
        if (buffer.length() == 0) {
            buffer.append('\u0000');
        } else {
            char last2 = buffer.charAt(buffer.length() - 1);
            if (last2 == '\uffff') {
                buffer.append('\u0000');
            } else {
                char next2 = last2;
                next2 = (char)(next2 + '\u0001');
                buffer.setCharAt(buffer.length() - 1, next2);
            }
        }
        return buffer.toString();
    }

    @Deprecated
    public static String next(String self) {
        return StringGroovyMethods.next((CharSequence)self);
    }

    public static String normalize(CharSequence self) {
        String s2 = self.toString();
        int nx = s2.indexOf(13);
        if (nx < 0) {
            return s2;
        }
        int len = s2.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        do {
            sb.append(s2, i, nx);
            sb.append('\n');
        } while ((i = nx + 1) < len && (s2.charAt(i) != '\n' || ++i < len) && (nx = s2.indexOf(13, i)) > 0);
        sb.append(s2, i, len);
        return sb.toString();
    }

    @Deprecated
    public static String normalize(String self) {
        return StringGroovyMethods.normalize((CharSequence)self);
    }

    public static String padLeft(CharSequence self, Number numberOfChars) {
        return StringGroovyMethods.padLeft(self, numberOfChars, (CharSequence)" ");
    }

    public static String padLeft(CharSequence self, Number numberOfChars, CharSequence padding2) {
        int numChars = numberOfChars.intValue();
        if (numChars <= self.length()) {
            return self.toString();
        }
        return StringGroovyMethods.getPadding(padding2.toString(), numChars - self.length()) + self;
    }

    @Deprecated
    public static String padLeft(String self, Number numberOfChars) {
        return StringGroovyMethods.padLeft((CharSequence)self, numberOfChars);
    }

    @Deprecated
    public static String padLeft(String self, Number numberOfChars, String padding2) {
        return StringGroovyMethods.padLeft((CharSequence)self, numberOfChars, (CharSequence)padding2);
    }

    public static String padRight(CharSequence self, Number numberOfChars) {
        return StringGroovyMethods.padRight(self, numberOfChars, (CharSequence)" ");
    }

    public static String padRight(CharSequence self, Number numberOfChars, CharSequence padding2) {
        int numChars = numberOfChars.intValue();
        if (numChars <= self.length()) {
            return self.toString();
        }
        return self + StringGroovyMethods.getPadding(padding2.toString(), numChars - self.length());
    }

    @Deprecated
    public static String padRight(String self, Number numberOfChars) {
        return StringGroovyMethods.padRight((CharSequence)self, numberOfChars, (CharSequence)" ");
    }

    @Deprecated
    public static String padRight(String self, Number numberOfChars, String padding2) {
        return StringGroovyMethods.padRight((CharSequence)self, numberOfChars, (CharSequence)padding2);
    }

    public static String plus(CharSequence left, Object value2) {
        return left + DefaultGroovyMethods.toString(value2);
    }

    public static String plus(Number value2, String right) {
        return DefaultGroovyMethods.toString(value2) + right;
    }

    @Deprecated
    public static String plus(String left, Object value2) {
        return StringGroovyMethods.plus((CharSequence)left, value2);
    }

    public static String plus(String left, CharSequence value2) {
        return left + value2;
    }

    public static String plus(StringBuffer left, String value2) {
        return left + value2;
    }

    public static String previous(CharSequence self) {
        StringBuilder buffer = new StringBuilder(self);
        if (buffer.length() == 0) {
            throw new IllegalArgumentException("the string is empty");
        }
        char last2 = buffer.charAt(buffer.length() - 1);
        if (last2 == '\u0000') {
            buffer.deleteCharAt(buffer.length() - 1);
        } else {
            char next2 = last2;
            next2 = (char)(next2 - '\u0001');
            buffer.setCharAt(buffer.length() - 1, next2);
        }
        return buffer.toString();
    }

    @Deprecated
    public static String previous(String self) {
        return StringGroovyMethods.previous((CharSequence)self);
    }

    public static void putAt(StringBuffer self, EmptyRange range2, Object value2) {
        RangeInfo info2 = StringGroovyMethods.subListBorders(self.length(), range2);
        self.replace(info2.from, info2.to, value2.toString());
    }

    public static void putAt(StringBuffer self, IntRange range2, Object value2) {
        RangeInfo info2 = StringGroovyMethods.subListBorders(self.length(), range2);
        self.replace(info2.from, info2.to, value2.toString());
    }

    public static List<String> readLines(CharSequence self) {
        return DefaultGroovyMethods.toList(new LineIterable(self));
    }

    @Deprecated
    public static List<String> readLines(String self) {
        return StringGroovyMethods.readLines((CharSequence)self);
    }

    public static String replaceAll(CharSequence self, CharSequence regex, CharSequence replacement) {
        return self.toString().replaceAll(regex.toString(), replacement.toString());
    }

    public static String replaceAll(CharSequence self, CharSequence regex, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        return StringGroovyMethods.replaceAll(self, Pattern.compile(regex.toString()), closure);
    }

    public static String replaceAll(CharSequence self, Pattern pattern, CharSequence replacement) {
        return pattern.matcher(self).replaceAll(replacement.toString());
    }

    public static String replaceAll(CharSequence self, Pattern pattern, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        String s2 = self.toString();
        Matcher matcher2 = pattern.matcher(s2);
        if (matcher2.find()) {
            StringBuffer sb = new StringBuffer(s2.length() + 16);
            do {
                String replacement = StringGroovyMethods.getReplacement(matcher2, closure);
                matcher2.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } while (matcher2.find());
            matcher2.appendTail(sb);
            return sb.toString();
        }
        return s2;
    }

    @Deprecated
    public static String replaceAll(String self, Pattern pattern, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        return StringGroovyMethods.replaceAll((CharSequence)self, pattern, closure);
    }

    @Deprecated
    public static String replaceAll(String self, Pattern pattern, String replacement) {
        return pattern.matcher(self).replaceAll(replacement);
    }

    @Deprecated
    public static String replaceAll(String self, String regex, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        return StringGroovyMethods.replaceAll((CharSequence)self, (CharSequence)regex, closure);
    }

    public static String replaceFirst(CharSequence self, CharSequence regex, CharSequence replacement) {
        return self.toString().replaceFirst(regex.toString(), replacement.toString());
    }

    public static String replaceFirst(CharSequence self, CharSequence regex, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        return StringGroovyMethods.replaceFirst(self, Pattern.compile(regex.toString()), closure);
    }

    public static String replaceFirst(CharSequence self, Pattern pattern, CharSequence replacement) {
        return pattern.matcher(self).replaceFirst(replacement.toString());
    }

    public static String replaceFirst(CharSequence self, Pattern pattern, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        String s2 = self.toString();
        Matcher matcher2 = pattern.matcher(s2);
        if (matcher2.find()) {
            StringBuffer sb = new StringBuffer(s2.length() + 16);
            String replacement = StringGroovyMethods.getReplacement(matcher2, closure);
            matcher2.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            matcher2.appendTail(sb);
            return sb.toString();
        }
        return s2;
    }

    @Deprecated
    public static String replaceFirst(String self, Pattern pattern, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        return StringGroovyMethods.replaceFirst((CharSequence)self, pattern, closure);
    }

    @Deprecated
    public static String replaceFirst(String self, Pattern pattern, String replacement) {
        return pattern.matcher(self).replaceFirst(replacement);
    }

    @Deprecated
    public static String replaceFirst(String self, String regex, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}) Closure closure) {
        return StringGroovyMethods.replaceFirst((CharSequence)self, (CharSequence)regex, closure);
    }

    public static String replace(CharSequence self, Map<CharSequence, CharSequence> replacements) {
        return StringGroovyMethods.replace(self, -1, replacements);
    }

    public static String replace(CharSequence self, int capacity, Map<CharSequence, CharSequence> replacements) {
        if (self == null) {
            return null;
        }
        String text2 = self.toString();
        if (replacements == null || replacements.isEmpty() || text2.isEmpty()) {
            return text2;
        }
        ReplaceState state = new ReplaceState(replacements);
        StringGroovyMethods.nextMatch(text2, state);
        if (state.textIndex == -1) {
            return text2;
        }
        StringBuilder buf = new StringBuilder(StringGroovyMethods.guessCapacity(capacity, replacements));
        state.start = 0;
        while (state.textIndex != -1) {
            for (int i = state.start; i < state.textIndex; ++i) {
                buf.append(text2.charAt(i));
            }
            buf.append(state.value(state.replaceIndex));
            state.start = state.textIndex + state.key(state.replaceIndex).length();
            state.textIndex = -1;
            state.replaceIndex = -1;
            StringGroovyMethods.nextMatch(text2, state);
        }
        int textLength = text2.length();
        for (int i = state.start; i < textLength; ++i) {
            buf.append(text2.charAt(i));
        }
        return buf.toString();
    }

    private static int guessCapacity(int capacity, Map<CharSequence, CharSequence> replacements) {
        if (capacity >= 0) {
            return capacity;
        }
        boolean possiblyBigger = false;
        for (Map.Entry<CharSequence, CharSequence> entry2 : replacements.entrySet()) {
            if (entry2.getValue().length() <= entry2.getKey().length()) continue;
            possiblyBigger = true;
            break;
        }
        return possiblyBigger ? replacements.size() * 3 / 2 : replacements.size();
    }

    private static void nextMatch(String text2, ReplaceState state) {
        for (int i = 0; i < state.numReplacements(); ++i) {
            if (state.noMoreMatches[i] || state.key(i) == null || state.key(i).length() == 0 || state.value(i) == null) continue;
            state.tempIndex = text2.indexOf(state.key(i).toString(), state.start);
            if (state.tempIndex == -1) {
                state.noMoreMatches[i] = true;
                continue;
            }
            if (state.textIndex != -1 && state.tempIndex >= state.textIndex) continue;
            state.textIndex = state.tempIndex;
            state.replaceIndex = i;
        }
    }

    public static String reverse(CharSequence self) {
        return new StringBuilder(self).reverse().toString();
    }

    @Deprecated
    public static String reverse(String self) {
        return StringGroovyMethods.reverse((CharSequence)self);
    }

    public static void setIndex(Matcher matcher2, int idx) {
        block4: {
            block5: {
                block3: {
                    int count2 = StringGroovyMethods.getCount(matcher2);
                    if (idx < -count2 || idx >= count2) {
                        throw new IndexOutOfBoundsException("index is out of range " + -count2 + ".." + (count2 - 1) + " (index = " + idx + ")");
                    }
                    if (idx != 0) break block3;
                    matcher2.reset();
                    break block4;
                }
                if (idx <= 0) break block5;
                matcher2.reset();
                for (int i = 0; i < idx; ++i) {
                    matcher2.find();
                }
                break block4;
            }
            if (idx >= 0) break block4;
            matcher2.reset();
            idx += StringGroovyMethods.getCount(matcher2);
            for (int i = 0; i < idx; ++i) {
                matcher2.find();
            }
        }
    }

    public static int size(CharSequence text2) {
        return text2.length();
    }

    public static long size(Matcher self) {
        return StringGroovyMethods.getCount(self);
    }

    public static int size(String text2) {
        return text2.length();
    }

    public static int size(StringBuffer buffer) {
        return buffer.length();
    }

    public static String[] split(CharSequence self) {
        StringTokenizer st = new StringTokenizer(self.toString());
        String[] strings = new String[st.countTokens()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = st.nextToken();
        }
        return strings;
    }

    @Deprecated
    public static String[] split(GString self) {
        return StringGroovyMethods.split((CharSequence)self);
    }

    @Deprecated
    public static String[] split(String self) {
        return StringGroovyMethods.split((CharSequence)self);
    }

    public static <T> T splitEachLine(CharSequence self, CharSequence regex, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}, conflictResolutionStrategy=PickFirstResolver.class) Closure<T> closure) throws IOException {
        return StringGroovyMethods.splitEachLine(self, Pattern.compile(regex.toString()), closure);
    }

    public static <T> T splitEachLine(CharSequence self, Pattern pattern, @ClosureParams(value=FromString.class, options={"List<String>", "String[]"}, conflictResolutionStrategy=PickFirstResolver.class) Closure<T> closure) {
        T result2 = null;
        for (String line : new LineIterable(self)) {
            List<String> vals = Arrays.asList(pattern.split(line));
            result2 = closure.call((Object)vals);
        }
        return result2;
    }

    @Deprecated
    public static <T> T splitEachLine(String self, Pattern pattern, Closure<T> closure) throws IOException {
        return StringGroovyMethods.splitEachLine((CharSequence)self, pattern, closure);
    }

    @Deprecated
    public static <T> T splitEachLine(String self, String regex, Closure<T> closure) throws IOException {
        return StringGroovyMethods.splitEachLine((CharSequence)self, (CharSequence)regex, closure);
    }

    public static String stripIndent(CharSequence self) {
        if (self.length() == 0) {
            return self.toString();
        }
        int runningCount = -1;
        for (String line : new LineIterable(self)) {
            if (StringGroovyMethods.isAllWhitespace((CharSequence)line)) continue;
            if (runningCount == -1) {
                runningCount = line.length();
            }
            if ((runningCount = StringGroovyMethods.findMinimumLeadingSpaces(line, runningCount)) != 0) continue;
            break;
        }
        return StringGroovyMethods.stripIndent(self, runningCount == -1 ? 0 : runningCount);
    }

    public static String stripIndent(CharSequence self, int numChars) {
        if (self.length() == 0 || numChars <= 0) {
            return self.toString();
        }
        StringBuilder builder = new StringBuilder();
        for (String line : new LineIterable(self)) {
            if (!StringGroovyMethods.isAllWhitespace((CharSequence)line)) {
                builder.append(StringGroovyMethods.stripIndentFromLine(line, numChars));
            }
            builder.append("\n");
        }
        if (self.charAt(self.length() - 1) != '\n') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Deprecated
    public static String stripIndent(String self) {
        return StringGroovyMethods.stripIndent((CharSequence)self);
    }

    @Deprecated
    public static String stripIndent(String self, int numChars) {
        return StringGroovyMethods.stripIndent((CharSequence)self, numChars);
    }

    private static String stripIndentFromLine(String line, int numChars) {
        int length = line.length();
        return numChars <= length ? line.substring(numChars) : "";
    }

    public static String stripMargin(CharSequence self) {
        return StringGroovyMethods.stripMargin(self, '|');
    }

    public static String stripMargin(CharSequence self, char marginChar) {
        if (self.length() == 0) {
            return self.toString();
        }
        StringBuilder builder = new StringBuilder();
        for (String line : new LineIterable(self)) {
            builder.append(StringGroovyMethods.stripMarginFromLine(line, marginChar));
            builder.append("\n");
        }
        if (self.charAt(self.length() - 1) != '\n') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static String stripMargin(CharSequence self, CharSequence marginChar) {
        String mc = marginChar.toString();
        if (mc.length() == 0) {
            return StringGroovyMethods.stripMargin(self, '|');
        }
        return StringGroovyMethods.stripMargin(self, mc.charAt(0));
    }

    @Deprecated
    public static String stripMargin(String self) {
        return StringGroovyMethods.stripMargin((CharSequence)self);
    }

    @Deprecated
    public static String stripMargin(String self, char marginChar) {
        return StringGroovyMethods.stripMargin((CharSequence)self, marginChar);
    }

    @Deprecated
    public static String stripMargin(String self, String marginChar) {
        return StringGroovyMethods.stripMargin((CharSequence)self, (CharSequence)marginChar);
    }

    private static String stripMarginFromLine(String line, char marginChar) {
        int index2;
        int length = line.length();
        for (index2 = 0; index2 < length && line.charAt(index2) <= ' '; ++index2) {
        }
        return index2 < length && line.charAt(index2) == marginChar ? line.substring(index2 + 1) : line;
    }

    public static CharSequence take(CharSequence self, int num) {
        if (num < 0) {
            return self.subSequence(0, 0);
        }
        if (self.length() <= num) {
            return self;
        }
        return self.subSequence(0, num);
    }

    public static String take(GString self, int num) {
        return StringGroovyMethods.take(self.toString(), num);
    }

    public static String take(String self, int num) {
        return (String)StringGroovyMethods.take((CharSequence)self, num);
    }

    public static String takeWhile(CharSequence self, @ClosureParams(value=FromString.class, conflictResolutionStrategy=PickFirstResolver.class, options={"String", "Character"}) Closure condition) {
        Iterator<Character> selfIter = ClosureUtils.hasSingleCharacterArg(condition) ? new CharacterIterator(self) : new StringIterator(self);
        return DefaultGroovyMethods.join(DefaultGroovyMethods.takeWhile(selfIter, condition), "");
    }

    @Deprecated
    public static /* bridge */ /* synthetic */ CharSequence takeWhile(CharSequence self, @ClosureParams(value=FromString.class, conflictResolutionStrategy=PickFirstResolver.class, options={"String", "Character"}) Closure condition) {
        return StringGroovyMethods.takeWhile(self, condition);
    }

    public static String takeWhile(GString self, @ClosureParams(value=FromString.class, conflictResolutionStrategy=PickFirstResolver.class, options={"String", "Character"}) Closure condition) {
        return StringGroovyMethods.takeWhile(self.toString(), condition);
    }

    public static BigDecimal toBigDecimal(CharSequence self) {
        return new BigDecimal(self.toString().trim());
    }

    @Deprecated
    public static BigDecimal toBigDecimal(String self) {
        return StringGroovyMethods.toBigDecimal((CharSequence)self);
    }

    public static BigInteger toBigInteger(CharSequence self) {
        return new BigInteger(self.toString().trim());
    }

    @Deprecated
    public static BigInteger toBigInteger(String self) {
        return StringGroovyMethods.toBigInteger((CharSequence)self);
    }

    public static Boolean toBoolean(String self) {
        String trimmed = self.trim();
        if ("true".equalsIgnoreCase(trimmed) || "y".equalsIgnoreCase(trimmed) || "1".equals(trimmed)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Character toCharacter(String self) {
        return Character.valueOf(self.charAt(0));
    }

    public static Double toDouble(CharSequence self) {
        return Double.valueOf(self.toString().trim());
    }

    @Deprecated
    public static Double toDouble(String self) {
        return StringGroovyMethods.toDouble((CharSequence)self);
    }

    public static Float toFloat(CharSequence self) {
        return Float.valueOf(self.toString().trim());
    }

    @Deprecated
    public static Float toFloat(String self) {
        return StringGroovyMethods.toFloat((CharSequence)self);
    }

    public static Integer toInteger(CharSequence self) {
        return Integer.valueOf(self.toString().trim());
    }

    @Deprecated
    public static Integer toInteger(String self) {
        return StringGroovyMethods.toInteger((CharSequence)self);
    }

    public static List<String> tokenize(CharSequence self) {
        return InvokerHelper.asList(new StringTokenizer(self.toString()));
    }

    public static List<String> tokenize(CharSequence self, Character delimiter) {
        return StringGroovyMethods.tokenize(self, (CharSequence)delimiter.toString());
    }

    public static List<String> tokenize(CharSequence self, CharSequence delimiters) {
        return InvokerHelper.asList(new StringTokenizer(self.toString(), delimiters.toString()));
    }

    @Deprecated
    public static List<String> tokenize(String self) {
        return StringGroovyMethods.tokenize((CharSequence)self);
    }

    @Deprecated
    public static List<String> tokenize(String self, Character delimiter) {
        return StringGroovyMethods.tokenize((CharSequence)self, delimiter);
    }

    @Deprecated
    public static List<String> tokenize(String self, String delimiters) {
        return StringGroovyMethods.tokenize((CharSequence)self, (CharSequence)delimiters);
    }

    public static List<String> toList(CharSequence self) {
        String s2 = self.toString();
        int size2 = s2.length();
        ArrayList<String> answer = new ArrayList<String>(size2);
        for (int i = 0; i < size2; ++i) {
            answer.add(s2.substring(i, i + 1));
        }
        return answer;
    }

    @Deprecated
    public static List<String> toList(String self) {
        return StringGroovyMethods.toList((CharSequence)self);
    }

    public static Long toLong(CharSequence self) {
        return Long.valueOf(self.toString().trim());
    }

    @Deprecated
    public static Long toLong(String self) {
        return StringGroovyMethods.toLong((CharSequence)self);
    }

    public static Set<String> toSet(CharSequence self) {
        return new HashSet<String>(StringGroovyMethods.toList(self));
    }

    @Deprecated
    public static Set<String> toSet(String self) {
        return StringGroovyMethods.toSet((CharSequence)self);
    }

    public static Short toShort(CharSequence self) {
        return Short.valueOf(self.toString().trim());
    }

    @Deprecated
    public static Short toShort(String self) {
        return StringGroovyMethods.toShort((CharSequence)self);
    }

    public static String tr(CharSequence self, CharSequence sourceSet, CharSequence replacementSet) throws ClassNotFoundException {
        return (String)InvokerHelper.invokeStaticMethod("org.codehaus.groovy.util.StringUtil", "tr", (Object)new Object[]{self.toString(), sourceSet.toString(), replacementSet.toString()});
    }

    @Deprecated
    public static String tr(String self, String sourceSet, String replacementSet) throws ClassNotFoundException {
        return StringGroovyMethods.tr((CharSequence)self, (CharSequence)sourceSet, (CharSequence)replacementSet);
    }

    public static String unexpand(CharSequence self) {
        return StringGroovyMethods.unexpand(self, 8);
    }

    public static String unexpand(CharSequence self, int tabStop) {
        if (self.length() == 0) {
            return self.toString();
        }
        StringBuilder builder = new StringBuilder();
        for (String line : new LineIterable(self)) {
            builder.append(StringGroovyMethods.unexpandLine((CharSequence)line, tabStop));
            builder.append("\n");
        }
        if (self.charAt(self.length() - 1) != '\n') {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    @Deprecated
    public static String unexpand(String self) {
        return StringGroovyMethods.unexpand((CharSequence)self);
    }

    @Deprecated
    public static String unexpand(String self, int tabStop) {
        return StringGroovyMethods.unexpand((CharSequence)self, tabStop);
    }

    public static String unexpandLine(CharSequence self, int tabStop) {
        StringBuilder builder = new StringBuilder(self.toString());
        int index2 = 0;
        while (index2 + tabStop < builder.length()) {
            int count2;
            String piece = builder.substring(index2, index2 + tabStop);
            for (count2 = 0; count2 < tabStop && Character.isWhitespace(piece.charAt(tabStop - (count2 + 1))); ++count2) {
            }
            if (count2 > 0) {
                piece = piece.substring(0, tabStop - count2) + '\t';
                builder.replace(index2, index2 + tabStop, piece);
                index2 = index2 + tabStop - (count2 - 1);
                continue;
            }
            index2 += tabStop;
        }
        return builder.toString();
    }

    @Deprecated
    public static String unexpandLine(String self, int tabStop) {
        return StringGroovyMethods.unexpandLine((CharSequence)self, tabStop);
    }

    public static boolean startsWithAny(CharSequence self, CharSequence ... prefixes) {
        String str = self.toString();
        for (CharSequence prefix : prefixes) {
            if (!str.startsWith(prefix.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithAny(CharSequence self, CharSequence ... suffixes) {
        String str = self.toString();
        for (CharSequence suffix : suffixes) {
            if (!str.endsWith(suffix.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlank(CharSequence self) {
        if (null == self) {
            return true;
        }
        return self.toString().matches("\\s*");
    }

    private static class ReplaceState {
        int textIndex = -1;
        int tempIndex = -1;
        int replaceIndex = -1;
        int start = -1;
        final boolean[] noMoreMatches;
        private final List<Map.Entry<CharSequence, CharSequence>> replacementsList;

        public ReplaceState(Map<CharSequence, CharSequence> replacements) {
            this.noMoreMatches = new boolean[replacements.size()];
            this.replacementsList = DefaultGroovyMethods.toList(replacements.entrySet());
        }

        CharSequence key(int i) {
            return this.replacementsList.get(i).getKey();
        }

        CharSequence value(int i) {
            return this.replacementsList.get(i).getValue();
        }

        int numReplacements() {
            return this.replacementsList.size();
        }
    }

    private static final class LineIterable
    implements Iterable<String> {
        private final CharSequence delegate;

        public LineIterable(CharSequence cs) {
            this.delegate = cs instanceof GString ? cs.toString() : cs;
        }

        @Override
        public Iterator<String> iterator() {
            return IOGroovyMethods.iterator(new CharSequenceReader(this.delegate));
        }
    }

    private static final class StringIterator
    implements Iterator<String> {
        private final CharSequence delegate;
        private final int length;
        private int index;

        public StringIterator(CharSequence delegate) {
            this.delegate = delegate;
            this.length = delegate.length();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public String next() {
            return Character.toString(this.delegate.charAt(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported for CharSequence iterators");
        }
    }

    private static final class CharacterIterator
    implements Iterator<Character> {
        private final CharSequence delegate;
        private final int length;
        private int index;

        public CharacterIterator(CharSequence delegate) {
            this.delegate = delegate;
            this.length = delegate.length();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public Character next() {
            return Character.valueOf(this.delegate.charAt(this.index++));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported for CharSequence iterators");
        }
    }
}

