/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.CachedClass;

public abstract class GeneratedMetaMethod
extends MetaMethod {
    private final String name;
    private final CachedClass declaringClass;
    private final Class returnType;

    public GeneratedMetaMethod(String name2, CachedClass declaringClass, Class returnType, Class[] parameters) {
        this.name = name2;
        this.declaringClass = declaringClass;
        this.returnType = returnType;
        this.nativeParamTypes = parameters;
    }

    @Override
    public int getModifiers() {
        return 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getReturnType() {
        return this.returnType;
    }

    @Override
    public CachedClass getDeclaringClass() {
        return this.declaringClass;
    }

    public static class DgmMethodRecord
    implements Serializable {
        private static final long serialVersionUID = -5639988016452884450L;
        public String className;
        public String methodName;
        public Class returnType;
        public Class[] parameters;
        private static final Class[] PRIMITIVE_CLASSES = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Double.TYPE, Float.TYPE, Void.TYPE, boolean[].class, char[].class, byte[].class, short[].class, int[].class, long[].class, double[].class, float[].class, Object[].class, String[].class, Class[].class, Byte[].class, CharSequence[].class};

        public static void saveDgmInfo(List<DgmMethodRecord> records, String file) throws IOException {
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                LinkedHashMap<String, Integer> classes2 = new LinkedHashMap<String, Integer>();
                int nextClassId = 0;
                for (Class primitive : PRIMITIVE_CLASSES) {
                    classes2.put(primitive.getName(), nextClassId++);
                }
                for (DgmMethodRecord dgmMethodRecord : records) {
                    String name2 = dgmMethodRecord.returnType.getName();
                    Integer id = (Integer)classes2.get(name2);
                    if (id == null) {
                        id = nextClassId++;
                        classes2.put(name2, id);
                    }
                    for (int i = 0; i < dgmMethodRecord.parameters.length; ++i) {
                        name2 = dgmMethodRecord.parameters[i].getName();
                        id = (Integer)classes2.get(name2);
                        if (id != null) continue;
                        id = nextClassId++;
                        classes2.put(name2, id);
                    }
                }
                for (Map.Entry entry2 : classes2.entrySet()) {
                    out.writeUTF((String)entry2.getKey());
                    out.writeInt((Integer)entry2.getValue());
                }
                out.writeUTF("");
                out.writeInt(records.size());
                for (DgmMethodRecord dgmMethodRecord : records) {
                    out.writeUTF(dgmMethodRecord.className);
                    out.writeUTF(dgmMethodRecord.methodName);
                    out.writeInt((Integer)classes2.get(dgmMethodRecord.returnType.getName()));
                    out.writeInt(dgmMethodRecord.parameters.length);
                    for (int i = 0; i < dgmMethodRecord.parameters.length; ++i) {
                        Integer key = (Integer)classes2.get(dgmMethodRecord.parameters[i].getName());
                        out.writeInt(key);
                    }
                }
            }
        }

        public static List<DgmMethodRecord> loadDgmInfo() throws IOException {
            ClassLoader loader = DgmMethodRecord.class.getClassLoader();
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(loader.getResourceAsStream("META-INF/dgminfo")));){
                String name2;
                HashMap classes2 = new HashMap();
                for (int i = 0; i < PRIMITIVE_CLASSES.length; ++i) {
                    classes2.put(i, PRIMITIVE_CLASSES[i]);
                }
                int skip = 0;
                while ((name2 = in.readUTF()).length() != 0) {
                    int key = in.readInt();
                    if (skip++ < PRIMITIVE_CLASSES.length) continue;
                    Class<?> cls = null;
                    try {
                        cls = loader.loadClass(name2);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    classes2.put(key, cls);
                }
                int size2 = in.readInt();
                ArrayList<DgmMethodRecord> res = new ArrayList<DgmMethodRecord>(size2);
                for (int i = 0; i != size2; ++i) {
                    boolean skipRecord = false;
                    DgmMethodRecord record2 = new DgmMethodRecord();
                    record2.className = in.readUTF();
                    record2.methodName = in.readUTF();
                    record2.returnType = (Class)classes2.get(in.readInt());
                    if (record2.returnType == null) {
                        skipRecord = true;
                    }
                    int psize = in.readInt();
                    record2.parameters = new Class[psize];
                    for (int j = 0; j < record2.parameters.length; ++j) {
                        record2.parameters[j] = (Class)classes2.get(in.readInt());
                        if (record2.parameters[j] != null) continue;
                        skipRecord = true;
                    }
                    if (skipRecord) continue;
                    res.add(record2);
                }
                ArrayList<DgmMethodRecord> arrayList = res;
                return arrayList;
            }
        }
    }

    public static class Proxy
    extends GeneratedMetaMethod {
        private volatile MetaMethod proxy;
        private final String className;

        public Proxy(String className2, String name2, CachedClass declaringClass, Class returnType, Class[] parameters) {
            super(name2, declaringClass, returnType, parameters);
            this.className = className2;
        }

        @Override
        public boolean isValidMethod(Class[] arguments) {
            return this.proxy().isValidMethod(arguments);
        }

        @Override
        public Object doMethodInvoke(Object object, Object[] argumentArray) {
            return this.proxy().doMethodInvoke(object, argumentArray);
        }

        @Override
        public Object invoke(Object object, Object[] arguments) {
            return this.proxy().invoke(object, arguments);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final MetaMethod proxy() {
            if (this.proxy == null) {
                Proxy proxy = this;
                synchronized (proxy) {
                    if (this.proxy == null) {
                        this.createProxy();
                    }
                }
            }
            return this.proxy;
        }

        private void createProxy() {
            try {
                Class<?> aClass = this.getClass().getClassLoader().loadClass(this.className.replace('/', '.'));
                Constructor<?> constructor = aClass.getConstructor(String.class, CachedClass.class, Class.class, Class[].class);
                this.proxy = (MetaMethod)constructor.newInstance(this.getName(), this.getDeclaringClass(), this.getReturnType(), this.getNativeParameterTypes());
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new GroovyRuntimeException("Failed to create DGM method proxy : " + t, t);
            }
        }
    }
}

