/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.MetaClassImpl;
import groovy.lang.MetaMethod;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.GroovySunClassLoader;

public class ClassLoaderForClassArtifacts
extends ClassLoader {
    public final SoftReference<Class> klazz;
    private final AtomicInteger classNamesCounter = new AtomicInteger(-1);

    public ClassLoaderForClassArtifacts(Class klazz) {
        super(klazz.getClassLoader());
        this.klazz = new SoftReference<Class>(klazz);
    }

    public Class define(String name2, byte[] bytes2) {
        Class<?> cls = this.defineClass(name2, bytes2, 0, bytes2.length, this.klazz.get().getProtectionDomain());
        this.resolveClass(cls);
        return cls;
    }

    public Class loadClass(String name2) throws ClassNotFoundException {
        Class cls = this.findLoadedClass(name2);
        if (cls != null) {
            return cls;
        }
        if (GroovySunClassLoader.sunVM != null && (cls = GroovySunClassLoader.sunVM.doesKnow(name2)) != null) {
            return cls;
        }
        return super.loadClass(name2);
    }

    public String createClassName(Method method) {
        String clsName = this.klazz.get().getName();
        String name2 = clsName.startsWith("java.") ? clsName.replace('.', '_') + "$" + method.getName() : clsName + "$" + method.getName();
        int suffix = this.classNamesCounter.getAndIncrement();
        return suffix == -1 ? name2 : name2 + "$" + suffix;
    }

    public Constructor defineClassAndGetConstructor(final String name2, final byte[] bytes2) {
        Class cls = AccessController.doPrivileged(new PrivilegedAction<Class>(){

            @Override
            public Class run() {
                return ClassLoaderForClassArtifacts.this.define(name2, bytes2);
            }
        });
        if (cls != null) {
            try {
                return cls.getConstructor(CallSite.class, MetaClassImpl.class, MetaMethod.class, Class[].class, Constructor.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }
}

