/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.GroovyObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessControlException;
import org.codehaus.groovy.reflection.CacheAccessControlException;

final class AccessPermissionChecker {
    private static final ReflectPermission REFLECT_PERMISSION = new ReflectPermission("suppressAccessChecks");

    private AccessPermissionChecker() {
    }

    private static void checkAccessPermission(Class<?> declaringClass, int modifiers, boolean isAccessible2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && isAccessible2) {
            if (((modifiers & 2) != 0 || (modifiers & 5) == 0 && AccessPermissionChecker.packageCanNotBeAddedAnotherClass(declaringClass)) && !GroovyObject.class.isAssignableFrom(declaringClass)) {
                securityManager.checkPermission(REFLECT_PERMISSION);
            } else if ((modifiers & 4) != 0 && declaringClass.equals(ClassLoader.class)) {
                securityManager.checkCreateClassLoader();
            }
        }
    }

    private static boolean packageCanNotBeAddedAnotherClass(Class<?> declaringClass) {
        return declaringClass.getName().startsWith("java.");
    }

    static void checkAccessPermission(Method method) {
        try {
            AccessPermissionChecker.checkAccessPermission(method.getDeclaringClass(), method.getModifiers(), method.isAccessible());
        }
        catch (AccessControlException e) {
            throw AccessPermissionChecker.createCacheAccessControlExceptionOf(method, e);
        }
    }

    private static CacheAccessControlException createCacheAccessControlExceptionOf(Method method, AccessControlException e) {
        return new CacheAccessControlException("Groovy object can not access method " + method.getName() + " cacheAccessControlExceptionOf class " + method.getDeclaringClass().getName() + " with modifiers \"" + Modifier.toString(method.getModifiers()) + "\"", e);
    }

    static void checkAccessPermission(Field field2) {
        try {
            AccessPermissionChecker.checkAccessPermission(field2.getDeclaringClass(), field2.getModifiers(), field2.isAccessible());
        }
        catch (AccessControlException e) {
            throw AccessPermissionChecker.createCacheAccessControlExceptionOf(field2, e);
        }
    }

    private static CacheAccessControlException createCacheAccessControlExceptionOf(Field field2, AccessControlException e) {
        return new CacheAccessControlException("Groovy object can not access field " + field2.getName() + " cacheAccessControlExceptionOf class " + field2.getDeclaringClass().getName() + " with modifiers \"" + Modifier.toString(field2.getModifiers()) + "\"", e);
    }
}

