/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control.customizers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.syntax.Token;

public class SecureASTCustomizer
extends CompilationCustomizer {
    private boolean isPackageAllowed = true;
    private boolean isMethodDefinitionAllowed = true;
    private boolean isClosuresAllowed = true;
    private List<String> importsWhitelist;
    private List<String> importsBlacklist;
    private List<String> staticImportsWhitelist;
    private List<String> staticImportsBlacklist;
    private List<String> starImportsWhitelist;
    private List<String> starImportsBlacklist;
    private List<String> staticStarImportsWhitelist;
    private List<String> staticStarImportsBlacklist;
    private boolean isIndirectImportCheckEnabled;
    private List<Class<? extends Statement>> statementsWhitelist;
    private List<Class<? extends Statement>> statementsBlacklist;
    private final List<StatementChecker> statementCheckers = new LinkedList<StatementChecker>();
    private List<Class<? extends Expression>> expressionsWhitelist;
    private List<Class<? extends Expression>> expressionsBlacklist;
    private final List<ExpressionChecker> expressionCheckers = new LinkedList<ExpressionChecker>();
    private List<Integer> tokensWhitelist;
    private List<Integer> tokensBlacklist;
    private List<String> constantTypesWhiteList;
    private List<String> constantTypesBlackList;
    private List<String> receiversWhiteList;
    private List<String> receiversBlackList;

    public SecureASTCustomizer() {
        super(CompilePhase.CANONICALIZATION);
    }

    public boolean isMethodDefinitionAllowed() {
        return this.isMethodDefinitionAllowed;
    }

    public void setMethodDefinitionAllowed(boolean methodDefinitionAllowed) {
        this.isMethodDefinitionAllowed = methodDefinitionAllowed;
    }

    public boolean isPackageAllowed() {
        return this.isPackageAllowed;
    }

    public boolean isClosuresAllowed() {
        return this.isClosuresAllowed;
    }

    public void setClosuresAllowed(boolean closuresAllowed) {
        this.isClosuresAllowed = closuresAllowed;
    }

    public void setPackageAllowed(boolean packageAllowed) {
        this.isPackageAllowed = packageAllowed;
    }

    public List<String> getImportsBlacklist() {
        return this.importsBlacklist;
    }

    public void setImportsBlacklist(List<String> importsBlacklist) {
        if (this.importsWhitelist != null || this.starImportsWhitelist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.importsBlacklist = importsBlacklist;
    }

    public List<String> getImportsWhitelist() {
        return this.importsWhitelist;
    }

    public void setImportsWhitelist(List<String> importsWhitelist) {
        if (this.importsBlacklist != null || this.starImportsBlacklist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.importsWhitelist = importsWhitelist;
    }

    public List<String> getStarImportsBlacklist() {
        return this.starImportsBlacklist;
    }

    public void setStarImportsBlacklist(List<String> starImportsBlacklist) {
        if (this.importsWhitelist != null || this.starImportsWhitelist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.starImportsBlacklist = SecureASTCustomizer.normalizeStarImports(starImportsBlacklist);
        if (this.importsBlacklist == null) {
            this.importsBlacklist = Collections.emptyList();
        }
    }

    public List<String> getStarImportsWhitelist() {
        return this.starImportsWhitelist;
    }

    public void setStarImportsWhitelist(List<String> starImportsWhitelist) {
        if (this.importsBlacklist != null || this.starImportsBlacklist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.starImportsWhitelist = SecureASTCustomizer.normalizeStarImports(starImportsWhitelist);
        if (this.importsWhitelist == null) {
            this.importsWhitelist = Collections.emptyList();
        }
    }

    private static List<String> normalizeStarImports(List<String> starImports) {
        ArrayList<String> result2 = new ArrayList<String>(starImports.size());
        for (String starImport : starImports) {
            if (starImport.endsWith(".*")) {
                result2.add(starImport);
                continue;
            }
            if (starImport.endsWith(".")) {
                result2.add(starImport + "*");
                continue;
            }
            result2.add(starImport + ".*");
        }
        return Collections.unmodifiableList(result2);
    }

    public List<String> getStaticImportsBlacklist() {
        return this.staticImportsBlacklist;
    }

    public void setStaticImportsBlacklist(List<String> staticImportsBlacklist) {
        if (this.staticImportsWhitelist != null || this.staticStarImportsWhitelist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.staticImportsBlacklist = staticImportsBlacklist;
    }

    public List<String> getStaticImportsWhitelist() {
        return this.staticImportsWhitelist;
    }

    public void setStaticImportsWhitelist(List<String> staticImportsWhitelist) {
        if (this.staticImportsBlacklist != null || this.staticStarImportsBlacklist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.staticImportsWhitelist = staticImportsWhitelist;
    }

    public List<String> getStaticStarImportsBlacklist() {
        return this.staticStarImportsBlacklist;
    }

    public void setStaticStarImportsBlacklist(List<String> staticStarImportsBlacklist) {
        if (this.staticImportsWhitelist != null || this.staticStarImportsWhitelist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.staticStarImportsBlacklist = SecureASTCustomizer.normalizeStarImports(staticStarImportsBlacklist);
        if (this.staticImportsBlacklist == null) {
            this.staticImportsBlacklist = Collections.emptyList();
        }
    }

    public List<String> getStaticStarImportsWhitelist() {
        return this.staticStarImportsWhitelist;
    }

    public void setStaticStarImportsWhitelist(List<String> staticStarImportsWhitelist) {
        if (this.staticImportsBlacklist != null || this.staticStarImportsBlacklist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.staticStarImportsWhitelist = SecureASTCustomizer.normalizeStarImports(staticStarImportsWhitelist);
        if (this.staticImportsWhitelist == null) {
            this.staticImportsWhitelist = Collections.emptyList();
        }
    }

    public List<Class<? extends Expression>> getExpressionsBlacklist() {
        return this.expressionsBlacklist;
    }

    public void setExpressionsBlacklist(List<Class<? extends Expression>> expressionsBlacklist) {
        if (this.expressionsWhitelist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.expressionsBlacklist = expressionsBlacklist;
    }

    public List<Class<? extends Expression>> getExpressionsWhitelist() {
        return this.expressionsWhitelist;
    }

    public void setExpressionsWhitelist(List<Class<? extends Expression>> expressionsWhitelist) {
        if (this.expressionsBlacklist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.expressionsWhitelist = expressionsWhitelist;
    }

    public List<Class<? extends Statement>> getStatementsBlacklist() {
        return this.statementsBlacklist;
    }

    public void setStatementsBlacklist(List<Class<? extends Statement>> statementsBlacklist) {
        if (this.statementsWhitelist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.statementsBlacklist = statementsBlacklist;
    }

    public List<Class<? extends Statement>> getStatementsWhitelist() {
        return this.statementsWhitelist;
    }

    public void setStatementsWhitelist(List<Class<? extends Statement>> statementsWhitelist) {
        if (this.statementsBlacklist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.statementsWhitelist = statementsWhitelist;
    }

    public List<Integer> getTokensBlacklist() {
        return this.tokensBlacklist;
    }

    public boolean isIndirectImportCheckEnabled() {
        return this.isIndirectImportCheckEnabled;
    }

    public void setIndirectImportCheckEnabled(boolean indirectImportCheckEnabled) {
        this.isIndirectImportCheckEnabled = indirectImportCheckEnabled;
    }

    public void setTokensBlacklist(List<Integer> tokensBlacklist) {
        if (this.tokensWhitelist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.tokensBlacklist = tokensBlacklist;
    }

    public List<Integer> getTokensWhitelist() {
        return this.tokensWhitelist;
    }

    public void setTokensWhitelist(List<Integer> tokensWhitelist) {
        if (this.tokensBlacklist != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.tokensWhitelist = tokensWhitelist;
    }

    public void addStatementCheckers(StatementChecker ... checkers) {
        this.statementCheckers.addAll(Arrays.asList(checkers));
    }

    public void addExpressionCheckers(ExpressionChecker ... checkers) {
        this.expressionCheckers.addAll(Arrays.asList(checkers));
    }

    public List<String> getConstantTypesBlackList() {
        return this.constantTypesBlackList;
    }

    public void setConstantTypesBlackList(List<String> constantTypesBlackList) {
        if (this.constantTypesWhiteList != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.constantTypesBlackList = constantTypesBlackList;
    }

    public List<String> getConstantTypesWhiteList() {
        return this.constantTypesWhiteList;
    }

    public void setConstantTypesWhiteList(List<String> constantTypesWhiteList) {
        if (this.constantTypesBlackList != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.constantTypesWhiteList = constantTypesWhiteList;
    }

    public void setConstantTypesClassesWhiteList(List<Class> constantTypesWhiteList) {
        LinkedList<String> values2 = new LinkedList<String>();
        for (Class aClass : constantTypesWhiteList) {
            values2.add(aClass.getName());
        }
        this.setConstantTypesWhiteList(values2);
    }

    public void setConstantTypesClassesBlackList(List<Class> constantTypesBlackList) {
        LinkedList<String> values2 = new LinkedList<String>();
        for (Class aClass : constantTypesBlackList) {
            values2.add(aClass.getName());
        }
        this.setConstantTypesBlackList(values2);
    }

    public List<String> getReceiversBlackList() {
        return this.receiversBlackList;
    }

    public void setReceiversBlackList(List<String> receiversBlackList) {
        if (this.receiversWhiteList != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.receiversBlackList = receiversBlackList;
    }

    public void setReceiversClassesBlackList(List<Class> receiversBlacklist) {
        LinkedList<String> values2 = new LinkedList<String>();
        for (Class aClass : receiversBlacklist) {
            values2.add(aClass.getName());
        }
        this.setReceiversBlackList(values2);
    }

    public List<String> getReceiversWhiteList() {
        return this.receiversWhiteList;
    }

    public void setReceiversWhiteList(List<String> receiversWhiteList) {
        if (this.receiversBlackList != null) {
            throw new IllegalArgumentException("You are not allowed to set both whitelist and blacklist");
        }
        this.receiversWhiteList = receiversWhiteList;
    }

    public void setReceiversClassesWhiteList(List<Class> receiversWhitelist) {
        LinkedList<String> values2 = new LinkedList<String>();
        for (Class aClass : receiversWhitelist) {
            values2.add(aClass.getName());
        }
        this.setReceiversWhiteList(values2);
    }

    @Override
    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        String className2;
        ModuleNode ast = source.getAST();
        if (!this.isPackageAllowed && ast.getPackage() != null) {
            throw new SecurityException("Package definitions are not allowed");
        }
        this.checkMethodDefinitionAllowed(classNode);
        if (this.importsBlacklist != null || this.importsWhitelist != null || this.starImportsBlacklist != null || this.starImportsWhitelist != null) {
            for (ImportNode importNode : ast.getImports()) {
                String className22 = importNode.getClassName();
                this.assertImportIsAllowed(className22);
            }
            for (ImportNode importNode : ast.getStarImports()) {
                className2 = importNode.getPackageName();
                this.assertStarImportIsAllowed(className2 + "*");
            }
        }
        if (this.staticImportsBlacklist != null || this.staticImportsWhitelist != null || this.staticStarImportsBlacklist != null || this.staticStarImportsWhitelist != null) {
            for (Map.Entry entry2 : ast.getStaticImports().entrySet()) {
                className2 = ((ImportNode)entry2.getValue()).getClassName();
                this.assertStaticImportIsAllowed((String)entry2.getKey(), className2);
            }
            for (Map.Entry entry3 : ast.getStaticStarImports().entrySet()) {
                className2 = ((ImportNode)entry3.getValue()).getClassName();
                this.assertStaticImportIsAllowed((String)entry3.getKey(), className2);
            }
        }
        SecuringCodeVisitor visitor = new SecuringCodeVisitor();
        ast.getStatementBlock().visit(visitor);
        for (ClassNode clNode : ast.getClasses()) {
            if (clNode == classNode) continue;
            this.checkMethodDefinitionAllowed(clNode);
            for (MethodNode methodNode : clNode.getMethods()) {
                if (methodNode.isSynthetic() || methodNode.getCode() == null) continue;
                methodNode.getCode().visit(visitor);
            }
        }
        List<MethodNode> list2 = SecureASTCustomizer.filterMethods(classNode);
        if (this.isMethodDefinitionAllowed) {
            for (MethodNode method : list2) {
                if (method.getDeclaringClass() != classNode || method.getCode() == null) continue;
                method.getCode().visit(visitor);
            }
        }
    }

    private void checkMethodDefinitionAllowed(ClassNode owner) {
        if (this.isMethodDefinitionAllowed) {
            return;
        }
        List<MethodNode> methods2 = SecureASTCustomizer.filterMethods(owner);
        if (!methods2.isEmpty()) {
            throw new SecurityException("Method definitions are not allowed");
        }
    }

    private static List<MethodNode> filterMethods(ClassNode owner) {
        LinkedList<MethodNode> result2 = new LinkedList<MethodNode>();
        List<MethodNode> methods2 = owner.getMethods();
        for (MethodNode method : methods2) {
            if (method.getDeclaringClass() != owner || method.isSynthetic() || "main".equals(method.getName()) || "run".equals(method.getName()) && owner.isScriptBody()) continue;
            result2.add(method);
        }
        return result2;
    }

    private void assertStarImportIsAllowed(String packageName) {
        if (this.starImportsWhitelist != null && !this.starImportsWhitelist.contains(packageName)) {
            throw new SecurityException("Importing [" + packageName + "] is not allowed");
        }
        if (this.starImportsBlacklist != null && this.starImportsBlacklist.contains(packageName)) {
            throw new SecurityException("Importing [" + packageName + "] is not allowed");
        }
    }

    private void assertImportIsAllowed(String className2) {
        String packageName;
        ClassNode node;
        if (this.importsWhitelist != null && !this.importsWhitelist.contains(className2)) {
            if (this.starImportsWhitelist != null) {
                node = ClassHelper.make(className2);
                packageName = node.getPackageName();
                if (!this.starImportsWhitelist.contains(packageName + ".*")) {
                    throw new SecurityException("Importing [" + className2 + "] is not allowed");
                }
            } else {
                throw new SecurityException("Importing [" + className2 + "] is not allowed");
            }
        }
        if (this.importsBlacklist != null && this.importsBlacklist.contains(className2)) {
            throw new SecurityException("Importing [" + className2 + "] is not allowed");
        }
        if (this.starImportsBlacklist != null && this.starImportsBlacklist.contains((packageName = (node = ClassHelper.make(className2)).getPackageName()) + ".*")) {
            throw new SecurityException("Importing [" + className2 + "] is not allowed");
        }
    }

    private void assertStaticImportIsAllowed(String member2, String className2) {
        String fqn;
        String string2 = fqn = member2.equals(className2) ? member2 : className2 + "." + member2;
        if (this.staticImportsWhitelist != null && !this.staticImportsWhitelist.contains(fqn)) {
            if (this.staticStarImportsWhitelist != null) {
                if (!this.staticStarImportsWhitelist.contains(className2 + ".*")) {
                    throw new SecurityException("Importing [" + fqn + "] is not allowed");
                }
            } else {
                throw new SecurityException("Importing [" + fqn + "] is not allowed");
            }
        }
        if (this.staticImportsBlacklist != null && this.staticImportsBlacklist.contains(fqn)) {
            throw new SecurityException("Importing [" + fqn + "] is not allowed");
        }
        if (this.staticStarImportsBlacklist != null && this.staticStarImportsBlacklist.contains(className2 + ".*")) {
            throw new SecurityException("Importing [" + fqn + "] is not allowed");
        }
    }

    public static interface StatementChecker {
        public boolean isAuthorized(Statement var1);
    }

    public static interface ExpressionChecker {
        public boolean isAuthorized(Expression var1);
    }

    private class SecuringCodeVisitor
    implements GroovyCodeVisitor {
        private SecuringCodeVisitor() {
        }

        private void assertStatementAuthorized(Statement statement2) throws SecurityException {
            Class<?> clazz2 = statement2.getClass();
            if (SecureASTCustomizer.this.statementsBlacklist != null && SecureASTCustomizer.this.statementsBlacklist.contains(clazz2)) {
                throw new SecurityException(clazz2.getSimpleName() + "s are not allowed");
            }
            if (SecureASTCustomizer.this.statementsWhitelist != null && !SecureASTCustomizer.this.statementsWhitelist.contains(clazz2)) {
                throw new SecurityException(clazz2.getSimpleName() + "s are not allowed");
            }
            for (StatementChecker statementChecker : SecureASTCustomizer.this.statementCheckers) {
                if (statementChecker.isAuthorized(statement2)) continue;
                throw new SecurityException("Statement [" + clazz2.getSimpleName() + "] is not allowed");
            }
        }

        private void assertExpressionAuthorized(Expression expression2) throws SecurityException {
            Class<?> clazz2 = expression2.getClass();
            if (SecureASTCustomizer.this.expressionsBlacklist != null && SecureASTCustomizer.this.expressionsBlacklist.contains(clazz2)) {
                throw new SecurityException(clazz2.getSimpleName() + "s are not allowed: " + expression2.getText());
            }
            if (SecureASTCustomizer.this.expressionsWhitelist != null && !SecureASTCustomizer.this.expressionsWhitelist.contains(clazz2)) {
                throw new SecurityException(clazz2.getSimpleName() + "s are not allowed: " + expression2.getText());
            }
            for (ExpressionChecker expressionChecker : SecureASTCustomizer.this.expressionCheckers) {
                if (expressionChecker.isAuthorized(expression2)) continue;
                throw new SecurityException("Expression [" + clazz2.getSimpleName() + "] is not allowed: " + expression2.getText());
            }
            if (SecureASTCustomizer.this.isIndirectImportCheckEnabled) {
                try {
                    String typename;
                    Expression expr2;
                    if (expression2 instanceof ConstructorCallExpression) {
                        SecureASTCustomizer.this.assertImportIsAllowed(expression2.getType().getName());
                    } else if (expression2 instanceof MethodCallExpression) {
                        expr2 = (MethodCallExpression)expression2;
                        ClassNode objectExpressionType = ((MethodCallExpression)expr2).getObjectExpression().getType();
                        String typename2 = this.getExpressionType(objectExpressionType).getName();
                        SecureASTCustomizer.this.assertImportIsAllowed(typename2);
                        SecureASTCustomizer.this.assertStaticImportIsAllowed(((MethodCallExpression)expr2).getMethodAsString(), typename2);
                    } else if (expression2 instanceof StaticMethodCallExpression) {
                        expr2 = (StaticMethodCallExpression)expression2;
                        typename = ((StaticMethodCallExpression)expr2).getOwnerType().getName();
                        SecureASTCustomizer.this.assertImportIsAllowed(typename);
                        SecureASTCustomizer.this.assertStaticImportIsAllowed(((StaticMethodCallExpression)expr2).getMethod(), typename);
                    } else if (expression2 instanceof MethodPointerExpression) {
                        expr2 = (MethodPointerExpression)expression2;
                        typename = ((MethodPointerExpression)expr2).getType().getName();
                        SecureASTCustomizer.this.assertImportIsAllowed(typename);
                        SecureASTCustomizer.this.assertStaticImportIsAllowed(((MethodPointerExpression)expr2).getText(), typename);
                    }
                }
                catch (SecurityException e) {
                    throw new SecurityException("Indirect import checks prevents usage of expression", e);
                }
            }
        }

        private ClassNode getExpressionType(ClassNode objectExpressionType) {
            return objectExpressionType.isArray() ? this.getExpressionType(objectExpressionType.getComponentType()) : objectExpressionType;
        }

        private void assertTokenAuthorized(Token token2) throws SecurityException {
            int value2 = token2.getType();
            if (SecureASTCustomizer.this.tokensBlacklist != null && SecureASTCustomizer.this.tokensBlacklist.contains(value2)) {
                throw new SecurityException("Token " + token2 + " is not allowed");
            }
            if (SecureASTCustomizer.this.tokensWhitelist != null && !SecureASTCustomizer.this.tokensWhitelist.contains(value2)) {
                throw new SecurityException("Token " + token2 + " is not allowed");
            }
        }

        @Override
        public void visitBlockStatement(BlockStatement block) {
            this.assertStatementAuthorized(block);
            for (Statement statement2 : block.getStatements()) {
                statement2.visit(this);
            }
        }

        @Override
        public void visitForLoop(ForStatement forLoop) {
            this.assertStatementAuthorized(forLoop);
            forLoop.getCollectionExpression().visit(this);
            forLoop.getLoopBlock().visit(this);
        }

        @Override
        public void visitWhileLoop(WhileStatement loop2) {
            this.assertStatementAuthorized(loop2);
            loop2.getBooleanExpression().visit(this);
            loop2.getLoopBlock().visit(this);
        }

        @Override
        public void visitDoWhileLoop(DoWhileStatement loop2) {
            this.assertStatementAuthorized(loop2);
            loop2.getBooleanExpression().visit(this);
            loop2.getLoopBlock().visit(this);
        }

        @Override
        public void visitIfElse(IfStatement ifElse) {
            this.assertStatementAuthorized(ifElse);
            ifElse.getBooleanExpression().visit(this);
            ifElse.getIfBlock().visit(this);
            Statement elseBlock = ifElse.getElseBlock();
            if (elseBlock instanceof EmptyStatement) {
                this.visitEmptyStatement((EmptyStatement)elseBlock);
            } else {
                elseBlock.visit(this);
            }
        }

        @Override
        public void visitExpressionStatement(ExpressionStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getExpression().visit(this);
        }

        @Override
        public void visitReturnStatement(ReturnStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getExpression().visit(this);
        }

        @Override
        public void visitAssertStatement(AssertStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getBooleanExpression().visit(this);
            statement2.getMessageExpression().visit(this);
        }

        @Override
        public void visitTryCatchFinally(TryCatchStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getTryStatement().visit(this);
            for (CatchStatement catchStatement : statement2.getCatchStatements()) {
                catchStatement.visit(this);
            }
            Statement finallyStatement = statement2.getFinallyStatement();
            if (finallyStatement instanceof EmptyStatement) {
                this.visitEmptyStatement((EmptyStatement)finallyStatement);
            } else {
                finallyStatement.visit(this);
            }
        }

        protected void visitEmptyStatement(EmptyStatement statement2) {
        }

        @Override
        public void visitSwitch(SwitchStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getExpression().visit(this);
            for (CaseStatement caseStatement : statement2.getCaseStatements()) {
                caseStatement.visit(this);
            }
            statement2.getDefaultStatement().visit(this);
        }

        @Override
        public void visitCaseStatement(CaseStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getExpression().visit(this);
            statement2.getCode().visit(this);
        }

        @Override
        public void visitBreakStatement(BreakStatement statement2) {
            this.assertStatementAuthorized(statement2);
        }

        @Override
        public void visitContinueStatement(ContinueStatement statement2) {
            this.assertStatementAuthorized(statement2);
        }

        @Override
        public void visitThrowStatement(ThrowStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getExpression().visit(this);
        }

        @Override
        public void visitSynchronizedStatement(SynchronizedStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getExpression().visit(this);
            statement2.getCode().visit(this);
        }

        @Override
        public void visitCatchStatement(CatchStatement statement2) {
            this.assertStatementAuthorized(statement2);
            statement2.getCode().visit(this);
        }

        @Override
        public void visitMethodCallExpression(MethodCallExpression call2) {
            this.assertExpressionAuthorized(call2);
            Expression receiver = call2.getObjectExpression();
            String typeName = receiver.getType().getName();
            if (SecureASTCustomizer.this.receiversWhiteList != null && !SecureASTCustomizer.this.receiversWhiteList.contains(typeName)) {
                throw new SecurityException("Method calls not allowed on [" + typeName + "]");
            }
            if (SecureASTCustomizer.this.receiversBlackList != null && SecureASTCustomizer.this.receiversBlackList.contains(typeName)) {
                throw new SecurityException("Method calls not allowed on [" + typeName + "]");
            }
            receiver.visit(this);
            Expression method = call2.getMethod();
            this.checkConstantTypeIfNotMethodNameOrProperty(method);
            call2.getArguments().visit(this);
        }

        @Override
        public void visitStaticMethodCallExpression(StaticMethodCallExpression call2) {
            this.assertExpressionAuthorized(call2);
            String typeName = call2.getOwnerType().getName();
            if (SecureASTCustomizer.this.receiversWhiteList != null && !SecureASTCustomizer.this.receiversWhiteList.contains(typeName)) {
                throw new SecurityException("Method calls not allowed on [" + typeName + "]");
            }
            if (SecureASTCustomizer.this.receiversBlackList != null && SecureASTCustomizer.this.receiversBlackList.contains(typeName)) {
                throw new SecurityException("Method calls not allowed on [" + typeName + "]");
            }
            call2.getArguments().visit(this);
        }

        @Override
        public void visitConstructorCallExpression(ConstructorCallExpression call2) {
            this.assertExpressionAuthorized(call2);
            call2.getArguments().visit(this);
        }

        @Override
        public void visitTernaryExpression(TernaryExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getBooleanExpression().visit(this);
            expression2.getTrueExpression().visit(this);
            expression2.getFalseExpression().visit(this);
        }

        @Override
        public void visitShortTernaryExpression(ElvisOperatorExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitTernaryExpression(expression2);
        }

        @Override
        public void visitBinaryExpression(BinaryExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.assertTokenAuthorized(expression2.getOperation());
            expression2.getLeftExpression().visit(this);
            expression2.getRightExpression().visit(this);
        }

        @Override
        public void visitPrefixExpression(PrefixExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.assertTokenAuthorized(expression2.getOperation());
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitPostfixExpression(PostfixExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.assertTokenAuthorized(expression2.getOperation());
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitBooleanExpression(BooleanExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitClosureExpression(ClosureExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            if (!SecureASTCustomizer.this.isClosuresAllowed) {
                throw new SecurityException("Closures are not allowed");
            }
            expression2.getCode().visit(this);
        }

        @Override
        public void visitTupleExpression(TupleExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitListOfExpressions(expression2.getExpressions());
        }

        @Override
        public void visitMapExpression(MapExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitListOfExpressions(expression2.getMapEntryExpressions());
        }

        @Override
        public void visitMapEntryExpression(MapEntryExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getKeyExpression().visit(this);
            expression2.getValueExpression().visit(this);
        }

        @Override
        public void visitListExpression(ListExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitListOfExpressions(expression2.getExpressions());
        }

        @Override
        public void visitRangeExpression(RangeExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getFrom().visit(this);
            expression2.getTo().visit(this);
        }

        @Override
        public void visitPropertyExpression(PropertyExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            Expression receiver = expression2.getObjectExpression();
            String typeName = receiver.getType().getName();
            if (SecureASTCustomizer.this.receiversWhiteList != null && !SecureASTCustomizer.this.receiversWhiteList.contains(typeName)) {
                throw new SecurityException("Property access not allowed on [" + typeName + "]");
            }
            if (SecureASTCustomizer.this.receiversBlackList != null && SecureASTCustomizer.this.receiversBlackList.contains(typeName)) {
                throw new SecurityException("Property access not allowed on [" + typeName + "]");
            }
            receiver.visit(this);
            Expression property = expression2.getProperty();
            this.checkConstantTypeIfNotMethodNameOrProperty(property);
        }

        private void checkConstantTypeIfNotMethodNameOrProperty(Expression expr2) {
            if (expr2 instanceof ConstantExpression) {
                if (!"java.lang.String".equals(expr2.getType().getName())) {
                    expr2.visit(this);
                }
            } else {
                expr2.visit(this);
            }
        }

        @Override
        public void visitAttributeExpression(AttributeExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            Expression receiver = expression2.getObjectExpression();
            String typeName = receiver.getType().getName();
            if (SecureASTCustomizer.this.receiversWhiteList != null && !SecureASTCustomizer.this.receiversWhiteList.contains(typeName)) {
                throw new SecurityException("Attribute access not allowed on [" + typeName + "]");
            }
            if (SecureASTCustomizer.this.receiversBlackList != null && SecureASTCustomizer.this.receiversBlackList.contains(typeName)) {
                throw new SecurityException("Attribute access not allowed on [" + typeName + "]");
            }
            receiver.visit(this);
            Expression property = expression2.getProperty();
            this.checkConstantTypeIfNotMethodNameOrProperty(property);
        }

        @Override
        public void visitFieldExpression(FieldExpression expression2) {
            this.assertExpressionAuthorized(expression2);
        }

        @Override
        public void visitMethodPointerExpression(MethodPointerExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
            expression2.getMethodName().visit(this);
        }

        @Override
        public void visitConstantExpression(ConstantExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            String type = expression2.getType().getName();
            if (SecureASTCustomizer.this.constantTypesWhiteList != null && !SecureASTCustomizer.this.constantTypesWhiteList.contains(type)) {
                throw new SecurityException("Constant expression type [" + type + "] is not allowed");
            }
            if (SecureASTCustomizer.this.constantTypesBlackList != null && SecureASTCustomizer.this.constantTypesBlackList.contains(type)) {
                throw new SecurityException("Constant expression type [" + type + "] is not allowed");
            }
        }

        @Override
        public void visitClassExpression(ClassExpression expression2) {
            this.assertExpressionAuthorized(expression2);
        }

        @Override
        public void visitVariableExpression(VariableExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            String type = expression2.getType().getName();
            if (SecureASTCustomizer.this.constantTypesWhiteList != null && !SecureASTCustomizer.this.constantTypesWhiteList.contains(type)) {
                throw new SecurityException("Usage of variables of type [" + type + "] is not allowed");
            }
            if (SecureASTCustomizer.this.constantTypesBlackList != null && SecureASTCustomizer.this.constantTypesBlackList.contains(type)) {
                throw new SecurityException("Usage of variables of type [" + type + "] is not allowed");
            }
        }

        @Override
        public void visitDeclarationExpression(DeclarationExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitBinaryExpression(expression2);
        }

        protected void visitListOfExpressions(List<? extends Expression> list2) {
            if (list2 == null) {
                return;
            }
            for (Expression expression2 : list2) {
                if (expression2 instanceof SpreadExpression) {
                    Expression spread = ((SpreadExpression)expression2).getExpression();
                    spread.visit(this);
                    continue;
                }
                expression2.visit(this);
            }
        }

        @Override
        public void visitGStringExpression(GStringExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitListOfExpressions(expression2.getStrings());
            this.visitListOfExpressions(expression2.getValues());
        }

        @Override
        public void visitArrayExpression(ArrayExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitListOfExpressions(expression2.getExpressions());
            this.visitListOfExpressions(expression2.getSizeExpression());
        }

        @Override
        public void visitSpreadExpression(SpreadExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitSpreadMapExpression(SpreadMapExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitNotExpression(NotExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitUnaryMinusExpression(UnaryMinusExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitUnaryPlusExpression(UnaryPlusExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitBitwiseNegationExpression(BitwiseNegationExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitCastExpression(CastExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            expression2.getExpression().visit(this);
        }

        @Override
        public void visitArgumentlistExpression(ArgumentListExpression expression2) {
            this.assertExpressionAuthorized(expression2);
            this.visitTupleExpression(expression2);
        }

        @Override
        public void visitClosureListExpression(ClosureListExpression closureListExpression) {
            this.assertExpressionAuthorized(closureListExpression);
            if (!SecureASTCustomizer.this.isClosuresAllowed) {
                throw new SecurityException("Closures are not allowed");
            }
            this.visitListOfExpressions(closureListExpression.getExpressions());
        }

        @Override
        public void visitBytecodeExpression(BytecodeExpression expression2) {
            this.assertExpressionAuthorized(expression2);
        }
    }
}

