/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;

public class StaticImportVisitor
extends ClassCodeExpressionTransformer {
    private ClassNode currentClass;
    private MethodNode currentMethod;
    private SourceUnit source;
    private boolean inSpecialConstructorCall;
    private boolean inClosure;
    private boolean inPropertyExpression;
    private Expression foundConstant;
    private Expression foundArgs;
    private boolean inAnnotation;
    private boolean inLeftExpression;

    public void visitClass(ClassNode node, SourceUnit source) {
        this.currentClass = node;
        this.source = source;
        super.visitClass(node);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.currentMethod = node;
        super.visitConstructorOrMethod(node, isConstructor);
        this.currentMethod = null;
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        boolean oldInAnnotation = this.inAnnotation;
        this.inAnnotation = true;
        super.visitAnnotations(node);
        this.inAnnotation = oldInAnnotation;
    }

    @Override
    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        if (exp.getClass() == VariableExpression.class) {
            return this.transformVariableExpression((VariableExpression)exp);
        }
        if (exp.getClass() == BinaryExpression.class) {
            return this.transformBinaryExpression((BinaryExpression)exp);
        }
        if (exp.getClass() == PropertyExpression.class) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        if (exp.getClass() == MethodCallExpression.class) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        if (exp.getClass() == ClosureExpression.class) {
            return this.transformClosureExpression((ClosureExpression)exp);
        }
        if (exp.getClass() == ConstructorCallExpression.class) {
            return this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        }
        if (exp.getClass() == ArgumentListExpression.class) {
            Expression result2 = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundArgs = result2;
            }
            return result2;
        }
        if (exp instanceof ConstantExpression) {
            ConstantExpression ce;
            Expression result3 = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundConstant = result3;
            }
            if (this.inAnnotation && exp instanceof AnnotationConstantExpression && (ce = (ConstantExpression)result3).getValue() instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)ce.getValue();
                Map<String, Expression> attributes2 = an.getMembers();
                for (Map.Entry<String, Expression> entry2 : attributes2.entrySet()) {
                    Expression attrExpr = this.transform(entry2.getValue());
                    entry2.setValue(attrExpr);
                }
            }
            return result3;
        }
        return exp.transformExpression(this);
    }

    private Expression transformMapEntryExpression(MapEntryExpression me, ClassNode constructorCallType) {
        ImportNode importNode;
        Map<String, ImportNode> importNodes;
        Expression key = me.getKeyExpression();
        Expression value2 = me.getValueExpression();
        ModuleNode module2 = this.currentClass.getModule();
        if (module2 != null && key instanceof ConstantExpression && (importNodes = module2.getStaticImports()).containsKey(key.getText()) && (importNode = importNodes.get(key.getText())).getType().equals(constructorCallType)) {
            String newKey = importNode.getFieldName();
            return new MapEntryExpression(new ConstantExpression(newKey), value2.transformExpression(this));
        }
        return me;
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left;
        int type = be.getOperation().getType();
        Expression right = this.transform(be.getRightExpression());
        be.setRightExpression(right);
        if (type == 100 && be.getLeftExpression() instanceof VariableExpression) {
            boolean oldInLeftExpression = this.inLeftExpression;
            this.inLeftExpression = true;
            left = this.transform(be.getLeftExpression());
            this.inLeftExpression = oldInLeftExpression;
            if (left instanceof StaticMethodCallExpression) {
                StaticMethodCallExpression smce = (StaticMethodCallExpression)left;
                StaticMethodCallExpression result2 = new StaticMethodCallExpression(smce.getOwnerType(), smce.getMethod(), right);
                StaticImportVisitor.setSourcePosition(result2, be);
                return result2;
            }
        } else {
            left = this.transform(be.getLeftExpression());
        }
        be.setLeftExpression(left);
        return be;
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v instanceof DynamicVariable) {
            Expression result2 = this.findStaticFieldOrPropAccessorImportFromModule(v.getName());
            if (result2 != null) {
                StaticImportVisitor.setSourcePosition(result2, ve);
                if (this.inAnnotation) {
                    result2 = ExpressionUtils.transformInlineConstants(result2);
                }
                return result2;
            }
        } else if (v instanceof FieldNode && this.inSpecialConstructorCall) {
            FieldNode fn2 = (FieldNode)v;
            ClassNode declaringClass = fn2.getDeclaringClass();
            if (fn2.isStatic() && this.currentClass.isDerivedFrom(declaringClass)) {
                PropertyExpression result3 = new PropertyExpression((Expression)new ClassExpression(declaringClass), v.getName());
                result3.setSourcePosition(ve);
                return result3;
            }
        }
        return ve;
    }

    private static void setSourcePosition(Expression toSet2, Expression origNode) {
        toSet2.setSourcePosition(origNode);
        if (toSet2 instanceof PropertyExpression) {
            ((PropertyExpression)toSet2).getProperty().setSourcePosition(origNode);
        }
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args2 = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = this.transform(mce.getObjectExpression());
        boolean isExplicitThisOrSuper = false;
        boolean isExplicitSuper = false;
        if (object instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)object;
            isExplicitThisOrSuper = !mce.isImplicitThis() && (ve.isThisExpression() || ve.isSuperExpression());
            isExplicitSuper = ve.isSuperExpression();
        }
        if (mce.isImplicitThis() || isExplicitThisOrSuper) {
            ConstantExpression ce;
            Object value2;
            Expression ret;
            if (mce.isImplicitThis()) {
                if (null == this.currentClass.tryFindPossibleMethod(mce.getMethodAsString(), args2)) {
                    String methodName;
                    ret = this.findStaticMethodImportFromModule(method, args2);
                    if (ret != null) {
                        StaticImportVisitor.setSourcePosition(ret, mce);
                        return ret;
                    }
                    if (method instanceof ConstantExpression && !this.inLeftExpression && (ret = this.findStaticFieldOrPropAccessorImportFromModule(methodName = (String)((ConstantExpression)method).getValue())) != null) {
                        ret = new MethodCallExpression(ret, "call", args2);
                        StaticImportVisitor.setSourcePosition(ret, mce);
                        return ret;
                    }
                }
            } else if (this.currentMethod != null && this.currentMethod.isStatic() && isExplicitSuper) {
                ret = new MethodCallExpression((Expression)new ClassExpression(this.currentClass.getSuperClass()), method, args2);
                StaticImportVisitor.setSourcePosition(ret, mce);
                return ret;
            }
            if (method instanceof ConstantExpression && (value2 = (ce = (ConstantExpression)method).getValue()) instanceof String) {
                boolean foundInstanceMethod = false;
                String methodName = (String)value2;
                boolean inInnerClass = ClassNodeUtils.isInnerClass(this.currentClass);
                if (this.currentMethod != null && !this.currentMethod.isStatic() && this.currentClass.hasPossibleMethod(methodName, args2)) {
                    foundInstanceMethod = true;
                }
                boolean lookForPossibleStaticMethod = !methodName.equals("call");
                lookForPossibleStaticMethod &= !foundInstanceMethod;
                lookForPossibleStaticMethod |= this.inSpecialConstructorCall;
                if (!this.inClosure && (lookForPossibleStaticMethod &= !inInnerClass) && ClassNodeUtils.hasPossibleStaticMethod(this.currentClass, methodName, args2, true) || ClassNodeUtils.hasPossibleStaticProperty(this.currentClass, methodName)) {
                    StaticMethodCallExpression smce = new StaticMethodCallExpression(this.currentClass, methodName, args2);
                    StaticImportVisitor.setSourcePosition(smce, mce);
                    return smce;
                }
                if (!this.inClosure && inInnerClass && this.inSpecialConstructorCall && mce.isImplicitThis() && !foundInstanceMethod) {
                    if (this.currentClass.getOuterClass().hasPossibleMethod(methodName, args2)) {
                        object = new PropertyExpression((Expression)new ClassExpression(this.currentClass.getOuterClass()), new ConstantExpression("this"));
                    } else if (ClassNodeUtils.hasPossibleStaticMethod(this.currentClass.getOuterClass(), methodName, args2, true) || ClassNodeUtils.hasPossibleStaticProperty(this.currentClass.getOuterClass(), methodName)) {
                        StaticMethodCallExpression smce = new StaticMethodCallExpression(this.currentClass.getOuterClass(), methodName, args2);
                        StaticImportVisitor.setSourcePosition(smce, mce);
                        return smce;
                    }
                }
                if (mce.isImplicitThis() && lookForPossibleStaticMethod && ClassNodeUtils.hasPossibleStaticMethod(this.currentClass, methodName, args2, true)) {
                    StaticMethodCallExpression result2 = new StaticMethodCallExpression(this.currentClass, methodName, args2);
                    result2.setSourcePosition(mce);
                    return result2;
                }
            }
        }
        MethodCallExpression result3 = new MethodCallExpression(object, method, args2);
        result3.setSafe(mce.isSafe());
        result3.setImplicitThis(mce.isImplicitThis());
        result3.setSpreadSafe(mce.isSpreadSafe());
        result3.setMethodTarget(mce.getMethodTarget());
        result3.setGenericsTypes(mce.getGenericsTypes());
        StaticImportVisitor.setSourcePosition(result3, mce);
        return result3;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        TupleExpression tuple2;
        this.inSpecialConstructorCall = cce.isSpecialCall();
        Expression expression2 = cce.getArguments();
        if (expression2 instanceof TupleExpression && (tuple2 = (TupleExpression)expression2).getExpressions().size() == 1 && (expression2 = tuple2.getExpression(0)) instanceof NamedArgumentListExpression) {
            NamedArgumentListExpression namedArgs = (NamedArgumentListExpression)expression2;
            List<MapEntryExpression> entryExpressions = namedArgs.getMapEntryExpressions();
            for (int i = 0; i < entryExpressions.size(); ++i) {
                entryExpressions.set(i, (MapEntryExpression)this.transformMapEntryExpression(entryExpressions.get(i), cce.getType()));
            }
        }
        Expression ret = cce.transformExpression(this);
        this.inSpecialConstructorCall = false;
        return ret;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        for (Parameter p : ClosureUtils.getParametersSafe(ce)) {
            if (!p.hasInitialExpression()) continue;
            p.setInitialExpression(this.transform(p.getInitialExpression()));
        }
        Statement code = ce.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        Expression result2;
        if (this.currentMethod != null && this.currentMethod.isStatic() && pe.getObjectExpression() instanceof VariableExpression && ((VariableExpression)pe.getObjectExpression()).isSuperExpression()) {
            PropertyExpression pexp = new PropertyExpression((Expression)new ClassExpression(this.currentClass.getSuperClass()), this.transform(pe.getProperty()));
            pexp.setSourcePosition(pe);
            return pexp;
        }
        boolean oldInPropertyExpression = this.inPropertyExpression;
        Expression oldFoundArgs = this.foundArgs;
        Expression oldFoundConstant = this.foundConstant;
        this.inPropertyExpression = true;
        this.foundArgs = null;
        this.foundConstant = null;
        Expression objectExpression = this.transform(pe.getObjectExpression());
        boolean candidate = false;
        if (objectExpression instanceof MethodCallExpression) {
            candidate = ((MethodCallExpression)objectExpression).isImplicitThis();
        }
        if (this.foundArgs != null && this.foundConstant != null && candidate && (result2 = this.findStaticMethodImportFromModule(this.foundConstant, this.foundArgs)) != null) {
            objectExpression = result2;
            objectExpression.setSourcePosition(pe);
        }
        this.inPropertyExpression = oldInPropertyExpression;
        this.foundArgs = oldFoundArgs;
        this.foundConstant = oldFoundConstant;
        pe.setObjectExpression(objectExpression);
        return pe;
    }

    private Expression findStaticFieldOrPropAccessorImportFromModule(String name2) {
        Expression expression2;
        String accessorName;
        ModuleNode module2 = this.currentClass.getModule();
        if (module2 == null) {
            return null;
        }
        Map<String, ImportNode> importNodes = module2.getStaticImports();
        if (importNodes.containsKey(accessorName = this.getAccessorName(name2)) && (expression2 = this.findStaticProperty(importNodes, accessorName)) != null) {
            return expression2;
        }
        if (accessorName.startsWith("get") && importNodes.containsKey(accessorName = "is" + accessorName.substring(3)) && (expression2 = this.findStaticProperty(importNodes, accessorName)) != null) {
            return expression2;
        }
        if (importNodes.containsKey(name2)) {
            ImportNode importNode = importNodes.get(name2);
            expression2 = this.findStaticPropertyAccessor(importNode.getType(), importNode.getFieldName());
            if (expression2 != null) {
                return expression2;
            }
            expression2 = StaticImportVisitor.findStaticField(importNode.getType(), importNode.getFieldName());
            if (expression2 != null) {
                return expression2;
            }
        }
        for (ImportNode importNode : module2.getStaticStarImports().values()) {
            ClassNode node = importNode.getType();
            expression2 = this.findStaticPropertyAccessor(node, name2);
            if (expression2 != null) {
                return expression2;
            }
            expression2 = StaticImportVisitor.findStaticField(node, name2);
            if (expression2 == null) continue;
            return expression2;
        }
        return null;
    }

    private Expression findStaticProperty(Map<String, ImportNode> importNodes, String accessorName) {
        String importMember;
        Expression result2 = null;
        ImportNode importNode = importNodes.get(accessorName);
        ClassNode importClass = importNode.getType();
        result2 = this.findStaticPropertyAccessorByFullName(importClass, importMember = importNode.getFieldName());
        if (result2 == null) {
            result2 = this.findStaticPropertyAccessor(importClass, ClassNodeUtils.getPropNameForAccessor(importMember));
        }
        return result2;
    }

    private Expression findStaticMethodImportFromModule(Expression method, Expression args2) {
        ClassNode starImportType;
        String propName;
        Expression expression2;
        ModuleNode module2 = this.currentClass.getModule();
        if (module2 == null || !(method instanceof ConstantExpression)) {
            return null;
        }
        Map<String, ImportNode> importNodes = module2.getStaticImports();
        ConstantExpression ce = (ConstantExpression)method;
        Object value2 = ce.getValue();
        if (!(value2 instanceof String)) {
            return null;
        }
        String name2 = (String)value2;
        if (importNodes.containsKey(name2)) {
            ImportNode importNode = importNodes.get(name2);
            expression2 = StaticImportVisitor.findStaticMethod(importNode.getType(), importNode.getFieldName(), args2);
            if (expression2 != null) {
                return expression2;
            }
            expression2 = this.findStaticPropertyAccessorGivenArgs(importNode.getType(), ClassNodeUtils.getPropNameForAccessor(importNode.getFieldName()), args2);
            if (expression2 != null) {
                return new StaticMethodCallExpression(importNode.getType(), importNode.getFieldName(), args2);
            }
        }
        if (ClassNodeUtils.isValidAccessorName(name2) && importNodes.containsKey(propName = ClassNodeUtils.getPropNameForAccessor(name2))) {
            ImportNode importNode = importNodes.get(propName);
            ClassNode importClass = importNode.getType();
            String importMember = importNode.getFieldName();
            expression2 = StaticImportVisitor.findStaticMethod(importClass, StaticImportVisitor.prefix(name2) + MetaClassHelper.capitalize(importMember), args2);
            if (expression2 != null) {
                return expression2;
            }
            expression2 = this.findStaticPropertyAccessorGivenArgs(importClass, importMember, args2);
            if (expression2 != null) {
                return new StaticMethodCallExpression(importClass, StaticImportVisitor.prefix(name2) + MetaClassHelper.capitalize(importMember), args2);
            }
        }
        Map<String, ImportNode> starImports = module2.getStaticStarImports();
        if (this.currentClass.isEnum() && starImports.containsKey(this.currentClass.getName())) {
            ImportNode importNode = starImports.get(this.currentClass.getName());
            starImportType = importNode == null ? null : importNode.getType();
            expression2 = StaticImportVisitor.findStaticMethod(starImportType, name2, args2);
            if (expression2 != null) {
                return expression2;
            }
        } else {
            for (ImportNode importNode : starImports.values()) {
                starImportType = importNode == null ? null : importNode.getType();
                expression2 = StaticImportVisitor.findStaticMethod(starImportType, name2, args2);
                if (expression2 != null) {
                    return expression2;
                }
                expression2 = this.findStaticPropertyAccessorGivenArgs(starImportType, ClassNodeUtils.getPropNameForAccessor(name2), args2);
                if (expression2 == null) continue;
                return new StaticMethodCallExpression(starImportType, name2, args2);
            }
        }
        return null;
    }

    private static String prefix(String name2) {
        return name2.startsWith("is") ? "is" : name2.substring(0, 3);
    }

    private String getAccessorName(String name2) {
        return (this.inLeftExpression ? "set" : "get") + MetaClassHelper.capitalize(name2);
    }

    private Expression findStaticPropertyAccessorGivenArgs(ClassNode staticImportType, String propName, Expression args2) {
        return this.findStaticPropertyAccessor(staticImportType, propName);
    }

    private Expression findStaticPropertyAccessor(ClassNode staticImportType, String propName) {
        String accessorName = this.getAccessorName(propName);
        Expression accessor = this.findStaticPropertyAccessorByFullName(staticImportType, accessorName);
        if (accessor == null && accessorName.startsWith("get")) {
            accessor = this.findStaticPropertyAccessorByFullName(staticImportType, "is" + accessorName.substring(3));
        }
        if (accessor == null && ClassNodeUtils.hasStaticProperty(staticImportType, propName)) {
            accessor = this.inLeftExpression ? new StaticMethodCallExpression(staticImportType, accessorName, ArgumentListExpression.EMPTY_ARGUMENTS) : new PropertyExpression((Expression)new ClassExpression(staticImportType), propName);
        }
        return accessor;
    }

    private Expression findStaticPropertyAccessorByFullName(ClassNode staticImportType, String accessorMethodName) {
        ArgumentListExpression dummyArgs2 = new ArgumentListExpression();
        dummyArgs2.addExpression(EmptyExpression.INSTANCE);
        return StaticImportVisitor.findStaticMethod(staticImportType, accessorMethodName, this.inLeftExpression ? dummyArgs2 : ArgumentListExpression.EMPTY_ARGUMENTS);
    }

    private static Expression findStaticField(ClassNode staticImportType, String fieldName) {
        FieldNode field2;
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && (field2 = ClassNodeUtils.getField(staticImportType, fieldName)) != null && field2.isStatic()) {
            return new PropertyExpression((Expression)new ClassExpression(staticImportType), fieldName);
        }
        return null;
    }

    private static Expression findStaticMethod(ClassNode staticImportType, String methodName, Expression args2) {
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && staticImportType.hasPossibleStaticMethod(methodName, args2)) {
            return new StaticMethodCallExpression(staticImportType, methodName, args2);
        }
        return null;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }
}

