/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;

public class LabelVerifier
extends ClassCodeVisitorSupport {
    private final SourceUnit source;
    private LinkedList<String> visitedLabels;
    private LinkedList<ContinueStatement> continueLabels;
    private LinkedList<BreakStatement> breakLabels;
    boolean inLoop = false;
    boolean inSwitch = false;

    public LabelVerifier(SourceUnit src) {
        this.source = src;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private void init() {
        this.visitedLabels = new LinkedList();
        this.continueLabels = new LinkedList();
        this.breakLabels = new LinkedList();
        this.inLoop = false;
        this.inSwitch = false;
    }

    @Override
    protected void visitClassCodeContainer(Statement code) {
        this.init();
        super.visitClassCodeContainer(code);
        this.assertNoLabelsMissed();
    }

    @Override
    public void visitStatement(Statement statement2) {
        List<String> labels = statement2.getStatementLabels();
        if (labels != null) {
            for (String label : labels) {
                Iterator iter2;
                if (this.breakLabels != null) {
                    iter2 = this.breakLabels.iterator();
                    while (iter2.hasNext()) {
                        if (!((BreakStatement)iter2.next()).getLabel().equals(label)) continue;
                        iter2.remove();
                    }
                }
                if (this.continueLabels != null) {
                    iter2 = this.continueLabels.iterator();
                    while (iter2.hasNext()) {
                        if (!((ContinueStatement)iter2.next()).getLabel().equals(label)) continue;
                        iter2.remove();
                    }
                }
                if (this.visitedLabels == null) continue;
                this.visitedLabels.add(label);
            }
        }
        super.visitStatement(statement2);
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        boolean oldInLoop = this.inLoop;
        this.inLoop = true;
        super.visitForLoop(forLoop);
        this.inLoop = oldInLoop;
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement loop2) {
        boolean oldInLoop = this.inLoop;
        this.inLoop = true;
        super.visitDoWhileLoop(loop2);
        this.inLoop = oldInLoop;
    }

    @Override
    public void visitWhileLoop(WhileStatement loop2) {
        boolean oldInLoop = this.inLoop;
        this.inLoop = true;
        super.visitWhileLoop(loop2);
        this.inLoop = oldInLoop;
    }

    @Override
    public void visitBreakStatement(BreakStatement statement2) {
        boolean hasNamedLabel;
        String label = statement2.getLabel();
        boolean bl = hasNamedLabel = label != null;
        if (!(hasNamedLabel || this.inLoop || this.inSwitch)) {
            this.addError("the break statement is only allowed inside loops or switches", statement2);
        } else if (hasNamedLabel && !this.inLoop) {
            this.addError("the break statement with named label is only allowed inside loops", statement2);
        }
        if (label != null) {
            boolean found = false;
            for (String element : this.visitedLabels) {
                if (!element.equals(label)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.breakLabels.add(statement2);
            }
        }
        super.visitBreakStatement(statement2);
    }

    @Override
    public void visitContinueStatement(ContinueStatement statement2) {
        boolean hasNamedLabel;
        String label = statement2.getLabel();
        boolean bl = hasNamedLabel = label != null;
        if (!hasNamedLabel && !this.inLoop) {
            this.addError("the continue statement is only allowed inside loops", statement2);
        }
        if (label != null) {
            boolean found = false;
            for (String element : this.visitedLabels) {
                if (!element.equals(label)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.continueLabels.add(statement2);
            }
        }
        super.visitContinueStatement(statement2);
    }

    protected void assertNoLabelsMissed() {
        for (ContinueStatement continueStatement : this.continueLabels) {
            this.addError("continue to missing label", continueStatement);
        }
        for (BreakStatement breakStatement : this.breakLabels) {
            this.addError("break to missing label", breakStatement);
        }
    }

    @Override
    public void visitSwitch(SwitchStatement statement2) {
        boolean oldInSwitch = this.inSwitch;
        this.inSwitch = true;
        super.visitSwitch(statement2);
        this.inSwitch = oldInSwitch;
    }
}

