/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.decompiled.AsmDecompiler;
import org.codehaus.groovy.ast.decompiled.AsmReferenceResolver;
import org.codehaus.groovy.ast.decompiled.DecompiledClassNode;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class ClassNodeResolver {
    private final Map<String, ClassNode> cachedClasses = new HashMap<String, ClassNode>();
    protected static final ClassNode NO_CLASS = new ClassNode("NO_CLASS", 1, ClassHelper.OBJECT_TYPE){

        @Override
        public void setRedirect(ClassNode cn) {
            throw new GroovyBugError("This is a dummy class node only! Never use it for real classes.");
        }
    };

    public LookupResult resolveName(String name2, CompilationUnit compilationUnit2) {
        ClassNode res = this.getFromClassCache(name2);
        if (res == NO_CLASS) {
            return null;
        }
        if (res != null) {
            return new LookupResult(null, res);
        }
        LookupResult lr = this.findClassNode(name2, compilationUnit2);
        if (lr != null) {
            if (lr.isClassNode()) {
                this.cacheClass(name2, lr.getClassNode());
            }
            return lr;
        }
        this.cacheClass(name2, NO_CLASS);
        return null;
    }

    public void cacheClass(String name2, ClassNode res) {
        this.cachedClasses.put(name2, res);
    }

    public ClassNode getFromClassCache(String name2) {
        ClassNode cached = this.cachedClasses.get(name2);
        return cached;
    }

    public LookupResult findClassNode(String name2, CompilationUnit compilationUnit2) {
        return this.tryAsLoaderClassOrScript(name2, compilationUnit2);
    }

    private LookupResult tryAsLoaderClassOrScript(String name2, CompilationUnit compilationUnit2) {
        LookupResult result2;
        GroovyClassLoader loader = compilationUnit2.getClassLoader();
        Map<String, Boolean> options = compilationUnit2.configuration.getOptimizationOptions();
        boolean useAsm = !Boolean.FALSE.equals(options.get("asmResolving"));
        boolean useClassLoader = !Boolean.FALSE.equals(options.get("classLoaderResolving"));
        LookupResult lookupResult = result2 = useAsm ? this.findDecompiled(name2, compilationUnit2, loader) : null;
        if (result2 != null) {
            return result2;
        }
        if (!useClassLoader) {
            return ClassNodeResolver.tryAsScript(name2, compilationUnit2, null);
        }
        return ClassNodeResolver.findByClassLoading(name2, compilationUnit2, loader);
    }

    private static LookupResult findByClassLoading(String name2, CompilationUnit compilationUnit2, GroovyClassLoader loader) {
        Class cls;
        try {
            cls = loader.loadClass(name2, false, true);
        }
        catch (ClassNotFoundException cnfe) {
            LookupResult lr = ClassNodeResolver.tryAsScript(name2, compilationUnit2, null);
            return lr;
        }
        catch (CompilationFailedException cfe) {
            throw new GroovyBugError("The lookup for " + name2 + " caused a failed compilation. There should not have been any compilation from this call.", cfe);
        }
        if (cls == null) {
            return null;
        }
        ClassNode cn = ClassHelper.make(cls);
        if (cls.getClassLoader() != loader) {
            return ClassNodeResolver.tryAsScript(name2, compilationUnit2, cn);
        }
        return new LookupResult(null, cn);
    }

    private LookupResult findDecompiled(String name2, CompilationUnit compilationUnit2, GroovyClassLoader loader) {
        ClassNode node = ClassHelper.make(name2);
        if (node.isResolved()) {
            return new LookupResult(null, node);
        }
        DecompiledClassNode asmClass = null;
        String fileName = name2.replace('.', '/') + ".class";
        URL resource2 = loader.getResource(fileName);
        if (resource2 != null) {
            try {
                asmClass = new DecompiledClassNode(AsmDecompiler.parseClass(resource2), new AsmReferenceResolver(this, compilationUnit2));
                if (!asmClass.getName().equals(name2)) {
                    asmClass = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (asmClass != null) {
            if (ClassNodeResolver.isFromAnotherClassLoader(loader, fileName)) {
                return ClassNodeResolver.tryAsScript(name2, compilationUnit2, asmClass);
            }
            return new LookupResult(null, asmClass);
        }
        return null;
    }

    private static boolean isFromAnotherClassLoader(GroovyClassLoader loader, String fileName) {
        ClassLoader parent = loader.getParent();
        return parent != null && parent.getResource(fileName) != null;
    }

    private static LookupResult tryAsScript(String name2, CompilationUnit compilationUnit2, ClassNode oldClass) {
        LookupResult lr = null;
        if (oldClass != null) {
            lr = new LookupResult(null, oldClass);
        }
        if (name2.startsWith("java.")) {
            return lr;
        }
        if (name2.indexOf(36) != -1) {
            return lr;
        }
        GroovyClassLoader gcl = compilationUnit2.getClassLoader();
        URL url = null;
        try {
            url = gcl.getResourceLoader().loadGroovySource(name2);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (url != null && (oldClass == null || ClassNodeResolver.isSourceNewer(url, oldClass))) {
            SourceUnit su = compilationUnit2.addSource(url);
            return new LookupResult(su, null);
        }
        return lr;
    }

    private static long getTimeStamp(ClassNode cls) {
        if (!(cls instanceof DecompiledClassNode)) {
            return Verifier.getTimestamp(cls.getTypeClass());
        }
        return ((DecompiledClassNode)cls).getCompilationTimeStamp();
    }

    private static boolean isSourceNewer(URL source, ClassNode cls) {
        try {
            long lastMod;
            if (source.getProtocol().equals("file")) {
                String path = source.getPath().replace('/', File.separatorChar).replace('|', ':');
                File file = new File(path);
                lastMod = file.lastModified();
            } else {
                URLConnection conn = source.openConnection();
                lastMod = conn.getLastModified();
                conn.getInputStream().close();
            }
            return lastMod > ClassNodeResolver.getTimeStamp(cls);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static class LookupResult {
        private final SourceUnit su;
        private final ClassNode cn;

        public LookupResult(SourceUnit su, ClassNode cn) {
            this.su = su;
            this.cn = cn;
            if (su == null && cn == null) {
                throw new IllegalArgumentException("Either the SourceUnit or the ClassNode must not be null.");
            }
            if (su != null && cn != null) {
                throw new IllegalArgumentException("SourceUnit and ClassNode cannot be set at the same time.");
            }
        }

        public boolean isClassNode() {
            return this.cn != null;
        }

        public boolean isSourceUnit() {
            return this.su != null;
        }

        public SourceUnit getSourceUnit() {
            return this.su;
        }

        public ClassNode getClassNode() {
            return this.cn;
        }
    }
}

