/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm.util;

import groovyjarjarasm.asm.Attribute;
import groovyjarjarasm.asm.Handle;
import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.TypePath;
import groovyjarjarasm.asm.util.Printer;
import groovyjarjarasm.asm.util.Textifier;
import java.util.LinkedList;
import java.util.List;

public class LoggableTextifier
extends Textifier {
    private static final String GROOVY_LOG_CLASSGEN_STACKTRACE_MAX_DEPTH = "groovy.log.classgen.stacktrace.max.depth";
    private static final String GROOVY = ".groovy.";
    private static final String LOGGABLE_TEXTIFIER = ".LoggableTextifier";
    private static final int STACKTRACE_MAX_DEPTH = Integer.getInteger("groovy.log.classgen.stacktrace.max.depth", 0);
    private int loggedLineCnt = 0;

    public LoggableTextifier() {
        super(458752);
    }

    @Override
    protected Textifier createTextifier() {
        return new LoggableTextifier();
    }

    protected void log() {
        int textSize = this.text.size();
        LinkedList bcList = new LinkedList();
        for (int i = this.loggedLineCnt; i < textSize; ++i) {
            Object bc = this.text.get(i);
            if (bc instanceof List && 0 == ((List)bc).size()) continue;
            bcList.add(bc);
        }
        if (bcList.size() > 0) {
            List<StackTraceElement> invocationPositionInfo = this.getInvocationPositionInfo();
            if (invocationPositionInfo.size() > 0) {
                System.out.print(this.formatInvocationPositionInfo(invocationPositionInfo));
            }
            for (Object bc : bcList) {
                System.out.print(bc);
            }
        }
        this.loggedLineCnt = textSize;
    }

    private List<StackTraceElement> getInvocationPositionInfo() {
        StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
        LinkedList<StackTraceElement> stackTraceElementList = new LinkedList<StackTraceElement>();
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            String className2 = stackTraceElement.getClassName();
            if (!className2.contains(GROOVY) || className2.endsWith(LOGGABLE_TEXTIFIER)) continue;
            if (stackTraceElementList.size() >= STACKTRACE_MAX_DEPTH) break;
            stackTraceElementList.add(stackTraceElement);
        }
        return stackTraceElementList;
    }

    private String formatInvocationPositionInfo(List<StackTraceElement> stackTraceElementList) {
        StringBuilder sb = new StringBuilder(128);
        for (StackTraceElement stackTraceElement : stackTraceElementList) {
            sb.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t// ");
            sb.append(String.format("%s#%s:%s%n", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()));
        }
        return sb.toString();
    }

    @Override
    public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaces2) {
        super.visit(version, access, name2, signature2, superName, interfaces2);
        this.log();
    }

    @Override
    public void visitSource(String file, String debug) {
        super.visitSource(file, debug);
        this.log();
    }

    @Override
    public Printer visitModule(String name2, int access, String version) {
        Printer p = super.visitModule(name2, access, version);
        this.log();
        return p;
    }

    @Override
    public void visitOuterClass(String owner, String name2, String desc) {
        super.visitOuterClass(owner, name2, desc);
        this.log();
    }

    @Override
    public Textifier visitClassAnnotation(String desc, boolean visible) {
        Textifier t = super.visitClassAnnotation(desc, visible);
        this.log();
        return t;
    }

    @Override
    public Printer visitClassTypeAnnotation(int typeRef, TypePath typePath2, String desc, boolean visible) {
        Printer t = super.visitClassTypeAnnotation(typeRef, typePath2, desc, visible);
        this.log();
        return t;
    }

    @Override
    public void visitClassAttribute(Attribute attr) {
        super.visitClassAttribute(attr);
        this.log();
    }

    @Override
    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        super.visitInnerClass(name2, outerName, innerName, access);
        this.log();
    }

    @Override
    public Textifier visitField(int access, String name2, String desc, String signature2, Object value2) {
        Textifier t = super.visitField(access, name2, desc, signature2, value2);
        this.log();
        return t;
    }

    @Override
    public Textifier visitMethod(int access, String name2, String desc, String signature2, String[] exceptions) {
        Textifier t = super.visitMethod(access, name2, desc, signature2, exceptions);
        this.log();
        return t;
    }

    @Override
    public void visitClassEnd() {
        super.visitClassEnd();
        this.log();
    }

    @Override
    public void visitRequire(String require2, int access, String version) {
        super.visitRequire(require2, access, version);
        this.log();
    }

    @Override
    public void visitExport(String export, int access, String ... modules) {
        super.visitExport(export, access, modules);
        this.log();
    }

    @Override
    public void visitUse(String use) {
        super.visitUse(use);
        this.log();
    }

    @Override
    public void visitProvide(String provide, String ... providers) {
        super.visitProvide(provide, providers);
        this.log();
    }

    @Override
    public void visitModuleEnd() {
        super.visitModuleEnd();
        this.log();
    }

    @Override
    public void visit(String name2, Object value2) {
        super.visit(name2, value2);
        this.log();
    }

    @Override
    public void visitEnum(String name2, String desc, String value2) {
        super.visitEnum(name2, desc, value2);
        this.log();
    }

    @Override
    public Textifier visitAnnotation(String name2, String desc) {
        Textifier t = super.visitAnnotation(name2, desc);
        this.log();
        return t;
    }

    @Override
    public Textifier visitArray(String name2) {
        Textifier t = super.visitArray(name2);
        this.log();
        return t;
    }

    @Override
    public void visitAnnotationEnd() {
        super.visitAnnotationEnd();
        this.log();
    }

    @Override
    public Textifier visitFieldAnnotation(String desc, boolean visible) {
        Textifier t = super.visitFieldAnnotation(desc, visible);
        this.log();
        return t;
    }

    @Override
    public Printer visitFieldTypeAnnotation(int typeRef, TypePath typePath2, String desc, boolean visible) {
        Printer t = super.visitFieldTypeAnnotation(typeRef, typePath2, desc, visible);
        this.log();
        return t;
    }

    @Override
    public void visitFieldAttribute(Attribute attr) {
        super.visitFieldAttribute(attr);
        this.log();
    }

    @Override
    public void visitFieldEnd() {
        super.visitFieldEnd();
        this.log();
    }

    @Override
    public void visitParameter(String name2, int access) {
        super.visitParameter(name2, access);
        this.log();
    }

    @Override
    public Textifier visitAnnotationDefault() {
        Textifier t = super.visitAnnotationDefault();
        this.log();
        return t;
    }

    @Override
    public Textifier visitMethodAnnotation(String desc, boolean visible) {
        Textifier t = super.visitMethodAnnotation(desc, visible);
        this.log();
        return t;
    }

    @Override
    public Printer visitMethodTypeAnnotation(int typeRef, TypePath typePath2, String desc, boolean visible) {
        Printer t = super.visitMethodTypeAnnotation(typeRef, typePath2, desc, visible);
        this.log();
        return t;
    }

    @Override
    public Textifier visitParameterAnnotation(int parameter, String desc, boolean visible) {
        Textifier t = super.visitParameterAnnotation(parameter, desc, visible);
        this.log();
        return t;
    }

    @Override
    public void visitMethodAttribute(Attribute attr) {
        super.visitMethodAttribute(attr);
        this.log();
    }

    @Override
    public void visitCode() {
        super.visitCode();
        this.log();
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        super.visitFrame(type, nLocal, local, nStack, stack);
        this.log();
    }

    @Override
    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.log();
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.log();
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.log();
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.log();
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name2, String desc) {
        super.visitFieldInsn(opcode, owner, name2, desc);
        this.log();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name2, String desc) {
        super.visitMethodInsn(opcode, owner, name2, desc);
        this.log();
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name2, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name2, desc, itf);
        this.log();
    }

    @Override
    public void visitInvokeDynamicInsn(String name2, String desc, Handle bsm, Object ... bsmArgs) {
        super.visitInvokeDynamicInsn(name2, desc, bsm, bsmArgs);
        this.log();
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.log();
    }

    @Override
    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.log();
    }

    @Override
    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.log();
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.log();
    }

    @Override
    public void visitTableSwitchInsn(int min2, int max2, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min2, max2, dflt, labels);
        this.log();
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.log();
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        this.log();
    }

    @Override
    public Printer visitInsnAnnotation(int typeRef, TypePath typePath2, String desc, boolean visible) {
        Printer t = super.visitInsnAnnotation(typeRef, typePath2, desc, visible);
        this.log();
        return t;
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        this.log();
    }

    @Override
    public Printer visitTryCatchAnnotation(int typeRef, TypePath typePath2, String desc, boolean visible) {
        Printer t = super.visitTryCatchAnnotation(typeRef, typePath2, desc, visible);
        this.log();
        return t;
    }

    @Override
    public void visitLocalVariable(String name2, String desc, String signature2, Label start, Label end, int index2) {
        super.visitLocalVariable(name2, desc, signature2, start, end, index2);
        this.log();
    }

    @Override
    public Printer visitLocalVariableAnnotation(int typeRef, TypePath typePath2, Label[] start, Label[] end, int[] index2, String desc, boolean visible) {
        Printer t = super.visitLocalVariableAnnotation(typeRef, typePath2, start, end, index2, desc, visible);
        this.log();
        return t;
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.log();
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
        this.log();
    }

    @Override
    public void visitMethodEnd() {
        super.visitMethodEnd();
        this.log();
    }

    @Override
    public Textifier visitAnnotation(String desc, boolean visible) {
        Textifier t = super.visitAnnotation(desc, visible);
        this.log();
        return t;
    }

    @Override
    public Textifier visitTypeAnnotation(int typeRef, TypePath typePath2, String desc, boolean visible) {
        Textifier t = super.visitTypeAnnotation(typeRef, typePath2, desc, visible);
        this.log();
        return t;
    }

    @Override
    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        this.log();
    }
}

