/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.tools.WideningCategories;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.BytecodeVariable;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.WriterController;

public class OperandStack {
    private final WriterController controller;
    private final List<ClassNode> stack = new ArrayList<ClassNode>();

    public OperandStack(WriterController wc) {
        this.controller = wc;
    }

    public int getStackLength() {
        return this.stack.size();
    }

    public void popDownTo(int elements) {
        int last2 = this.stack.size();
        MethodVisitor mv = this.controller.getMethodVisitor();
        while (last2 > elements) {
            ClassNode element;
            if (OperandStack.isTwoSlotType(element = this.popWithMessage(--last2))) {
                mv.visitInsn(88);
                continue;
            }
            mv.visitInsn(87);
        }
    }

    private ClassNode popWithMessage(int last2) {
        try {
            return this.stack.remove(last2);
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            String method = this.controller.getMethodNode() == null ? this.controller.getConstructorNode().getTypeDescriptor() : this.controller.getMethodNode().getTypeDescriptor();
            throw new GroovyBugError("Error while popping argument from operand stack tracker in class " + this.controller.getClassName() + " method " + method + ".");
        }
    }

    private static boolean isTwoSlotType(ClassNode type) {
        return type == ClassHelper.long_TYPE || type == ClassHelper.double_TYPE;
    }

    public void castToBool(int mark2, boolean emptyDefault) {
        int size2 = this.stack.size();
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (mark2 == size2) {
            if (emptyDefault) {
                mv.visitIntInsn(16, 1);
            } else {
                mv.visitIntInsn(16, 0);
            }
            this.stack.add(null);
        } else if (mark2 == size2 - 1) {
            ClassNode last2 = this.stack.get(size2 - 1);
            if (last2 == ClassHelper.boolean_TYPE) {
                return;
            }
            if (!ClassHelper.isPrimitiveType(last2)) {
                this.controller.getInvocationWriter().castNonPrimitiveToBool(last2);
            } else {
                BytecodeHelper.convertPrimitiveToBoolean(mv, last2);
            }
        } else {
            throw new GroovyBugError("operand stack contains " + size2 + " elements, but we expected only " + mark2);
        }
        this.stack.set(mark2, ClassHelper.boolean_TYPE);
    }

    public void pop() {
        this.popDownTo(this.stack.size() - 1);
    }

    public Label jump(int ifIns) {
        Label label = new Label();
        this.jump(ifIns, label);
        return label;
    }

    public void jump(int ifIns, Label label) {
        this.controller.getMethodVisitor().visitJumpInsn(ifIns, label);
        this.remove(1);
    }

    public void dup() {
        ClassNode type = this.getTopOperand();
        this.stack.add(type);
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (type == ClassHelper.double_TYPE || type == ClassHelper.long_TYPE) {
            mv.visitInsn(92);
        } else {
            mv.visitInsn(89);
        }
    }

    public ClassNode box() {
        MethodVisitor mv = this.controller.getMethodVisitor();
        int size2 = this.stack.size();
        ClassNode type = this.stack.get(size2 - 1);
        if (ClassHelper.isPrimitiveType(type) && ClassHelper.VOID_TYPE != type) {
            ClassNode wrapper2 = ClassHelper.getWrapper(type);
            BytecodeHelper.doCastToWrappedType(mv, type, wrapper2);
            type = wrapper2;
        }
        this.stack.set(size2 - 1, type);
        return type;
    }

    public void remove(int amount) {
        int size2 = this.stack.size();
        for (int i = size2 - 1; i > size2 - 1 - amount; --i) {
            this.popWithMessage(i);
        }
    }

    public void push(ClassNode type) {
        this.stack.add(type);
    }

    public void swap() {
        MethodVisitor mv = this.controller.getMethodVisitor();
        int size2 = this.stack.size();
        ClassNode b = this.stack.get(size2 - 1);
        ClassNode a = this.stack.get(size2 - 2);
        if (OperandStack.isTwoSlotType(a)) {
            if (OperandStack.isTwoSlotType(b)) {
                mv.visitInsn(94);
                mv.visitInsn(88);
            } else {
                mv.visitInsn(91);
                mv.visitInsn(87);
            }
        } else if (OperandStack.isTwoSlotType(b)) {
            mv.visitInsn(93);
            mv.visitInsn(88);
        } else {
            mv.visitInsn(95);
        }
        this.stack.set(size2 - 1, a);
        this.stack.set(size2 - 2, b);
    }

    public void replace(ClassNode type) {
        int size2 = this.ensureStackNotEmpty(this.stack);
        this.stack.set(size2 - 1, type);
    }

    private int ensureStackNotEmpty(List<ClassNode> stack) {
        int size2 = stack.size();
        try {
            if (size2 == 0) {
                throw new ArrayIndexOutOfBoundsException("size==0");
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            System.err.println("index problem in " + this.controller.getSourceUnit().getName());
            throw ai;
        }
        return size2;
    }

    public void replace(ClassNode type, int n) {
        this.remove(n);
        this.push(type);
    }

    public void doGroovyCast(ClassNode targetType) {
        this.doConvertAndCast(targetType, false);
    }

    public void doGroovyCast(Variable v) {
        ClassNode targetType = v.getOriginType();
        this.doConvertAndCast(targetType, false);
    }

    public void doAsType(ClassNode targetType) {
        this.doConvertAndCast(targetType, true);
    }

    private void throwExceptionForNoStackElement(int size2, ClassNode targetType, boolean coerce) {
        ConstructorNode constructorNode;
        if (size2 > 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Internal compiler error while compiling ").append(this.controller.getSourceUnit().getName()).append("\n");
        MethodNode methodNode = this.controller.getMethodNode();
        if (methodNode != null) {
            sb.append("Method: ");
            sb.append(methodNode);
            sb.append("\n");
        }
        if ((constructorNode = this.controller.getConstructorNode()) != null) {
            sb.append("Constructor: ");
            sb.append(methodNode);
            sb.append("\n");
        }
        sb.append("Line ").append(this.controller.getLineNumber()).append(",");
        sb.append(" expecting ").append(coerce ? "coercion" : "casting").append(" to ").append(targetType.toString(false));
        sb.append(" but operand stack is empty");
        throw new ArrayIndexOutOfBoundsException(sb.toString());
    }

    private void doConvertAndCast(ClassNode targetType, boolean coerce) {
        int size2 = this.stack.size();
        this.throwExceptionForNoStackElement(size2, targetType, coerce);
        ClassNode top = this.stack.get(size2 - 1);
        targetType = targetType.redirect();
        if (targetType == top) {
            return;
        }
        if (coerce) {
            this.controller.getInvocationWriter().coerce(top, targetType);
            return;
        }
        boolean primTarget = ClassHelper.isPrimitiveType(targetType);
        boolean primTop = ClassHelper.isPrimitiveType(top);
        if (primTop && primTarget) {
            if (this.convertPrimitive(top, targetType)) {
                this.replace(targetType);
                return;
            }
            this.box();
        } else if (!primTarget) {
            this.controller.getInvocationWriter().castToNonPrimitiveIfNecessary(top, targetType);
        }
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (primTarget && !ClassHelper.boolean_TYPE.equals(targetType) && !primTop && ClassHelper.getWrapper(targetType).equals(top)) {
            BytecodeHelper.doCastToPrimitive(mv, top, targetType);
        } else {
            top = this.stack.get(size2 - 1);
            if (!WideningCategories.implementsInterfaceOrSubclassOf(top, targetType)) {
                BytecodeHelper.doCast(mv, targetType);
            }
        }
        this.replace(targetType);
    }

    private boolean convertFromInt(ClassNode target) {
        int convertCode;
        if (target == ClassHelper.char_TYPE) {
            convertCode = 146;
        } else if (target == ClassHelper.byte_TYPE) {
            convertCode = 145;
        } else if (target == ClassHelper.short_TYPE) {
            convertCode = 147;
        } else if (target == ClassHelper.long_TYPE) {
            convertCode = 133;
        } else if (target == ClassHelper.float_TYPE) {
            convertCode = 134;
        } else if (target == ClassHelper.double_TYPE) {
            convertCode = 135;
        } else {
            return false;
        }
        this.controller.getMethodVisitor().visitInsn(convertCode);
        return true;
    }

    private boolean convertFromLong(ClassNode target) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (target == ClassHelper.int_TYPE) {
            mv.visitInsn(136);
            return true;
        }
        if (target == ClassHelper.char_TYPE || target == ClassHelper.byte_TYPE || target == ClassHelper.short_TYPE) {
            mv.visitInsn(136);
            return this.convertFromInt(target);
        }
        if (target == ClassHelper.double_TYPE) {
            mv.visitInsn(138);
            return true;
        }
        if (target == ClassHelper.float_TYPE) {
            mv.visitInsn(137);
            return true;
        }
        return false;
    }

    private boolean convertFromDouble(ClassNode target) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (target == ClassHelper.int_TYPE) {
            mv.visitInsn(142);
            return true;
        }
        if (target == ClassHelper.char_TYPE || target == ClassHelper.byte_TYPE || target == ClassHelper.short_TYPE) {
            mv.visitInsn(142);
            return this.convertFromInt(target);
        }
        if (target == ClassHelper.long_TYPE) {
            mv.visitInsn(143);
            return true;
        }
        if (target == ClassHelper.float_TYPE) {
            mv.visitInsn(144);
            return true;
        }
        return false;
    }

    private boolean convertFromFloat(ClassNode target) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (target == ClassHelper.int_TYPE) {
            mv.visitInsn(139);
            return true;
        }
        if (target == ClassHelper.char_TYPE || target == ClassHelper.byte_TYPE || target == ClassHelper.short_TYPE) {
            mv.visitInsn(139);
            return this.convertFromInt(target);
        }
        if (target == ClassHelper.long_TYPE) {
            mv.visitInsn(140);
            return true;
        }
        if (target == ClassHelper.double_TYPE) {
            mv.visitInsn(141);
            return true;
        }
        return false;
    }

    private boolean convertPrimitive(ClassNode top, ClassNode target) {
        if (top == target) {
            return true;
        }
        if (top == ClassHelper.int_TYPE) {
            return this.convertFromInt(target);
        }
        if (top == ClassHelper.char_TYPE || top == ClassHelper.byte_TYPE || top == ClassHelper.short_TYPE) {
            return target == ClassHelper.int_TYPE || this.convertFromInt(target);
        }
        if (top == ClassHelper.float_TYPE) {
            return this.convertFromFloat(target);
        }
        if (top == ClassHelper.double_TYPE) {
            return this.convertFromDouble(target);
        }
        if (top == ClassHelper.long_TYPE) {
            return this.convertFromLong(target);
        }
        return false;
    }

    public void pushConstant(ConstantExpression expression2) {
        boolean asPrimitive;
        ClassNode type;
        MethodVisitor mv = this.controller.getMethodVisitor();
        Object value2 = expression2.getValue();
        ClassNode origType = expression2.getType().redirect();
        boolean boxing = origType != (type = ClassHelper.getUnwrapper(origType));
        boolean bl = asPrimitive = boxing || ClassHelper.isPrimitiveType(type);
        if (value2 == null) {
            mv.visitInsn(1);
        } else if (boxing && value2 instanceof Boolean) {
            Boolean bool2 = (Boolean)value2;
            String text2 = bool2 != false ? "TRUE" : "FALSE";
            mv.visitFieldInsn(178, "java/lang/Boolean", text2, "Ljava/lang/Boolean;");
            boxing = false;
            type = origType;
        } else if (asPrimitive) {
            OperandStack.pushPrimitiveConstant(mv, value2, type);
        } else if (value2 instanceof BigDecimal) {
            OperandStack.newInstance(mv, value2);
        } else if (value2 instanceof BigInteger) {
            OperandStack.newInstance(mv, value2);
        } else if (value2 instanceof String) {
            mv.visitLdcInsn(value2);
        } else {
            throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value2 + " of type: " + type.getName());
        }
        this.push(type);
        if (boxing) {
            this.box();
        }
    }

    private static void newInstance(MethodVisitor mv, Object value2) {
        String className2 = BytecodeHelper.getClassInternalName(value2.getClass().getName());
        mv.visitTypeInsn(187, className2);
        mv.visitInsn(89);
        mv.visitLdcInsn(value2.toString());
        mv.visitMethodInsn(183, className2, "<init>", "(Ljava/lang/String;)V", false);
    }

    private static void pushPrimitiveConstant(MethodVisitor mv, Object value2, ClassNode type) {
        boolean isInt2 = ClassHelper.int_TYPE.equals(type);
        boolean isShort = ClassHelper.short_TYPE.equals(type);
        boolean isByte = ClassHelper.byte_TYPE.equals(type);
        boolean isChar = ClassHelper.char_TYPE.equals(type);
        if (isInt2 || isShort || isByte || isChar) {
            int val = isInt2 ? (Integer)value2 : (isShort ? (int)((Short)value2).shortValue() : (isChar ? (int)((Character)value2).charValue() : (int)((Byte)value2).byteValue()));
            BytecodeHelper.pushConstant(mv, val);
        } else if (ClassHelper.long_TYPE.equals(type)) {
            if ((Long)value2 == 0L) {
                mv.visitInsn(9);
            } else if ((Long)value2 == 1L) {
                mv.visitInsn(10);
            } else {
                mv.visitLdcInsn(value2);
            }
        } else if (ClassHelper.float_TYPE.equals(type)) {
            if (((Float)value2).floatValue() == 0.0f) {
                mv.visitInsn(11);
            } else if (((Float)value2).floatValue() == 1.0f) {
                mv.visitInsn(12);
            } else if (((Float)value2).floatValue() == 2.0f) {
                mv.visitInsn(13);
            } else {
                mv.visitLdcInsn(value2);
            }
        } else if (ClassHelper.double_TYPE.equals(type)) {
            if ((Double)value2 == 0.0) {
                mv.visitInsn(14);
            } else if ((Double)value2 == 1.0) {
                mv.visitInsn(15);
            } else {
                mv.visitLdcInsn(value2);
            }
        } else if (ClassHelper.boolean_TYPE.equals(type)) {
            boolean b = (Boolean)value2;
            if (b) {
                mv.visitInsn(4);
            } else {
                mv.visitInsn(3);
            }
        } else {
            mv.visitLdcInsn(value2);
        }
    }

    public void pushDynamicName(Expression name2) {
        ConstantExpression ce;
        Object value2;
        if (name2 instanceof ConstantExpression && (value2 = (ce = (ConstantExpression)name2).getValue()) instanceof String) {
            this.pushConstant(ce);
            return;
        }
        new CastExpression(ClassHelper.STRING_TYPE, name2).visit(this.controller.getAcg());
    }

    public void loadOrStoreVariable(BytecodeVariable variable2, boolean useReferenceDirectly) {
        CompileStack compileStack = this.controller.getCompileStack();
        if (compileStack.isLHS()) {
            this.storeVar(variable2);
        } else {
            MethodVisitor mv = this.controller.getMethodVisitor();
            int idx = variable2.getIndex();
            ClassNode type = variable2.getType();
            if (variable2.isHolder()) {
                mv.visitVarInsn(25, idx);
                if (!useReferenceDirectly) {
                    mv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;", false);
                    BytecodeHelper.doCast(mv, type);
                    this.push(type);
                } else {
                    this.push(ClassHelper.REFERENCE_TYPE);
                }
            } else {
                this.load(type, idx);
            }
        }
    }

    public void storeVar(BytecodeVariable variable2) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        int idx = variable2.getIndex();
        ClassNode type = variable2.getType();
        if (variable2.isHolder()) {
            this.doGroovyCast(type);
            this.box();
            mv.visitVarInsn(25, idx);
            mv.visitTypeInsn(192, "groovy/lang/Reference");
            mv.visitInsn(95);
            mv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V", false);
        } else {
            this.doGroovyCast(type);
            BytecodeHelper.store(mv, type, idx);
        }
        this.remove(1);
    }

    public void load(ClassNode type, int idx) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        BytecodeHelper.load(mv, type, idx);
        this.push(type);
    }

    public void pushBool(boolean inclusive2) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitLdcInsn(inclusive2);
        this.push(ClassHelper.boolean_TYPE);
    }

    public String toString() {
        return "OperandStack(size=" + this.stack.size() + ":" + this.stack.toString() + ")";
    }

    public ClassNode getTopOperand() {
        int size2 = this.ensureStackNotEmpty(this.stack);
        return this.stack.get(size2 - 1);
    }
}

