/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import groovyjarjarasm.asm.Type;
import java.lang.reflect.Method;
import org.codehaus.groovy.classgen.ClassGeneratorException;

public class MethodCaller
implements Opcodes {
    private int opcode;
    private String internalName;
    private String name;
    private Class theClass;
    private String methodDescriptor;

    public static MethodCaller newStatic(Class theClass, String name2) {
        return new MethodCaller(184, theClass, name2);
    }

    public static MethodCaller newInterface(Class theClass, String name2) {
        return new MethodCaller(185, theClass, name2);
    }

    public static MethodCaller newVirtual(Class theClass, String name2) {
        return new MethodCaller(182, theClass, name2);
    }

    protected MethodCaller() {
    }

    public MethodCaller(int opcode, Class theClass, String name2) {
        this.opcode = opcode;
        this.internalName = Type.getInternalName(theClass);
        this.theClass = theClass;
        this.name = name2;
    }

    public void call(MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(this.opcode, this.internalName, this.name, this.getMethodDescriptor(), this.opcode == 185);
    }

    public String getMethodDescriptor() {
        if (this.methodDescriptor == null) {
            Method method = this.getMethod();
            this.methodDescriptor = Type.getMethodDescriptor(method);
        }
        return this.methodDescriptor;
    }

    protected Method getMethod() {
        Method[] methods2 = this.theClass.getMethods();
        for (int i = 0; i < methods2.length; ++i) {
            Method method = methods2[i];
            if (!method.getName().equals(this.name)) continue;
            return method;
        }
        throw new ClassGeneratorException("Could not find method: " + this.name + " on class: " + this.theClass);
    }
}

