/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import groovyjarjarasm.asm.MethodVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.classgen.AsmClassGenerator;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.BytecodeVariable;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.OperandStack;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.classgen.asm.WriterControllerFactory;

public class ClosureWriter {
    private final Map<Expression, ClassNode> closureClassMap;
    private final WriterController controller;
    private final WriterControllerFactory factory;

    public ClosureWriter(WriterController wc) {
        this.controller = wc;
        this.closureClassMap = new HashMap<Expression, ClassNode>();
        this.factory = new WriterControllerFactory(){

            @Override
            public WriterController makeController(WriterController normalController) {
                return ClosureWriter.this.controller;
            }
        };
    }

    public void writeClosure(ClosureExpression expression2) {
        CompileStack compileStack = this.controller.getCompileStack();
        MethodVisitor mv = this.controller.getMethodVisitor();
        ClassNode classNode = this.controller.getClassNode();
        AsmClassGenerator acg = this.controller.getAcg();
        int mods = 17;
        if (classNode.isInterface()) {
            mods |= 8;
        }
        ClassNode closureClass = this.getOrAddClosureClass(expression2, mods);
        String closureClassinternalName = BytecodeHelper.getClassInternalName(closureClass);
        List<ConstructorNode> constructors2 = closureClass.getDeclaredConstructors();
        ConstructorNode node = constructors2.get(0);
        Parameter[] localVariableParams = node.getParameters();
        mv.visitTypeInsn(187, closureClassinternalName);
        mv.visitInsn(89);
        if (this.controller.isStaticMethod() || compileStack.isInSpecialConstructorCall()) {
            new ClassExpression(classNode).visit(acg);
            new ClassExpression(this.controller.getOutermostClass()).visit(acg);
        } else {
            mv.visitVarInsn(25, 0);
            this.controller.getOperandStack().push(ClassHelper.OBJECT_TYPE);
            this.loadThis();
        }
        for (int i = 2; i < localVariableParams.length; ++i) {
            Parameter param2 = localVariableParams[i];
            String name2 = param2.getName();
            ClosureWriter.loadReference(name2, this.controller);
            if (param2.getNodeMetaData(UseExistingReference.class) != null) continue;
            param2.setNodeMetaData(UseExistingReference.class, Boolean.TRUE);
        }
        mv.visitMethodInsn(183, closureClassinternalName, "<init>", BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, localVariableParams), false);
        this.controller.getOperandStack().replace(ClassHelper.CLOSURE_TYPE, localVariableParams.length);
    }

    public static void loadReference(String name2, WriterController controller) {
        CompileStack compileStack = controller.getCompileStack();
        MethodVisitor mv = controller.getMethodVisitor();
        ClassNode classNode = controller.getClassNode();
        AsmClassGenerator acg = controller.getAcg();
        if (!compileStack.containsVariable(name2) && compileStack.getScope().isReferencedClassVariable(name2)) {
            acg.visitFieldExpression(new FieldExpression(classNode.getDeclaredField(name2)));
        } else {
            BytecodeVariable v = compileStack.getVariable(name2, !ClosureWriter.classNodeUsesReferences(controller.getClassNode()));
            if (v == null) {
                FieldNode field2 = classNode.getDeclaredField(name2);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, controller.getInternalClassName(), name2, BytecodeHelper.getTypeDescription(field2.getType()));
            } else {
                mv.visitVarInsn(25, v.getIndex());
            }
            controller.getOperandStack().push(ClassHelper.REFERENCE_TYPE);
        }
    }

    public ClassNode getOrAddClosureClass(ClosureExpression expression2, int mods) {
        ClassNode closureClass = this.closureClassMap.get(expression2);
        if (closureClass == null) {
            closureClass = this.createClosureClass(expression2, mods);
            this.closureClassMap.put(expression2, closureClass);
            this.controller.getAcg().addInnerClass(closureClass);
            closureClass.addInterface(ClassHelper.GENERATED_CLOSURE_Type);
            closureClass.putNodeMetaData(WriterControllerFactory.class, this.factory);
        }
        return closureClass;
    }

    private static boolean classNodeUsesReferences(ClassNode classNode) {
        boolean ret;
        boolean bl = ret = classNode.getSuperClass() == ClassHelper.CLOSURE_TYPE;
        if (ret) {
            return ret;
        }
        if (classNode instanceof InnerClassNode) {
            InnerClassNode inner2 = (InnerClassNode)classNode;
            return inner2.isAnonymous();
        }
        return false;
    }

    protected ClassNode createClosureClass(ClosureExpression expression2, int mods) {
        ClassNode classNode = this.controller.getClassNode();
        ClassNode outerClass = this.controller.getOutermostClass();
        MethodNode methodNode = this.controller.getMethodNode();
        String name2 = classNode.getName() + "$" + this.controller.getContext().getNextClosureInnerName(outerClass, classNode, methodNode);
        boolean staticMethodOrInStaticClass = this.controller.isStaticMethod() || classNode.isStaticClass();
        Parameter[] parameters = expression2.getParameters();
        if (parameters == null) {
            parameters = Parameter.EMPTY_ARRAY;
        } else if (parameters.length == 0) {
            Parameter it = new Parameter(ClassHelper.OBJECT_TYPE, "it", ConstantExpression.NULL);
            parameters = new Parameter[]{it};
            Variable ref = expression2.getVariableScope().getDeclaredVariable("it");
            if (ref != null) {
                it.setClosureSharedVariable(ref.isClosureSharedVariable());
            }
        }
        Parameter[] localVariableParams = this.getClosureSharedVariables(expression2);
        ClosureWriter.removeInitialValues(localVariableParams);
        InnerClassNode answer = new InnerClassNode(classNode, name2, mods, ClassHelper.CLOSURE_TYPE.getPlainNodeReference());
        answer.setEnclosingMethod(this.controller.getMethodNode());
        answer.setSynthetic(true);
        answer.setUsingGenerics(outerClass.isUsingGenerics());
        answer.setSourcePosition(expression2);
        if (staticMethodOrInStaticClass) {
            answer.setStaticClass(true);
        }
        if (this.controller.isInScriptBody()) {
            answer.setScriptBody(true);
        }
        MethodNode method = answer.addMethod("doCall", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, expression2.getCode());
        method.setSourcePosition(expression2);
        VariableScope varScope = expression2.getVariableScope();
        if (varScope == null) {
            throw new RuntimeException("Must have a VariableScope by now! for expression: " + expression2 + " class: " + name2);
        }
        method.setVariableScope(varScope.copy());
        if (parameters.length > 1 || parameters.length == 1 && parameters[0].getType() != null && parameters[0].getType() != ClassHelper.OBJECT_TYPE && !ClassHelper.OBJECT_TYPE.equals(parameters[0].getType().getComponentType())) {
            MethodNode call2 = answer.addMethod("call", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, new ReturnStatement(new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "doCall", (Expression)new ArgumentListExpression(parameters))));
            call2.setSourcePosition(expression2);
        }
        BlockStatement block = new BlockStatement();
        VariableExpression outer = new VariableExpression("_outerInstance", outerClass);
        outer.setSourcePosition(expression2);
        block.getVariableScope().putReferencedLocalVariable(outer);
        VariableExpression thisObject = new VariableExpression("_thisObject", classNode);
        thisObject.setSourcePosition(expression2);
        block.getVariableScope().putReferencedLocalVariable(thisObject);
        TupleExpression conArgs = new TupleExpression(outer, thisObject);
        block.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.SUPER, conArgs)));
        for (Parameter param2 : localVariableParams) {
            String paramName = param2.getName();
            ClassNode type = param2.getType();
            VariableExpression initialValue = new VariableExpression(paramName);
            initialValue.setAccessedVariable(param2);
            initialValue.setUseReferenceDirectly(true);
            ClassNode realType = type;
            type = ClassHelper.makeReference();
            param2.setType(ClassHelper.makeReference());
            FieldNode paramField = answer.addField(paramName, 4098, type, initialValue);
            paramField.setOriginType(ClassHelper.getWrapper(param2.getOriginType()));
            paramField.setHolder(true);
            String methodName = Verifier.capitalize(paramName);
            FieldExpression fieldExp = new FieldExpression(paramField);
            answer.addMethod("get" + methodName, 1, realType.getPlainNodeReference(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, new ReturnStatement(fieldExp));
        }
        Parameter[] params2 = new Parameter[2 + localVariableParams.length];
        params2[0] = new Parameter(ClassHelper.OBJECT_TYPE, "_outerInstance");
        params2[1] = new Parameter(ClassHelper.OBJECT_TYPE, "_thisObject");
        System.arraycopy(localVariableParams, 0, params2, 2, localVariableParams.length);
        ConstructorNode sn = answer.addConstructor(1, params2, ClassNode.EMPTY_ARRAY, block);
        sn.setSourcePosition(expression2);
        ClosureWriter.correctAccessedVariable(answer, expression2);
        return answer;
    }

    private static void correctAccessedVariable(final InnerClassNode closureClass, ClosureExpression ce) {
        CodeVisitorSupport visitor = new CodeVisitorSupport(){

            @Override
            public void visitVariableExpression(VariableExpression expression2) {
                Variable v = expression2.getAccessedVariable();
                if (v == null) {
                    return;
                }
                if (!(v instanceof FieldNode)) {
                    return;
                }
                String name2 = expression2.getName();
                FieldNode fn2 = closureClass.getDeclaredField(name2);
                if (fn2 != null) {
                    expression2.setAccessedVariable(fn2);
                }
            }
        };
        visitor.visitClosureExpression(ce);
    }

    private static void removeInitialValues(Parameter[] params2) {
        for (int i = 0; i < params2.length; ++i) {
            if (!params2[i].hasInitialExpression()) continue;
            Parameter p = new Parameter(params2[i].getType(), params2[i].getName());
            p.setOriginType(p.getOriginType());
            params2[i] = p;
        }
    }

    public boolean addGeneratedClosureConstructorCall(ConstructorCallExpression call2) {
        ClassNode classNode = this.controller.getClassNode();
        if (!classNode.declaresInterface(ClassHelper.GENERATED_CLOSURE_Type)) {
            return false;
        }
        AsmClassGenerator acg = this.controller.getAcg();
        OperandStack operandStack = this.controller.getOperandStack();
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitVarInsn(25, 0);
        ClassNode callNode = classNode.getSuperClass();
        TupleExpression arguments = (TupleExpression)call2.getArguments();
        if (arguments.getExpressions().size() != 2) {
            throw new GroovyBugError("expected 2 arguments for closure constructor super call, but got" + arguments.getExpressions().size());
        }
        arguments.getExpression(0).visit(acg);
        operandStack.box();
        arguments.getExpression(1).visit(acg);
        operandStack.box();
        Parameter p = new Parameter(ClassHelper.OBJECT_TYPE, "_p");
        String descriptor = BytecodeHelper.getMethodDescriptor(ClassHelper.VOID_TYPE, new Parameter[]{p, p});
        mv.visitMethodInsn(183, BytecodeHelper.getClassInternalName(callNode), "<init>", descriptor, false);
        operandStack.remove(2);
        return true;
    }

    protected Parameter[] getClosureSharedVariables(ClosureExpression ce) {
        VariableScope scope = ce.getVariableScope();
        Parameter[] ret = new Parameter[scope.getReferencedLocalVariablesCount()];
        int index2 = 0;
        Iterator<Variable> iter2 = scope.getReferencedLocalVariablesIterator();
        while (iter2.hasNext()) {
            Variable element = iter2.next();
            Parameter p = new Parameter(element.getType(), element.getName());
            p.setOriginType(element.getOriginType());
            p.setClosureSharedVariable(element.isClosureSharedVariable());
            ret[index2] = p;
            ++index2;
        }
        return ret;
    }

    private void loadThis() {
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitVarInsn(25, 0);
        if (this.controller.isInClosure()) {
            mv.visitMethodInsn(182, "groovy/lang/Closure", "getThisObject", "()Ljava/lang/Object;", false);
            this.controller.getOperandStack().push(ClassHelper.OBJECT_TYPE);
        } else {
            this.controller.getOperandStack().push(this.controller.getClassNode());
        }
    }

    protected static interface UseExistingReference {
    }
}

