/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.Opcodes;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.syntax.RuntimeParserException;

public class VerifierCodeVisitor
extends CodeVisitorSupport
implements Opcodes {
    private final Verifier verifier;

    VerifierCodeVisitor(Verifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public void visitForLoop(ForStatement expression2) {
        VerifierCodeVisitor.assertValidIdentifier(expression2.getVariable().getName(), "for loop variable name", expression2);
        super.visitForLoop(expression2);
    }

    @Override
    public void visitFieldExpression(FieldExpression expression2) {
        if (!expression2.getField().isSynthetic()) {
            VerifierCodeVisitor.assertValidIdentifier(expression2.getFieldName(), "field name", expression2);
        }
        super.visitFieldExpression(expression2);
    }

    @Override
    public void visitVariableExpression(VariableExpression expression2) {
        VerifierCodeVisitor.assertValidIdentifier(expression2.getName(), "variable name", expression2);
        super.visitVariableExpression(expression2);
    }

    @Override
    public void visitListExpression(ListExpression expression2) {
        for (Expression element : expression2.getExpressions()) {
            if (!(element instanceof MapEntryExpression)) continue;
            throw new RuntimeParserException("No map entry allowed at this place", element);
        }
        super.visitListExpression(expression2);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call2) {
        ClassNode callType = call2.getType();
        if (callType.isEnum() && !callType.equals(this.verifier.getClassNode())) {
            throw new RuntimeParserException("Enum constructor calls are only allowed inside the enum class", call2);
        }
    }

    public static void assertValidIdentifier(String name2, String message, ASTNode node) {
        int size2 = name2.length();
        if (size2 <= 0) {
            throw new RuntimeParserException("Invalid " + message + ". Identifier must not be empty", node);
        }
        char firstCh = name2.charAt(0);
        if (size2 == 1 && firstCh == '$') {
            throw new RuntimeParserException("Invalid " + message + ". Must include a letter but only found: " + name2, node);
        }
        if (!Character.isJavaIdentifierStart(firstCh)) {
            throw new RuntimeParserException("Invalid " + message + ". Must start with a letter but was: " + name2, node);
        }
        for (int i = 1; i < size2; ++i) {
            char ch = name2.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            throw new RuntimeParserException("Invalid " + message + ". Invalid character at position: " + (i + 1) + " of value:  " + ch + " in name: " + name2, node);
        }
    }
}

