/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.groovy.ast.tools.MethodNodeUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;

public class VariableScopeVisitor
extends ClassCodeVisitorSupport {
    private VariableScope currentScope = null;
    private final VariableScope headScope = new VariableScope();
    private ClassNode currentClass = null;
    private final SourceUnit source;
    private boolean isSpecialConstructorCall = false;
    private boolean inConstructor = false;
    private final boolean recurseInnerClasses;
    private final LinkedList stateStack = new LinkedList();

    public VariableScopeVisitor(SourceUnit source, boolean recurseInnerClasses) {
        this.source = source;
        this.currentScope = this.headScope;
        this.recurseInnerClasses = recurseInnerClasses;
    }

    public VariableScopeVisitor(SourceUnit source) {
        this(source, false);
    }

    private void pushState(boolean isStatic) {
        this.stateStack.add(new StateStackElement());
        this.currentScope = new VariableScope(this.currentScope);
        this.currentScope.setInStaticContext(isStatic);
    }

    private void pushState() {
        this.pushState(this.currentScope.isInStaticContext());
    }

    private void popState() {
        StateStackElement element = (StateStackElement)this.stateStack.removeLast();
        this.currentScope = element.scope;
        this.currentClass = element.clazz;
        this.inConstructor = element.inConstructor;
    }

    private void declare(Parameter[] parameters, ASTNode node) {
        for (Parameter parameter : parameters) {
            if (parameter.hasInitialExpression()) {
                parameter.getInitialExpression().visit(this);
            }
            this.declare(parameter, node);
        }
    }

    private void declare(VariableExpression vex) {
        vex.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(vex, (ASTNode)vex);
        vex.setAccessedVariable(vex);
    }

    private void declare(Variable var, ASTNode expr2) {
        String scopeType = "scope";
        String variableType = "variable";
        if (expr2.getClass() == FieldNode.class) {
            scopeType = "class";
            variableType = "field";
        } else if (expr2.getClass() == PropertyNode.class) {
            scopeType = "class";
            variableType = "property";
        }
        StringBuilder msg = new StringBuilder();
        msg.append("The current ").append(scopeType);
        msg.append(" already contains a ").append(variableType);
        msg.append(" of the name ").append(var.getName());
        if (this.currentScope.getDeclaredVariable(var.getName()) != null) {
            this.addError(msg.toString(), expr2);
            return;
        }
        for (VariableScope scope = this.currentScope.getParent(); scope != null && (scope.getClassScope() == null || VariableScopeVisitor.isAnonymous(scope.getClassScope())); scope = scope.getParent()) {
            if (scope.getDeclaredVariable(var.getName()) == null) continue;
            this.addError(msg.toString(), expr2);
            break;
        }
        this.currentScope.putDeclaredVariable(var);
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private Variable findClassMember(ClassNode cn, String name2) {
        if (cn == null) {
            return null;
        }
        if (cn.isScript()) {
            return new DynamicVariable(name2, false);
        }
        for (FieldNode fn2 : cn.getFields()) {
            if (!fn2.getName().equals(name2)) continue;
            return fn2;
        }
        for (MethodNode mn : cn.getMethods()) {
            String pName = MethodNodeUtils.getPropertyName(mn);
            if (!name2.equals(pName)) continue;
            PropertyNode property = new PropertyNode(name2, mn.getModifiers(), ClassHelper.OBJECT_TYPE, cn, null, null, null);
            property.getField().setHasNoRealSourcePosition(true);
            property.getField().setSynthetic(true);
            property.getField().setDeclaringClass(cn);
            property.setDeclaringClass(cn);
            return property;
        }
        for (PropertyNode pn : cn.getProperties()) {
            if (!pn.getName().equals(name2)) continue;
            return pn;
        }
        Variable ret = this.findClassMember(cn.getSuperClass(), name2);
        if (ret != null) {
            return ret;
        }
        if (VariableScopeVisitor.isAnonymous(cn)) {
            return null;
        }
        return this.findClassMember(cn.getOuterClass(), name2);
    }

    private static boolean isAnonymous(ClassNode node) {
        return !node.isEnum() && node instanceof InnerClassNode && ((InnerClassNode)node).isAnonymous();
    }

    private Variable checkVariableNameForDeclaration(String name2, Expression expression2) {
        if ("super".equals(name2) || "this".equals(name2)) {
            return null;
        }
        VariableScope scope = this.currentScope;
        Variable var = new DynamicVariable(name2, this.currentScope.isInStaticContext());
        DynamicVariable orig = var;
        boolean crossingStaticContext = false;
        while (true) {
            crossingStaticContext = crossingStaticContext || scope.isInStaticContext();
            Variable var1 = scope.getDeclaredVariable(var.getName());
            if (var1 != null) {
                var = var1;
                break;
            }
            var1 = scope.getReferencedLocalVariable(var.getName());
            if (var1 != null) {
                var = var1;
                break;
            }
            var1 = scope.getReferencedClassVariable(var.getName());
            if (var1 != null) {
                var = var1;
                break;
            }
            ClassNode classScope = scope.getClassScope();
            if (classScope != null) {
                Variable member2 = this.findClassMember(classScope, var.getName());
                if (member2 != null) {
                    boolean staticScope = crossingStaticContext || this.isSpecialConstructorCall;
                    boolean staticMember = member2.isInStaticContext();
                    if (!staticScope || staticMember) {
                        var = member2;
                    }
                }
                if (!VariableScopeVisitor.isAnonymous(classScope)) break;
            }
            scope = scope.getParent();
        }
        if (var == orig && crossingStaticContext) {
            var = new DynamicVariable(var.getName(), true);
        }
        VariableScope end = scope;
        for (scope = this.currentScope; scope != end; scope = scope.getParent()) {
            if (end.isClassScope() || end.isReferencedClassVariable(name2) && end.getDeclaredVariable(name2) == null) {
                scope.putReferencedClassVariable(var);
                continue;
            }
            scope.putReferencedLocalVariable(var);
        }
        return var;
    }

    private void checkPropertyOnExplicitThis(PropertyExpression pe) {
        if (!this.currentScope.isInStaticContext()) {
            return;
        }
        Expression object = pe.getObjectExpression();
        if (!(object instanceof VariableExpression)) {
            return;
        }
        VariableExpression ve = (VariableExpression)object;
        if (!ve.getName().equals("this")) {
            return;
        }
        String name2 = pe.getPropertyAsString();
        if (name2 == null || name2.equals("class")) {
            return;
        }
        Variable member2 = this.findClassMember(this.currentClass, name2);
        if (member2 == null) {
            return;
        }
        this.checkVariableContextAccess(member2, pe);
    }

    private void checkVariableContextAccess(Variable v, Expression expr2) {
        if (v.isInStaticContext() || !this.currentScope.isInStaticContext()) {
            return;
        }
        String msg = v.getName() + " is declared in a dynamic context, but you tried to access it from a static context.";
        this.addError(msg, expr2);
        DynamicVariable v2 = new DynamicVariable(v.getName(), this.currentScope.isInStaticContext());
        this.currentScope.putDeclaredVariable(v2);
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        this.pushState();
        block.setVariableScope(this.currentScope);
        super.visitBlockStatement(block);
        this.popState();
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        this.pushState();
        forLoop.setVariableScope(this.currentScope);
        Parameter p = forLoop.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        if (p != ForStatement.FOR_LOOP_DUMMY) {
            this.declare(p, (ASTNode)forLoop);
        }
        super.visitForLoop(forLoop);
        this.popState();
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        ifElse.getBooleanExpression().visit(this);
        this.pushState();
        ifElse.getIfBlock().visit(this);
        this.popState();
        this.pushState();
        ifElse.getElseBlock().visit(this);
        this.popState();
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression2) {
        this.visitAnnotations(expression2);
        expression2.getRightExpression().visit(this);
        if (expression2.isMultipleAssignmentDeclaration()) {
            TupleExpression list2 = expression2.getTupleExpression();
            for (Expression e : list2.getExpressions()) {
                this.declare((VariableExpression)e);
            }
        } else {
            this.declare(expression2.getVariableExpression());
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression be) {
        super.visitBinaryExpression(be);
        switch (be.getOperation().getType()) {
            case 100: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 285: 
            case 286: 
            case 287: 
            case 350: 
            case 351: 
            case 352: {
                this.checkFinalFieldAccess(be.getLeftExpression());
                break;
            }
        }
    }

    private void checkFinalFieldAccess(Expression expression2) {
        if (!(expression2 instanceof VariableExpression) && !(expression2 instanceof TupleExpression)) {
            return;
        }
        if (expression2 instanceof TupleExpression) {
            TupleExpression list2 = (TupleExpression)expression2;
            for (Expression e : list2.getExpressions()) {
                this.checkForFinal(expression2, (VariableExpression)e);
            }
        } else {
            this.checkForFinal(expression2, (VariableExpression)expression2);
        }
    }

    private void checkForFinal(Expression expression2, VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v != null) {
            boolean isFinal = Modifier.isFinal(v.getModifiers());
            boolean isParameter = v instanceof Parameter;
            if (isFinal && isParameter) {
                this.addError("Cannot assign a value to final variable '" + v.getName() + "'", expression2);
            }
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression expression2) {
        String name2 = expression2.getName();
        Variable v = this.checkVariableNameForDeclaration(name2, expression2);
        if (v == null) {
            return;
        }
        expression2.setAccessedVariable(v);
        this.checkVariableContextAccess(v, expression2);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression2) {
        expression2.getObjectExpression().visit(this);
        expression2.getProperty().visit(this);
        this.checkPropertyOnExplicitThis(expression2);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression2) {
        this.pushState();
        expression2.setVariableScope(this.currentScope);
        if (expression2.isParameterSpecified()) {
            for (Parameter parameter : expression2.getParameters()) {
                parameter.setInStaticContext(this.currentScope.isInStaticContext());
                if (parameter.hasInitialExpression()) {
                    parameter.getInitialExpression().visit(this);
                }
                this.declare(parameter, (ASTNode)expression2);
            }
        } else if (expression2.getParameters() != null) {
            Parameter var = new Parameter(ClassHelper.OBJECT_TYPE, "it");
            var.setInStaticContext(this.currentScope.isInStaticContext());
            this.currentScope.putDeclaredVariable(var);
        }
        super.visitClosureExpression(expression2);
        this.markClosureSharedVariables();
        this.popState();
    }

    private void markClosureSharedVariables() {
        VariableScope scope = this.currentScope;
        Iterator<Variable> it = scope.getReferencedLocalVariablesIterator();
        while (it.hasNext()) {
            it.next().setClosureSharedVariable(true);
        }
    }

    @Override
    public void visitCatchStatement(CatchStatement statement2) {
        this.pushState();
        Parameter p = statement2.getVariable();
        p.setInStaticContext(this.currentScope.isInStaticContext());
        this.declare(p, (ASTNode)statement2);
        super.visitCatchStatement(statement2);
        this.popState();
    }

    @Override
    public void visitFieldExpression(FieldExpression expression2) {
        String name2 = expression2.getFieldName();
        Variable v = this.checkVariableNameForDeclaration(name2, expression2);
        this.checkVariableContextAccess(v, expression2);
    }

    @Override
    public void visitClass(ClassNode node) {
        if (VariableScopeVisitor.isAnonymous(node)) {
            return;
        }
        this.pushState();
        this.prepareVisit(node);
        super.visitClass(node);
        if (this.recurseInnerClasses) {
            Iterator<InnerClassNode> innerClasses = node.getInnerClasses();
            while (innerClasses.hasNext()) {
                this.visitClass(innerClasses.next());
            }
        }
        this.popState();
    }

    public void prepareVisit(ClassNode node) {
        this.currentClass = node;
        this.currentScope.setClassScope(node);
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        Parameter[] parameters;
        this.pushState(node.isStatic());
        this.inConstructor = isConstructor;
        node.setVariableScope(this.currentScope);
        this.visitAnnotations(node);
        for (Parameter parameter : parameters = node.getParameters()) {
            this.visitAnnotations(parameter);
        }
        this.declare(node.getParameters(), (ASTNode)node);
        this.visitClassCodeContainer(node.getCode());
        this.popState();
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call2) {
        if (call2.isImplicitThis() && call2.getMethod() instanceof ConstantExpression) {
            ConstantExpression methodNameConstant = (ConstantExpression)call2.getMethod();
            String value2 = methodNameConstant.getText();
            if (!(value2 instanceof String)) {
                throw new GroovyBugError("tried to make a method call with a non-String constant method name.");
            }
            String methodName = value2;
            Variable v = this.checkVariableNameForDeclaration(methodName, call2);
            if (v != null && !(v instanceof DynamicVariable)) {
                this.checkVariableContextAccess(v, call2);
            }
            if (v instanceof VariableExpression || v instanceof Parameter) {
                VariableExpression object = new VariableExpression(v);
                object.setSourcePosition(methodNameConstant);
                call2.setObjectExpression(object);
                ConstantExpression method = new ConstantExpression("call");
                method.setSourcePosition(methodNameConstant);
                call2.setImplicitThis(false);
                call2.setMethod(method);
            }
        }
        super.visitMethodCallExpression(call2);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call2) {
        this.isSpecialConstructorCall = call2.isSpecialCall();
        super.visitConstructorCallExpression(call2);
        this.isSpecialConstructorCall = false;
        if (!call2.isUsingAnonymousInnerClass()) {
            return;
        }
        this.pushState();
        InnerClassNode innerClass = (InnerClassNode)call2.getType();
        innerClass.setVariableScope(this.currentScope);
        this.currentScope.setClassScope(innerClass);
        this.currentScope.setInStaticContext(false);
        for (MethodNode method : innerClass.getMethods()) {
            Parameter[] parameters = method.getParameters();
            if (parameters.length == 0) {
                parameters = null;
            }
            ClosureExpression cl = new ClosureExpression(parameters, method.getCode());
            this.visitClosureExpression(cl);
        }
        for (FieldNode field2 : innerClass.getFields()) {
            Expression expression2 = field2.getInitialExpression();
            this.pushState(field2.isStatic());
            if (expression2 != null) {
                VariableExpression vexp;
                if (expression2 instanceof VariableExpression && (vexp = (VariableExpression)expression2).getAccessedVariable() instanceof Parameter) {
                    this.popState();
                    continue;
                }
                expression2.visit(this);
            }
            this.popState();
        }
        for (Statement statement2 : innerClass.getObjectInitializerStatements()) {
            statement2.visit(this);
        }
        this.markClosureSharedVariables();
        this.popState();
    }

    @Override
    public void visitProperty(PropertyNode node) {
        this.pushState(node.isStatic());
        super.visitProperty(node);
        this.popState();
    }

    @Override
    public void visitField(FieldNode node) {
        this.pushState(node.isStatic());
        super.visitField(node);
        this.popState();
    }

    @Override
    public void visitAnnotations(AnnotatedNode node) {
        List<AnnotationNode> annotations2 = node.getAnnotations();
        if (annotations2.isEmpty()) {
            return;
        }
        for (AnnotationNode an : annotations2) {
            if (an.isBuiltIn()) continue;
            for (Map.Entry<String, Expression> member2 : an.getMembers().entrySet()) {
                Expression annMemberValue = member2.getValue();
                annMemberValue.visit(this);
            }
        }
    }

    private class StateStackElement {
        final VariableScope scope;
        final ClassNode clazz;
        final boolean inConstructor;

        StateStackElement() {
            this.scope = VariableScopeVisitor.this.currentScope;
            this.clazz = VariableScopeVisitor.this.currentClass;
            this.inConstructor = VariableScopeVisitor.this.inConstructor;
        }
    }
}

