/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.classgen.BytecodeSequence;

public class ReturnAdder {
    private static final ReturnStatementListener DEFAULT_LISTENER = new ReturnStatementListener(){

        @Override
        public void returnStatementAdded(ReturnStatement returnStatement) {
        }
    };
    private final boolean doAdd;
    private final ReturnStatementListener listener;

    public ReturnAdder() {
        this.doAdd = true;
        this.listener = DEFAULT_LISTENER;
    }

    public ReturnAdder(ReturnStatementListener listener) {
        this.listener = listener;
        this.doAdd = false;
    }

    @Deprecated
    public static void addReturnIfNeeded(MethodNode node) {
        ReturnAdder adder = new ReturnAdder();
        adder.visitMethod(node);
    }

    public void visitMethod(MethodNode node) {
        Statement statement2 = node.getCode();
        if (!node.isVoidMethod()) {
            if (statement2 != null) {
                Statement code = this.addReturnsIfNeeded(statement2, node.getVariableScope());
                if (this.doAdd) {
                    node.setCode(code);
                }
            }
        } else if (!node.isAbstract() && node.getReturnType().redirect() != ClassHelper.VOID_TYPE && !(statement2 instanceof BytecodeSequence)) {
            BlockStatement newBlock = new BlockStatement();
            Statement code = node.getCode();
            if (code instanceof BlockStatement) {
                newBlock.setVariableScope(((BlockStatement)code).getVariableScope());
            }
            if (statement2 instanceof BlockStatement) {
                newBlock.addStatements(((BlockStatement)statement2).getStatements());
            } else {
                newBlock.addStatement(statement2);
            }
            ReturnStatement returnStatement = ReturnStatement.RETURN_NULL_OR_VOID;
            this.listener.returnStatementAdded(returnStatement);
            newBlock.addStatement(returnStatement);
            newBlock.setSourcePosition(statement2);
            if (this.doAdd) {
                node.setCode(newBlock);
            }
        }
    }

    private Statement addReturnsIfNeeded(Statement statement2, VariableScope scope) {
        if (statement2 instanceof ReturnStatement || statement2 instanceof BytecodeSequence || statement2 instanceof ThrowStatement) {
            return statement2;
        }
        if (statement2 instanceof EmptyStatement) {
            ReturnStatement returnStatement = new ReturnStatement(ConstantExpression.NULL);
            this.listener.returnStatementAdded(returnStatement);
            return returnStatement;
        }
        if (statement2 instanceof ExpressionStatement) {
            ExpressionStatement expStmt = (ExpressionStatement)statement2;
            Expression expr2 = expStmt.getExpression();
            ReturnStatement ret = new ReturnStatement(expr2);
            ret.setSourcePosition(expr2);
            ret.setStatementLabel(statement2.getStatementLabel());
            this.listener.returnStatementAdded(ret);
            return ret;
        }
        if (statement2 instanceof SynchronizedStatement) {
            SynchronizedStatement sync = (SynchronizedStatement)statement2;
            Statement code = this.addReturnsIfNeeded(sync.getCode(), scope);
            if (this.doAdd) {
                sync.setCode(code);
            }
            return sync;
        }
        if (statement2 instanceof IfStatement) {
            IfStatement ifs = (IfStatement)statement2;
            Statement ifBlock = this.addReturnsIfNeeded(ifs.getIfBlock(), scope);
            Statement elseBlock = this.addReturnsIfNeeded(ifs.getElseBlock(), scope);
            if (this.doAdd) {
                ifs.setIfBlock(ifBlock);
                ifs.setElseBlock(elseBlock);
            }
            return ifs;
        }
        if (statement2 instanceof SwitchStatement) {
            SwitchStatement swi = (SwitchStatement)statement2;
            for (CaseStatement caseStatement : swi.getCaseStatements()) {
                Statement code = this.adjustSwitchCaseCode(caseStatement.getCode(), scope, false);
                if (!this.doAdd) continue;
                caseStatement.setCode(code);
            }
            Statement defaultStatement = this.adjustSwitchCaseCode(swi.getDefaultStatement(), scope, true);
            if (this.doAdd) {
                swi.setDefaultStatement(defaultStatement);
            }
            return swi;
        }
        if (statement2 instanceof TryCatchStatement) {
            boolean hasFinally;
            TryCatchStatement trys = (TryCatchStatement)statement2;
            final boolean[] missesReturn = new boolean[1];
            new ReturnAdder(new ReturnStatementListener(){

                @Override
                public void returnStatementAdded(ReturnStatement returnStatement) {
                    missesReturn[0] = true;
                }
            }).addReturnsIfNeeded(trys.getFinallyStatement(), scope);
            boolean bl = hasFinally = !(trys.getFinallyStatement() instanceof EmptyStatement);
            if (hasFinally && !missesReturn[0]) {
                return trys;
            }
            Statement tryStatement = this.addReturnsIfNeeded(trys.getTryStatement(), scope);
            if (this.doAdd) {
                trys.setTryStatement(tryStatement);
            }
            int len = trys.getCatchStatements().size();
            for (int i = 0; i != len; ++i) {
                CatchStatement catchStatement = trys.getCatchStatement(i);
                Statement code = this.addReturnsIfNeeded(catchStatement.getCode(), scope);
                if (!this.doAdd) continue;
                catchStatement.setCode(code);
            }
            return trys;
        }
        if (statement2 instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)statement2;
            List<Statement> list2 = block.getStatements();
            if (!list2.isEmpty()) {
                int idx = list2.size() - 1;
                Statement last2 = this.addReturnsIfNeeded(list2.get(idx), block.getVariableScope());
                if (this.doAdd) {
                    list2.set(idx, last2);
                }
                if (!ReturnAdder.statementReturns(last2)) {
                    ReturnStatement returnStatement = new ReturnStatement(ConstantExpression.NULL);
                    this.listener.returnStatementAdded(returnStatement);
                    if (this.doAdd) {
                        list2.add(returnStatement);
                    }
                }
            } else {
                ReturnStatement ret = new ReturnStatement(ConstantExpression.NULL);
                ret.setSourcePosition(block);
                this.listener.returnStatementAdded(ret);
                return ret;
            }
            BlockStatement newBlock = new BlockStatement(list2, block.getVariableScope());
            newBlock.setSourcePosition(block);
            return newBlock;
        }
        if (statement2 == null) {
            ReturnStatement returnStatement = new ReturnStatement(ConstantExpression.NULL);
            this.listener.returnStatementAdded(returnStatement);
            return returnStatement;
        }
        ArrayList<Statement> list3 = new ArrayList<Statement>();
        list3.add(statement2);
        ReturnStatement returnStatement = new ReturnStatement(ConstantExpression.NULL);
        this.listener.returnStatementAdded(returnStatement);
        list3.add(returnStatement);
        BlockStatement newBlock = new BlockStatement(list3, new VariableScope(scope));
        newBlock.setSourcePosition(statement2);
        return newBlock;
    }

    private Statement adjustSwitchCaseCode(Statement statement2, VariableScope scope, boolean defaultCase) {
        List<Statement> list2;
        if (statement2 instanceof BlockStatement && !(list2 = ((BlockStatement)statement2).getStatements()).isEmpty()) {
            int idx = list2.size() - 1;
            Statement last2 = list2.get(idx);
            if (last2 instanceof BreakStatement) {
                if (this.doAdd) {
                    list2.remove(idx);
                    return this.addReturnsIfNeeded(statement2, scope);
                }
                BlockStatement newStmt = new BlockStatement();
                for (int i = 0; i < idx; ++i) {
                    newStmt.addStatement(list2.get(i));
                }
                return this.addReturnsIfNeeded(newStmt, scope);
            }
            if (defaultCase) {
                return this.addReturnsIfNeeded(statement2, scope);
            }
        }
        return statement2;
    }

    private static boolean statementReturns(Statement last2) {
        return last2 instanceof ReturnStatement || last2 instanceof BlockStatement || last2 instanceof IfStatement || last2 instanceof ExpressionStatement || last2 instanceof EmptyStatement || last2 instanceof TryCatchStatement || last2 instanceof BytecodeSequence || last2 instanceof ThrowStatement || last2 instanceof SynchronizedStatement;
    }

    public static interface ReturnStatementListener {
        public void returnStatementAdded(ReturnStatement var1);
    }
}

