/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.tools.BeanUtils;
import org.codehaus.groovy.classgen.Verifier;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.AbstractASTTransformation;

public class GeneralUtils {
    public static final Token ASSIGN = Token.newSymbol(100, -1, -1);
    public static final Token EQ = Token.newSymbol(123, -1, -1);
    public static final Token NE = Token.newSymbol(120, -1, -1);
    public static final Token LT = Token.newSymbol(124, -1, -1);
    public static final Token AND = Token.newSymbol(164, -1, -1);
    public static final Token OR = Token.newSymbol(162, -1, -1);
    public static final Token CMP = Token.newSymbol(128, -1, -1);
    private static final Token INSTANCEOF = Token.newSymbol(544, -1, -1);
    private static final Token PLUS = Token.newSymbol(200, -1, -1);
    private static final Token INDEX = Token.newSymbol("[", -1, -1);

    public static BinaryExpression andX(Expression lhv, Expression rhv) {
        return new BinaryExpression(lhv, AND, rhv);
    }

    public static ArgumentListExpression args(Expression ... expressions) {
        ArrayList<Expression> args2 = new ArrayList<Expression>();
        Collections.addAll(args2, expressions);
        return new ArgumentListExpression(args2);
    }

    public static ArgumentListExpression args(List<Expression> expressions) {
        return new ArgumentListExpression(expressions);
    }

    public static ArgumentListExpression args(Parameter[] parameters) {
        return new ArgumentListExpression(parameters);
    }

    public static ArgumentListExpression args(String ... names) {
        ArrayList<Expression> vars = new ArrayList<Expression>();
        for (String name2 : names) {
            vars.add(GeneralUtils.varX(name2));
        }
        return new ArgumentListExpression(vars);
    }

    public static Statement assignS(Expression target, Expression value2) {
        return new ExpressionStatement(GeneralUtils.assignX(target, value2));
    }

    public static Expression assignX(Expression target, Expression value2) {
        return new BinaryExpression(target, ASSIGN, value2);
    }

    public static Expression attrX(Expression oe, Expression prop) {
        return new AttributeExpression(oe, prop);
    }

    public static BinaryExpression binX(Expression left, Token token2, Expression right) {
        return new BinaryExpression(left, token2, right);
    }

    public static BlockStatement block(VariableScope varScope, Statement ... stmts2) {
        BlockStatement block = new BlockStatement();
        block.setVariableScope(varScope);
        for (Statement stmt : stmts2) {
            block.addStatement(stmt);
        }
        return block;
    }

    public static BlockStatement block(VariableScope varScope, List<Statement> stmts2) {
        BlockStatement block = new BlockStatement();
        block.setVariableScope(varScope);
        for (Statement stmt : stmts2) {
            block.addStatement(stmt);
        }
        return block;
    }

    public static BlockStatement block(Statement ... stmts2) {
        BlockStatement block = new BlockStatement();
        for (Statement stmt : stmts2) {
            block.addStatement(stmt);
        }
        return block;
    }

    public static MethodCallExpression callSuperX(String methodName, Expression args2) {
        return GeneralUtils.callX((Expression)GeneralUtils.varX("super"), methodName, args2);
    }

    public static MethodCallExpression callSuperX(String methodName) {
        return GeneralUtils.callSuperX(methodName, MethodCallExpression.NO_ARGUMENTS);
    }

    public static MethodCallExpression callThisX(String methodName, Expression args2) {
        return GeneralUtils.callX((Expression)GeneralUtils.varX("this"), methodName, args2);
    }

    public static MethodCallExpression callThisX(String methodName) {
        return GeneralUtils.callThisX(methodName, MethodCallExpression.NO_ARGUMENTS);
    }

    public static MethodCallExpression callX(Expression receiver, String methodName, Expression args2) {
        return new MethodCallExpression(receiver, methodName, args2);
    }

    public static MethodCallExpression callX(Expression receiver, Expression method, Expression args2) {
        return new MethodCallExpression(receiver, method, args2);
    }

    public static MethodCallExpression callX(Expression receiver, String methodName) {
        return GeneralUtils.callX(receiver, methodName, MethodCallExpression.NO_ARGUMENTS);
    }

    public static StaticMethodCallExpression callX(ClassNode receiver, String methodName, Expression args2) {
        return new StaticMethodCallExpression(receiver, methodName, args2);
    }

    public static StaticMethodCallExpression callX(ClassNode receiver, String methodName) {
        return GeneralUtils.callX(receiver, methodName, MethodCallExpression.NO_ARGUMENTS);
    }

    public static CastExpression castX(ClassNode type, Expression expression2) {
        return new CastExpression(type, expression2);
    }

    public static BooleanExpression boolX(Expression boolExpr) {
        return new BooleanExpression(boolExpr);
    }

    public static CastExpression castX(ClassNode type, Expression expression2, boolean ignoreAutoboxing) {
        return new CastExpression(type, expression2, ignoreAutoboxing);
    }

    public static ClassExpression classX(ClassNode clazz2) {
        return new ClassExpression(clazz2);
    }

    public static ClassExpression classX(Class clazz2) {
        return GeneralUtils.classX(ClassHelper.make(clazz2).getPlainNodeReference());
    }

    public static ClosureExpression closureX(Parameter[] params2, Statement code) {
        return new ClosureExpression(params2, code);
    }

    public static ClosureExpression closureX(Statement code) {
        return GeneralUtils.closureX(Parameter.EMPTY_ARRAY, code);
    }

    public static Parameter[] cloneParams(Parameter[] source) {
        Parameter[] result2 = new Parameter[source.length];
        for (int i = 0; i < source.length; ++i) {
            Parameter dstParam;
            Parameter srcParam = source[i];
            result2[i] = dstParam = new Parameter(srcParam.getOriginType(), srcParam.getName());
        }
        return result2;
    }

    public static BinaryExpression cmpX(Expression lhv, Expression rhv) {
        return new BinaryExpression(lhv, CMP, rhv);
    }

    public static ConstantExpression constX(Object val) {
        return new ConstantExpression(val);
    }

    public static ConstantExpression constX(Object val, boolean keepPrimitive) {
        return new ConstantExpression(val, keepPrimitive);
    }

    public static void copyAnnotatedNodeAnnotations(AnnotatedNode annotatedNode, List<AnnotationNode> copied, List<AnnotationNode> notCopied) {
        List<AnnotationNode> annotationList2 = annotatedNode.getAnnotations();
        for (AnnotationNode annotation : annotationList2) {
            PropertyExpression propertyExpression;
            boolean processAnnotation;
            List<AnnotationNode> annotations2 = annotation.getClassNode().getAnnotations(AbstractASTTransformation.RETENTION_CLASSNODE);
            if (annotations2.isEmpty()) continue;
            if (GeneralUtils.hasClosureMember(annotation)) {
                notCopied.add(annotation);
                continue;
            }
            AnnotationNode retentionPolicyAnnotation = annotations2.get(0);
            Expression valueExpression = retentionPolicyAnnotation.getMember("value");
            if (!(valueExpression instanceof PropertyExpression) || !(processAnnotation = (propertyExpression = (PropertyExpression)valueExpression).getProperty() instanceof ConstantExpression && ("RUNTIME".equals(((ConstantExpression)propertyExpression.getProperty()).getValue()) || "CLASS".equals(((ConstantExpression)propertyExpression.getProperty()).getValue())))) continue;
            AnnotationNode newAnnotation = new AnnotationNode(annotation.getClassNode());
            for (Map.Entry<String, Expression> member2 : annotation.getMembers().entrySet()) {
                newAnnotation.addMember(member2.getKey(), member2.getValue());
            }
            newAnnotation.setSourcePosition(annotatedNode);
            copied.add(newAnnotation);
        }
    }

    public static Statement createConstructorStatementDefault(FieldNode fNode) {
        String name2 = fNode.getName();
        ClassNode fType = fNode.getType();
        Expression fieldExpr = GeneralUtils.propX((Expression)GeneralUtils.varX("this"), name2);
        Expression initExpr = fNode.getInitialValueExpression();
        Statement assignInit = initExpr == null || initExpr instanceof ConstantExpression && ((ConstantExpression)initExpr).isNullExpression() ? (ClassHelper.isPrimitiveType(fType) ? EmptyStatement.INSTANCE : GeneralUtils.assignS(fieldExpr, ConstantExpression.EMPTY_EXPRESSION)) : GeneralUtils.assignS(fieldExpr, initExpr);
        fNode.setInitialValueExpression(null);
        Expression value2 = GeneralUtils.findArg(name2);
        return GeneralUtils.ifElseS(GeneralUtils.equalsNullX(value2), assignInit, GeneralUtils.assignS(fieldExpr, GeneralUtils.castX(fType, value2)));
    }

    public static ConstructorCallExpression ctorX(ClassNode type, Expression args2) {
        return new ConstructorCallExpression(type, args2);
    }

    public static ConstructorCallExpression ctorX(ClassNode type) {
        return new ConstructorCallExpression(type, ArgumentListExpression.EMPTY_ARGUMENTS);
    }

    public static Statement ctorSuperS(Expression args2) {
        return GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.SUPER, args2));
    }

    public static Statement ctorThisS(Expression args2) {
        return GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.THIS, args2));
    }

    public static Statement ctorSuperS() {
        return GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.SUPER));
    }

    public static Statement ctorThisS() {
        return GeneralUtils.stmt(GeneralUtils.ctorX(ClassNode.THIS));
    }

    public static Statement declS(Expression target, Expression init2) {
        return new ExpressionStatement(new DeclarationExpression(target, ASSIGN, init2));
    }

    public static BinaryExpression eqX(Expression lhv, Expression rhv) {
        return new BinaryExpression(lhv, EQ, rhv);
    }

    public static BooleanExpression equalsNullX(Expression argExpr) {
        return new BooleanExpression(GeneralUtils.eqX(argExpr, new ConstantExpression(null)));
    }

    public static FieldExpression fieldX(FieldNode fieldNode) {
        return new FieldExpression(fieldNode);
    }

    public static FieldExpression fieldX(ClassNode owner, String fieldName) {
        return new FieldExpression(owner.getField(fieldName));
    }

    public static Expression findArg(String argName) {
        return new PropertyExpression((Expression)new VariableExpression("args"), argName);
    }

    public static List<MethodNode> getAllMethods(ClassNode type) {
        ArrayList<MethodNode> result2 = new ArrayList<MethodNode>();
        for (ClassNode node = type; node != null; node = node.getSuperClass()) {
            result2.addAll(node.getMethods());
        }
        return result2;
    }

    public static List<PropertyNode> getAllProperties(ClassNode type) {
        ArrayList<PropertyNode> result2 = new ArrayList<PropertyNode>();
        for (ClassNode node = type; node != null; node = node.getSuperClass()) {
            result2.addAll(node.getProperties());
        }
        return result2;
    }

    public static String getGetterName(PropertyNode pNode) {
        return "get" + Verifier.capitalize(pNode.getName());
    }

    public static List<FieldNode> getInstanceNonPropertyFields(ClassNode cNode) {
        ArrayList<FieldNode> result2 = new ArrayList<FieldNode>();
        for (FieldNode fNode : cNode.getFields()) {
            if (fNode.isStatic() || cNode.getProperty(fNode.getName()) != null) continue;
            result2.add(fNode);
        }
        return result2;
    }

    public static List<String> getInstanceNonPropertyFieldNames(ClassNode cNode) {
        List<FieldNode> fList = GeneralUtils.getInstanceNonPropertyFields(cNode);
        ArrayList<String> result2 = new ArrayList<String>(fList.size());
        for (FieldNode fNode : fList) {
            result2.add(fNode.getName());
        }
        return result2;
    }

    public static List<PropertyNode> getInstanceProperties(ClassNode cNode) {
        ArrayList<PropertyNode> result2 = new ArrayList<PropertyNode>();
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            result2.add(pNode);
        }
        return result2;
    }

    public static List<String> getInstancePropertyNames(ClassNode cNode) {
        List<PropertyNode> pList = BeanUtils.getAllProperties(cNode, false, false, true);
        ArrayList<String> result2 = new ArrayList<String>(pList.size());
        for (PropertyNode pNode : pList) {
            result2.add(pNode.getName());
        }
        return result2;
    }

    public static List<FieldNode> getInstancePropertyFields(ClassNode cNode) {
        ArrayList<FieldNode> result2 = new ArrayList<FieldNode>();
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            result2.add(pNode.getField());
        }
        return result2;
    }

    public static Set<ClassNode> getInterfacesAndSuperInterfaces(ClassNode type) {
        LinkedHashSet<ClassNode> res = new LinkedHashSet<ClassNode>();
        if (type.isInterface()) {
            res.add(type);
            return res;
        }
        for (ClassNode next2 = type; next2 != null; next2 = next2.getSuperClass()) {
            res.addAll(next2.getAllInterfaces());
        }
        return res;
    }

    public static List<FieldNode> getSuperNonPropertyFields(ClassNode cNode) {
        List<Object> result2 = cNode == ClassHelper.OBJECT_TYPE ? new ArrayList() : GeneralUtils.getSuperNonPropertyFields(cNode.getSuperClass());
        for (FieldNode fNode : cNode.getFields()) {
            if (fNode.isStatic() || cNode.getProperty(fNode.getName()) != null) continue;
            result2.add(fNode);
        }
        return result2;
    }

    public static List<FieldNode> getSuperPropertyFields(ClassNode cNode) {
        List<Object> result2 = cNode == ClassHelper.OBJECT_TYPE ? new ArrayList() : GeneralUtils.getSuperPropertyFields(cNode.getSuperClass());
        for (PropertyNode pNode : cNode.getProperties()) {
            if (pNode.isStatic()) continue;
            result2.add(pNode.getField());
        }
        return result2;
    }

    public static List<PropertyNode> getAllProperties(Set<String> names, ClassNode cNode, boolean includeProperties, boolean includeFields, boolean includePseudoGetters, boolean includePseudoSetters, boolean traverseSuperClasses, boolean skipReadonly) {
        return GeneralUtils.getAllProperties(names, cNode, cNode, includeProperties, includeFields, includePseudoGetters, includePseudoSetters, traverseSuperClasses, skipReadonly);
    }

    public static List<PropertyNode> getAllProperties(Set<String> names, ClassNode origType, ClassNode cNode, boolean includeProperties, boolean includeFields, boolean includePseudoGetters, boolean includePseudoSetters, boolean traverseSuperClasses, boolean skipReadonly) {
        return GeneralUtils.getAllProperties(names, origType, cNode, includeProperties, includeFields, includePseudoGetters, includePseudoSetters, traverseSuperClasses, skipReadonly, false, false, false);
    }

    public static List<PropertyNode> getAllProperties(Set<String> names, ClassNode origType, ClassNode cNode, boolean includeProperties, boolean includeFields, boolean includePseudoGetters, boolean includePseudoSetters, boolean traverseSuperClasses, boolean skipReadonly, boolean reverse2, boolean allNames, boolean includeStatic) {
        ArrayList<PropertyNode> result2 = new ArrayList<PropertyNode>();
        if (cNode != ClassHelper.OBJECT_TYPE && traverseSuperClasses && !reverse2) {
            result2.addAll(GeneralUtils.getAllProperties(names, origType, cNode.getSuperClass(), includeProperties, includeFields, includePseudoGetters, includePseudoSetters, true, skipReadonly));
        }
        if (includeProperties) {
            for (PropertyNode pNode : cNode.getProperties()) {
                if (pNode.isStatic() && !includeStatic || names.contains(pNode.getName())) continue;
                result2.add(pNode);
                names.add(pNode.getName());
            }
            if (includePseudoGetters || includePseudoSetters) {
                BeanUtils.addPseudoProperties(origType, cNode, result2, names, includeStatic, includePseudoGetters, includePseudoSetters);
            }
        }
        if (includeFields) {
            for (FieldNode fNode : cNode.getFields()) {
                if (fNode.isStatic() && !includeStatic || fNode.isSynthetic() || cNode.getProperty(fNode.getName()) != null || names.contains(fNode.getName()) || fNode.getName().contains("$") && !allNames || fNode.isPrivate() && !cNode.equals(origType) || fNode.isFinal() && fNode.getInitialExpression() != null && skipReadonly) continue;
                result2.add(new PropertyNode(fNode, fNode.getModifiers(), null, null));
                names.add(fNode.getName());
            }
        }
        if (cNode != ClassHelper.OBJECT_TYPE && traverseSuperClasses && reverse2) {
            result2.addAll(GeneralUtils.getAllProperties(names, origType, cNode.getSuperClass(), includeProperties, includeFields, includePseudoGetters, includePseudoSetters, true, skipReadonly));
        }
        return result2;
    }

    public static BinaryExpression hasClassX(Expression instance, ClassNode cNode) {
        return GeneralUtils.eqX(GeneralUtils.classX(cNode), GeneralUtils.callX(instance, "getClass"));
    }

    private static boolean hasClosureMember(AnnotationNode annotation) {
        Map<String, Expression> members2 = annotation.getMembers();
        for (Map.Entry<String, Expression> member2 : members2.entrySet()) {
            ClassExpression classExpression;
            Class typeClass;
            if (member2.getValue() instanceof ClosureExpression) {
                return true;
            }
            if (!(member2.getValue() instanceof ClassExpression) || (typeClass = (classExpression = (ClassExpression)member2.getValue()).getType().isResolved() ? classExpression.getType().redirect().getTypeClass() : null) == null || !GeneratedClosure.class.isAssignableFrom(typeClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDeclaredMethod(ClassNode cNode, String name2, int argsCount) {
        List<MethodNode> ms = cNode.getDeclaredMethods(name2);
        for (MethodNode m : ms) {
            Parameter[] paras = m.getParameters();
            if (paras == null || paras.length != argsCount) continue;
            return true;
        }
        return false;
    }

    public static BinaryExpression hasEqualFieldX(FieldNode fNode, Expression other) {
        return GeneralUtils.eqX(GeneralUtils.varX(fNode), GeneralUtils.propX(other, fNode.getName()));
    }

    public static BinaryExpression hasEqualPropertyX(ClassNode annotatedNode, PropertyNode pNode, VariableExpression other) {
        return GeneralUtils.eqX(GeneralUtils.getterThisX(annotatedNode, pNode), GeneralUtils.getterX(other.getOriginType(), other, pNode));
    }

    @Deprecated
    public static BinaryExpression hasEqualPropertyX(PropertyNode pNode, Expression other) {
        String getterName = GeneralUtils.getGetterName(pNode);
        return GeneralUtils.eqX(GeneralUtils.callThisX(getterName), GeneralUtils.callX(other, getterName));
    }

    public static BooleanExpression hasSameFieldX(FieldNode fNode, Expression other) {
        return GeneralUtils.sameX(GeneralUtils.varX(fNode), GeneralUtils.propX(other, fNode.getName()));
    }

    public static BooleanExpression hasSamePropertyX(PropertyNode pNode, Expression other) {
        ClassNode cNode = pNode.getDeclaringClass();
        return GeneralUtils.sameX(GeneralUtils.getterThisX(cNode, pNode), GeneralUtils.getterX(cNode, other, pNode));
    }

    public static Statement ifElseS(Expression cond, Statement thenStmt, Statement elseStmt) {
        return new IfStatement(cond instanceof BooleanExpression ? (BooleanExpression)cond : new BooleanExpression(cond), thenStmt, elseStmt);
    }

    public static Statement ifS(Expression cond, Expression trueExpr) {
        return GeneralUtils.ifS(cond, new ExpressionStatement(trueExpr));
    }

    public static Statement ifS(Expression cond, Statement trueStmt) {
        return new IfStatement(cond instanceof BooleanExpression ? (BooleanExpression)cond : new BooleanExpression(cond), trueStmt, EmptyStatement.INSTANCE);
    }

    public static Expression indexX(Expression target, Expression value2) {
        return new BinaryExpression(target, INDEX, value2);
    }

    public static BooleanExpression isInstanceOfX(Expression objectExpression, ClassNode cNode) {
        return new BooleanExpression(new BinaryExpression(objectExpression, INSTANCEOF, GeneralUtils.classX(cNode)));
    }

    public static BooleanExpression isOneX(Expression expr2) {
        return new BooleanExpression(new BinaryExpression(expr2, EQ, new ConstantExpression(1)));
    }

    public static boolean isOrImplements(ClassNode type, ClassNode interfaceType) {
        return type.equals(interfaceType) || type.implementsInterface(interfaceType);
    }

    public static BooleanExpression isTrueX(Expression argExpr) {
        return new BooleanExpression(new BinaryExpression(argExpr, EQ, new ConstantExpression(Boolean.TRUE)));
    }

    public static BooleanExpression isZeroX(Expression expr2) {
        return new BooleanExpression(new BinaryExpression(expr2, EQ, new ConstantExpression(0)));
    }

    public static ListExpression listX(List<Expression> args2) {
        return new ListExpression(args2);
    }

    public static ListExpression list2args(List args2) {
        ListExpression result2 = new ListExpression();
        for (Object o : args2) {
            result2.addExpression(new ConstantExpression(o));
        }
        return result2;
    }

    public static ListExpression classList2args(List<String> args2) {
        ListExpression result2 = new ListExpression();
        for (String o : args2) {
            result2.addExpression(new ClassExpression(ClassHelper.make(o.toString())));
        }
        return result2;
    }

    public static VariableExpression localVarX(String name2) {
        VariableExpression result2 = new VariableExpression(name2);
        result2.setAccessedVariable(result2);
        return result2;
    }

    public static VariableExpression localVarX(String name2, ClassNode type) {
        VariableExpression result2 = new VariableExpression(name2, type);
        result2.setAccessedVariable(result2);
        return result2;
    }

    public static BinaryExpression ltX(Expression lhv, Expression rhv) {
        return new BinaryExpression(lhv, LT, rhv);
    }

    public static MapExpression mapX(List<MapEntryExpression> expressions) {
        return new MapExpression(expressions);
    }

    public static MapEntryExpression entryX(Expression key, Expression value2) {
        return new MapEntryExpression(key, value2);
    }

    @Deprecated
    public static String makeDescriptorWithoutReturnType(MethodNode mn) {
        StringBuilder sb = new StringBuilder();
        sb.append(mn.getName()).append(':');
        for (Parameter p : mn.getParameters()) {
            sb.append(p.getType()).append(',');
        }
        return sb.toString();
    }

    public static BinaryExpression neX(Expression lhv, Expression rhv) {
        return new BinaryExpression(lhv, NE, rhv);
    }

    public static BooleanExpression notNullX(Expression argExpr) {
        return new BooleanExpression(new BinaryExpression(argExpr, NE, new ConstantExpression(null)));
    }

    public static NotExpression notX(Expression expr2) {
        return new NotExpression(expr2 instanceof BooleanExpression ? expr2 : new BooleanExpression(expr2));
    }

    public static BinaryExpression orX(Expression lhv, Expression rhv) {
        return new BinaryExpression(lhv, OR, rhv);
    }

    public static Parameter param(ClassNode type, String name2) {
        return GeneralUtils.param(type, name2, null);
    }

    public static Parameter param(ClassNode type, String name2, Expression initialExpression) {
        Parameter param2 = new Parameter(type, name2);
        if (initialExpression != null) {
            param2.setInitialExpression(initialExpression);
        }
        return param2;
    }

    public static Parameter[] params(Parameter ... params2) {
        return params2 != null ? params2 : Parameter.EMPTY_ARRAY;
    }

    public static BinaryExpression plusX(Expression lhv, Expression rhv) {
        return new BinaryExpression(lhv, PLUS, rhv);
    }

    public static Expression propX(Expression owner, String property) {
        return new PropertyExpression(owner, property);
    }

    public static Expression propX(Expression owner, Expression property) {
        return new PropertyExpression(owner, property);
    }

    public static Statement returnS(Expression expr2) {
        return new ReturnStatement(new ExpressionStatement(expr2));
    }

    public static Statement safeExpression(Expression fieldExpr, Expression expression2) {
        return new IfStatement(GeneralUtils.equalsNullX(fieldExpr), new ExpressionStatement(fieldExpr), new ExpressionStatement(expression2));
    }

    public static BooleanExpression sameX(Expression self, Expression other) {
        return new BooleanExpression(GeneralUtils.callX(self, "is", (Expression)GeneralUtils.args(other)));
    }

    public static Statement stmt(Expression expr2) {
        return new ExpressionStatement(expr2);
    }

    public static TernaryExpression ternaryX(Expression cond, Expression trueExpr, Expression elseExpr) {
        return new TernaryExpression(cond instanceof BooleanExpression ? (BooleanExpression)cond : new BooleanExpression(cond), trueExpr, elseExpr);
    }

    public static VariableExpression varX(String name2) {
        return new VariableExpression(name2);
    }

    public static VariableExpression varX(Variable variable2) {
        return new VariableExpression(variable2);
    }

    public static VariableExpression varX(String name2, ClassNode type) {
        return new VariableExpression(name2, type);
    }

    public static ThrowStatement throwS(Expression expr2) {
        return new ThrowStatement(expr2);
    }

    public static CatchStatement catchS(Parameter variable2, Statement code) {
        return new CatchStatement(variable2, code);
    }

    public static Expression getterThisX(ClassNode annotatedNode, PropertyNode pNode) {
        ClassNode owner = pNode.getDeclaringClass();
        if (annotatedNode.equals(owner)) {
            return GeneralUtils.callThisX(GeneralUtils.getterName(annotatedNode, pNode));
        }
        return GeneralUtils.propX((Expression)new VariableExpression("this"), pNode.getName());
    }

    private static String getterName(ClassNode annotatedNode, PropertyNode pNode) {
        boolean existingExplicitGetter;
        String getterName = "get" + MetaClassHelper.capitalize(pNode.getName());
        boolean bl = existingExplicitGetter = annotatedNode.getMethod(getterName, Parameter.EMPTY_ARRAY) != null;
        if (ClassHelper.boolean_TYPE.equals(pNode.getOriginType()) && !existingExplicitGetter) {
            getterName = "is" + MetaClassHelper.capitalize(pNode.getName());
        }
        return getterName;
    }

    public static Expression getterX(ClassNode annotatedNode, Expression receiver, PropertyNode pNode) {
        ClassNode owner = pNode.getDeclaringClass();
        if (annotatedNode.equals(owner)) {
            return GeneralUtils.callX(receiver, GeneralUtils.getterName(annotatedNode, pNode));
        }
        return GeneralUtils.propX(receiver, pNode.getName());
    }

    public static String convertASTToSource(ReaderSource readerSource, ASTNode expression2) throws Exception {
        if (expression2 == null) {
            throw new IllegalArgumentException("Null: expression");
        }
        StringBuilder result2 = new StringBuilder();
        for (int x = expression2.getLineNumber(); x <= expression2.getLastLineNumber(); ++x) {
            String line = readerSource.getLine(x, null);
            if (line == null) {
                throw new Exception("Error calculating source code for expression. Trying to read line " + x + " from " + readerSource.getClass());
            }
            if (x == expression2.getLastLineNumber()) {
                line = line.substring(0, expression2.getLastColumnNumber() - 1);
            }
            if (x == expression2.getLineNumber()) {
                line = line.substring(expression2.getColumnNumber() - 1);
            }
            result2.append(line).append('\n');
        }
        String source = result2.toString().trim();
        return source;
    }

    public static boolean copyStatementsWithSuperAdjustment(ClosureExpression pre, BlockStatement body2) {
        Statement preCode = pre.getCode();
        boolean changed = false;
        if (preCode instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)preCode;
            List<Statement> statements = block.getStatements();
            for (int i = 0; i < statements.size(); ++i) {
                MethodCallExpression mce;
                String name2;
                ExpressionStatement es;
                Expression preExp;
                Statement statement2 = statements.get(i);
                if (i == 0 && statement2 instanceof ExpressionStatement && (preExp = (es = (ExpressionStatement)statement2).getExpression()) instanceof MethodCallExpression && "super".equals(name2 = (mce = (MethodCallExpression)preExp).getMethodAsString())) {
                    es.setExpression(new ConstructorCallExpression(ClassNode.SUPER, mce.getArguments()));
                    changed = true;
                }
                body2.addStatement(statement2);
            }
        }
        return changed;
    }

    public static String getSetterName(String name2) {
        return "set" + Verifier.capitalize(name2);
    }

    public static boolean isDefaultVisibility(int modifiers) {
        return (modifiers & 7) == 0;
    }

    public static boolean inSamePackage(ClassNode first, ClassNode second) {
        PackageNode firstPackage = first.getPackage();
        PackageNode secondPackage = second.getPackage();
        return firstPackage == null && secondPackage == null || firstPackage != null && secondPackage != null && firstPackage.getName().equals(secondPackage.getName());
    }

    public static boolean inSamePackage(Class first, Class second) {
        Package firstPackage = first.getPackage();
        Package secondPackage = second.getPackage();
        return firstPackage == null && secondPackage == null || firstPackage != null && secondPackage != null && firstPackage.getName().equals(secondPackage.getName());
    }
}

