/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.decompiled;

import groovyjarjarasm.asm.Type;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationUnit;

public class AsmReferenceResolver {
    private final ClassNodeResolver resolver;
    private final CompilationUnit unit;

    public AsmReferenceResolver(ClassNodeResolver resolver, CompilationUnit unit) {
        this.resolver = resolver;
        this.unit = unit;
    }

    public ClassNode resolveClass(String className2) {
        ClassNode classNode = this.resolveClassNullable(className2);
        if (classNode == null) {
            throw new NoClassDefFoundError(className2);
        }
        return classNode;
    }

    public ClassNode resolveClassNullable(String className2) {
        ClassNode beingCompiled = this.unit.getAST().getClass(className2);
        if (beingCompiled != null) {
            return beingCompiled;
        }
        ClassNodeResolver.LookupResult lookupResult = this.resolver.resolveName(className2, this.unit);
        return lookupResult == null ? null : lookupResult.getClassNode();
    }

    public ClassNode resolveType(Type type) {
        if (type.getSort() == 9) {
            ClassNode result2 = this.resolveNonArrayType(type.getElementType());
            for (int i = 0; i < type.getDimensions(); ++i) {
                result2 = result2.makeArray();
            }
            return result2;
        }
        return this.resolveNonArrayType(type);
    }

    private ClassNode resolveNonArrayType(Type type) {
        String className2 = type.getClassName();
        if (type.getSort() != 10) {
            return ClassHelper.make(className2);
        }
        return this.resolveClass(className2);
    }

    public Class resolveJvmClass(String name2) {
        try {
            return this.unit.getClassLoader().loadClass(name2, false, true);
        }
        catch (ClassNotFoundException e) {
            throw new GroovyBugError("JVM class can't be loaded for " + name2, e);
        }
    }
}

