/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.decompiled;

import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.AnnotationVisitor;
import groovyjarjarasm.asm.ClassReader;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.FieldVisitor;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Type;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.ast.decompiled.AnnotationStub;
import org.codehaus.groovy.ast.decompiled.ClassStub;
import org.codehaus.groovy.ast.decompiled.EnumConstantWrapper;
import org.codehaus.groovy.ast.decompiled.FieldStub;
import org.codehaus.groovy.ast.decompiled.MethodStub;
import org.codehaus.groovy.ast.decompiled.TypeWrapper;
import org.codehaus.groovy.util.URLStreams;

public abstract class AsmDecompiler {
    public static ClassStub parseClass(URL url) throws IOException {
        ClassStub stub;
        URI uri2;
        try {
            uri2 = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new GroovyRuntimeException(e);
        }
        SoftReference<ClassStub> ref = StubCache.map.get(uri2);
        ClassStub classStub = stub = ref == null ? null : ref.get();
        if (stub == null) {
            DecompilingVisitor visitor = new DecompilingVisitor();
            try (BufferedInputStream stream = new BufferedInputStream(URLStreams.openUncachedStream(url));){
                new ClassReader(stream).accept(visitor, 4);
            }
            stub = visitor.result;
            StubCache.map.put(uri2, new SoftReference<ClassStub>(stub));
        }
        return stub;
    }

    private static AnnotationReader readAnnotationMembers(final AnnotationStub stub) {
        return new AnnotationReader(){

            @Override
            void visitAttribute(String name2, Object value2) {
                stub.members.put(name2, value2);
            }
        };
    }

    static String fromInternalName(String name2) {
        return name2.replace('/', '.');
    }

    private static abstract class AnnotationReader
    extends AnnotationVisitor {
        public AnnotationReader() {
            super(458752);
        }

        abstract void visitAttribute(String var1, Object var2);

        @Override
        public void visit(String name2, Object value2) {
            this.visitAttribute(name2, value2 instanceof Type ? new TypeWrapper(((Type)value2).getDescriptor()) : value2);
        }

        @Override
        public void visitEnum(String name2, String desc, String value2) {
            this.visitAttribute(name2, new EnumConstantWrapper(desc, value2));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name2, String desc) {
            AnnotationStub stub = new AnnotationStub(desc);
            this.visitAttribute(name2, stub);
            return AsmDecompiler.readAnnotationMembers(stub);
        }

        @Override
        public AnnotationVisitor visitArray(String name2) {
            final ArrayList list2 = new ArrayList();
            this.visitAttribute(name2, list2);
            return new AnnotationReader(){

                @Override
                void visitAttribute(String name2, Object value2) {
                    list2.add(value2);
                }
            };
        }
    }

    private static class DecompilingVisitor
    extends ClassVisitor {
        private static final String[] EMPTY_STRING_ARRAY = new String[0];
        private ClassStub result;

        public DecompilingVisitor() {
            super(458752);
        }

        @Override
        public void visit(int version, int access, String name2, String signature2, String superName, String[] interfaceNames) {
            this.result = new ClassStub(AsmDecompiler.fromInternalName(name2), access, signature2, superName, interfaceNames);
        }

        @Override
        public void visitInnerClass(String name2, String outerName, String innerName, int access) {
            if (AsmDecompiler.fromInternalName(name2).equals(this.result.className)) {
                this.result.innerClassModifiers = access;
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name2, String desc, String signature2, String[] exceptions) {
            if (!"<clinit>".equals(name2)) {
                final MethodStub stub = new MethodStub(name2, access, desc, signature2, exceptions != null ? exceptions : EMPTY_STRING_ARRAY);
                if (this.result.methods == null) {
                    this.result.methods = new ArrayList<MethodStub>(1);
                }
                this.result.methods.add(stub);
                return new MethodVisitor(this.api){

                    @Override
                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        return AsmDecompiler.readAnnotationMembers(stub.addAnnotation(desc));
                    }

                    @Override
                    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                        List<AnnotationStub> list2;
                        if (stub.parameterAnnotations == null) {
                            stub.parameterAnnotations = new HashMap<Integer, List<AnnotationStub>>(1);
                        }
                        if ((list2 = stub.parameterAnnotations.get(parameter)) == null) {
                            list2 = new ArrayList<AnnotationStub>();
                            stub.parameterAnnotations.put(parameter, list2);
                        }
                        AnnotationStub annotationStub = new AnnotationStub(desc);
                        list2.add(annotationStub);
                        return AsmDecompiler.readAnnotationMembers(annotationStub);
                    }

                    @Override
                    public AnnotationVisitor visitAnnotationDefault() {
                        return new AnnotationReader(){

                            @Override
                            void visitAttribute(String name2, Object value2) {
                                stub.annotationDefault = value2;
                            }
                        };
                    }

                    @Override
                    public void visitParameter(String name2, int access) {
                        if (stub.parameterNames == null) {
                            stub.parameterNames = new ArrayList<String>();
                        }
                        stub.parameterNames.add(name2);
                    }
                };
            }
            return null;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return AsmDecompiler.readAnnotationMembers(this.result.addAnnotation(desc));
        }

        @Override
        public FieldVisitor visitField(int access, String name2, String desc, String signature2, Object value2) {
            final FieldStub stub = new FieldStub(name2, access, desc, signature2, value2);
            if (this.result.fields == null) {
                this.result.fields = new ArrayList<FieldStub>(1);
            }
            this.result.fields.add(stub);
            return new FieldVisitor(this.api){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return AsmDecompiler.readAnnotationMembers(stub.addAnnotation(desc));
                }
            };
        }
    }

    private static class StubCache {
        static final Map<URI, SoftReference<ClassStub>> map = new ConcurrentHashMap<URI, SoftReference<ClassStub>>();

        private StubCache() {
        }
    }
}

