/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.builder;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodCallTransformation;
import org.codehaus.groovy.ast.MethodInvocationTrap;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class AstBuilderTransformation
extends MethodCallTransformation {
    @Override
    protected GroovyCodeVisitor getTransformer(ASTNode[] nodes2, SourceUnit sourceUnit) {
        return new AstBuilderInvocationTrap(sourceUnit.getAST().getImports(), sourceUnit.getAST().getStarImports(), sourceUnit.getSource(), sourceUnit);
    }

    private static class AstBuilderInvocationTrap
    extends MethodInvocationTrap {
        private final List<String> factoryTargets = new ArrayList<String>();

        AstBuilderInvocationTrap(List<ImportNode> imports, List<ImportNode> importPackages, ReaderSource source, SourceUnit sourceUnit) {
            super(source, sourceUnit);
            this.factoryTargets.add("org.codehaus.groovy.ast.builder.AstBuilder");
            if (imports != null) {
                for (ImportNode importStatement : imports) {
                    if (!"org.codehaus.groovy.ast.builder.AstBuilder".equals(importStatement.getType().getName())) continue;
                    this.factoryTargets.add(importStatement.getAlias());
                }
            }
            if (importPackages != null) {
                for (ImportNode importPackage : importPackages) {
                    if (!"org.codehaus.groovy.ast.builder.".equals(importPackage.getPackageName())) continue;
                    this.factoryTargets.add("AstBuilder");
                    break;
                }
            }
        }

        @Override
        protected boolean handleTargetMethodCallExpression(MethodCallExpression call2) {
            ClosureExpression closureExpression = AstBuilderInvocationTrap.getClosureArgument(call2);
            List<Expression> otherArgs = AstBuilderInvocationTrap.getNonClosureArguments(call2);
            String source = this.convertClosureToSource(closureExpression);
            otherArgs.add(new ConstantExpression(source));
            call2.setArguments(new ArgumentListExpression(otherArgs));
            call2.setMethod(new ConstantExpression("buildFromBlock"));
            call2.setSpreadSafe(false);
            call2.setSafe(false);
            call2.setImplicitThis(false);
            return false;
        }

        private static List<Expression> getNonClosureArguments(MethodCallExpression call2) {
            ArrayList<Expression> result2 = new ArrayList<Expression>();
            if (call2.getArguments() instanceof TupleExpression) {
                for (ASTNode aSTNode : ((TupleExpression)call2.getArguments()).getExpressions()) {
                    if (aSTNode instanceof ClosureExpression) continue;
                    result2.add((Expression)aSTNode);
                }
            }
            return result2;
        }

        private static ClosureExpression getClosureArgument(MethodCallExpression call2) {
            if (call2.getArguments() instanceof TupleExpression) {
                for (ASTNode aSTNode : ((TupleExpression)call2.getArguments()).getExpressions()) {
                    if (!(aSTNode instanceof ClosureExpression)) continue;
                    return (ClosureExpression)aSTNode;
                }
            }
            return null;
        }

        @Override
        protected boolean isBuildInvocation(MethodCallExpression call2) {
            String name2;
            if (call2 == null) {
                throw new IllegalArgumentException("Null: call");
            }
            if (call2.getMethod() instanceof ConstantExpression && "buildFromCode".equals(((ConstantExpression)call2.getMethod()).getValue()) && call2.getObjectExpression() != null && call2.getObjectExpression().getType() != null && (name2 = call2.getObjectExpression().getType().getName()) != null && !"".equals(name2) && this.factoryTargets.contains(name2) && call2.getArguments() != null && call2.getArguments() instanceof TupleExpression && ((TupleExpression)call2.getArguments()).getExpressions() != null) {
                for (ASTNode aSTNode : ((TupleExpression)call2.getArguments()).getExpressions()) {
                    if (!(aSTNode instanceof ClosureExpression)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

