/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public abstract class MethodInvocationTrap
extends CodeVisitorSupport {
    protected final ReaderSource source;
    protected final SourceUnit sourceUnit;

    public MethodInvocationTrap(ReaderSource source, SourceUnit sourceUnit) {
        if (source == null) {
            throw new IllegalArgumentException("Null: source");
        }
        if (sourceUnit == null) {
            throw new IllegalArgumentException("Null: sourceUnit");
        }
        this.source = source;
        this.sourceUnit = sourceUnit;
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call2) {
        boolean shouldContinueWalking = true;
        if (this.isBuildInvocation(call2)) {
            shouldContinueWalking = this.handleTargetMethodCallExpression(call2);
        }
        if (shouldContinueWalking) {
            call2.getObjectExpression().visit(this);
            call2.getMethod().visit(this);
            call2.getArguments().visit(this);
        }
    }

    protected void addError(String msg, ASTNode expr2) {
        this.sourceUnit.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr2.getLineNumber(), expr2.getColumnNumber(), expr2.getLastLineNumber(), expr2.getLastColumnNumber()), this.sourceUnit));
    }

    protected String convertClosureToSource(ClosureExpression expression2) {
        try {
            return ClosureUtils.convertClosureToSource(this.source, expression2);
        }
        catch (Exception e) {
            this.addError(e.getMessage(), expression2);
            return null;
        }
    }

    protected abstract boolean handleTargetMethodCallExpression(MethodCallExpression var1);

    protected abstract boolean isBuildInvocation(MethodCallExpression var1);
}

