/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.List;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;

public abstract class CodeVisitorSupport
implements GroovyCodeVisitor {
    @Override
    public void visitBlockStatement(BlockStatement block) {
        for (Statement statement2 : block.getStatements()) {
            statement2.visit(this);
        }
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        forLoop.getCollectionExpression().visit(this);
        forLoop.getLoopBlock().visit(this);
    }

    @Override
    public void visitWhileLoop(WhileStatement loop2) {
        loop2.getBooleanExpression().visit(this);
        loop2.getLoopBlock().visit(this);
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement loop2) {
        loop2.getLoopBlock().visit(this);
        loop2.getBooleanExpression().visit(this);
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        ifElse.getBooleanExpression().visit(this);
        ifElse.getIfBlock().visit(this);
        Statement elseBlock = ifElse.getElseBlock();
        if (elseBlock instanceof EmptyStatement) {
            this.visitEmptyStatement((EmptyStatement)elseBlock);
        } else {
            elseBlock.visit(this);
        }
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement2) {
        statement2.getExpression().visit(this);
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement2) {
        statement2.getExpression().visit(this);
    }

    @Override
    public void visitAssertStatement(AssertStatement statement2) {
        statement2.getBooleanExpression().visit(this);
        statement2.getMessageExpression().visit(this);
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement statement2) {
        statement2.getTryStatement().visit(this);
        for (CatchStatement catchStatement : statement2.getCatchStatements()) {
            catchStatement.visit(this);
        }
        Statement finallyStatement = statement2.getFinallyStatement();
        if (finallyStatement instanceof EmptyStatement) {
            this.visitEmptyStatement((EmptyStatement)finallyStatement);
        } else {
            finallyStatement.visit(this);
        }
    }

    protected void visitEmptyStatement(EmptyStatement statement2) {
    }

    @Override
    public void visitSwitch(SwitchStatement statement2) {
        statement2.getExpression().visit(this);
        for (CaseStatement caseStatement : statement2.getCaseStatements()) {
            caseStatement.visit(this);
        }
        statement2.getDefaultStatement().visit(this);
    }

    @Override
    public void visitCaseStatement(CaseStatement statement2) {
        statement2.getExpression().visit(this);
        statement2.getCode().visit(this);
    }

    @Override
    public void visitBreakStatement(BreakStatement statement2) {
    }

    @Override
    public void visitContinueStatement(ContinueStatement statement2) {
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement statement2) {
        statement2.getExpression().visit(this);
        statement2.getCode().visit(this);
    }

    @Override
    public void visitThrowStatement(ThrowStatement statement2) {
        statement2.getExpression().visit(this);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression call2) {
        call2.getObjectExpression().visit(this);
        call2.getMethod().visit(this);
        call2.getArguments().visit(this);
    }

    @Override
    public void visitStaticMethodCallExpression(StaticMethodCallExpression call2) {
        call2.getArguments().visit(this);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call2) {
        call2.getArguments().visit(this);
    }

    @Override
    public void visitBinaryExpression(BinaryExpression expression2) {
        expression2.getLeftExpression().visit(this);
        expression2.getRightExpression().visit(this);
    }

    @Override
    public void visitTernaryExpression(TernaryExpression expression2) {
        expression2.getBooleanExpression().visit(this);
        expression2.getTrueExpression().visit(this);
        expression2.getFalseExpression().visit(this);
    }

    @Override
    public void visitShortTernaryExpression(ElvisOperatorExpression expression2) {
        this.visitTernaryExpression(expression2);
    }

    @Override
    public void visitPostfixExpression(PostfixExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitPrefixExpression(PrefixExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitBooleanExpression(BooleanExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitNotExpression(NotExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression2) {
        expression2.getCode().visit(this);
    }

    @Override
    public void visitTupleExpression(TupleExpression expression2) {
        this.visitListOfExpressions(expression2.getExpressions());
    }

    @Override
    public void visitListExpression(ListExpression expression2) {
        this.visitListOfExpressions(expression2.getExpressions());
    }

    @Override
    public void visitArrayExpression(ArrayExpression expression2) {
        this.visitListOfExpressions(expression2.getExpressions());
        this.visitListOfExpressions(expression2.getSizeExpression());
    }

    @Override
    public void visitMapExpression(MapExpression expression2) {
        this.visitListOfExpressions(expression2.getMapEntryExpressions());
    }

    @Override
    public void visitMapEntryExpression(MapEntryExpression expression2) {
        expression2.getKeyExpression().visit(this);
        expression2.getValueExpression().visit(this);
    }

    @Override
    public void visitRangeExpression(RangeExpression expression2) {
        expression2.getFrom().visit(this);
        expression2.getTo().visit(this);
    }

    @Override
    public void visitSpreadExpression(SpreadExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitSpreadMapExpression(SpreadMapExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitMethodPointerExpression(MethodPointerExpression expression2) {
        expression2.getExpression().visit(this);
        expression2.getMethodName().visit(this);
    }

    @Override
    public void visitUnaryMinusExpression(UnaryMinusExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitUnaryPlusExpression(UnaryPlusExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitBitwiseNegationExpression(BitwiseNegationExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitCastExpression(CastExpression expression2) {
        expression2.getExpression().visit(this);
    }

    @Override
    public void visitConstantExpression(ConstantExpression expression2) {
    }

    @Override
    public void visitClassExpression(ClassExpression expression2) {
    }

    @Override
    public void visitVariableExpression(VariableExpression expression2) {
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression2) {
        this.visitBinaryExpression(expression2);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression expression2) {
        expression2.getObjectExpression().visit(this);
        expression2.getProperty().visit(this);
    }

    @Override
    public void visitAttributeExpression(AttributeExpression expression2) {
        expression2.getObjectExpression().visit(this);
        expression2.getProperty().visit(this);
    }

    @Override
    public void visitFieldExpression(FieldExpression expression2) {
    }

    @Override
    public void visitGStringExpression(GStringExpression expression2) {
        this.visitListOfExpressions(expression2.getStrings());
        this.visitListOfExpressions(expression2.getValues());
    }

    protected void visitListOfExpressions(List<? extends Expression> list2) {
        if (list2 == null) {
            return;
        }
        for (Expression expression2 : list2) {
            if (expression2 instanceof SpreadExpression) {
                Expression spread = ((SpreadExpression)expression2).getExpression();
                spread.visit(this);
                continue;
            }
            expression2.visit(this);
        }
    }

    @Override
    public void visitCatchStatement(CatchStatement statement2) {
        statement2.getCode().visit(this);
    }

    @Override
    public void visitArgumentlistExpression(ArgumentListExpression ale) {
        this.visitTupleExpression(ale);
    }

    @Override
    public void visitClosureListExpression(ClosureListExpression cle) {
        this.visitListOfExpressions(cle.getExpressions());
    }

    @Override
    public void visitBytecodeExpression(BytecodeExpression cle) {
    }
}

