/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.BreakStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ContinueStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.transform.ErrorCollecting;

public abstract class ClassCodeVisitorSupport
extends CodeVisitorSupport
implements ErrorCollecting,
GroovyClassVisitor {
    @Override
    public void visitClass(ClassNode node) {
        this.visitAnnotations(node);
        this.visitPackage(node.getPackage());
        this.visitImports(node.getModule());
        node.visitContents(this);
        this.visitObjectInitializerStatements(node);
    }

    protected void visitObjectInitializerStatements(ClassNode node) {
        for (Statement element : node.getObjectInitializerStatements()) {
            element.visit(this);
        }
    }

    public void visitPackage(PackageNode node) {
        if (node != null) {
            this.visitAnnotations(node);
            node.visit(this);
        }
    }

    public void visitImports(ModuleNode node) {
        if (node != null) {
            for (ImportNode importNode : node.getImports()) {
                this.visitAnnotations(importNode);
                importNode.visit(this);
            }
            for (ImportNode importStarNode : node.getStarImports()) {
                this.visitAnnotations(importStarNode);
                importStarNode.visit(this);
            }
            for (ImportNode importStaticNode : node.getStaticImports().values()) {
                this.visitAnnotations(importStaticNode);
                importStaticNode.visit(this);
            }
            for (ImportNode importStaticStarNode : node.getStaticStarImports().values()) {
                this.visitAnnotations(importStaticStarNode);
                importStaticStarNode.visit(this);
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        List<AnnotationNode> annotations2 = node.getAnnotations();
        if (annotations2.isEmpty()) {
            return;
        }
        for (AnnotationNode an : annotations2) {
            if (an.isBuiltIn()) continue;
            for (Map.Entry<String, Expression> member2 : an.getMembers().entrySet()) {
                member2.getValue().visit(this);
            }
        }
    }

    @Override
    public void visitBlockStatement(BlockStatement block) {
        this.visitStatement(block);
        super.visitBlockStatement(block);
    }

    protected void visitClassCodeContainer(Statement code) {
        if (code != null) {
            code.visit(this);
        }
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression2) {
        this.visitAnnotations(expression2);
        super.visitDeclarationExpression(expression2);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.visitAnnotations(node);
        this.visitClassCodeContainer(node.getCode());
        for (Parameter param2 : node.getParameters()) {
            this.visitAnnotations(param2);
        }
    }

    @Override
    public void visitConstructor(ConstructorNode node) {
        this.visitConstructorOrMethod(node, true);
    }

    @Override
    public void visitMethod(MethodNode node) {
        this.visitConstructorOrMethod(node, false);
    }

    @Override
    public void visitField(FieldNode node) {
        this.visitAnnotations(node);
        Expression init2 = node.getInitialExpression();
        if (init2 != null) {
            init2.visit(this);
        }
    }

    @Override
    public void visitProperty(PropertyNode node) {
        this.visitAnnotations(node);
        Statement statement2 = node.getGetterBlock();
        this.visitClassCodeContainer(statement2);
        statement2 = node.getSetterBlock();
        this.visitClassCodeContainer(statement2);
        Expression init2 = node.getInitialExpression();
        if (init2 != null) {
            init2.visit(this);
        }
    }

    @Override
    public void addError(String msg, ASTNode expr2) {
        SourceUnit source = this.getSourceUnit();
        source.getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + '\n', expr2.getLineNumber(), expr2.getColumnNumber(), expr2.getLastLineNumber(), expr2.getLastColumnNumber()), source));
    }

    protected abstract SourceUnit getSourceUnit();

    protected void visitStatement(Statement statement2) {
    }

    @Override
    public void visitAssertStatement(AssertStatement statement2) {
        this.visitStatement(statement2);
        super.visitAssertStatement(statement2);
    }

    @Override
    public void visitBreakStatement(BreakStatement statement2) {
        this.visitStatement(statement2);
        super.visitBreakStatement(statement2);
    }

    @Override
    public void visitCaseStatement(CaseStatement statement2) {
        this.visitStatement(statement2);
        super.visitCaseStatement(statement2);
    }

    @Override
    public void visitCatchStatement(CatchStatement statement2) {
        this.visitStatement(statement2);
        super.visitCatchStatement(statement2);
    }

    @Override
    public void visitContinueStatement(ContinueStatement statement2) {
        this.visitStatement(statement2);
        super.visitContinueStatement(statement2);
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement loop2) {
        this.visitStatement(loop2);
        super.visitDoWhileLoop(loop2);
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement statement2) {
        this.visitStatement(statement2);
        super.visitExpressionStatement(statement2);
    }

    @Override
    public void visitForLoop(ForStatement forLoop) {
        this.visitStatement(forLoop);
        super.visitForLoop(forLoop);
    }

    @Override
    public void visitIfElse(IfStatement ifElse) {
        this.visitStatement(ifElse);
        super.visitIfElse(ifElse);
    }

    @Override
    public void visitReturnStatement(ReturnStatement statement2) {
        this.visitStatement(statement2);
        super.visitReturnStatement(statement2);
    }

    @Override
    public void visitSwitch(SwitchStatement statement2) {
        this.visitStatement(statement2);
        super.visitSwitch(statement2);
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement statement2) {
        this.visitStatement(statement2);
        super.visitSynchronizedStatement(statement2);
    }

    @Override
    public void visitThrowStatement(ThrowStatement statement2) {
        this.visitStatement(statement2);
        super.visitThrowStatement(statement2);
    }

    @Override
    public void visitTryCatchFinally(TryCatchStatement statement2) {
        this.visitStatement(statement2);
        super.visitTryCatchFinally(statement2);
    }

    @Override
    public void visitWhileLoop(WhileStatement loop2) {
        this.visitStatement(loop2);
        super.visitWhileLoop(loop2);
    }
}

