/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.antlr;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;

public class EnumHelper {
    private static final int FS = 24;
    private static final int PUBLIC_FS = 25;

    public static ClassNode makeEnumNode(String name2, int modifiers, ClassNode[] interfaces2, ClassNode outerClass) {
        ClassNode enumClass;
        modifiers = modifiers | 0x10 | 0x4000;
        if (outerClass == null) {
            enumClass = new ClassNode(name2, modifiers, null, interfaces2, MixinNode.EMPTY_ARRAY);
        } else {
            name2 = outerClass.getName() + "$" + name2;
            enumClass = new InnerClassNode(outerClass, name2, modifiers |= 8, null, interfaces2, MixinNode.EMPTY_ARRAY);
        }
        GenericsType gt = new GenericsType(enumClass);
        ClassNode superClass = ClassHelper.makeWithoutCaching("java.lang.Enum");
        superClass.setGenericsTypes(new GenericsType[]{gt});
        enumClass.setSuperClass(superClass);
        superClass.setRedirect(ClassHelper.Enum_Type);
        return enumClass;
    }

    public static FieldNode addEnumConstant(ClassNode enumClass, String name2, Expression init2) {
        int modifiers = 16409;
        if (init2 != null && !(init2 instanceof ListExpression)) {
            ListExpression list2 = new ListExpression();
            list2.addExpression(init2);
            init2 = list2;
        }
        FieldNode fn2 = new FieldNode(name2, modifiers, enumClass.getPlainNodeReference(), enumClass, init2);
        enumClass.addField(fn2);
        return fn2;
    }
}

