/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.zeppelin.cassandra.BoundValuesParser;
import org.apache.zeppelin.cassandra.InterpreterLogic;
import org.apache.zeppelin.cassandra.ParagraphParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.util.matching.Regex;

public final class InterpreterLogic$ {
    public static final InterpreterLogic$ MODULE$;
    private final String CHOICES_SEPARATOR;
    private final Regex VARIABLE_PATTERN;
    private final Regex SIMPLE_VARIABLE_DEFINITION_PATTERN;
    private final Regex MULTIPLE_CHOICES_VARIABLE_DEFINITION_PATTERN;
    private final String STANDARD_DATE_FORMAT;
    private final String ACCURATE_DATE_FORMAT;
    private final DateTimeFormatter STANDARD_DATE_FORMATTER;
    private final DateTimeFormatter ACCURATE_DATE_FORMATTER;
    private final Map<String, PreparedStatement> preparedStatements;
    private final Logger logger;
    private final ParagraphParser paragraphParser;
    private final BoundValuesParser boundValuesParser;

    static {
        new InterpreterLogic$();
    }

    public String CHOICES_SEPARATOR() {
        return this.CHOICES_SEPARATOR;
    }

    public Regex VARIABLE_PATTERN() {
        return this.VARIABLE_PATTERN;
    }

    public Regex SIMPLE_VARIABLE_DEFINITION_PATTERN() {
        return this.SIMPLE_VARIABLE_DEFINITION_PATTERN;
    }

    public Regex MULTIPLE_CHOICES_VARIABLE_DEFINITION_PATTERN() {
        return this.MULTIPLE_CHOICES_VARIABLE_DEFINITION_PATTERN;
    }

    public String STANDARD_DATE_FORMAT() {
        return this.STANDARD_DATE_FORMAT;
    }

    public String ACCURATE_DATE_FORMAT() {
        return this.ACCURATE_DATE_FORMAT;
    }

    public DateTimeFormatter STANDARD_DATE_FORMATTER() {
        return this.STANDARD_DATE_FORMATTER;
    }

    public DateTimeFormatter ACCURATE_DATE_FORMATTER() {
        return this.ACCURATE_DATE_FORMATTER;
    }

    public Map<String, PreparedStatement> preparedStatements() {
        return this.preparedStatements;
    }

    public Logger logger() {
        return this.logger;
    }

    public ParagraphParser paragraphParser() {
        return this.paragraphParser;
    }

    public BoundValuesParser boundValuesParser() {
        return this.boundValuesParser;
    }

    private InterpreterLogic$() {
        MODULE$ = this;
        this.CHOICES_SEPARATOR = "\\|";
        this.VARIABLE_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\{\\{[^}]+}}")).r();
        this.SIMPLE_VARIABLE_DEFINITION_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\{\\{([^=]+)=([^=]+)}}")).r();
        this.MULTIPLE_CHOICES_VARIABLE_DEFINITION_PATTERN = new StringOps(Predef$.MODULE$.augmentString("\\{\\{([^=]+)=((?:[^=]+\\|)+[^|]+)}}")).r();
        this.STANDARD_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        this.ACCURATE_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
        this.STANDARD_DATE_FORMATTER = DateTimeFormatter.ofPattern(this.STANDARD_DATE_FORMAT());
        this.ACCURATE_DATE_FORMATTER = DateTimeFormatter.ofPattern(this.ACCURATE_DATE_FORMAT());
        this.preparedStatements = JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.logger = LoggerFactory.getLogger(InterpreterLogic.class);
        this.paragraphParser = new ParagraphParser();
        this.boundValuesParser = new BoundValuesParser();
    }
}

