/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import io.netty.buffer.ByteBufUtil;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.zeppelin.cassandra.CassandraInterpreter;
import org.apache.zeppelin.cassandra.CqlFormatter$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\rw!B\u0001\u0003\u0011\u0003Y\u0011\u0001D\"rY\u001a{'/\\1ui\u0016\u0014(BA\u0002\u0005\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018M\u0003\u0002\u0006\r\u0005A!0\u001a9qK2LgN\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\r\u0007Fdgi\u001c:nCR$XM]\n\u0003\u001bA\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007\"B\f\u000e\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\f\u0011\u001dQRB1A\u0005\u0002m\t\u0001\u0003R#G\u0003VcEk\u0018+J\u001b\u0016SvJT#\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t1\fgn\u001a\u0006\u0002C\u0005!!.\u0019<b\u0013\t\u0019cD\u0001\u0004TiJLgn\u001a\u0005\u0007K5\u0001\u000b\u0011\u0002\u000f\u0002#\u0011+e)Q+M)~#\u0016*T#[\u001f:+\u0005\u0005C\u0004(\u001b\t\u0007I\u0011A\u000e\u0002\u001d\u0011+e)Q+M)~3uJU'B)\"1\u0011&\u0004Q\u0001\nq\tq\u0002R#G\u0003VcEk\u0018$P%6\u000bE\u000b\t\u0005\bW5\u0011\r\u0011\"\u0001-\u0003]!UIR!V\u0019R{f\tT(B)~\u0003&+R\"J'&{e*F\u0001.!\t\tb&\u0003\u00020%\t\u0019\u0011J\u001c;\t\rEj\u0001\u0015!\u0003.\u0003a!UIR!V\u0019R{f\tT(B)~\u0003&+R\"J'&{e\n\t\u0005\bg5\u0011\r\u0011\"\u0001-\u0003a!UIR!V\u0019R{FiT+C\u0019\u0016{\u0006KU#D\u0013NKuJ\u0014\u0005\u0007k5\u0001\u000b\u0011B\u0017\u00023\u0011+e)Q+M)~#u*\u0016\"M\u000b~\u0003&+R\"J'&{e\n\t\u0005\bo5\u0011\r\u0011\"\u0001-\u0003e!UIR!V\u0019R{F)R\"J\u001b\u0006cu\f\u0015*F\u0007&\u001b\u0016j\u0014(\t\rej\u0001\u0015!\u0003.\u0003i!UIR!V\u0019R{F)R\"J\u001b\u0006cu\f\u0015*F\u0007&\u001b\u0016j\u0014(!\u0011\u001dYTB1A\u0005\u0002m\t\u0001\u0004R#G\u0003VcEk\u0018+J\u001b\u0016\u001bF+Q'Q?\u001a{%+T!U\u0011\u0019iT\u0002)A\u00059\u0005IB)\u0012$B+2#v\fV%N\u000bN#\u0016)\u0014)`\r>\u0013V*\u0011+!\u0011\u001dyTB1A\u0005\u0002m\t1\u0003R#G\u0003VcEk\u0018+J\u001b\u0016{fi\u0014*N\u0003RCa!Q\u0007!\u0002\u0013a\u0012\u0001\u0006#F\r\u0006+F\nV0U\u00136+uLR(S\u001b\u0006#\u0006\u0005C\u0004D\u001b\t\u0007I\u0011A\u000e\u0002'\u0011+e)Q+M)~#\u0015\tV#`\r>\u0013V*\u0011+\t\r\u0015k\u0001\u0015!\u0003\u001d\u0003Q!UIR!V\u0019R{F)\u0011+F?\u001a{%+T!UA!9q)\u0004b\u0001\n\u0003Y\u0012A\u0004#F\r\u0006+F\nV0M\u001f\u000e\u000bE*\u0012\u0005\u0007\u00136\u0001\u000b\u0011\u0002\u000f\u0002\u001f\u0011+e)Q+M)~cujQ!M\u000b\u0002BqaS\u0007C\u0002\u0013\u0005A*A\u000bbY2\fe/Y5mC\ndW\rV5nKj|g.Z:\u0016\u00035\u00032AT)U\u001d\t\tr*\u0003\u0002Q%\u00051\u0001K]3eK\u001aL!AU*\u0003\u0007M+GO\u0003\u0002Q%A\u0011a*V\u0005\u0003GMCaaV\u0007!\u0002\u0013i\u0015AF1mY\u00063\u0018-\u001b7bE2,G+[7fu>tWm\u001d\u0011\t\u000bekA\u0011\u0001.\u0002%\u001d,GOT;nE\u0016\u0014hi\u001c:nCR$XM\u001d\u000b\u00047\u0012d\u0007cA\t]=&\u0011QL\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005}\u0013W\"\u00011\u000b\u0005\u0005\u0004\u0013\u0001\u0002;fqRL!a\u00191\u0003\u001b\u0011+7-[7bY\u001a{'/\\1u\u0011\u0015)\u0007\f1\u0001g\u0003\u0019awnY1mKB\u0011qM[\u0007\u0002Q*\u0011\u0011\u000eI\u0001\u0005kRLG.\u0003\u0002lQ\n1Aj\\2bY\u0016DQ!\u001c-A\u00025\n\u0011\u0002\u001d:fG&\u001c\u0018n\u001c8\t\u000b=lA\u0011\u00019\u0002)\u001d,G\u000fR1uKRKW.\u001a$pe6\fG\u000f^3s)\u0015\t\u0018P_A\u0001!\t\u0011x/D\u0001t\u0015\t!X/\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0003m\u0002\nA\u0001^5nK&\u0011\u0001p\u001d\u0002\u0012\t\u0006$X\rV5nK\u001a{'/\\1ui\u0016\u0014\b\"B3o\u0001\u00041\u0007\"B>o\u0001\u0004a\u0018\u0001\u0003;j[\u0016TvN\\3\u0011\u0005utX\"A;\n\u0005},(A\u0002.p]\u0016LE\rC\u0003u]\u0002\u0007A\u000bC\u0004\u0002\u00065!\t!a\u0002\u0002\u0013\u001d,G\u000fT8dC2,Gc\u00014\u0002\n!9\u00111BA\u0002\u0001\u0004!\u0016!\u00037pG\u0006dWm\u0015;s\u0011\u001d\ty!\u0004C\u0001\u0003#\t1bZ3u)&lWM_8oKR\u0019A0a\u0005\t\u000f\u0005U\u0011Q\u0002a\u0001)\u0006)AO_*ue\"I\u0011\u0011D\u0007\u0012\u0002\u0013\u0005\u00111D\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u!f\u0001+\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002,I\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u000245\t\n\u0011\"\u0001\u00026\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u000e+\u00075\ny\u0002C\u0005\u0002<5\t\n\u0011\"\u0001\u00026\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMB\u0011\"a\u0010\u000e#\u0003%\t!!\u000e\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011%\t\u0019%DI\u0001\n\u0003\tY\"A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\u000e\u0005\n\u0003\u000fj\u0011\u0013!C\u0001\u00037\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0004\"CA&\u001bE\u0005I\u0011AA\u000e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%o!I\u0011qJ\u0007\u0012\u0002\u0013\u0005\u00111D\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\t\u0013\u0005MS\"%A\u0005\u0002\u0005m\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013HB\u0003\u000f\u0005\u0001\t9fE\u0002\u0002VAA1\"a\u0017\u0002V\t\u0015\r\u0011\"\u0001\u0002^\u0005aq.\u001e;qkR4uN]7biV\tA\u000b\u0003\u0006\u0002b\u0005U#\u0011!Q\u0001\nQ\u000bQb\\;uaV$hi\u001c:nCR\u0004\u0003BCA3\u0003+\u0012)\u0019!C\u0001Y\u0005qa\r\\8biB\u0013XmY5tS>t\u0007BCA5\u0003+\u0012\t\u0011)A\u0005[\u0005ya\r\\8biB\u0013XmY5tS>t\u0007\u0005\u0003\u0006\u0002n\u0005U#Q1A\u0005\u00021\nq\u0002Z8vE2,\u0007K]3dSNLwN\u001c\u0005\u000b\u0003c\n)F!A!\u0002\u0013i\u0013\u0001\u00053pk\ndW\r\u0015:fG&\u001c\u0018n\u001c8!\u0011)\t)(!\u0016\u0003\u0006\u0004%\t\u0001L\u0001\u0011I\u0016\u001c\u0017.\\1m!J,7-[:j_:D!\"!\u001f\u0002V\t\u0005\t\u0015!\u0003.\u0003E!WmY5nC2\u0004&/Z2jg&|g\u000e\t\u0005\f\u0003{\n)F!b\u0001\n\u0003\ti&A\buS6,7\u000f^1na\u001a{'/\\1u\u0011)\t\t)!\u0016\u0003\u0002\u0003\u0006I\u0001V\u0001\u0011i&lWm\u001d;b[B4uN]7bi\u0002B1\"!\"\u0002V\t\u0015\r\u0011\"\u0001\u0002^\u0005QA/[7f\r>\u0014X.\u0019;\t\u0015\u0005%\u0015Q\u000bB\u0001B\u0003%A+A\u0006uS6,gi\u001c:nCR\u0004\u0003bCAG\u0003+\u0012)\u0019!C\u0001\u0003;\n!\u0002Z1uK\u001a{'/\\1u\u0011)\t\t*!\u0016\u0003\u0002\u0003\u0006I\u0001V\u0001\fI\u0006$XMR8s[\u0006$\b\u0005C\u0006\u0002\u0016\u0006U#Q1A\u0005\u0002\u0005u\u0013A\u0003;j[\u0016TvN\\3JI\"Q\u0011\u0011TA+\u0005\u0003\u0005\u000b\u0011\u0002+\u0002\u0017QLW.\u001a.p]\u0016LE\r\t\u0005\f\u0003\u0017\t)F!b\u0001\n\u0003\ti\u0006\u0003\u0006\u0002 \u0006U#\u0011!Q\u0001\nQ\u000b!\u0002\\8dC2,7\u000b\u001e:!\u0011\u001d9\u0012Q\u000bC\u0001\u0003G#B#!*\u0002(\u0006%\u00161VAW\u0003_\u000b\t,a-\u00026\u0006]\u0006c\u0001\u0007\u0002V!I\u00111LAQ!\u0003\u0005\r\u0001\u0016\u0005\n\u0003K\n\t\u000b%AA\u00025B\u0011\"!\u001c\u0002\"B\u0005\t\u0019A\u0017\t\u0013\u0005U\u0014\u0011\u0015I\u0001\u0002\u0004i\u0003\"CA?\u0003C\u0003\n\u00111\u0001U\u0011%\t))!)\u0011\u0002\u0003\u0007A\u000bC\u0005\u0002\u000e\u0006\u0005\u0006\u0013!a\u0001)\"I\u0011QSAQ!\u0003\u0005\r\u0001\u0016\u0005\n\u0003\u0017\t\t\u000b%AA\u0002QC!\"a/\u0002V\t\u0007I\u0011AA_\u0003-I7oQ9m\r>\u0014X.\u0019;\u0016\u0005\u0005}\u0006cA\t\u0002B&\u0019\u00111\u0019\n\u0003\u000f\t{w\u000e\\3b]\"I\u0011qYA+A\u0003%\u0011qX\u0001\rSN\u001c\u0015\u000f\u001c$pe6\fG\u000f\t\u0005\nK\u0006U#\u0019!C\u0001\u0003\u0017,\u0012A\u001a\u0005\t\u0003\u001f\f)\u0006)A\u0005M\u00069An\\2bY\u0016\u0004\u0003\"C>\u0002V\t\u0007I\u0011AAj+\u0005a\b\u0002CAl\u0003+\u0002\u000b\u0011\u0002?\u0002\u0013QLW.\u001a.p]\u0016\u0004\u0003BCAn\u0003+\u0012\r\u0011\"\u0001\u0002^\u0006qa\r\\8bi\u001a{'/\\1ui\u0016\u0014X#A.\t\u0011\u0005\u0005\u0018Q\u000bQ\u0001\nm\u000bqB\u001a7pCR4uN]7biR,'\u000f\t\u0005\u000b\u0003K\f)F1A\u0005\u0002\u0005u\u0017a\u00043pk\ndWMR8s[\u0006$H/\u001a:\t\u0011\u0005%\u0018Q\u000bQ\u0001\nm\u000b\u0001\u0003Z8vE2,gi\u001c:nCR$XM\u001d\u0011\t\u0015\u00055\u0018Q\u000bb\u0001\n\u0003\ti.\u0001\teK\u000eLW.\u00197G_Jl\u0017\r\u001e;fe\"A\u0011\u0011_A+A\u0003%1,A\teK\u000eLW.\u00197G_Jl\u0017\r\u001e;fe\u0002B!\"!>\u0002V\t\u0007I\u0011AA|\u0003I!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0016\u0003ED\u0001\"a?\u0002V\u0001\u0006I!]\u0001\u0014i&lWm\u001d;b[B4uN]7biR,'\u000f\t\u0005\u000b\u0003\u007f\f)F1A\u0005\u0002\u0005]\u0018!\u0004;j[\u00164uN]7biR,'\u000f\u0003\u0005\u0003\u0004\u0005U\u0003\u0015!\u0003r\u00039!\u0018.\\3G_Jl\u0017\r\u001e;fe\u0002B!Ba\u0002\u0002V\t\u0007I\u0011AA|\u00035!\u0017\r^3G_Jl\u0017\r\u001e;fe\"A!1BA+A\u0003%\u0011/\u0001\beCR,gi\u001c:nCR$XM\u001d\u0011\t\u000f]\t)\u0006\"\u0001\u0003\u0010Q!\u0011Q\u0015B\t\u0011!\u0011\u0019B!\u0004A\u0002\tU\u0011A\u00039s_B,'\u000f^5fgB\u0019qMa\u0006\n\u0007\te\u0001N\u0001\u0006Qe>\u0004XM\u001d;jKND\u0001B!\b\u0002V\u0011\u0005!qD\u0001\u0005G>\u0004\u0018\u0010\u0006\u000b\u0002&\n\u0005\"1\u0005B\u0013\u0005O\u0011ICa\u000b\u0003.\t=\"\u0011\u0007\u0005\n\u00037\u0012Y\u0002%AA\u0002QC\u0011\"!\u001a\u0003\u001cA\u0005\t\u0019A\u0017\t\u0013\u00055$1\u0004I\u0001\u0002\u0004i\u0003\"CA;\u00057\u0001\n\u00111\u0001.\u0011%\tiHa\u0007\u0011\u0002\u0003\u0007A\u000bC\u0005\u0002\u0006\nm\u0001\u0013!a\u0001)\"I\u0011Q\u0012B\u000e!\u0003\u0005\r\u0001\u0016\u0005\n\u0003+\u0013Y\u0002%AA\u0002QC\u0011\"a\u0003\u0003\u001cA\u0005\t\u0019\u0001+\t\u0011\tU\u0012Q\u000bC\u0001\u0005o\t1BZ8s[\u0006$\b*^7b]R\u0019AK!\u000f\t\u0011\tm\"1\u0007a\u0001\u0005{\t1a\u001c2k!\ri\"qH\u0005\u0004\u0005\u0003r\"AB(cU\u0016\u001cG\u000fC\u0004u\u0003+\"\tA!\u0012\u0015\u000bQ\u00139E!\u0013\t\u0011\tm\"1\ta\u0001\u0005{A\u0001Ba\u0013\u0003D\u0001\u0007!QJ\u0001\u0006G>$Wm\u0019\t\u0006\u0005\u001f\u0012y\u0007E\u0007\u0003\u0005#RAAa\u0013\u0003T)!!Q\u000bB,\u0003\u0011!\u0018\u0010]3\u000b\t\te#1L\u0001\u0005G>\u0014XM\u0003\u0003\u0003^\t}\u0013aA1qS*!!\u0011\rB2\u0003\u0019!'/\u001b<fe*!!Q\rB4\u0003\ry7o\u001d\u0006\u0005\u0005S\u0012Y'\u0001\u0005eCR\f7\u000f^1y\u0015\t\u0011i'A\u0002d_6LAA!\u001d\u0003R\tIA+\u001f9f\u0007>$Wm\u0019\u0005\t\u0005k\n)\u0006\"\u0001\u0003x\u0005\u0001r-\u001a;WC2,X-Q:TiJLgn\u001a\u000b\b)\ne$\u0011\u0012BG\u0011!\u0011YHa\u001dA\u0002\tu\u0014a\u0001:poB!!q\u0010BC\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\n]\u0013aA2rY&!!q\u0011BA\u0005\r\u0011vn\u001e\u0005\b\u0005\u0017\u0013\u0019\b1\u0001U\u0003\u0011q\u0017-\\3\t\u0011\t=%1\u000fa\u0001\u0005#\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0005\u0005'\u0013)*\u0004\u0002\u0003T%!!q\u0013B*\u0005!!\u0015\r^1UsB,\u0007\u0002\u0003BN\u0003+\"\tE!(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u0016\u0005\u000b\u0005C\u000b)&%A\u0005\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$H%\r\u0005\u000b\u0005K\u000b)&%A\u0005\u0002\u0005U\u0012AD2paf$C-\u001a4bk2$HE\r\u0005\u000b\u0005S\u000b)&%A\u0005\u0002\u0005U\u0012AD2paf$C-\u001a4bk2$He\r\u0005\u000b\u0005[\u000b)&%A\u0005\u0002\u0005U\u0012AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0005c\u000b)&%A\u0005\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$H%\u000e\u0005\u000b\u0005k\u000b)&%A\u0005\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$HE\u000e\u0005\u000b\u0005s\u000b)&%A\u0005\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$He\u000e\u0005\u000b\u0005{\u000b)&%A\u0005\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$H\u0005\u000f\u0005\u000b\u0005\u0003\f)&%A\u0005\u0002\u0005m\u0011AD2paf$C-\u001a4bk2$H%\u000f")
public class CqlFormatter {
    private final String outputFormat;
    private final int floatPrecision;
    private final int doublePrecision;
    private final int decimalPrecision;
    private final String timestampFormat;
    private final String timeFormat;
    private final String dateFormat;
    private final String timeZoneId;
    private final String localeStr;
    private final boolean isCqlFormat;
    private final Locale locale;
    private final ZoneId timeZone;
    private final Option<DecimalFormat> floatFormatter;
    private final Option<DecimalFormat> doubleFormatter;
    private final Option<DecimalFormat> decimalFormatter;
    private final DateTimeFormatter timestampFormatter;
    private final DateTimeFormatter timeFormatter;
    private final DateTimeFormatter dateFormatter;

    public static String $lessinit$greater$default$9() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$9();
    }

    public static String $lessinit$greater$default$8() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$8();
    }

    public static String $lessinit$greater$default$7() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$7();
    }

    public static String $lessinit$greater$default$6() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$6();
    }

    public static String $lessinit$greater$default$5() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$2();
    }

    public static String $lessinit$greater$default$1() {
        return CqlFormatter$.MODULE$.$lessinit$greater$default$1();
    }

    public static ZoneId getTimezone(String string2) {
        return CqlFormatter$.MODULE$.getTimezone(string2);
    }

    public static Locale getLocale(String string2) {
        return CqlFormatter$.MODULE$.getLocale(string2);
    }

    public static DateTimeFormatter getDateTimeFormatter(Locale locale, ZoneId zoneId, String string2) {
        return CqlFormatter$.MODULE$.getDateTimeFormatter(locale, zoneId, string2);
    }

    public static Option<DecimalFormat> getNumberFormatter(Locale locale, int n) {
        return CqlFormatter$.MODULE$.getNumberFormatter(locale, n);
    }

    public static scala.collection.immutable.Set<String> allAvailableTimezones() {
        return CqlFormatter$.MODULE$.allAvailableTimezones();
    }

    public static String DEFAULT_LOCALE() {
        return CqlFormatter$.MODULE$.DEFAULT_LOCALE();
    }

    public static String DEFAULT_DATE_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_DATE_FORMAT();
    }

    public static String DEFAULT_TIME_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_TIME_FORMAT();
    }

    public static String DEFAULT_TIMESTAMP_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_TIMESTAMP_FORMAT();
    }

    public static int DEFAULT_DECIMAL_PRECISION() {
        return CqlFormatter$.MODULE$.DEFAULT_DECIMAL_PRECISION();
    }

    public static int DEFAULT_DOUBLE_PRECISION() {
        return CqlFormatter$.MODULE$.DEFAULT_DOUBLE_PRECISION();
    }

    public static int DEFAULT_FLOAT_PRECISION() {
        return CqlFormatter$.MODULE$.DEFAULT_FLOAT_PRECISION();
    }

    public static String DEFAULT_FORMAT() {
        return CqlFormatter$.MODULE$.DEFAULT_FORMAT();
    }

    public static String DEFAULT_TIMEZONE() {
        return CqlFormatter$.MODULE$.DEFAULT_TIMEZONE();
    }

    public String outputFormat() {
        return this.outputFormat;
    }

    public int floatPrecision() {
        return this.floatPrecision;
    }

    public int doublePrecision() {
        return this.doublePrecision;
    }

    public int decimalPrecision() {
        return this.decimalPrecision;
    }

    public String timestampFormat() {
        return this.timestampFormat;
    }

    public String timeFormat() {
        return this.timeFormat;
    }

    public String dateFormat() {
        return this.dateFormat;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    public String localeStr() {
        return this.localeStr;
    }

    public boolean isCqlFormat() {
        return this.isCqlFormat;
    }

    public Locale locale() {
        return this.locale;
    }

    public ZoneId timeZone() {
        return this.timeZone;
    }

    public Option<DecimalFormat> floatFormatter() {
        return this.floatFormatter;
    }

    public Option<DecimalFormat> doubleFormatter() {
        return this.doubleFormatter;
    }

    public Option<DecimalFormat> decimalFormatter() {
        return this.decimalFormatter;
    }

    public DateTimeFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    public DateTimeFormatter timeFormatter() {
        return this.timeFormatter;
    }

    public DateTimeFormatter dateFormatter() {
        return this.dateFormatter;
    }

    public CqlFormatter copy(String outputFormat, int floatPrecision, int doublePrecision, int decimalPrecision, String timestampFormat, String timeFormat, String dateFormat, String timeZoneId, String localeStr) {
        return new CqlFormatter(outputFormat, floatPrecision, doublePrecision, decimalPrecision, timestampFormat, timeFormat, dateFormat, timeZoneId, localeStr);
    }

    public String copy$default$1() {
        return this.outputFormat();
    }

    public int copy$default$2() {
        return this.floatPrecision();
    }

    public int copy$default$3() {
        return this.doublePrecision();
    }

    public int copy$default$4() {
        return this.decimalPrecision();
    }

    public String copy$default$5() {
        return this.timestampFormat();
    }

    public String copy$default$6() {
        return this.timeFormat();
    }

    public String copy$default$7() {
        return this.dateFormat();
    }

    public String copy$default$8() {
        return this.timeZoneId();
    }

    public String copy$default$9() {
        return this.localeStr();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String formatHuman(Object obj) {
        String string2;
        if (obj == null) {
            return "null";
        }
        Object object = obj;
        if (object instanceof Float) {
            String string3;
            Float f2 = (Float)object;
            Option<DecimalFormat> option2 = this.floatFormatter();
            None$ none$ = None$.MODULE$;
            Option<DecimalFormat> option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                string3 = Float.toString(Predef$.MODULE$.Float2float(f2));
            } else {
                if (!(option2 instanceof Some)) throw new MatchError(option2);
                Some some = (Some)option2;
                DecimalFormat fmt = (DecimalFormat)some.x();
                string3 = fmt.format(f2);
            }
            string2 = string3;
        } else if (object instanceof Double) {
            String string4;
            Double d = (Double)object;
            Option<DecimalFormat> option4 = this.doubleFormatter();
            None$ none$ = None$.MODULE$;
            Option<DecimalFormat> option5 = option4;
            if (!(none$ != null ? !none$.equals(option5) : option5 != null)) {
                string4 = Double.toString(Predef$.MODULE$.Double2double(d));
            } else {
                if (!(option4 instanceof Some)) throw new MatchError(option4);
                Some some = (Some)option4;
                DecimalFormat fmt = (DecimalFormat)some.x();
                string4 = fmt.format(d);
            }
            string2 = string4;
        } else if (object instanceof BigDecimal) {
            String string5;
            BigDecimal bigDecimal = (BigDecimal)object;
            Option<DecimalFormat> option6 = this.decimalFormatter();
            None$ none$ = None$.MODULE$;
            Option<DecimalFormat> option7 = option6;
            if (!(none$ != null ? !none$.equals(option7) : option7 != null)) {
                string5 = bigDecimal.toString();
            } else {
                if (!(option6 instanceof Some)) throw new MatchError(option6);
                Some some = (Some)option6;
                DecimalFormat fmt = (DecimalFormat)some.x();
                string5 = fmt.format(bigDecimal);
            }
            string2 = string5;
        } else if (object instanceof Map) {
            Map map2 = (Map)object;
            string2 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map2).asScala()).map(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CqlFormatter $outer;

                public final String apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        Object v = tuple2._2();
                        String string2 = new StringBuilder().append((Object)this.$outer.formatHuman(k)).append((Object)": ").append((Object)this.$outer.formatHuman(v)).toString();
                        return string2;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString("{", ", ", "}");
        } else if (object instanceof List) {
            List list2 = (List)object;
            string2 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list2).asScala()).map(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CqlFormatter $outer;

                public final String apply(Object x) {
                    return this.$outer.formatHuman(x);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        } else if (object instanceof Set) {
            Set set2 = (Set)object;
            string2 = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(set2).asScala()).map(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CqlFormatter $outer;

                public final String apply(Object x) {
                    return this.$outer.formatHuman(x);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom())).mkString("{", ", ", "}");
        } else if (object instanceof Instant) {
            Instant instant = (Instant)object;
            string2 = this.timestampFormatter().format(instant.atZone(this.timeZone()));
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            string2 = this.dateFormatter().format(localDate);
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            string2 = this.timeFormatter().format(localTime);
        } else if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            string2 = new StringBuilder().append((Object)"0x").append((Object)ByteBufUtil.hexDump(byteBuffer.array())).toString();
        } else if (object instanceof InetAddress) {
            InetAddress inetAddress = (InetAddress)object;
            string2 = inetAddress.getHostAddress();
        } else if (object instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)object;
            string2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tupleValue.size()).map(new Serializable(this, tupleValue){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CqlFormatter $outer;
                private final TupleValue x13$1;

                public final String apply(int i) {
                    return this.$outer.formatHuman(this.x13$1.getObject(i));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.x13$1 = x13$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("(", ", ", ")");
        } else if (object instanceof UdtValue) {
            UdtValue udtValue = (UdtValue)object;
            List<CqlIdentifier> names = udtValue.getType().getFieldNames();
            string2 = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), udtValue.size()).map(new Serializable(this, names, udtValue){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CqlFormatter $outer;
                private final List names$1;
                private final UdtValue x14$1;

                public final String apply(int i) {
                    return new StringBuilder().append((Object)((CqlIdentifier)this.names$1.get(i)).asInternal()).append((Object)": ").append((Object)this.$outer.formatHuman(this.x14$1.getObject(i))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.names$1 = names$1;
                    this.x14$1 = x14$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("{", ", ", "}");
        } else {
            string2 = obj.toString();
        }
        String string6 = string2;
        return string6;
    }

    public String format(Object obj, TypeCodec<Object> codec) {
        return this.isCqlFormat() ? codec.format(obj) : this.formatHuman(new Tuple2<Object, TypeCodec<Object>>(obj, codec));
    }

    public String getValueAsString(Row row, String name2, DataType dataType) {
        Object value2 = row.getObject(name2);
        return this.isCqlFormat() ? this.format(value2, row.codecRegistry().codecFor(dataType, value2)) : this.formatHuman(value2);
    }

    public String toString() {
        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CqlFormatter(format=", ", fp=", ", dp=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.outputFormat(), BoxesRunTime.boxToInteger(this.floatPrecision()), BoxesRunTime.boxToInteger(this.doublePrecision())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{", dcp=", ", tsFormat=", ", tmFormat=", ", dtFormat=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.decimalPrecision()), this.timestampFormat(), this.timeFormat(), this.dateFormat()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timeozone=", ", locale=", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.timeZoneId(), this.localeStr()}))).toString();
    }

    public CqlFormatter(String outputFormat, int floatPrecision, int doublePrecision, int decimalPrecision, String timestampFormat, String timeFormat, String dateFormat, String timeZoneId, String localeStr) {
        this.outputFormat = outputFormat;
        this.floatPrecision = floatPrecision;
        this.doublePrecision = doublePrecision;
        this.decimalPrecision = decimalPrecision;
        this.timestampFormat = timestampFormat;
        this.timeFormat = timeFormat;
        this.dateFormat = dateFormat;
        this.timeZoneId = timeZoneId;
        this.localeStr = localeStr;
        this.isCqlFormat = "cql".equalsIgnoreCase(outputFormat);
        this.locale = CqlFormatter$.MODULE$.getLocale(localeStr);
        this.timeZone = CqlFormatter$.MODULE$.getTimezone(timeZoneId);
        this.floatFormatter = CqlFormatter$.MODULE$.getNumberFormatter(this.locale(), floatPrecision);
        this.doubleFormatter = CqlFormatter$.MODULE$.getNumberFormatter(this.locale(), doublePrecision);
        this.decimalFormatter = CqlFormatter$.MODULE$.getNumberFormatter(this.locale(), decimalPrecision);
        this.timestampFormatter = CqlFormatter$.MODULE$.getDateTimeFormatter(this.locale(), this.timeZone(), timestampFormat);
        this.timeFormatter = CqlFormatter$.MODULE$.getDateTimeFormatter(this.locale(), this.timeZone(), timeFormat);
        this.dateFormatter = CqlFormatter$.MODULE$.getDateTimeFormatter(this.locale(), this.timeZone(), dateFormat);
    }

    public CqlFormatter(Properties properties2) {
        this(properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_TYPE, CqlFormatter$.MODULE$.DEFAULT_FORMAT()), new StringOps(Predef$.MODULE$.augmentString(properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_FLOAT_PRECISION, ((Object)BoxesRunTime.boxToInteger(CqlFormatter$.MODULE$.DEFAULT_FLOAT_PRECISION())).toString()))).toInt(), new StringOps(Predef$.MODULE$.augmentString(properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_DOUBLE_PRECISION, ((Object)BoxesRunTime.boxToInteger(CqlFormatter$.MODULE$.DEFAULT_DOUBLE_PRECISION())).toString()))).toInt(), new StringOps(Predef$.MODULE$.augmentString(properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_DECIMAL_PRECISION, ((Object)BoxesRunTime.boxToInteger(CqlFormatter$.MODULE$.DEFAULT_DECIMAL_PRECISION())).toString()))).toInt(), properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_TIMESTAMP, CqlFormatter$.MODULE$.DEFAULT_TIMESTAMP_FORMAT()), properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_TIME, CqlFormatter$.MODULE$.DEFAULT_TIME_FORMAT()), properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_DATE, CqlFormatter$.MODULE$.DEFAULT_DATE_FORMAT()), properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_TIMEZONE, CqlFormatter$.MODULE$.DEFAULT_TIMEZONE()), properties2.getProperty(CassandraInterpreter.CASSANDRA_FORMAT_LOCALE, CqlFormatter$.MODULE$.DEFAULT_LOCALE()));
    }
}

