/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.cassandra;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.zeppelin.interpreter.InterpreterException;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class CqlFormatter$ {
    public static final CqlFormatter$ MODULE$;
    private final String DEFAULT_TIMEZONE;
    private final String DEFAULT_FORMAT;
    private final int DEFAULT_FLOAT_PRECISION;
    private final int DEFAULT_DOUBLE_PRECISION;
    private final int DEFAULT_DECIMAL_PRECISION;
    private final String DEFAULT_TIMESTAMP_FORMAT;
    private final String DEFAULT_TIME_FORMAT;
    private final String DEFAULT_DATE_FORMAT;
    private final String DEFAULT_LOCALE;
    private final Set<String> allAvailableTimezones;

    static {
        new CqlFormatter$();
    }

    public String DEFAULT_TIMEZONE() {
        return this.DEFAULT_TIMEZONE;
    }

    public String DEFAULT_FORMAT() {
        return this.DEFAULT_FORMAT;
    }

    public int DEFAULT_FLOAT_PRECISION() {
        return this.DEFAULT_FLOAT_PRECISION;
    }

    public int DEFAULT_DOUBLE_PRECISION() {
        return this.DEFAULT_DOUBLE_PRECISION;
    }

    public int DEFAULT_DECIMAL_PRECISION() {
        return this.DEFAULT_DECIMAL_PRECISION;
    }

    public String DEFAULT_TIMESTAMP_FORMAT() {
        return this.DEFAULT_TIMESTAMP_FORMAT;
    }

    public String DEFAULT_TIME_FORMAT() {
        return this.DEFAULT_TIME_FORMAT;
    }

    public String DEFAULT_DATE_FORMAT() {
        return this.DEFAULT_DATE_FORMAT;
    }

    public String DEFAULT_LOCALE() {
        return this.DEFAULT_LOCALE;
    }

    public Set<String> allAvailableTimezones() {
        return this.allAvailableTimezones;
    }

    public Option<DecimalFormat> getNumberFormatter(Locale locale, int precision) {
        Option option2;
        if (precision == -1) {
            option2 = None$.MODULE$;
        } else {
            DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(locale);
            df.applyPattern(new StringBuilder().append((Object)"#.").append((Object)new StringOps(Predef$.MODULE$.augmentString("#")).$times(precision)).toString());
            option2 = new Some<DecimalFormat>(df);
        }
        return option2;
    }

    public DateTimeFormatter getDateTimeFormatter(Locale locale, ZoneId timeZone, String format2) {
        try {
            return DateTimeFormatter.ofPattern(format2).withLocale(locale).withZone(timeZone);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InterpreterException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid time/date format: '", "'. error message: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{format2, illegalArgumentException.getMessage()})));
        }
    }

    public Locale getLocale(String localeStr) {
        try {
            return LocaleUtils.toLocale(localeStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InterpreterException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid locale: '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{localeStr})));
        }
    }

    public ZoneId getTimezone(String tzStr) {
        if (this.allAvailableTimezones().contains(tzStr)) {
            return TimeZone.getTimeZone(tzStr).toZoneId();
        }
        throw new InterpreterException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid timezone: '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tzStr})));
    }

    public String $lessinit$greater$default$1() {
        return this.DEFAULT_FORMAT();
    }

    public int $lessinit$greater$default$2() {
        return this.DEFAULT_FLOAT_PRECISION();
    }

    public int $lessinit$greater$default$3() {
        return this.DEFAULT_DOUBLE_PRECISION();
    }

    public int $lessinit$greater$default$4() {
        return this.DEFAULT_DECIMAL_PRECISION();
    }

    public String $lessinit$greater$default$5() {
        return this.DEFAULT_TIMESTAMP_FORMAT();
    }

    public String $lessinit$greater$default$6() {
        return this.DEFAULT_TIME_FORMAT();
    }

    public String $lessinit$greater$default$7() {
        return this.DEFAULT_DATE_FORMAT();
    }

    public String $lessinit$greater$default$8() {
        return this.DEFAULT_TIMEZONE();
    }

    public String $lessinit$greater$default$9() {
        return this.DEFAULT_LOCALE();
    }

    private CqlFormatter$() {
        MODULE$ = this;
        this.DEFAULT_TIMEZONE = "UTC";
        this.DEFAULT_FORMAT = "human";
        this.DEFAULT_FLOAT_PRECISION = 5;
        this.DEFAULT_DOUBLE_PRECISION = 12;
        this.DEFAULT_DECIMAL_PRECISION = -1;
        this.DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        this.DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
        this.DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
        this.DEFAULT_LOCALE = "en_US";
        this.allAvailableTimezones = Predef$.MODULE$.refArrayOps((Object[])TimeZone.getAvailableIDs()).toSet();
    }
}

