/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.objenesis.strategy;

import java.lang.reflect.Field;
import org.apache.tinkerpop.shaded.objenesis.ObjenesisException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformDescription {
    public static final String JROCKIT = "BEA";
    public static final String GNU = "GNU libgcj";
    public static final String SUN = "Java HotSpot";
    public static final String OPENJDK = "OpenJDK";
    public static final String PERC = "PERC";
    public static final String DALVIK = "Dalvik";
    public static final String SPECIFICATION_VERSION = System.getProperty("java.specification.version");
    public static final String VM_VERSION = System.getProperty("java.runtime.version");
    public static final String VM_INFO = System.getProperty("java.vm.info");
    public static final String VENDOR_VERSION = System.getProperty("java.vm.version");
    public static final String VENDOR = System.getProperty("java.vm.vendor");
    public static final String JVM_NAME = System.getProperty("java.vm.name");
    public static final int ANDROID_VERSION = PlatformDescription.getAndroidVersion();

    public static boolean isThisJVM(String name2) {
        return JVM_NAME.startsWith(name2);
    }

    private static int getAndroidVersion() {
        if (!PlatformDescription.isThisJVM(DALVIK)) {
            return 0;
        }
        return PlatformDescription.getAndroidVersion0();
    }

    private static int getAndroidVersion0() {
        int version;
        Field field2;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("android.os.Build$VERSION");
        }
        catch (ClassNotFoundException e) {
            throw new ObjenesisException(e);
        }
        try {
            field2 = clazz2.getField("SDK_INT");
        }
        catch (NoSuchFieldException e) {
            return PlatformDescription.getOldAndroidVersion(clazz2);
        }
        try {
            version = (Integer)field2.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return version;
    }

    private static int getOldAndroidVersion(Class<?> versionClass) {
        String version;
        Field field2;
        try {
            field2 = versionClass.getField("SDK");
        }
        catch (NoSuchFieldException e) {
            throw new ObjenesisException(e);
        }
        try {
            version = (String)field2.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return Integer.parseInt(version);
    }

    private PlatformDescription() {
    }
}

