/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.shaded.kryo.util.IntArray;
import org.apache.tinkerpop.shaded.kryo.util.ObjectMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntMap<V> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    private static final int EMPTY = 0;
    public int size;
    int[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    V zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;

    public IntMap() {
        this(32, 0.8f);
    }

    public IntMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public IntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + initialCapacity);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(initialCapacity);
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public IntMap(IntMap<? extends V> map2) {
        this(map2.capacity, map2.loadFactor);
        this.stashSize = map2.stashSize;
        System.arraycopy(map2.keyTable, 0, this.keyTable, 0, map2.keyTable.length);
        System.arraycopy(map2.valueTable, 0, this.valueTable, 0, map2.valueTable.length);
        this.size = map2.size;
        this.zeroValue = map2.zeroValue;
        this.hasZeroValue = map2.hasZeroValue;
    }

    public V put(int key, V value2) {
        int i;
        if (key == 0) {
            V oldValue = this.zeroValue;
            this.zeroValue = value2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return oldValue;
        }
        int[] keyTable = this.keyTable;
        int index1 = key & this.mask;
        int key1 = keyTable[index1];
        if (key1 == key) {
            V oldValue = this.valueTable[index1];
            this.valueTable[index1] = value2;
            return oldValue;
        }
        int index2 = this.hash2(key);
        int key2 = keyTable[index2];
        if (key2 == key) {
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = value2;
            return oldValue;
        }
        int index3 = this.hash3(key);
        int key3 = keyTable[index3];
        if (key3 == key) {
            V oldValue = this.valueTable[index3];
            this.valueTable[index3] = value2;
            return oldValue;
        }
        int n = i + this.stashSize;
        for (i = this.capacity; i < n; ++i) {
            if (keyTable[i] != key) continue;
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value2;
            return oldValue;
        }
        if (key1 == 0) {
            keyTable[index1] = key;
            this.valueTable[index1] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key2 == 0) {
            keyTable[index2] = key;
            this.valueTable[index2] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key3 == 0) {
            keyTable[index3] = key;
            this.valueTable[index3] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(key, value2, index1, key1, index2, key2, index3, key3);
        return null;
    }

    public void putAll(IntMap<V> map2) {
        for (Entry<V> entry2 : map2.entries()) {
            this.put(entry2.key, entry2.value);
        }
    }

    private void putResize(int key, V value2) {
        if (key == 0) {
            this.zeroValue = value2;
            this.hasZeroValue = true;
            return;
        }
        int index1 = key & this.mask;
        int key1 = this.keyTable[index1];
        if (key1 == 0) {
            this.keyTable[index1] = key;
            this.valueTable[index1] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index2 = this.hash2(key);
        int key2 = this.keyTable[index2];
        if (key2 == 0) {
            this.keyTable[index2] = key;
            this.valueTable[index2] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index3 = this.hash3(key);
        int key3 = this.keyTable[index3];
        if (key3 == 0) {
            this.keyTable[index3] = key;
            this.valueTable[index3] = value2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(key, value2, index1, key1, index2, key2, index3, key3);
    }

    private void push(int insertKey, V insertValue, int index1, int key1, int index2, int key2, int index3, int key3) {
        V evictedValue;
        int evictedKey;
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int mask = this.mask;
        int i = 0;
        int pushIterations = this.pushIterations;
        while (true) {
            switch (ObjectMap.random.nextInt(3)) {
                case 0: {
                    evictedKey = key1;
                    evictedValue = valueTable[index1];
                    keyTable[index1] = insertKey;
                    valueTable[index1] = insertValue;
                    break;
                }
                case 1: {
                    evictedKey = key2;
                    evictedValue = valueTable[index2];
                    keyTable[index2] = insertKey;
                    valueTable[index2] = insertValue;
                    break;
                }
                default: {
                    evictedKey = key3;
                    evictedValue = valueTable[index3];
                    keyTable[index3] = insertKey;
                    valueTable[index3] = insertValue;
                }
            }
            index1 = evictedKey & mask;
            key1 = keyTable[index1];
            if (key1 == 0) {
                keyTable[index1] = evictedKey;
                valueTable[index1] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index2 = this.hash2(evictedKey);
            key2 = keyTable[index2];
            if (key2 == 0) {
                keyTable[index2] = evictedKey;
                valueTable[index2] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index3 = this.hash3(evictedKey);
            key3 = keyTable[index3];
            if (key3 == 0) {
                keyTable[index3] = evictedKey;
                valueTable[index3] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++i == pushIterations) break;
            insertKey = evictedKey;
            insertValue = evictedValue;
        }
        this.putStash(evictedKey, evictedValue);
    }

    private void putStash(int key, V value2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(key, value2);
            return;
        }
        int index2 = this.capacity + this.stashSize;
        this.keyTable[index2] = key;
        this.valueTable[index2] = value2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(int key) {
        if (key == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int index2 = key & this.mask;
        if (this.keyTable[index2] != key && this.keyTable[index2 = this.hash2(key)] != key && this.keyTable[index2 = this.hash3(key)] != key) {
            return this.getStash(key, null);
        }
        return this.valueTable[index2];
    }

    public V get(int key, V defaultValue2) {
        if (key == 0) {
            if (!this.hasZeroValue) {
                return defaultValue2;
            }
            return this.zeroValue;
        }
        int index2 = key & this.mask;
        if (this.keyTable[index2] != key && this.keyTable[index2 = this.hash2(key)] != key && this.keyTable[index2 = this.hash3(key)] != key) {
            return this.getStash(key, defaultValue2);
        }
        return this.valueTable[index2];
    }

    private V getStash(int key, V defaultValue2) {
        int i;
        int[] keyTable = this.keyTable;
        int n = i + this.stashSize;
        for (i = this.capacity; i < n; ++i) {
            if (keyTable[i] != key) continue;
            return this.valueTable[i];
        }
        return defaultValue2;
    }

    public V remove(int key) {
        if (key == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            V oldValue = this.zeroValue;
            this.zeroValue = null;
            this.hasZeroValue = false;
            --this.size;
            return oldValue;
        }
        int index2 = key & this.mask;
        if (this.keyTable[index2] == key) {
            this.keyTable[index2] = 0;
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = null;
            --this.size;
            return oldValue;
        }
        index2 = this.hash2(key);
        if (this.keyTable[index2] == key) {
            this.keyTable[index2] = 0;
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = null;
            --this.size;
            return oldValue;
        }
        index2 = this.hash3(key);
        if (this.keyTable[index2] == key) {
            this.keyTable[index2] = 0;
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = null;
            --this.size;
            return oldValue;
        }
        return this.removeStash(key);
    }

    V removeStash(int key) {
        int i;
        int[] keyTable = this.keyTable;
        int n = i + this.stashSize;
        for (i = this.capacity; i < n; ++i) {
            if (keyTable[i] != key) continue;
            V oldValue = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return oldValue;
        }
        return null;
    }

    void removeStashIndex(int index2) {
        --this.stashSize;
        int lastIndex = this.capacity + this.stashSize;
        if (index2 < lastIndex) {
            this.keyTable[index2] = this.keyTable[lastIndex];
            this.valueTable[index2] = this.valueTable[lastIndex];
            this.valueTable[lastIndex] = null;
        } else {
            this.valueTable[index2] = null;
        }
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        if (this.size > maximumCapacity) {
            maximumCapacity = this.size;
        }
        if (this.capacity <= maximumCapacity) {
            return;
        }
        maximumCapacity = ObjectMap.nextPowerOfTwo(maximumCapacity);
        this.resize(maximumCapacity);
    }

    public void clear(int maximumCapacity) {
        if (this.capacity <= maximumCapacity) {
            this.clear();
            return;
        }
        this.zeroValue = null;
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(maximumCapacity);
    }

    public void clear() {
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = this.capacity + this.stashSize;
        while (i-- > 0) {
            keyTable[i] = 0;
            valueTable[i] = null;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public boolean containsValue(Object value2, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value2 == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            int[] keyTable = this.keyTable;
            int i = this.capacity + this.stashSize;
            while (i-- > 0) {
                if (keyTable[i] == 0 || valueTable[i] != null) continue;
                return true;
            }
        } else if (identity) {
            if (value2 == this.zeroValue) {
                return true;
            }
            int i = this.capacity + this.stashSize;
            while (i-- > 0) {
                if (valueTable[i] != value2) continue;
                return true;
            }
        } else {
            if (this.hasZeroValue && value2.equals(this.zeroValue)) {
                return true;
            }
            int i = this.capacity + this.stashSize;
            while (i-- > 0) {
                if (!value2.equals(valueTable[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int key) {
        if (key == 0) {
            return this.hasZeroValue;
        }
        int index2 = key & this.mask;
        if (this.keyTable[index2] != key && this.keyTable[index2 = this.hash2(key)] != key && this.keyTable[index2 = this.hash3(key)] != key) {
            return this.containsKeyStash(key);
        }
        return true;
    }

    private boolean containsKeyStash(int key) {
        int i;
        int[] keyTable = this.keyTable;
        int n = i + this.stashSize;
        for (i = this.capacity; i < n; ++i) {
            if (keyTable[i] != key) continue;
            return true;
        }
        return false;
    }

    public int findKey(Object value2, boolean identity, int notFound) {
        V[] valueTable = this.valueTable;
        if (value2 == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0;
            }
            int[] keyTable = this.keyTable;
            int i = this.capacity + this.stashSize;
            while (i-- > 0) {
                if (keyTable[i] == 0 || valueTable[i] != null) continue;
                return keyTable[i];
            }
        } else if (identity) {
            if (value2 == this.zeroValue) {
                return 0;
            }
            int i = this.capacity + this.stashSize;
            while (i-- > 0) {
                if (valueTable[i] != value2) continue;
                return this.keyTable[i];
            }
        } else {
            if (this.hasZeroValue && value2.equals(this.zeroValue)) {
                return 0;
            }
            int i = this.capacity + this.stashSize;
            while (i-- > 0) {
                if (!value2.equals(valueTable[i])) continue;
                return this.keyTable[i];
            }
        }
        return notFound;
    }

    public void ensureCapacity(int additionalCapacity) {
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded >= this.threshold) {
            this.resize(ObjectMap.nextPowerOfTwo((int)((float)sizeNeeded / this.loadFactor)));
        }
    }

    private void resize(int newSize) {
        int oldEndIndex = this.capacity + this.stashSize;
        this.capacity = newSize;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(newSize);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(newSize)) * 2);
        this.pushIterations = Math.max(Math.min(newSize, 8), (int)Math.sqrt(newSize) / 8);
        int[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new int[newSize + this.stashCapacity];
        this.valueTable = new Object[newSize + this.stashCapacity];
        int oldSize = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (oldSize > 0) {
            for (int i = 0; i < oldEndIndex; ++i) {
                int key = oldKeyTable[i];
                if (key == 0) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    private int hash2(int h) {
        return ((h *= -1262997959) ^ h >>> this.hashShift) & this.mask;
    }

    private int hash3(int h) {
        return ((h *= -825114047) ^ h >>> this.hashShift) & this.mask;
    }

    public String toString() {
        int key;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i-- > 0) {
                key = keyTable[i];
                if (key == 0) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i]);
                break;
            }
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == 0) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public Entries<V> entries() {
        return new Entries(this);
    }

    public Values<V> values() {
        return new Values(this);
    }

    public Keys keys() {
        return new Keys(this);
    }

    public static class Keys
    extends MapIterator {
        public Keys(IntMap map2) {
            super(map2);
        }

        public int next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            int key = this.nextIndex == -1 ? 0 : this.map.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public IntArray toArray() {
            IntArray array2 = new IntArray(true, this.map.size);
            while (this.hasNext) {
                array2.add(this.next());
            }
            return array2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Values<V>
    extends MapIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(IntMap<V> map2) {
            super(map2);
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public V next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            Object value2 = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return value2;
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        public ArrayList<V> toArray() {
            ArrayList<V> array2 = new ArrayList<V>(this.map.size);
            while (this.hasNext) {
                array2.add(this.next());
            }
            return array2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> entry = new Entry();

        public Entries(IntMap map2) {
            super(map2);
        }

        @Override
        public Entry<V> next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            int[] keyTable = this.map.keyTable;
            if (this.nextIndex == -1) {
                this.entry.key = 0;
                this.entry.value = this.map.zeroValue;
            } else {
                this.entry.key = keyTable[this.nextIndex];
                this.entry.value = this.map.valueTable[this.nextIndex];
            }
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapIterator<V> {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final IntMap<V> map;
        int nextIndex;
        int currentIndex;

        public MapIterator(IntMap<V> map2) {
            this.map = map2;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }

        void findNextIndex() {
            this.hasNext = false;
            int[] keyTable = this.map.keyTable;
            int n = this.map.capacity + this.map.stashSize;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == 0) continue;
                this.hasNext = true;
                break;
            }
        }

        public void remove() {
            if (this.currentIndex == -1 && this.map.hasZeroValue) {
                this.map.zeroValue = null;
                this.map.hasZeroValue = false;
            } else {
                if (this.currentIndex < 0) {
                    throw new IllegalStateException("next must be called before remove.");
                }
                if (this.currentIndex >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = 0;
                    this.map.valueTable[this.currentIndex] = null;
                }
            }
            this.currentIndex = -2;
            --this.map.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<V> {
        public int key;
        public V value;

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

