/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.serializers;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.apache.tinkerpop.shaded.kryo.serializers.FieldSerializer;
import org.apache.tinkerpop.shaded.minlog.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;

    public TaggedFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    protected void initializeCachedFields() {
        Field field2;
        int i;
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fields.length;
        for (i = 0; i < n; ++i) {
            field2 = fields[i].getField();
            if (field2.getAnnotation(Tag.class) != null) continue;
            if (Log.TRACE) {
                Log.trace("kryo", "Ignoring field without tag: " + fields[i]);
            }
            super.removeField(fields[i]);
        }
        fields = this.getFields();
        this.tags = new int[fields.length];
        this.deprecated = new boolean[fields.length];
        this.writeFieldCount = fields.length;
        n = fields.length;
        for (i = 0; i < n; ++i) {
            field2 = fields[i].getField();
            this.tags[i] = field2.getAnnotation(Tag.class).value();
            if (field2.getAnnotation(Deprecated.class) == null) continue;
            this.deprecated[i] = true;
            --this.writeFieldCount;
        }
        this.removedFields.clear();
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void removeField(FieldSerializer.CachedField field2) {
        super.removeField(field2);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        output.writeVarInt(this.writeFieldCount, true);
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (this.deprecated[i]) continue;
            output.writeVarInt(this.tags[i], true);
            fields[i].write(output, object);
        }
    }

    @Override
    public T read(Kryo kryo, Input input2, Class<T> type) {
        T object = this.create(kryo, input2, type);
        kryo.reference(object);
        int fieldCount = input2.readVarInt(true);
        int[] tags = this.tags;
        FieldSerializer.CachedField[] fields = this.getFields();
        int n = fieldCount;
        for (int i = 0; i < n; ++i) {
            int tag = input2.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            int nn = tags.length;
            for (int ii = 0; ii < nn; ++ii) {
                if (tags[ii] != tag) continue;
                cachedField = fields[ii];
                break;
            }
            if (cachedField == null) {
                throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
            }
            cachedField.read(input2, object);
        }
        return object;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

