/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.serializers;

import java.lang.reflect.Field;
import java.util.List;
import org.apache.tinkerpop.shaded.kryo.FieldAccess;
import org.apache.tinkerpop.shaded.kryo.serializers.FieldSerializer;
import org.apache.tinkerpop.shaded.kryo.serializers.FieldSerializerUnsafeUtil;
import org.apache.tinkerpop.shaded.kryo.serializers.UnsafeCacheFields;
import org.apache.tinkerpop.shaded.kryo.util.IntArray;
import org.apache.tinkerpop.shaded.kryo.util.UnsafeUtil;
import org.apache.tinkerpop.shaded.minlog.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldSerializerUnsafeUtilImpl
implements FieldSerializerUnsafeUtil {
    private FieldSerializer serializer;

    public FieldSerializerUnsafeUtilImpl(FieldSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public void createUnsafeCacheFieldsAndRegions(List<Field> validFields, List<FieldSerializer.CachedField> cachedFields, int baseIndex, IntArray useAsm) {
        long startPrimitives = 0L;
        long endPrimitives = 0L;
        boolean lastWasPrimitive = false;
        int primitiveLength = 0;
        int lastAccessIndex = -1;
        Field lastField = null;
        long fieldOffset = -1L;
        long fieldEndOffset = -1L;
        long lastFieldEndOffset = -1L;
        int n = validFields.size();
        for (int i = 0; i < n; ++i) {
            Field field2 = validFields.get(i);
            int accessIndex = -1;
            if (this.serializer.access != null && useAsm.get(baseIndex + i) == 1) {
                accessIndex = ((FieldAccess)this.serializer.access).getIndex(field2.getName());
            }
            fieldOffset = UnsafeUtil.unsafe().objectFieldOffset(field2);
            fieldEndOffset = fieldOffset + (long)this.fieldSizeOf(field2.getType());
            if (!field2.getType().isPrimitive() && lastWasPrimitive) {
                endPrimitives = lastFieldEndOffset;
                lastWasPrimitive = false;
                if (primitiveLength > 1) {
                    if (Log.TRACE) {
                        Log.trace("kryo", "Class " + this.serializer.getType().getName() + ". Found a set of consecutive primitive fields. Number of fields = " + primitiveLength + ". Byte length = " + (endPrimitives - startPrimitives) + " Start offset = " + startPrimitives + " endOffset=" + endPrimitives);
                    }
                    UnsafeCacheFields.UnsafeRegionField cf = new UnsafeCacheFields.UnsafeRegionField(startPrimitives, endPrimitives - startPrimitives);
                    cf.field = lastField;
                    cachedFields.add(cf);
                } else if (lastField != null) {
                    cachedFields.add(this.serializer.newCachedField(lastField, cachedFields.size(), lastAccessIndex));
                }
                cachedFields.add(this.serializer.newCachedField(field2, cachedFields.size(), accessIndex));
            } else if (!field2.getType().isPrimitive()) {
                cachedFields.add(this.serializer.newCachedField(field2, cachedFields.size(), accessIndex));
            } else if (!lastWasPrimitive) {
                startPrimitives = fieldOffset;
                lastWasPrimitive = true;
                primitiveLength = 1;
            } else {
                ++primitiveLength;
            }
            lastAccessIndex = accessIndex;
            lastField = field2;
            lastFieldEndOffset = fieldEndOffset;
        }
        if (!this.serializer.getUseAsmEnabled() && this.serializer.getUseMemRegions() && lastWasPrimitive) {
            endPrimitives = lastFieldEndOffset;
            if (primitiveLength > 1) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Class " + this.serializer.getType().getName() + ". Found a set of consecutive primitive fields. Number of fields = " + primitiveLength + ". Byte length = " + (endPrimitives - startPrimitives) + " Start offset = " + startPrimitives + " endOffset=" + endPrimitives);
                }
                UnsafeCacheFields.UnsafeRegionField cf = new UnsafeCacheFields.UnsafeRegionField(startPrimitives, endPrimitives - startPrimitives);
                cf.field = lastField;
                cachedFields.add(cf);
            } else if (lastField != null) {
                cachedFields.add(this.serializer.newCachedField(lastField, cachedFields.size(), lastAccessIndex));
            }
        }
    }

    private int fieldSizeOf(Class<?> clazz2) {
        if (clazz2 == Integer.TYPE || clazz2 == Float.TYPE) {
            return 4;
        }
        if (clazz2 == Long.TYPE || clazz2 == Double.TYPE) {
            return 8;
        }
        if (clazz2 == Byte.TYPE || clazz2 == Boolean.TYPE) {
            return 1;
        }
        if (clazz2 == Short.TYPE || clazz2 == Character.TYPE) {
            return 2;
        }
        return UnsafeUtil.unsafe().addressSize();
    }

    @Override
    public long getObjectFieldOffset(Field field2) {
        return UnsafeUtil.unsafe().objectFieldOffset(field2);
    }
}

