/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.serializers;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.tinkerpop.shaded.kryo.Generics;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.serializers.FieldSerializer;
import org.apache.tinkerpop.shaded.kryo.serializers.ObjectField;
import org.apache.tinkerpop.shaded.minlog.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldSerializerGenericsUtil {
    private Kryo kryo;
    private FieldSerializer serializer;

    public FieldSerializerGenericsUtil(FieldSerializer serializer) {
        this.serializer = serializer;
        this.kryo = serializer.getKryo();
    }

    Generics buildGenericsScope(Class clazz2, Class[] generics) {
        Class typ2 = clazz2;
        TypeVariable<Class<Object>>[] typeParams2 = null;
        while (typ2 != null && ((typeParams2 = typ2 == this.serializer.type ? this.serializer.typeParameters : typ2.getTypeParameters()) == null || typeParams2.length == 0)) {
            if (typ2 == this.serializer.type) {
                typ2 = this.serializer.componentType;
                if (typ2 != null) continue;
                typ2 = this.serializer.type;
                Type superclass = null;
                do {
                    superclass = typ2.getGenericSuperclass();
                    typ2 = typ2.getSuperclass();
                } while (superclass != null && !(superclass instanceof ParameterizedType));
                if (superclass == null) break;
                ParameterizedType pt = (ParameterizedType)superclass;
                Type[] typeArgs2 = pt.getActualTypeArguments();
                typeParams2 = typ2.getTypeParameters();
                generics = new Class[typeArgs2.length];
                for (int i = 0; i < typeArgs2.length; ++i) {
                    generics[i] = typeArgs2[i] instanceof Class ? (Class)typeArgs2[i] : Object.class;
                }
                break;
            }
            typ2 = typ2.getComponentType();
        }
        if (typeParams2 != null && typeParams2.length > 0) {
            if (Log.TRACE) {
                Log.trace("kryo", "Class " + clazz2.getName() + " has generic type parameters");
            }
            int typeVarNum = 0;
            HashMap<String, Class> typeVar2concreteClass = new HashMap<String, Class>();
            for (TypeVariable typeVariable : typeParams2) {
                Class<?> concreteClass;
                String typeVarName = typeVariable.getName();
                if (Log.TRACE) {
                    Log.trace("kryo", "Type parameter variable: name=" + typeVarName + " type bounds=" + Arrays.toString(typeVariable.getBounds()));
                }
                if ((concreteClass = this.getTypeVarConcreteClass(generics, typeVarNum, typeVarName)) != null) {
                    typeVar2concreteClass.put(typeVarName, concreteClass);
                    if (Log.TRACE) {
                        Log.trace("kryo", "Concrete type used for " + typeVarName + " is: " + concreteClass.getName());
                    }
                }
                ++typeVarNum;
            }
            Generics genScope = new Generics(typeVar2concreteClass);
            return genScope;
        }
        return null;
    }

    private Class<?> getTypeVarConcreteClass(Class[] generics, int typeVarNum, String typeVarName) {
        Generics scope;
        if (generics != null && generics.length > typeVarNum) {
            return generics[typeVarNum];
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Trying to use kryo.getGenericScope");
        }
        if ((scope = this.kryo.getGenericsScope()) != null) {
            return scope.getConcreteClass(typeVarName);
        }
        return null;
    }

    Class[] computeFieldGenerics(Type fieldGenericType, Field field2, Class[] fieldClass) {
        Object[] fieldGenerics = null;
        if (fieldGenericType != null) {
            if (fieldGenericType instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                TypeVariable typeVar = (TypeVariable)fieldGenericType;
                Class concreteClass = this.serializer.getGenericsScope().getConcreteClass(typeVar.getName());
                if (concreteClass != null) {
                    fieldClass[0] = concreteClass;
                    fieldGenerics = new Class[]{fieldClass[0]};
                    if (Log.TRACE) {
                        Log.trace("kryo", "Determined concrete class of '" + field2.getName() + "' to be " + fieldClass[0].getName());
                    }
                }
            } else if (fieldGenericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)fieldGenericType;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                if (actualTypeArguments != null) {
                    fieldGenerics = new Class[actualTypeArguments.length];
                    for (int i = 0; i < actualTypeArguments.length; ++i) {
                        Type t = actualTypeArguments[i];
                        if (t instanceof Class) {
                            fieldGenerics[i] = (Class)t;
                            continue;
                        }
                        if (t instanceof ParameterizedType) {
                            fieldGenerics[i] = (Class)((ParameterizedType)t).getRawType();
                            continue;
                        }
                        if (t instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
                            fieldGenerics[i] = this.serializer.getGenericsScope().getConcreteClass(((TypeVariable)t).getName());
                            if (fieldGenerics[i] != null) continue;
                            fieldGenerics[i] = Object.class;
                            continue;
                        }
                        if (t instanceof WildcardType) {
                            fieldGenerics[i] = Object.class;
                            continue;
                        }
                        if (t instanceof GenericArrayType) {
                            Class clazz2;
                            Generics scope;
                            Type componentType = ((GenericArrayType)t).getGenericComponentType();
                            if (componentType instanceof Class) {
                                fieldGenerics[i] = Array.newInstance((Class)componentType, 0).getClass();
                                continue;
                            }
                            if (!(componentType instanceof TypeVariable) || (scope = this.serializer.getGenericsScope()) == null || (clazz2 = scope.getConcreteClass(((TypeVariable)componentType).getName())) == null) continue;
                            fieldGenerics[i] = Array.newInstance(clazz2, 0).getClass();
                            continue;
                        }
                        fieldGenerics[i] = null;
                    }
                    if (Log.TRACE && fieldGenerics != null) {
                        Log.trace("kryo", "Determined concrete class of parametrized '" + field2.getName() + "' to be " + fieldGenericType + " where type parameters are " + Arrays.toString(fieldGenerics));
                    }
                }
            } else if (fieldGenericType instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)fieldGenericType;
                Type genericComponentType = arrayType.getGenericComponentType();
                Class[] tmpFieldClass = new Class[]{fieldClass[0]};
                fieldGenerics = this.computeFieldGenerics(genericComponentType, field2, tmpFieldClass);
                if (Log.TRACE && fieldGenerics != null) {
                    Log.trace("kryo", "Determined concrete class of a generic array '" + field2.getName() + "' to be " + fieldGenericType + " where type parameters are " + Arrays.toString(fieldGenerics));
                } else if (Log.TRACE) {
                    Log.trace("kryo", "Determined concrete class of '" + field2.getName() + "' to be " + fieldGenericType);
                }
            }
        }
        return fieldGenerics;
    }

    FieldSerializer.CachedField newCachedFieldOfGenericType(Field field2, int accessIndex, Class[] fieldClass, Type fieldGenericType) {
        if (Log.TRACE) {
            Log.trace("kryo", "Field '" + field2.getName() + "' of type " + fieldClass[0] + " of generic type " + fieldGenericType);
        }
        if (Log.TRACE && fieldGenericType != null) {
            Log.trace("kryo", "Field generic type is of class " + fieldGenericType.getClass().getName());
        }
        Class[] cachedFieldGenerics = FieldSerializerGenericsUtil.getGenerics(fieldGenericType, this.kryo);
        Generics scope = this.buildGenericsScope(fieldClass[0], cachedFieldGenerics);
        if (fieldClass[0] == Object.class && fieldGenericType instanceof TypeVariable && this.serializer.getGenericsScope() != null) {
            TypeVariable typeVar = (TypeVariable)fieldGenericType;
            Class concreteClass = this.serializer.getGenericsScope().getConcreteClass(typeVar.getName());
            if (concreteClass != null) {
                scope = new Generics();
                scope.add(typeVar.getName(), concreteClass);
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Generics scope of field '" + field2.getName() + "' of class " + fieldGenericType + " is " + scope);
        }
        Object[] fieldGenerics = this.computeFieldGenerics(fieldGenericType, field2, fieldClass);
        FieldSerializer.CachedField cachedField = this.serializer.newMatchingCachedField(field2, accessIndex, fieldClass[0], fieldGenericType, (Class[])fieldGenerics);
        if (fieldGenerics != null && cachedField instanceof ObjectField && fieldGenerics.length > 0 && fieldGenerics[0] != null) {
            ((ObjectField)cachedField).generics = fieldGenerics;
            if (Log.TRACE) {
                Log.trace("kryo", "Field generics: " + Arrays.toString(fieldGenerics));
            }
        }
        return cachedField;
    }

    public static Class[] getGenerics(Type genericType, Kryo kryo) {
        if (genericType instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)genericType).getGenericComponentType();
            if (componentType instanceof Class) {
                return new Class[]{(Class)componentType};
            }
            return FieldSerializerGenericsUtil.getGenerics(componentType, kryo);
        }
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Processing generic type " + genericType);
        }
        Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
        Class[] generics = new Class[actualTypes.length];
        int count2 = 0;
        for (Type actualType : actualTypes) {
            if (Log.TRACE) {
                Log.trace("kryo", "Processing actual type " + actualType + " (" + actualType.getClass().getName() + ")");
            }
            generics[i] = Object.class;
            if (actualType instanceof Class) {
                generics[i] = (Class)actualType;
            } else if (actualType instanceof ParameterizedType) {
                generics[i] = (Class)((ParameterizedType)actualType).getRawType();
            } else if (actualType instanceof TypeVariable) {
                Class clazz2;
                Generics scope = kryo.getGenericsScope();
                if (scope == null || (clazz2 = scope.getConcreteClass(((TypeVariable)actualType).getName())) == null) continue;
                generics[i] = clazz2;
            } else {
                if (!(actualType instanceof GenericArrayType)) continue;
                Type componentType = ((GenericArrayType)actualType).getGenericComponentType();
                if (componentType instanceof Class) {
                    generics[i] = Array.newInstance((Class)componentType, 0).getClass();
                } else if (componentType instanceof TypeVariable) {
                    Class clazz3;
                    Generics scope = kryo.getGenericsScope();
                    if (scope != null && (clazz3 = scope.getConcreteClass(((TypeVariable)componentType).getName())) != null) {
                        generics[i] = Array.newInstance(clazz3, 0).getClass();
                    }
                } else {
                    Class[] componentGenerics = FieldSerializerGenericsUtil.getGenerics(componentType, kryo);
                    if (componentGenerics != null) {
                        generics[i] = componentGenerics[0];
                    }
                }
            }
            ++count2;
        }
        if (count2 == 0) {
            return null;
        }
        return generics;
    }
}

