/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.serializers;

import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumNameSerializer
extends Serializer<Enum> {
    private final Class<? extends Enum> enumType;
    private final Serializer stringSerializer;

    public EnumNameSerializer(Kryo kryo, Class<? extends Enum> type) {
        this.enumType = type;
        this.stringSerializer = kryo.getSerializer(String.class);
        this.setImmutable(true);
    }

    @Override
    public void write(Kryo kryo, Output output, Enum object) {
        kryo.writeObject(output, object.name(), this.stringSerializer);
    }

    @Override
    public Enum read(Kryo kryo, Input input2, Class<Enum> type) {
        String name2 = kryo.readObject(input2, String.class, this.stringSerializer);
        try {
            return Enum.valueOf(this.enumType, name2);
        }
        catch (IllegalArgumentException e) {
            throw new KryoException("Invalid name for enum \"" + this.enumType.getName() + "\": " + name2, e);
        }
    }
}

