/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.serializers;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.KryoSerializable;
import org.apache.tinkerpop.shaded.kryo.Registration;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;
import org.apache.tinkerpop.shaded.kryo.serializers.CollectionSerializer;
import org.apache.tinkerpop.shaded.kryo.serializers.MapSerializer;
import org.apache.tinkerpop.shaded.kryo.util.Util;

public class DefaultSerializers {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocaleSerializer
    extends Serializer<Locale> {
        public static final Locale SPANISH = new Locale("es", "", "");
        public static final Locale SPAIN = new Locale("es", "ES", "");

        public LocaleSerializer() {
            this.setImmutable(true);
        }

        protected Locale create(String language2, String country, String variant) {
            Locale defaultLocale = Locale.getDefault();
            if (LocaleSerializer.isSameLocale(defaultLocale, language2, country, variant)) {
                return defaultLocale;
            }
            if (defaultLocale != Locale.US && LocaleSerializer.isSameLocale(Locale.US, language2, country, variant)) {
                return Locale.US;
            }
            if (LocaleSerializer.isSameLocale(Locale.ENGLISH, language2, country, variant)) {
                return Locale.ENGLISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMAN, language2, country, variant)) {
                return Locale.GERMAN;
            }
            if (LocaleSerializer.isSameLocale(SPANISH, language2, country, variant)) {
                return SPANISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRENCH, language2, country, variant)) {
                return Locale.FRENCH;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALIAN, language2, country, variant)) {
                return Locale.ITALIAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPANESE, language2, country, variant)) {
                return Locale.JAPANESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREAN, language2, country, variant)) {
                return Locale.KOREAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.SIMPLIFIED_CHINESE, language2, country, variant)) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.CHINESE, language2, country, variant)) {
                return Locale.CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.TRADITIONAL_CHINESE, language2, country, variant)) {
                return Locale.TRADITIONAL_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.UK, language2, country, variant)) {
                return Locale.UK;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMANY, language2, country, variant)) {
                return Locale.GERMANY;
            }
            if (LocaleSerializer.isSameLocale(SPAIN, language2, country, variant)) {
                return SPAIN;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRANCE, language2, country, variant)) {
                return Locale.FRANCE;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALY, language2, country, variant)) {
                return Locale.ITALY;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPAN, language2, country, variant)) {
                return Locale.JAPAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREA, language2, country, variant)) {
                return Locale.KOREA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA, language2, country, variant)) {
                return Locale.CANADA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA_FRENCH, language2, country, variant)) {
                return Locale.CANADA_FRENCH;
            }
            return new Locale(language2, country, variant);
        }

        @Override
        public void write(Kryo kryo, Output output, Locale l) {
            output.writeAscii(l.getLanguage());
            output.writeAscii(l.getCountry());
            output.writeString(l.getVariant());
        }

        @Override
        public Locale read(Kryo kryo, Input input2, Class<Locale> type) {
            String language2 = input2.readString();
            String country = input2.readString();
            String variant = input2.readString();
            return this.create(language2, country, variant);
        }

        protected static boolean isSameLocale(Locale locale, String language2, String country, String variant) {
            try {
                return locale.getLanguage().equals(language2) && locale.getCountry().equals(country) && locale.getVariant().equals(variant);
            }
            catch (NullPointerException npe) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeSetSerializer
    extends CollectionSerializer {
        @Override
        public void write(Kryo kryo, Output output, Collection collection2) {
            TreeSet treeSet = (TreeSet)collection2;
            kryo.writeClassAndObject(output, treeSet.comparator());
            super.write(kryo, output, collection2);
        }

        @Override
        protected TreeSet create(Kryo kryo, Input input2, Class<Collection> type) {
            return this.createTreeSet(type, (Comparator)kryo.readClassAndObject(input2));
        }

        @Override
        protected TreeSet createCopy(Kryo kryo, Collection original) {
            return this.createTreeSet(original.getClass(), ((TreeSet)original).comparator());
        }

        private TreeSet createTreeSet(Class<? extends Collection> type, Comparator comparator) {
            if (type != TreeSet.class && type != null) {
                try {
                    Constructor<? extends Collection> constructor = type.getConstructor(Comparator.class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return (TreeSet)constructor.newInstance(comparator);
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            return new TreeSet(comparator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeMapSerializer
    extends MapSerializer {
        @Override
        public void write(Kryo kryo, Output output, Map map2) {
            TreeMap treeMap = (TreeMap)map2;
            kryo.writeClassAndObject(output, treeMap.comparator());
            super.write(kryo, output, map2);
        }

        @Override
        protected Map create(Kryo kryo, Input input2, Class<Map> type) {
            return this.createTreeMap(type, (Comparator)kryo.readClassAndObject(input2));
        }

        @Override
        protected Map createCopy(Kryo kryo, Map original) {
            return this.createTreeMap(original.getClass(), ((TreeMap)original).comparator());
        }

        private TreeMap createTreeMap(Class<? extends Map> type, Comparator comparator) {
            if (type != TreeMap.class && type != null) {
                try {
                    Constructor<? extends Map> constructor = type.getConstructor(Comparator.class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return (TreeMap)constructor.newInstance(comparator);
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            return new TreeMap(comparator);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CalendarSerializer
    extends Serializer<Calendar> {
        private static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
        TimeZoneSerializer timeZoneSerializer = new TimeZoneSerializer();

        @Override
        public void write(Kryo kryo, Output output, Calendar object) {
            this.timeZoneSerializer.write(kryo, output, object.getTimeZone());
            output.writeLong(object.getTimeInMillis(), true);
            output.writeBoolean(object.isLenient());
            output.writeInt(object.getFirstDayOfWeek(), true);
            output.writeInt(object.getMinimalDaysInFirstWeek(), true);
            if (object instanceof GregorianCalendar) {
                output.writeLong(((GregorianCalendar)object).getGregorianChange().getTime(), false);
            } else {
                output.writeLong(-12219292800000L, false);
            }
        }

        @Override
        public Calendar read(Kryo kryo, Input input2, Class<Calendar> type) {
            Calendar result2 = Calendar.getInstance((TimeZone)this.timeZoneSerializer.read(kryo, input2, (Class)TimeZone.class));
            result2.setTimeInMillis(input2.readLong(true));
            result2.setLenient(input2.readBoolean());
            result2.setFirstDayOfWeek(input2.readInt(true));
            result2.setMinimalDaysInFirstWeek(input2.readInt(true));
            long gregorianChange = input2.readLong(false);
            if (gregorianChange != -12219292800000L && result2 instanceof GregorianCalendar) {
                ((GregorianCalendar)result2).setGregorianChange(new java.util.Date(gregorianChange));
            }
            return result2;
        }

        @Override
        public Calendar copy(Kryo kryo, Calendar original) {
            return (Calendar)original.clone();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TimeZoneSerializer
    extends Serializer<TimeZone> {
        public TimeZoneSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, TimeZone object) {
            output.writeString(object.getID());
        }

        @Override
        public TimeZone read(Kryo kryo, Input input2, Class<TimeZone> type) {
            return TimeZone.getTimeZone(input2.readString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonSetSerializer
    extends Serializer<Set> {
        public CollectionsSingletonSetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Set object) {
            kryo.writeClassAndObject(output, object.iterator().next());
        }

        @Override
        public Set read(Kryo kryo, Input input2, Class type) {
            return Collections.singleton(kryo.readClassAndObject(input2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonMapSerializer
    extends Serializer<Map> {
        public CollectionsSingletonMapSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Map object) {
            Map.Entry entry2 = object.entrySet().iterator().next();
            kryo.writeClassAndObject(output, entry2.getKey());
            kryo.writeClassAndObject(output, entry2.getValue());
        }

        @Override
        public Map read(Kryo kryo, Input input2, Class type) {
            Object key = kryo.readClassAndObject(input2);
            Object value2 = kryo.readClassAndObject(input2);
            return Collections.singletonMap(key, value2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionsSingletonListSerializer
    extends Serializer<List> {
        public CollectionsSingletonListSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, List object) {
            kryo.writeClassAndObject(output, object.get(0));
        }

        @Override
        public List read(Kryo kryo, Input input2, Class type) {
            return Collections.singletonList(kryo.readClassAndObject(input2));
        }
    }

    public static class CollectionsEmptySetSerializer
    extends Serializer {
        public CollectionsEmptySetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input2, Class type) {
            return Collections.EMPTY_SET;
        }
    }

    public static class CollectionsEmptyMapSerializer
    extends Serializer {
        public CollectionsEmptyMapSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input2, Class type) {
            return Collections.EMPTY_MAP;
        }
    }

    public static class CollectionsEmptyListSerializer
    extends Serializer {
        public CollectionsEmptyListSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input2, Class type) {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KryoSerializableSerializer
    extends Serializer<KryoSerializable> {
        @Override
        public void write(Kryo kryo, Output output, KryoSerializable object) {
            object.write(kryo, output);
        }

        @Override
        public KryoSerializable read(Kryo kryo, Input input2, Class<KryoSerializable> type) {
            KryoSerializable object = kryo.newInstance(type);
            kryo.reference(object);
            object.read(kryo, input2);
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        public StringBuilderSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuilder object) {
            output.writeString(object);
        }

        @Override
        public StringBuilder read(Kryo kryo, Input input2, Class<StringBuilder> type) {
            return input2.readStringBuilder();
        }

        @Override
        public StringBuilder copy(Kryo kryo, StringBuilder original) {
            return new StringBuilder(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringBufferSerializer
    extends Serializer<StringBuffer> {
        public StringBufferSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuffer object) {
            output.writeString(object);
        }

        @Override
        public StringBuffer read(Kryo kryo, Input input2, Class<StringBuffer> type) {
            String value2 = input2.readString();
            if (value2 == null) {
                return null;
            }
            return new StringBuffer(value2);
        }

        @Override
        public StringBuffer copy(Kryo kryo, StringBuffer original) {
            return new StringBuffer(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Currency object) {
            output.writeString(object == null ? null : object.getCurrencyCode());
        }

        @Override
        public Currency read(Kryo kryo, Input input2, Class<Currency> type) {
            String currencyCode = input2.readString();
            if (currencyCode == null) {
                return null;
            }
            return Currency.getInstance(currencyCode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSetSerializer
    extends Serializer<EnumSet> {
        @Override
        public void write(Kryo kryo, Output output, EnumSet object) {
            Serializer serializer;
            if (object.isEmpty()) {
                EnumSet tmp = EnumSet.complementOf(object);
                if (tmp.isEmpty()) {
                    throw new KryoException("An EnumSet must have a defined Enum to be serialized.");
                }
                serializer = kryo.writeClass(output, tmp.iterator().next().getClass()).getSerializer();
            } else {
                serializer = kryo.writeClass(output, object.iterator().next().getClass()).getSerializer();
            }
            output.writeInt(object.size(), true);
            for (Object element : object) {
                serializer.write(kryo, output, element);
            }
        }

        @Override
        public EnumSet read(Kryo kryo, Input input2, Class<EnumSet> type) {
            Registration registration = kryo.readClass(input2);
            EnumSet object = EnumSet.noneOf(registration.getType());
            Serializer serializer = registration.getSerializer();
            int length = input2.readInt(true);
            for (int i = 0; i < length; ++i) {
                object.add(serializer.read(kryo, input2, null));
            }
            return object;
        }

        @Override
        public EnumSet copy(Kryo kryo, EnumSet original) {
            return EnumSet.copyOf(original);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumSerializer
    extends Serializer<Enum> {
        private Object[] enumConstants;

        public EnumSerializer(Class<? extends Enum> type) {
            this.setImmutable(true);
            this.setAcceptsNull(true);
            this.enumConstants = type.getEnumConstants();
            if (this.enumConstants == null) {
                throw new IllegalArgumentException("The type must be an enum: " + type);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Enum object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.ordinal() + 1, true);
        }

        @Override
        public Enum read(Kryo kryo, Input input2, Class<Enum> type) {
            int ordinal = input2.readVarInt(true);
            if (ordinal == 0) {
                return null;
            }
            if (--ordinal < 0 || ordinal > this.enumConstants.length - 1) {
                throw new KryoException("Invalid ordinal for enum \"" + type.getName() + "\": " + ordinal);
            }
            Object constant = this.enumConstants[ordinal];
            return (Enum)constant;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateSerializer
    extends Serializer<java.util.Date> {
        private java.util.Date create(Kryo kryo, Class<? extends java.util.Date> type, long time) throws KryoException {
            if (type == java.util.Date.class || type == null) {
                return new java.util.Date(time);
            }
            if (type == Timestamp.class) {
                return new Timestamp(time);
            }
            if (type == Date.class) {
                return new Date(time);
            }
            if (type == Time.class) {
                return new Time(time);
            }
            try {
                Constructor<? extends java.util.Date> constructor = type.getConstructor(Long.TYPE);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(time);
            }
            catch (Exception ex) {
                java.util.Date d = kryo.newInstance(type);
                d.setTime(time);
                return d;
            }
        }

        @Override
        public void write(Kryo kryo, Output output, java.util.Date object) {
            output.writeLong(object.getTime(), true);
        }

        @Override
        public java.util.Date read(Kryo kryo, Input input2, Class<java.util.Date> type) {
            return this.create(kryo, type, input2.readLong(true));
        }

        @Override
        public java.util.Date copy(Kryo kryo, java.util.Date original) {
            return this.create(kryo, original.getClass(), original.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassSerializer
    extends Serializer<Class> {
        public ClassSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Class object) {
            kryo.writeClass(output, object);
            output.writeByte(object != null && object.isPrimitive() ? 1 : 0);
        }

        @Override
        public Class read(Kryo kryo, Input input2, Class<Class> type) {
            Class typ2;
            Registration registration = kryo.readClass(input2);
            int isPrimitive = input2.read();
            Class clazz2 = typ2 = registration != null ? registration.getType() : null;
            if (typ2 == null || !typ2.isPrimitive()) {
                return typ2;
            }
            return isPrimitive == 1 ? typ2 : Util.getWrapperClass(typ2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        private final BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

        public BigDecimalSerializer() {
            this.setAcceptsNull(true);
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigDecimal object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            BigDecimal value2 = object;
            if (value2 == BigDecimal.ZERO) {
                this.bigIntegerSerializer.write(kryo, output, BigInteger.ZERO);
                output.writeInt(0, false);
                return;
            }
            this.bigIntegerSerializer.write(kryo, output, value2.unscaledValue());
            output.writeInt(value2.scale(), false);
        }

        @Override
        public BigDecimal read(Kryo kryo, Input input2, Class<BigDecimal> type) {
            Object unscaledValue = this.bigIntegerSerializer.read(kryo, input2, (Class)BigInteger.class);
            if (unscaledValue == null) {
                return null;
            }
            int scale = input2.readInt(false);
            if (type != BigDecimal.class && type != null) {
                try {
                    Constructor<BigDecimal> constructor = type.getConstructor(BigInteger.class, Integer.TYPE);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return constructor.newInstance(unscaledValue, scale);
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            if (unscaledValue == BigInteger.ZERO && scale == 0) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal((BigInteger)unscaledValue, scale);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigInteger object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            BigInteger value2 = object;
            if (value2 == BigInteger.ZERO) {
                output.writeVarInt(2, true);
                output.writeByte(0);
                return;
            }
            byte[] bytes2 = value2.toByteArray();
            output.writeVarInt(bytes2.length + 1, true);
            output.writeBytes(bytes2);
        }

        @Override
        public BigInteger read(Kryo kryo, Input input2, Class<BigInteger> type) {
            int length = input2.readVarInt(true);
            if (length == 0) {
                return null;
            }
            byte[] bytes2 = input2.readBytes(length - 1);
            if (type != BigInteger.class && type != null) {
                try {
                    Constructor<BigInteger> constructor = type.getConstructor(byte[].class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return constructor.newInstance(new Object[]{bytes2});
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            if (length == 2) {
                switch (bytes2[0]) {
                    case 0: {
                        return BigInteger.ZERO;
                    }
                    case 1: {
                        return BigInteger.ONE;
                    }
                    case 10: {
                        return BigInteger.TEN;
                    }
                }
            }
            return new BigInteger(bytes2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringSerializer
    extends Serializer<String> {
        public StringSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String object) {
            output.writeString(object);
        }

        @Override
        public String read(Kryo kryo, Input input2, Class<String> type) {
            return input2.readString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleSerializer
    extends Serializer<Double> {
        public DoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Double object) {
            output.writeDouble(object);
        }

        @Override
        public Double read(Kryo kryo, Input input2, Class<Double> type) {
            return input2.readDouble();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatSerializer
    extends Serializer<Float> {
        public FloatSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Float object) {
            output.writeFloat(object.floatValue());
        }

        @Override
        public Float read(Kryo kryo, Input input2, Class<Float> type) {
            return Float.valueOf(input2.readFloat());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongSerializer
    extends Serializer<Long> {
        public LongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Long object) {
            output.writeLong(object, false);
        }

        @Override
        public Long read(Kryo kryo, Input input2, Class<Long> type) {
            return input2.readLong(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntSerializer
    extends Serializer<Integer> {
        public IntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Integer object) {
            output.writeInt(object, false);
        }

        @Override
        public Integer read(Kryo kryo, Input input2, Class<Integer> type) {
            return input2.readInt(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShortSerializer
    extends Serializer<Short> {
        public ShortSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Short object) {
            output.writeShort(object.shortValue());
        }

        @Override
        public Short read(Kryo kryo, Input input2, Class<Short> type) {
            return input2.readShort();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharSerializer
    extends Serializer<Character> {
        public CharSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Character object) {
            output.writeChar(object.charValue());
        }

        @Override
        public Character read(Kryo kryo, Input input2, Class<Character> type) {
            return Character.valueOf(input2.readChar());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByteSerializer
    extends Serializer<Byte> {
        public ByteSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Byte object) {
            output.writeByte(object);
        }

        @Override
        public Byte read(Kryo kryo, Input input2, Class<Byte> type) {
            return input2.readByte();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanSerializer
    extends Serializer<Boolean> {
        public BooleanSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Boolean object) {
            output.writeBoolean(object);
        }

        @Override
        public Boolean read(Kryo kryo, Input input2, Class<Boolean> type) {
            return input2.readBoolean();
        }
    }

    public static class VoidSerializer
    extends Serializer {
        public VoidSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input2, Class type) {
            return null;
        }
    }
}

