/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.io;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.io.ByteBufferOutput;
import org.apache.tinkerpop.shaded.kryo.util.UnsafeUtil;
import org.apache.tinkerpop.shaded.kryo.util.Util;
import sun.nio.ch.DirectBuffer;

public final class UnsafeMemoryOutput
extends ByteBufferOutput {
    private long bufaddress;
    private static final boolean isLittleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);

    public UnsafeMemoryOutput() {
        this.varIntsEnabled = false;
    }

    public UnsafeMemoryOutput(int bufferSize) {
        this(bufferSize, bufferSize);
    }

    public UnsafeMemoryOutput(int bufferSize, int maxBufferSize) {
        super(bufferSize, maxBufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(OutputStream outputStream) {
        super(outputStream);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(OutputStream outputStream, int bufferSize) {
        super(outputStream, bufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryOutput(long address, int maxBufferSize) {
        super(address, maxBufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public void setBuffer(ByteBuffer buffer, int maxBufferSize) {
        super.setBuffer(buffer, maxBufferSize);
        this.updateBufferAddress();
    }

    private void updateBufferAddress() {
        this.bufaddress = ((DirectBuffer)((Object)this.niobuffer)).address();
    }

    public final void writeInt(int value2) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putInt(this.bufaddress + (long)this.position, value2);
        this.position += 4;
    }

    public final void writeFloat(float value2) throws KryoException {
        this.require(4);
        UnsafeUtil.unsafe().putFloat(this.bufaddress + (long)this.position, value2);
        this.position += 4;
    }

    public final void writeShort(int value2) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putShort(this.bufaddress + (long)this.position, (short)value2);
        this.position += 2;
    }

    public final void writeLong(long value2) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putLong(this.bufaddress + (long)this.position, value2);
        this.position += 8;
    }

    public final void writeByte(int value2) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeByte(value2);
    }

    public void writeByte(byte value2) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeByte(value2);
    }

    public final void writeBoolean(boolean value2) throws KryoException {
        this.niobuffer.position(this.position);
        super.writeBoolean(value2);
    }

    public final void writeChar(char value2) throws KryoException {
        this.require(2);
        UnsafeUtil.unsafe().putChar(this.bufaddress + (long)this.position, value2);
        this.position += 2;
    }

    public final void writeDouble(double value2) throws KryoException {
        this.require(8);
        UnsafeUtil.unsafe().putDouble(this.bufaddress + (long)this.position, value2);
        this.position += 8;
    }

    public final int writeInt(int value2, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeInt(value2);
            return 4;
        }
        return this.writeVarInt(value2, optimizePositive);
    }

    public final int writeLong(long value2, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            this.writeLong(value2);
            return 8;
        }
        return this.writeVarLong(value2, optimizePositive);
    }

    public final int writeVarInt(int val, boolean optimizePositive) throws KryoException {
        long value2 = val;
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 31;
        }
        long varInt = 0L;
        varInt = value2 & 0x7FL;
        if ((value2 >>>= 7) == 0L) {
            this.writeByte((byte)varInt);
            return 1;
        }
        varInt |= 0x80L;
        varInt |= (value2 & 0x7FL) << 8;
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)varInt);
            this.position -= 2;
            return 2;
        }
        varInt |= 0x8000L;
        varInt |= (value2 & 0x7FL) << 16;
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)varInt);
            --this.position;
            return 3;
        }
        varInt |= 0x800000L;
        varInt |= (value2 & 0x7FL) << 24;
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianInt((int)varInt);
            this.position -= 0;
            return 4;
        }
        varInt |= Integer.MIN_VALUE;
        varInt |= (value2 & 0x7FL) << 32;
        this.writeLittleEndianLong(varInt &= 0xFFFFFFFFL);
        this.position -= 3;
        return 5;
    }

    public final int writeVarLong(long value2, boolean optimizePositive) throws KryoException {
        if (!optimizePositive) {
            value2 = value2 << 1 ^ value2 >> 63;
        }
        int varInt = 0;
        varInt = (int)(value2 & 0x7FL);
        if ((value2 >>>= 7) == 0L) {
            this.write(varInt);
            return 1;
        }
        varInt |= 0x80;
        varInt = (int)((long)varInt | (value2 & 0x7FL) << 8);
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            this.position -= 2;
            return 2;
        }
        varInt |= 0x8000;
        varInt = (int)((long)varInt | (value2 & 0x7FL) << 16);
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            --this.position;
            return 3;
        }
        varInt |= 0x800000;
        varInt = (int)((long)varInt | (value2 & 0x7FL) << 24);
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianInt(varInt);
            this.position -= 0;
            return 4;
        }
        long varLong = (long)(varInt |= Integer.MIN_VALUE) & 0xFFFFFFFFL | (value2 & 0x7FL) << 32;
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            this.position -= 3;
            return 5;
        }
        varLong |= 0x8000000000L;
        varLong |= (value2 & 0x7FL) << 40;
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            this.position -= 2;
            return 6;
        }
        varLong |= 0x800000000000L;
        varLong |= (value2 & 0x7FL) << 48;
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            --this.position;
            return 7;
        }
        varLong |= 0x80000000000000L;
        varLong |= (value2 & 0x7FL) << 56;
        if ((value2 >>>= 7) == 0L) {
            this.writeLittleEndianLong(varLong);
            return 8;
        }
        this.writeLittleEndianLong(varLong |= Long.MIN_VALUE);
        this.write((byte)(value2 & 0x7FL));
        return 9;
    }

    private final void writeLittleEndianInt(int val) {
        if (isLittleEndian) {
            this.writeInt(val);
        } else {
            this.writeInt(Util.swapInt(val));
        }
    }

    private final void writeLittleEndianLong(long val) {
        if (isLittleEndian) {
            this.writeLong(val);
        } else {
            this.writeLong(Util.swapLong(val));
        }
    }

    public final void writeInts(int[] object, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = object.length << 2;
            this.writeBytes(object, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
        } else {
            super.writeInts(object, optimizePositive);
        }
    }

    public final void writeLongs(long[] object, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = object.length << 3;
            this.writeBytes(object, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
        } else {
            super.writeLongs(object, optimizePositive);
        }
    }

    public final void writeInts(int[] object) throws KryoException {
        int bytesToCopy = object.length << 2;
        this.writeBytes(object, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeLongs(long[] object) throws KryoException {
        int bytesToCopy = object.length << 3;
        this.writeBytes(object, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeFloats(float[] object) throws KryoException {
        int bytesToCopy = object.length << 2;
        this.writeBytes(object, UnsafeUtil.floatArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeShorts(short[] object) throws KryoException {
        int bytesToCopy = object.length << 1;
        this.writeBytes(object, UnsafeUtil.shortArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeChars(char[] object) throws KryoException {
        int bytesToCopy = object.length << 1;
        this.writeBytes(object, UnsafeUtil.charArrayBaseOffset, 0L, bytesToCopy);
    }

    public final void writeDoubles(double[] object) throws KryoException {
        int bytesToCopy = object.length << 3;
        this.writeBytes(object, UnsafeUtil.doubleArrayBaseOffset, 0L, bytesToCopy);
    }

    public void writeBytes(byte[] bytes2) throws KryoException {
        if (bytes2 == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.writeBytes((Object)bytes2, 0L, (long)bytes2.length);
    }

    public final void writeBytes(Object obj, long offset, long count2) throws KryoException {
        this.writeBytes(obj, UnsafeUtil.byteArrayBaseOffset, offset, count2);
    }

    private final void writeBytes(Object srcArray, long srcArrayTypeOffset, long srcOffset, long count2) throws KryoException {
        int copyCount = Math.min(this.capacity - this.position, (int)count2);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(srcArray, srcArrayTypeOffset + srcOffset, null, this.bufaddress + (long)this.position, copyCount);
            this.position += copyCount;
            if ((count2 -= (long)copyCount) == 0L) {
                return;
            }
            srcOffset += (long)copyCount;
            copyCount = Math.min(this.capacity, (int)count2);
            this.require(copyCount);
        }
    }
}

