/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.kryo.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.tinkerpop.shaded.kryo.KryoException;
import org.apache.tinkerpop.shaded.kryo.io.ByteBufferInput;
import org.apache.tinkerpop.shaded.kryo.util.UnsafeUtil;
import sun.nio.ch.DirectBuffer;

public final class UnsafeMemoryInput
extends ByteBufferInput {
    private long bufaddress;

    public UnsafeMemoryInput() {
        this.varIntsEnabled = false;
    }

    public UnsafeMemoryInput(int bufferSize) {
        super(bufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(byte[] buffer) {
        super(buffer);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(ByteBuffer buffer) {
        super(buffer);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(long address, int maxBufferSize) {
        super(address, maxBufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(InputStream inputStream) {
        super(inputStream);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public UnsafeMemoryInput(InputStream inputStream, int bufferSize) {
        super(inputStream, bufferSize);
        this.varIntsEnabled = false;
        this.updateBufferAddress();
    }

    public void setBuffer(ByteBuffer buffer) {
        super.setBuffer(buffer);
        this.updateBufferAddress();
    }

    private void updateBufferAddress() {
        this.bufaddress = ((DirectBuffer)((Object)this.niobuffer)).address();
    }

    public int readInt() throws KryoException {
        this.require(4);
        int result2 = UnsafeUtil.unsafe().getInt(this.bufaddress + (long)this.position);
        this.position += 4;
        return result2;
    }

    public float readFloat() throws KryoException {
        this.require(4);
        float result2 = UnsafeUtil.unsafe().getFloat(this.bufaddress + (long)this.position);
        this.position += 4;
        return result2;
    }

    public short readShort() throws KryoException {
        this.require(2);
        short result2 = UnsafeUtil.unsafe().getShort(this.bufaddress + (long)this.position);
        this.position += 2;
        return result2;
    }

    public long readLong() throws KryoException {
        this.require(8);
        long result2 = UnsafeUtil.unsafe().getLong(this.bufaddress + (long)this.position);
        this.position += 8;
        return result2;
    }

    public boolean readBoolean() throws KryoException {
        this.niobuffer.position(this.position);
        return super.readBoolean();
    }

    public byte readByte() throws KryoException {
        this.niobuffer.position(this.position);
        return super.readByte();
    }

    public char readChar() throws KryoException {
        this.require(2);
        char result2 = UnsafeUtil.unsafe().getChar(this.bufaddress + (long)this.position);
        this.position += 2;
        return result2;
    }

    public double readDouble() throws KryoException {
        this.require(8);
        double result2 = UnsafeUtil.unsafe().getDouble(this.bufaddress + (long)this.position);
        this.position += 8;
        return result2;
    }

    public int readInt(boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            return this.readInt();
        }
        return super.readInt(optimizePositive);
    }

    public long readLong(boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            return this.readLong();
        }
        return super.readLong(optimizePositive);
    }

    public final int[] readInts(int length, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = length << 2;
            int[] array2 = new int[length];
            this.readBytes(array2, UnsafeUtil.intArrayBaseOffset, 0L, bytesToCopy);
            return array2;
        }
        return super.readInts(length, optimizePositive);
    }

    public final long[] readLongs(int length, boolean optimizePositive) throws KryoException {
        if (!this.varIntsEnabled) {
            int bytesToCopy = length << 3;
            long[] array2 = new long[length];
            this.readBytes(array2, UnsafeUtil.longArrayBaseOffset, 0L, bytesToCopy);
            return array2;
        }
        return super.readLongs(length, optimizePositive);
    }

    public final float[] readFloats(int length) throws KryoException {
        int bytesToCopy = length << 2;
        float[] array2 = new float[length];
        this.readBytes(array2, UnsafeUtil.floatArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    public final short[] readShorts(int length) throws KryoException {
        int bytesToCopy = length << 1;
        short[] array2 = new short[length];
        this.readBytes(array2, UnsafeUtil.shortArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    public final char[] readChars(int length) throws KryoException {
        int bytesToCopy = length << 1;
        char[] array2 = new char[length];
        this.readBytes(array2, UnsafeUtil.charArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    public final double[] readDoubles(int length) throws KryoException {
        int bytesToCopy = length << 3;
        double[] array2 = new double[length];
        this.readBytes(array2, UnsafeUtil.doubleArrayBaseOffset, 0L, bytesToCopy);
        return array2;
    }

    public byte[] readBytes(int length) throws KryoException {
        byte[] bytes2 = new byte[length];
        this.readBytes((Object)bytes2, 0L, (long)bytes2.length);
        return bytes2;
    }

    public final void readBytes(Object dstObj, long offset, long count2) throws KryoException {
        if (!dstObj.getClass().isArray()) {
            throw new KryoException("Only bulk reads of arrays is supported");
        }
        this.readBytes(dstObj, UnsafeUtil.byteArrayBaseOffset, offset, (int)count2);
    }

    private final void readBytes(Object dstObj, long dstArrayTypeOffset, long offset, int count2) throws KryoException {
        int copyCount = Math.min(this.limit - this.position, count2);
        while (true) {
            UnsafeUtil.unsafe().copyMemory(null, this.bufaddress + (long)this.position, dstObj, dstArrayTypeOffset + offset, copyCount);
            this.position += copyCount;
            if ((count2 -= copyCount) == 0) break;
            offset += (long)copyCount;
            copyCount = Math.min(count2, this.capacity);
            this.require(copyCount);
        }
    }
}

