/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.util;

import java.io.Serializable;
import org.apache.tinkerpop.shaded.jackson.databind.AnnotationIntrospector;
import org.apache.tinkerpop.shaded.jackson.databind.BeanDescription;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.PropertyName;
import org.apache.tinkerpop.shaded.jackson.databind.cfg.MapperConfig;
import org.apache.tinkerpop.shaded.jackson.databind.introspect.AnnotatedClass;
import org.apache.tinkerpop.shaded.jackson.databind.type.ClassKey;
import org.apache.tinkerpop.shaded.jackson.databind.util.LRUMap;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name2 = this._rootNames.get(key);
        if (name2 != null) {
            return name2;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name2 = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name2 == null || !name2.hasSimpleName()) {
            name2 = PropertyName.construct(rootType.getSimpleName());
        }
        this._rootNames.put(key, name2);
        return name2;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

