/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.ser.impl;

import java.io.IOException;
import java.util.List;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.BeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializationFeature;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.annotation.JacksonStdImpl;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.ContainerSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.impl.PropertySerializerMap;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.AsArraySerializerBase;

@JacksonStdImpl
public final class IndexedListSerializer
extends AsArraySerializerBase<List<?>> {
    private static final long serialVersionUID = 1L;

    public IndexedListSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, JsonSerializer<Object> valueSerializer) {
        super(List.class, elemType, staticTyping, vts, valueSerializer);
    }

    public IndexedListSerializer(IndexedListSerializer src, BeanProperty property, TypeSerializer vts, JsonSerializer<?> valueSerializer, Boolean unwrapSingle) {
        super(src, property, vts, valueSerializer, unwrapSingle);
    }

    public IndexedListSerializer withResolved(BeanProperty property, TypeSerializer vts, JsonSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new IndexedListSerializer(this, property, vts, elementSerializer, unwrapSingle);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, List<?> value2) {
        return value2.isEmpty();
    }

    @Override
    public boolean hasSingleElement(List<?> value2) {
        return value2.size() == 1;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IndexedListSerializer(this, this._property, vts, this._elementSerializer, this._unwrapSingle);
    }

    @Override
    public final void serialize(List<?> value2, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value2.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value2, gen, provider);
            return;
        }
        gen.writeStartArray(len);
        this.serializeContents(value2, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(List<?> value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        int i;
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(value2, g, provider, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(value2, g, provider);
            return;
        }
        int len = value2.size();
        if (len == 0) {
            return;
        }
        try {
            PropertySerializerMap serializers = this._dynamicSerializers;
            for (i = 0; i < len; ++i) {
                Object elem2 = value2.get(i);
                if (elem2 == null) {
                    provider.defaultSerializeNull(g);
                    continue;
                }
                Class<?> cc = elem2.getClass();
                JsonSerializer<Object> serializer = serializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._elementType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                    serializers = this._dynamicSerializers;
                }
                serializer.serialize(elem2, g, provider);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value2, i);
        }
    }

    public void serializeContentsUsing(List<?> value2, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException {
        int len = value2.size();
        if (len == 0) {
            return;
        }
        TypeSerializer typeSer = this._valueTypeSerializer;
        for (int i = 0; i < len; ++i) {
            Object elem2 = value2.get(i);
            try {
                if (elem2 == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                if (typeSer == null) {
                    ser.serialize(elem2, jgen, provider);
                    continue;
                }
                ser.serializeWithType(elem2, jgen, provider, typeSer);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(provider, (Throwable)e, value2, i);
            }
        }
    }

    public void serializeTypedContents(List<?> value2, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        int i;
        int len = value2.size();
        if (len == 0) {
            return;
        }
        try {
            TypeSerializer typeSer = this._valueTypeSerializer;
            PropertySerializerMap serializers = this._dynamicSerializers;
            for (i = 0; i < len; ++i) {
                Object elem2 = value2.get(i);
                if (elem2 == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                Class<?> cc = elem2.getClass();
                JsonSerializer<Object> serializer = serializers.serializerFor(cc);
                if (serializer == null) {
                    serializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(serializers, provider.constructSpecializedType(this._elementType, cc), provider) : this._findAndAddDynamic(serializers, cc, provider);
                    serializers = this._dynamicSerializers;
                }
                serializer.serializeWithType(elem2, jgen, provider, typeSer);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, (Throwable)e, value2, i);
        }
    }
}

