/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.introspect;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonFormat;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonInclude;
import org.apache.tinkerpop.shaded.jackson.databind.AnnotationIntrospector;
import org.apache.tinkerpop.shaded.jackson.databind.BeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.PropertyMetadata;
import org.apache.tinkerpop.shaded.jackson.databind.PropertyName;
import org.apache.tinkerpop.shaded.jackson.databind.cfg.MapperConfig;
import org.apache.tinkerpop.shaded.jackson.databind.introspect.AnnotatedMember;

public abstract class ConcreteBeanPropertyBase
implements BeanProperty,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyMetadata _metadata;
    protected transient JsonFormat.Value _propertyFormat;
    protected transient List<PropertyName> _aliases;

    protected ConcreteBeanPropertyBase(PropertyMetadata md) {
        this._metadata = md == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : md;
    }

    protected ConcreteBeanPropertyBase(ConcreteBeanPropertyBase src) {
        this._metadata = src._metadata;
        this._propertyFormat = src._propertyFormat;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    @Deprecated
    public final JsonFormat.Value findFormatOverrides(AnnotationIntrospector intr) {
        AnnotatedMember member2;
        JsonFormat.Value f2 = null;
        if (intr != null && (member2 = this.getMember()) != null) {
            f2 = intr.findFormat(member2);
        }
        if (f2 == null) {
            f2 = EMPTY_FORMAT;
        }
        return f2;
    }

    @Override
    public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
        JsonFormat.Value v = this._propertyFormat;
        if (v == null) {
            AnnotatedMember member2;
            JsonFormat.Value v1 = config.getDefaultPropertyFormat(baseType);
            JsonFormat.Value v2 = null;
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            if (intr != null && (member2 = this.getMember()) != null) {
                v2 = intr.findFormat(member2);
            }
            v = v1 == null ? (v2 == null ? EMPTY_FORMAT : v2) : (v2 == null ? v1 : v1.withOverrides(v2));
            this._propertyFormat = v;
        }
        return v;
    }

    @Override
    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> config, Class<?> baseType) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedMember member2 = this.getMember();
        if (member2 == null) {
            JsonInclude.Value def = config.getDefaultPropertyInclusion(baseType);
            return def;
        }
        JsonInclude.Value v0 = config.getDefaultInclusion(baseType, member2.getRawType());
        if (intr == null) {
            return v0;
        }
        JsonInclude.Value v = intr.findPropertyInclusion(member2);
        if (v0 == null) {
            return v;
        }
        return v0.withOverrides(v);
    }

    @Override
    public List<PropertyName> findAliases(MapperConfig<?> config) {
        List<PropertyName> aliases2 = this._aliases;
        if (aliases2 == null) {
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            if (intr != null) {
                aliases2 = intr.findPropertyAliases(this.getMember());
            }
            if (aliases2 == null) {
                aliases2 = Collections.emptyList();
            }
            this._aliases = aliases2;
        }
        return aliases2;
    }
}

