/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationConfig;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.MapperFeature;
import org.apache.tinkerpop.shaded.jackson.databind.PropertyName;
import org.apache.tinkerpop.shaded.jackson.databind.deser.NullValueProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.SettableBeanProperty;
import org.apache.tinkerpop.shaded.jackson.databind.deser.impl.NullsConstantProvider;
import org.apache.tinkerpop.shaded.jackson.databind.introspect.AnnotatedField;
import org.apache.tinkerpop.shaded.jackson.databind.introspect.AnnotatedMember;
import org.apache.tinkerpop.shaded.jackson.databind.introspect.BeanPropertyDefinition;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.util.Annotations;
import org.apache.tinkerpop.shaded.jackson.databind.util.ClassUtil;

public final class FieldProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedField _annotated;
    protected final transient Field _field;
    protected final boolean _skipNulls;

    public FieldProperty(BeanPropertyDefinition propDef, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedField field2) {
        super(propDef, type, typeDeser, contextAnnotations);
        this._annotated = field2;
        this._field = field2.getAnnotated();
        this._skipNulls = NullsConstantProvider.isSkipper(this._nullProvider);
    }

    protected FieldProperty(FieldProperty src, JsonDeserializer<?> deser, NullValueProvider nva) {
        super(src, deser, nva);
        this._annotated = src._annotated;
        this._field = src._field;
        this._skipNulls = NullsConstantProvider.isSkipper(nva);
    }

    protected FieldProperty(FieldProperty src, PropertyName newName) {
        super(src, newName);
        this._annotated = src._annotated;
        this._field = src._field;
        this._skipNulls = src._skipNulls;
    }

    protected FieldProperty(FieldProperty src) {
        super(src);
        this._annotated = src._annotated;
        Field f2 = this._annotated.getAnnotated();
        if (f2 == null) {
            throw new IllegalArgumentException("Missing field (broken JDK (de)serialization?)");
        }
        this._field = f2;
        this._skipNulls = src._skipNulls;
    }

    @Override
    public SettableBeanProperty withName(PropertyName newName) {
        return new FieldProperty(this, newName);
    }

    @Override
    public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> deser) {
        if (this._valueDeserializer == deser) {
            return this;
        }
        NullValueProvider nvp = this._valueDeserializer == this._nullProvider ? deser : this._nullProvider;
        return new FieldProperty(this, deser, nvp);
    }

    @Override
    public SettableBeanProperty withNullProvider(NullValueProvider nva) {
        return new FieldProperty(this, this._valueDeserializer, nva);
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        ClassUtil.checkAndFixAccess(this._field, config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotated == null ? null : (A)this._annotated.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value2;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            value2 = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value2 = this._valueDeserializer.deserialize(p, ctxt);
            if (value2 == null) {
                if (this._skipNulls) {
                    return;
                }
                value2 = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value2 = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        try {
            this._field.set(instance, value2);
        }
        catch (Exception e) {
            this._throwAsIOE(p, e, value2);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value2;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            value2 = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value2 = this._valueDeserializer.deserialize(p, ctxt);
            if (value2 == null) {
                if (this._skipNulls) {
                    return instance;
                }
                value2 = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value2 = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        try {
            this._field.set(instance, value2);
        }
        catch (Exception e) {
            this._throwAsIOE(p, e, value2);
        }
        return instance;
    }

    @Override
    public void set(Object instance, Object value2) throws IOException {
        try {
            this._field.set(instance, value2);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value2);
        }
    }

    @Override
    public Object setAndReturn(Object instance, Object value2) throws IOException {
        try {
            this._field.set(instance, value2);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value2);
        }
        return instance;
    }

    Object readResolve() {
        return new FieldProperty(this);
    }
}

